/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.GenJsTemplateBodyVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.OutputVarHandler;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.msgs.internal.IcuSyntaxUtils;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class GenJsCodeVisitorAssistantForMsgs
extends AbstractReturningSoyNodeVisitor<Statement> {
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private final SoyJsSrcOptions jsSrcOptions;
    protected final GenJsTemplateBodyVisitor master;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor genJsExprsVisitor;
    private final TemplateAliases templateAliases;
    protected final TranslationContext translationContext;
    private final ErrorReporter errorReporter;
    private final OutputVarHandler outputVars;

    protected GenJsCodeVisitorAssistantForMsgs(GenJsTemplateBodyVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter, OutputVarHandler outputVars) {
        this.master = master;
        this.jsSrcOptions = jsSrcOptions;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.templateAliases = functionAliases;
        this.genJsExprsVisitor = genJsExprsVisitor;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
        this.outputVars = outputVars;
    }

    public Expression generateMsgGroupVariable(MsgFallbackGroupNode node) {
        Expression msg;
        if (node.numChildren() == 1) {
            this.translationContext.soyToJsVariableMappings().setIsPrimaryMsgInUse(node, Expressions.LITERAL_TRUE);
            msg = this.generateSingleMsgVariable((MsgNode)node.getChild(0));
        } else {
            msg = this.generateMsgGroupVariableWithFallback(node);
        }
        for (SoyPrintDirective printDirective : node.getEscapingDirectives()) {
            msg = SoyJsPluginUtils.applyDirective(msg, (SoyJsSrcPrintDirective)printDirective, (List<Expression>)ImmutableList.of(), node.getSourceLocation(), this.errorReporter);
        }
        return msg;
    }

    private Expression generateMsgGroupVariableWithFallback(MsgFallbackGroupNode node) {
        Preconditions.checkState((node.numChildren() == 2 ? 1 : 0) != 0);
        GoogMsgCodeGenInfo primaryCodeGenInfo = this.genGoogGetMsgCallHelper(this.buildGoogMsgVarNameHelper((MsgNode)node.getChild(0)), (MsgNode)node.getChild(0));
        GoogMsgCodeGenInfo fallbackCodeGenInfo = this.genGoogGetMsgCallHelper(this.buildGoogMsgVarNameHelper((MsgNode)node.getChild(1)), (MsgNode)node.getChild(1));
        Expression selectedMsg = this.translationContext.codeGenerator().declarationBuilder("selected_msg").setRhs(Expressions.dottedIdNoRequire("goog.getMsgWithFallback").call(primaryCodeGenInfo.googMsgVar, fallbackCodeGenInfo.googMsgVar)).build().ref();
        Expression isPrimaryMsgInUse = selectedMsg.doubleEquals(primaryCodeGenInfo.googMsgVar);
        this.translationContext.soyToJsVariableMappings().setIsPrimaryMsgInUse(node, isPrimaryMsgInUse);
        if (primaryCodeGenInfo.placeholders == null && fallbackCodeGenInfo.placeholders == null) {
            return selectedMsg;
        }
        Expression initializer = primaryCodeGenInfo.placeholders != null ? Expressions.ifExpression(selectedMsg.doubleEquals(primaryCodeGenInfo.googMsgVar), GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(primaryCodeGenInfo)).setElse(fallbackCodeGenInfo.placeholders == null ? selectedMsg : GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(fallbackCodeGenInfo)).build(this.translationContext.codeGenerator()) : Expressions.ifExpression(selectedMsg.doubleEquals(fallbackCodeGenInfo.googMsgVar), GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(fallbackCodeGenInfo)).setElse(selectedMsg).build(this.translationContext.codeGenerator());
        return this.translationContext.codeGenerator().declarationBuilder("msg_s").setRhs(initializer).build().ref();
    }

    private Expression generateSingleMsgVariable(MsgNode msgNode) {
        String googMsgVarName = this.buildGoogMsgVarNameHelper(msgNode);
        GoogMsgCodeGenInfo googMsgCodeGenInfo = this.genGoogGetMsgCallHelper(googMsgVarName, msgNode);
        if (!msgNode.isPlrselMsg()) {
            return googMsgCodeGenInfo.googMsgVar;
        }
        return this.translationContext.codeGenerator().declarationBuilder("msg_s").setRhs(GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(googMsgCodeGenInfo)).build().ref();
    }

    private String buildGoogMsgVarNameHelper(MsgNode msgNode) {
        String desiredName = this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgIdForDualFormat(msgNode) : "MSG_UNNAMED";
        return this.translationContext.nameGenerator().generate(desiredName);
    }

    private GoogMsgCodeGenInfo genGoogGetMsgCallHelper(String googMsgVarName, MsgNode msgNode) {
        ImmutableList<SoyMsgPart> msgParts = MsgUtils.buildMsgParts(msgNode);
        Expression googMsgContent = Expressions.stringLiteral(GenJsCodeVisitorAssistantForMsgs.buildGoogMsgContentStr(msgParts, msgNode.isPlrselMsg()));
        GoogMsgPlaceholderCodeGenInfo placeholderInfo = new GoogMsgPlaceholderCodeGenInfo(msgNode.isPlrselMsg());
        this.genGoogMsgCodeForChildren(msgParts, msgNode, placeholderInfo);
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        if (msgNode.getMeaning() != null) {
            jsDocBuilder.addAnnotation("meaning", msgNode.getMeaning());
        }
        jsDocBuilder.addAnnotation("desc", LINE_BOUNDARY_PATTERN.matcher(msgNode.getDesc()).replaceAll(" "));
        if (msgNode.getAlternateId().isPresent()) {
            jsDocBuilder.addAnnotation("alternateMessageId", String.valueOf(msgNode.getAlternateId().getAsLong()));
        }
        VariableDeclaration.Builder builder = VariableDeclaration.builder(googMsgVarName).setJsDoc(jsDocBuilder.build());
        if (msgNode.getEscapingMode() == EscapingMode.ESCAPE_HTML) {
            builder.setRhs(JsRuntime.GOOG_GET_MSG.call(googMsgContent, msgNode.isPlrselMsg() ? Expressions.EMPTY_OBJECT_LITERAL : placeholderInfo.placeholders.build(), Expressions.objectLiteral((Map<String, Expression>)ImmutableMap.of((Object)"html", (Object)Expressions.LITERAL_TRUE))));
        } else if (msgNode.isPlrselMsg() || placeholderInfo.placeholders.isEmpty()) {
            builder.setRhs(JsRuntime.GOOG_GET_MSG.call(googMsgContent));
        } else {
            builder.setRhs(JsRuntime.GOOG_GET_MSG.call(googMsgContent, placeholderInfo.placeholders.build()));
        }
        Expression placeholders = msgNode.isPlrselMsg() ? placeholderInfo.pluralsAndSelects.putAll(placeholderInfo.placeholders).build() : null;
        return new GoogMsgCodeGenInfo(builder.build().ref(), placeholders);
    }

    private static String buildGoogMsgContentStr(ImmutableList<SoyMsgPart> msgParts, boolean doUseBracedPhs) {
        msgParts = IcuSyntaxUtils.convertMsgPartsToEmbeddedIcuSyntax(msgParts);
        StringBuilder msgStrSb = new StringBuilder();
        for (SoyMsgPart msgPart : msgParts) {
            if (msgPart instanceof SoyMsgRawTextPart) {
                msgStrSb.append(((SoyMsgRawTextPart)msgPart).getRawText());
                continue;
            }
            if (msgPart instanceof SoyMsgPlaceholderPart) {
                String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                if (doUseBracedPhs) {
                    msgStrSb.append("{").append(placeholderName).append("}");
                    continue;
                }
                String googMsgPlaceholderName = GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
                msgStrSb.append("{$").append(googMsgPlaceholderName).append("}");
                continue;
            }
            throw new AssertionError((Object)("unexpected part: " + String.valueOf(msgPart)));
        }
        return msgStrSb.toString();
    }

    private static Expression getMessageFormatCall(GoogMsgCodeGenInfo codeGenInfo) {
        return Expressions.construct(JsRuntime.GOOG_I18N_MESSAGE_FORMAT, codeGenInfo.googMsgVar).dotAccess("formatIgnoringPound").call(codeGenInfo.placeholders);
    }

    private void genGoogMsgCodeForChildren(ImmutableList<SoyMsgPart> parts, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        for (SoyMsgPart child : parts) {
            if (child instanceof SoyMsgRawTextPart || child instanceof SoyMsgPluralRemainderPart) continue;
            if (child instanceof SoyMsgSelectPart) {
                this.genGoogMsgCodeForSelectNode((SoyMsgSelectPart)child, msgNode, codeGenInfo);
                continue;
            }
            if (child instanceof SoyMsgPlaceholderPart) {
                this.genGoogMsgCodeForPlaceholder((SoyMsgPlaceholderPart)child, msgNode, codeGenInfo);
                continue;
            }
            if (child instanceof SoyMsgPluralPart) {
                this.genGoogMsgCodeForPluralNode((SoyMsgPluralPart)child, msgNode, codeGenInfo);
                continue;
            }
            throw new AssertionError((Object)("unexpected child: " + String.valueOf(child)));
        }
    }

    private void genGoogMsgCodeForPluralNode(SoyMsgPluralPart pluralPart, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        MsgPluralNode reprNode = msgNode.getRepPluralNode(pluralPart.getPluralVarName());
        if (!codeGenInfo.pluralsAndSelects.contains(pluralPart.getPluralVarName())) {
            codeGenInfo.pluralsAndSelects.put(pluralPart.getPluralVarName(), this.translateExpr(reprNode.getExpr()));
        }
        for (SoyMsgPart.Case child : pluralPart.getCases()) {
            this.genGoogMsgCodeForChildren(child.parts(), msgNode, codeGenInfo);
        }
    }

    private void genGoogMsgCodeForSelectNode(SoyMsgSelectPart selectPart, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        MsgSelectNode reprNode = msgNode.getRepSelectNode(selectPart.getSelectVarName());
        if (!codeGenInfo.pluralsAndSelects.contains(selectPart.getSelectVarName())) {
            codeGenInfo.pluralsAndSelects.put(selectPart.getSelectVarName(), this.translateExpr(reprNode.getExpr()));
        }
        for (SoyMsgPart.Case child : selectPart.getCases()) {
            this.genGoogMsgCodeForChildren(child.parts(), msgNode, codeGenInfo);
        }
    }

    private Expression translateExpr(ExprNode expr) {
        return (Expression)this.master.getExprTranslator().exec(expr);
    }

    private void genGoogMsgCodeForPlaceholder(SoyMsgPlaceholderPart placeholder, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        String googMsgPlaceholderName;
        String string = googMsgPlaceholderName = codeGenInfo.isPlrselMsg ? placeholder.getPlaceholderName() : GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholder.getPlaceholderName());
        if (codeGenInfo.placeholders.contains(googMsgPlaceholderName)) {
            return;
        }
        MsgPlaceholderNode reprNode = msgNode.getRepPlaceholderNode(placeholder.getPlaceholderName());
        codeGenInfo.placeholders.put(googMsgPlaceholderName, this.genGoogMsgPlaceholder(reprNode));
    }

    private static String genGoogMsgPlaceholderName(String placeholderName) {
        Matcher suffixMatcher = UNDERSCORE_NUMBER_SUFFIX.matcher(placeholderName);
        if (suffixMatcher.find()) {
            String base = placeholderName.substring(0, suffixMatcher.start());
            String suffix = suffixMatcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, base) + suffix;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, placeholderName);
    }

    protected Expression genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
        ArrayList<Expression> contentChunks = new ArrayList<Expression>();
        for (SoyNode.StandaloneNode contentNode : msgPhNode.getChildren()) {
            if (contentNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(contentNode)).booleanValue()) {
                Statement decl = (Statement)this.visit(contentNode);
                contentChunks.add(Expressions.id("htmlTag" + contentNode.getId()).withInitialStatement(decl));
                continue;
            }
            if (contentNode instanceof CallNode) {
                ArrayList<Statement> decls = new ArrayList<Statement>();
                CallNode callNode = (CallNode)contentNode;
                for (CallParamNode grandchild : callNode.getChildren()) {
                    if (!(grandchild instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(grandchild)).booleanValue()) continue;
                    decls.add((Statement)this.visit(grandchild));
                }
                Expression call = this.genCallCodeUtils.gen(callNode, this.templateAliases, this.translationContext, this.errorReporter, this.master.getExprTranslator()).withInitialStatements(decls);
                contentChunks.add(call);
                continue;
            }
            List<Expression> chunks = this.genJsExprsVisitor.exec(contentNode);
            contentChunks.add(Expressions.concat(chunks));
        }
        return Expressions.concat(contentChunks);
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.outputVars.pushOutputVar("htmlTag" + node.getId());
        List<Statement> children = this.visitChildren(node);
        this.outputVars.popOutputVar();
        return Statements.of(children);
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        return this.master.visit(node);
    }

    private static final class MapLiteralBuilder {
        final Map<String, Expression> map = new LinkedHashMap<String, Expression>();

        private MapLiteralBuilder() {
        }

        @CanIgnoreReturnValue
        MapLiteralBuilder put(String key, Expression value) {
            Expression prev = this.map.put(key, value);
            if (prev != null) {
                throw new IllegalArgumentException("already generated this placeholder");
            }
            return this;
        }

        public boolean contains(String selectVarName) {
            return this.map.containsKey(selectVarName);
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        @CanIgnoreReturnValue
        MapLiteralBuilder putAll(MapLiteralBuilder other) {
            Preconditions.checkState((boolean)Sets.intersection(this.map.keySet(), other.map.keySet()).isEmpty());
            this.map.putAll(other.map);
            return this;
        }

        Expression build() {
            return Expressions.objectLiteralWithQuotedKeys(this.map);
        }
    }

    private static final class GoogMsgPlaceholderCodeGenInfo {
        final boolean isPlrselMsg;
        final MapLiteralBuilder placeholders = new MapLiteralBuilder();
        final MapLiteralBuilder pluralsAndSelects = new MapLiteralBuilder();

        GoogMsgPlaceholderCodeGenInfo(boolean isPlrselMsg) {
            this.isPlrselMsg = isPlrselMsg;
        }
    }

    private static final class GoogMsgCodeGenInfo {
        final Expression googMsgVar;
        @Nullable
        final Expression placeholders;

        GoogMsgCodeGenInfo(Expression googMsgVar, Expression placeholders) {
            this.googMsgVar = googMsgVar;
            this.placeholders = placeholders;
        }
    }
}

