/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsArrowFunction;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.AliasUtils;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.GenJsTemplateBodyVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsSrcNameGenerators;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.OutputVarHandler;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DelcallAnnotationVisitor;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class GenJsCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final SoyErrorKind EXTERN_NO_JS_IMPL = SoyErrorKind.of("Extern ''{0}'' does not have a JS implementation. Either add one or don''t compile this Soy to JS.", new SoyErrorKind.StyleAllowance[0]);
    protected final SoyJsSrcOptions jsSrcOptions;
    protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
    private final DelTemplateNamer delTemplateNamer;
    protected final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    protected final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    JsCodeBuilder jsCodeBuilder;
    protected GenJsExprsVisitor genJsExprsVisitor;
    protected final String modifiableDefaultImplSuffix = "__default_impl";
    protected FileSetMetadata fileSetMetadata;
    private final SoyTypeRegistry typeRegistry;
    protected ErrorReporter errorReporter;
    protected TranslationContext templateTranslationContext;
    protected List<Statement> staticVarDeclarations;
    protected boolean generatePositionalParamsSignature;
    protected TemplateAliases templateAliases;
    protected final OutputVarHandler outputVars;

    protected GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, DelTemplateNamer delTemplateNamer, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        this.jsSrcOptions = jsSrcOptions;
        this.javaScriptValueFactory = javaScriptValueFactory;
        this.delTemplateNamer = delTemplateNamer;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.typeRegistry = typeRegistry;
        this.outputVars = new OutputVarHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gen(SoyFileSetNode node, FileSetMetadata registry, ErrorReporter errorReporter) {
        this.fileSetMetadata = (FileSetMetadata)Preconditions.checkNotNull((Object)registry);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        try {
            this.jsFilesContents = new ArrayList<String>();
            this.jsCodeBuilder = null;
            this.genJsExprsVisitor = null;
            this.visit(node);
            List<String> list = this.jsFilesContents;
            return list;
        }
        finally {
            this.fileSetMetadata = null;
            this.errorReporter = null;
        }
    }

    @Override
    @Deprecated
    public final List<String> exec(SoyNode node) {
        throw new UnsupportedOperationException();
    }

    public void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, FileSetMetadata registry, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.fileSetMetadata = registry;
        this.templateTranslationContext = TranslationContext.of(SoyToJsVariableMappings.newEmpty(), JsSrcNameGenerators.forLocalVariables());
        this.visit(node);
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    protected JsCodeBuilder createCodeBuilder() {
        return new JsCodeBuilder(this.outputVars);
    }

    protected JsCodeBuilder getJsCodeBuilder() {
        return this.jsCodeBuilder;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        StringBuilder file = new StringBuilder();
        file.append("// This file was automatically generated by the Soy compiler.\n").append("// Please don't edit this file by hand.\n").append("// source: ").append(node.getFilePath().path()).append('\n');
        if (node.getConstants().isEmpty() && node.getExterns().isEmpty() && node.getTemplates().isEmpty()) {
            this.jsFilesContents.add(file.toString());
            this.jsCodeBuilder = null;
            return;
        }
        file.append("\n");
        String fileOverviewDescription = "Templates in namespace " + node.getNamespace() + ".";
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        jsDocBuilder.addAnnotation("fileoverview", fileOverviewDescription);
        if (this.isIncrementalDom()) {
            jsDocBuilder.addAnnotation("suppress", "{missingRequire} TODO(b/152440355)");
        }
        jsDocBuilder.addAnnotation("suppress", "{suspiciousCode}");
        if (!this.jsSrcOptions.shouldGenerateGoogModules()) {
            jsDocBuilder.addAnnotation("suppress", "{uselessCode}");
        }
        jsDocBuilder.addAnnotation("suppress", "{strictMissingProperties} TODO(b/214874268): Remove strictMissingProperties suppression after b/214427036 is fixed");
        if (node.getTemplates().stream().anyMatch(tmpl -> tmpl instanceof TemplateElementNode)) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "extraRequire");
        }
        if (node.getModName() != null) {
            jsDocBuilder.addParameterizedAnnotation("modName", node.getModName());
            this.addModsAnnotation(jsDocBuilder, node);
        }
        this.addHasSoyDelTemplateAnnotations(jsDocBuilder, node);
        this.addHasSoyDelCallAnnotations(jsDocBuilder, node);
        this.addCodeToRequireCss(jsDocBuilder, node);
        jsDocBuilder.addAnnotation("public");
        file.append(jsDocBuilder.build());
        file.append("\n\n");
        this.templateAliases = AliasUtils.IDENTITY_ALIASES;
        this.jsCodeBuilder = this.createCodeBuilder();
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            this.templateAliases = AliasUtils.createTemplateAliases(node, this.fileSetMetadata);
            this.addCodeToDeclareGoogModule(file, node);
            this.addCodeToRequireGoogModules(node);
        } else if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            GenJsCodeVisitor.addCodeToProvideSoyNamespace(file, node);
            file.append('\n');
            this.addCodeToRequireSoyNamespaces(node);
        } else {
            throw new AssertionError((Object)"impossible");
        }
        Map<String, SoyType> ijData = this.getAllIjDataParams(node);
        if (!ijData.isEmpty()) {
            GoogRequire require = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.GOOG_SOY_ALIAS : JsRuntime.GOOG_SOY;
            this.jsCodeBuilder.appendLine(new String[0]);
            for (Map.Entry<String, SoyType> entry : ijData.entrySet()) {
                this.jsCodeBuilder.appendLine(new String[0]);
                JsType type = this.getJsTypeForParamForDeclaration(entry.getValue());
                this.jsCodeBuilder.appendLine(JsDoc.builder().addParameterizedAnnotation("suppress", "duplicate").addParameterizedAnnotation("type", type.typeExpr() + "|undefined").build().toString()).addGoogRequires((Iterable)type.getGoogRequires().stream().map(GoogRequire::toRequireType).collect(ImmutableList.toImmutableList()));
                this.jsCodeBuilder.append(require.reference().dotAccess("IjData").dotAccess("prototype").dotAccess(entry.getKey()).asStatement());
            }
        }
        if (this.jsSrcOptions.generateMaybeRequireForControllerAndModelXids()) {
            SoyTreeUtils.allNodesOfType(node, StringNode.class).filter(StringNode::isXid).map(StringNode::getValue).map(GoogRequire::createMaybeRequire).forEach(this.jsCodeBuilder::addGoogRequire);
        }
        this.templateTranslationContext = TranslationContext.of(SoyToJsVariableMappings.newEmpty(), JsSrcNameGenerators.forLocalVariables());
        for (ImportNode importNode : node.getImports()) {
            this.visit(importNode);
        }
        for (ConstNode constant : node.getConstants()) {
            this.registerLocalConstant(constant);
        }
        for (ExternNode extern : node.getExterns()) {
            Optional<JsImplNode> jsImpl = extern.getJsImpl();
            if (jsImpl.isPresent()) {
                this.visit(jsImpl.get());
                continue;
            }
            this.errorReporter.report(extern.getSourceLocation(), EXTERN_NO_JS_IMPL, extern.getIdentifier().identifier());
        }
        for (TemplateNode template : node.getTemplates()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.staticVarDeclarations = new ArrayList<Statement>();
            this.visit(template);
            if (this.staticVarDeclarations.isEmpty()) continue;
            this.jsCodeBuilder.append(Statements.of(this.staticVarDeclarations));
        }
        for (ConstNode constant : node.getConstants()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(constant);
        }
        this.jsCodeBuilder.appendGoogRequiresTo(file);
        this.jsCodeBuilder.appendCodeTo(file);
        this.jsFilesContents.add(file.toString());
        this.jsCodeBuilder = null;
    }

    private Map<String, SoyType> getAllIjDataParams(SoyFileNode node) {
        LinkedHashMap<String, SoyType> params = new LinkedHashMap<String, SoyType>();
        for (TemplateNode template : node.getTemplates()) {
            for (TemplateParam param : template.getInjectedParams()) {
                SoyType oldType = params.put(param.name(), param.type());
                if (oldType == null) continue;
                params.put(param.name(), this.typeRegistry.getOrCreateUnionType(Arrays.asList(param.type(), oldType)));
            }
        }
        return params;
    }

    private void addCodeToRequireCss(JsDoc.Builder header, SoyFileNode soyFile) {
        TreeSet<Object> requiredCssNamespaces = new TreeSet<Object>();
        if (this.jsSrcOptions.dependOnCssHeader()) {
            requiredCssNamespaces.add("./" + soyFile.getFilePath().fileName());
        } else {
            requiredCssNamespaces.addAll((Collection<Object>)soyFile.getRequireCss());
            for (TemplateNode template : soyFile.getTemplates()) {
                requiredCssNamespaces.addAll((Collection<Object>)template.getRequiredCssNamespaces());
            }
        }
        for (String requiredCssNamespace : requiredCssNamespaces) {
            header.addParameterizedAnnotation("requirecss", requiredCssNamespace);
        }
    }

    private static void addCodeToProvideSoyNamespace(StringBuilder header, SoyFileNode soyFile) {
        header.append("goog.provide('").append(soyFile.getNamespace()).append("');\n");
    }

    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace;
    }

    private void addCodeToDeclareGoogModule(StringBuilder header, SoyFileNode soyFile) {
        String exportNamespace = this.getGoogModuleNamespace(soyFile.getNamespace());
        header.append("goog.module('").append(exportNamespace).append("');\n\n");
    }

    private void addCodeToRequireGoogModules(SoyFileNode soyFile) {
        soyFile.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE).map(i -> this.namespaceForPath(i.getSourceFilePath())).distinct().sorted().forEach(calleeNamespace -> {
            String namespaceAlias = this.templateAliases.getNamespaceAlias((String)calleeNamespace);
            String importNamespace = this.getGoogModuleNamespace((String)calleeNamespace);
            this.jsCodeBuilder.append(VariableDeclaration.builder(namespaceAlias).setRhs(JsRuntime.GOOG_REQUIRE.call(Expressions.stringLiteral(importNamespace))).build());
        });
    }

    private void addModsAnnotation(JsDoc.Builder header, SoyFileNode soyFile) {
        Optional<String> mods = soyFile.getTemplates().stream().filter(t -> t instanceof TemplateBasicNode).map(TemplateBasicNode.class::cast).map(TemplateBasicNode::moddedSoyNamespace).filter(Objects::nonNull).findFirst();
        if (mods.isPresent()) {
            header.addParameterizedAnnotation("mods", this.getGoogModuleNamespace(mods.get()));
        }
    }

    private void addHasSoyDelTemplateAnnotations(JsDoc.Builder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (TemplateNode template : soyFile.getTemplates()) {
            String annotationName;
            if (template instanceof TemplateDelegateNode) {
                delTemplateNames.add(this.delTemplateNamer.getDelegateName((TemplateDelegateNode)template));
                continue;
            }
            if (!(template instanceof TemplateBasicNode) || (annotationName = ((TemplateBasicNode)template).deltemplateAnnotationName()) == null) continue;
            delTemplateNames.add(this.delTemplateNamer.getDelegateName(annotationName));
        }
        for (String delTemplateName : delTemplateNames) {
            header.addParameterizedAnnotation("hassoydeltemplate", delTemplateName);
        }
    }

    private void addHasSoyDelCallAnnotations(JsDoc.Builder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (CallDelegateNode delCall : SoyTreeUtils.getAllNodesOfType(soyFile, CallDelegateNode.class)) {
            delTemplateNames.add(this.delTemplateNamer.getDelegateName(delCall));
        }
        delTemplateNames.addAll((Collection)new DelcallAnnotationVisitor().exec(soyFile).stream().map(this.delTemplateNamer::getDelegateName).collect(ImmutableSet.toImmutableSet()));
        for (String delTemplateName : delTemplateNames) {
            header.addParameterizedAnnotation("hassoydelcall", delTemplateName);
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        soyFile.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE).map(i -> this.namespaceForPath(i.getSourceFilePath())).distinct().sorted().forEach(calleeNamespace -> this.jsCodeBuilder.addGoogRequire(GoogRequire.create(calleeNamespace)));
    }

    protected JsType getTemplateReturnType(TemplateNode node) {
        return JsType.templateReturnTypeForJsSrc(node.getContentKind());
    }

    @Override
    protected void visitImportNode(ImportNode node) {
        node.visitVars((var, parentType) -> {
            if (parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE && var.type().getKind() != SoyType.Kind.TEMPLATE_TYPE) {
                String namespace = this.namespaceForPath(node.getSourceFilePath());
                if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                    namespace = this.templateAliases.getNamespaceAlias(namespace);
                }
                if (var.type().getKind() == SoyType.Kind.FUNCTION) {
                    Expression translation = Expressions.dottedIdNoRequire(namespace + "." + var.getSymbol());
                    this.templateTranslationContext.soyToJsVariableMappings().put(var.getSymbol(), translation);
                } else {
                    this.templateTranslationContext.soyToJsVariableMappings().put(var.name(), JsRuntime.SOY_GET_CONST.call(Expressions.dottedIdNoRequire(namespace + "." + var.getSymbol()), JsRuntime.SOY_INTERNAL_CALL_MARKER));
                }
            }
        });
    }

    @Override
    protected void visitConstNode(ConstNode node) {
        SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
        ConstVar var = node.getVar();
        ImmutableList.Builder declarations = ImmutableList.builder();
        JsType varType = this.getJsTypeForParamForDeclaration(var.type());
        JsDoc.Builder jsDoc = JsDoc.builder().addParameterizedAnnotation("const", "function(!Object):" + varType.typeExprForFunctionReturn());
        String partialName = var.name();
        String alias = this.jsSrcOptions.shouldGenerateGoogModules() ? partialName : file.getNamespace() + "." + partialName;
        Expression aliasExp = this.getLocalConstantExpr(node);
        Expression constantExpr = Expressions.group(JsRuntime.SOY_CREATE_CONST.call(JsArrowFunction.create(JsDoc.builder().build(), Statements.returnValue(this.translateExpr(node.getExpr()))))).prepend(JsDoc.builder().setOverviewComment("@pureOrBreakMyCode").build());
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            if (node.isExported()) {
                declarations.add((Object)Statements.assign(JsRuntime.EXPORTS.dotAccess(partialName), constantExpr, jsDoc.build()));
            } else {
                declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc.build()).setRhs(constantExpr).build());
            }
        } else {
            declarations.add((Object)Statements.assign(aliasExp, constantExpr, jsDoc.addAnnotation(node.isExported() ? "public" : "private").build()));
        }
        this.jsCodeBuilder.append(Statements.of((Iterable<Statement>)declarations.build()));
        for (GoogRequire require : varType.getGoogRequires()) {
            this.jsCodeBuilder.addGoogRequire(require);
        }
    }

    private Expression getLocalConstantExpr(ConstNode node) {
        SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
        ConstVar var = node.getVar();
        String partialName = var.name();
        return this.jsSrcOptions.shouldGenerateGoogModules() ? (node.isExported() ? JsRuntime.EXPORTS.dotAccess(partialName) : Expressions.id(partialName)) : Expressions.dottedIdNoRequire(file.getNamespace()).dotAccess(partialName);
    }

    private void registerLocalConstant(ConstNode node) {
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar().name(), JsRuntime.SOY_GET_CONST.call(this.getLocalConstantExpr(node), JsRuntime.SOY_INTERNAL_CALL_MARKER));
    }

    private Statement makeRegisterDelegateFn(TemplateDelegateNode nodeAsDelTemplate, Expression aliasExp) {
        return JsRuntime.SOY_REGISTER_DELEGATE_FN.call(JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expressions.stringLiteral(this.delTemplateNamer.getDelegateName(nodeAsDelTemplate))), Expressions.stringLiteral(nodeAsDelTemplate.getDelTemplateVariant()), Expressions.number(nodeAsDelTemplate.getDelPriority().getValue()), aliasExp).asStatement();
    }

    protected static boolean isModifiable(TemplateNode node) {
        return node instanceof TemplateBasicNode && ((TemplateBasicNode)node).isModifiable();
    }

    protected static boolean isModifiableWithUseVariantType(TemplateNode node) {
        return GenJsCodeVisitor.isModifiable(node) && !SoyTypes.isNullOrUndefined(((TemplateBasicNode)node).getUseVariantType());
    }

    protected static boolean isModTemplate(TemplateNode node) {
        return node instanceof TemplateBasicNode && ((TemplateBasicNode)node).getModifiesExpr() != null;
    }

    protected static TemplateType getModifiedTemplateType(TemplateBasicNode node) {
        return (TemplateType)node.getModifiesExpr().getRoot().getType();
    }

    private Statement makeRegisterDefaultFnCall(TemplateBasicNode nodeAsBasicTemplate, Expression aliasExp) {
        Preconditions.checkState((boolean)nodeAsBasicTemplate.isModifiable());
        return JsRuntime.SOY_REGISTER_DELEGATE_FN.call(JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expressions.stringLiteral(this.delTemplateNamer.getDelegateName(nodeAsBasicTemplate))), Expressions.stringLiteral(""), Expressions.number(nodeAsBasicTemplate.getSoyFileHeaderInfo().getPriority().getValue()), aliasExp).asStatement();
    }

    private Statement makeRegisterModFn(TemplateBasicNode nodeAsBasicTemplate, Expression aliasExp) {
        Preconditions.checkState((nodeAsBasicTemplate.getModifiesExpr() != null ? 1 : 0) != 0);
        TemplateLiteralNode literal = (TemplateLiteralNode)nodeAsBasicTemplate.getModifiesExpr().getRoot();
        return JsRuntime.SOY_REGISTER_DELEGATE_FN.call(JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expressions.stringLiteral(this.delTemplateNamer.getDelegateName(literal))), Expressions.stringLiteral(nodeAsBasicTemplate.getDelTemplateVariant()), Expressions.number(nodeAsBasicTemplate.getSoyFileHeaderInfo().getPriority().getValue()), aliasExp).asStatement();
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.generatePositionalParamsSignature = GenCallCodeUtils.hasPositionalSignature(TemplateMetadata.buildTemplateType(node));
        String templateName = node.getTemplateName();
        String partialName = node.getPartialTemplateName();
        String alias = this.jsSrcOptions.shouldGenerateGoogModules() && node instanceof TemplateDelegateNode ? partialName : this.templateAliases.get(templateName);
        Expression aliasExp = Expressions.dottedIdNoRequire(alias);
        try (TranslationContext.ExitScope unused = this.templateTranslationContext.enterSoyAndJsScope();){
            JsDoc jsDoc;
            this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.templateTranslationContext, this.templateAliases, this.errorReporter, JsRuntime.OPT_DATA);
            ImmutableList.Builder declarations = ImmutableList.builder();
            if (node instanceof TemplateDelegateNode && node.getChildren().isEmpty()) {
                TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
                if (nodeAsDelTemplate.getDelTemplateVariant().isEmpty() && nodeAsDelTemplate.getModName() == null) {
                    return;
                }
                Expression emptyFnCall = JsRuntime.SOY_MAKE_EMPTY_TEMPLATE_FN.call(Expressions.stringLiteral(templateName));
                JsDoc jsDoc2 = this.generateEmptyFunctionJsDoc(node);
                if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                    declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc2).setRhs(emptyFnCall).build());
                } else {
                    declarations.add((Object)Statements.assign(aliasExp, emptyFnCall, jsDoc2));
                }
                declarations.add((Object)this.makeRegisterDelegateFn(nodeAsDelTemplate, aliasExp));
                this.jsCodeBuilder.append(Statements.of((Iterable<Statement>)declarations.build()));
                return;
            }
            if (this.generatePositionalParamsSignature) {
                jsDoc = this.generateFunctionJsDoc(node, alias, false, GenJsCodeVisitor.isModifiableWithUseVariantType(node));
                Expression publicFunction = Expressions.function(jsDoc, this.generateDelegateFunction(node, alias));
                JsDoc positionalFunctionDoc = this.generatePositionalFunctionJsDoc(node, GenJsCodeVisitor.isModifiableWithUseVariantType(node));
                Expression positionalFunction = Expressions.function(positionalFunctionDoc, GenJsCodeVisitor.isModifiable(node) ? this.generateModTemplateSelection(node, alias, this.templateTranslationContext.codeGenerator()) : this.generateFunctionBody(node, alias, null, true));
                if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                    VariableDeclaration publicDeclaration = VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(publicFunction).build();
                    declarations.add((Object)publicDeclaration);
                    VariableDeclaration positionalDeclaration = VariableDeclaration.builder(alias + "$").setJsDoc(positionalFunctionDoc).setRhs(positionalFunction).build();
                    declarations.add((Object)positionalDeclaration);
                    if (!(node instanceof TemplateDelegateNode) && node.getVisibility() == Visibility.PUBLIC) {
                        declarations.add((Object)Statements.assign(JsRuntime.EXPORTS.dotAccess(partialName), publicDeclaration.ref()));
                        declarations.add((Object)Statements.assign(JsRuntime.EXPORTS.dotAccess(partialName + "$"), positionalDeclaration.ref()));
                    }
                } else {
                    declarations.add((Object)Statements.assign(aliasExp, publicFunction, jsDoc));
                    declarations.add((Object)Statements.assign(Expressions.dottedIdNoRequire(alias + "$"), positionalFunction, positionalFunctionDoc));
                }
            } else {
                jsDoc = this.generateFunctionJsDoc(node, alias, true, GenJsCodeVisitor.isModifiableWithUseVariantType(node));
                String objectParamType = ((JsDoc.Param)jsDoc.params().get(1)).type();
                Expression function = Expressions.function(jsDoc, GenJsCodeVisitor.isModifiable(node) ? this.generateModTemplateSelection(node, alias, this.templateTranslationContext.codeGenerator()) : this.generateFunctionBody(node, alias, objectParamType.substring(0, objectParamType.length() - 1), true));
                if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                    declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(function).build());
                    if (!(node instanceof TemplateDelegateNode) && node.getVisibility() == Visibility.PUBLIC) {
                        declarations.add((Object)Statements.assign(JsRuntime.EXPORTS.dotAccess(partialName), aliasExp));
                    }
                } else {
                    declarations.add((Object)Statements.assign(aliasExp, function, jsDoc));
                }
            }
            if (!this.jsSrcOptions.shouldGenerateGoogModules() && node.getContentKind() == SanitizedContentKind.HTML && node.getVisibility() == Visibility.PUBLIC) {
                declarations.add((Object)Statements.ifStatement(Expressions.LITERAL_FALSE, VariableDeclaration.builder(alias + "_soyInternalStubs").setJsDoc(this.generatePositionalFunctionJsDoc(node, GenJsCodeVisitor.isModifiableWithUseVariantType(node))).build()).build());
            }
            if (!this.hasOnlyImplicitParams(node)) {
                declarations.add((Object)aliasExp.dotAccess("Params").asStatement(JsDoc.builder().addParameterizedAnnotation("typedef", this.genParamsRecordType(node)).build()));
            }
            declarations.add((Object)Statements.ifStatement(JsRuntime.GOOG_DEBUG, Statements.assign(aliasExp.dotAccess("soyTemplateName"), Expressions.stringLiteral(templateName), JsDoc.builder().addAnnotation("nocollapse").addParameterizedAnnotation("type", "string").build())).build());
            if (node instanceof TemplateDelegateNode) {
                TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
                declarations.add((Object)this.makeRegisterDelegateFn(nodeAsDelTemplate, aliasExp));
            }
            if (GenJsCodeVisitor.isModifiable(node) && !node.getChildren().isEmpty()) {
                String defaultImplName = alias + "__default_impl";
                JsDoc jsDoc3 = this.generatePositionalParamsSignature ? this.generatePositionalFunctionJsDoc(node, false) : this.generateFunctionJsDoc(node, alias, true, false);
                String objectParamType = ((JsDoc.Param)jsDoc3.params().get(1)).type();
                Expression impl = Expressions.function(jsDoc3, this.generateFunctionBody(node, alias, this.generatePositionalParamsSignature ? null : objectParamType.substring(0, objectParamType.length() - 1), false));
                if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                    declarations.add((Object)VariableDeclaration.builder(defaultImplName).setJsDoc(jsDoc3).setRhs(impl).build());
                } else {
                    declarations.add((Object)Statements.assign(Expressions.dottedIdNoRequire(defaultImplName), impl, jsDoc3));
                }
                TemplateBasicNode templateBasicNode = (TemplateBasicNode)node;
                declarations.add((Object)this.makeRegisterDefaultFnCall(templateBasicNode, Expressions.dottedIdNoRequire(defaultImplName)));
            }
            if (GenJsCodeVisitor.isModTemplate(node)) {
                declarations.add((Object)this.makeRegisterModFn((TemplateBasicNode)node, Expressions.dottedIdNoRequire(alias + (this.generatePositionalParamsSignature ? "$" : ""))));
            }
            this.jsCodeBuilder.append(Statements.of((Iterable<Statement>)declarations.build()));
            this.generatePositionalParamsSignature = false;
        }
    }

    protected boolean hasOnlyImplicitParams(TemplateNode node) {
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            return false;
        }
        return true;
    }

    private TemplateParam syntheticTemplateParam(TemplateType.Parameter typeParam) {
        TemplateParam param = new TemplateParam(typeParam.getName(), SourceLocation.UNKNOWN, SourceLocation.UNKNOWN, null, false, typeParam.isImplicit(), !typeParam.isRequired(), null, null);
        param.setType(typeParam.getType());
        return param;
    }

    protected final ImmutableList<TemplateParam> paramsInOrder(TemplateNode node) {
        HashMap<String, TemplateParam> paramsByName = new HashMap<String, TemplateParam>();
        for (Object param : node.getParams()) {
            paramsByName.put(((AbstractVarDefn)param).name(), (TemplateParam)param);
        }
        if (GenJsCodeVisitor.isModTemplate(node)) {
            for (Object param : GenJsCodeVisitor.getModifiedTemplateType((TemplateBasicNode)node).getActualParameters()) {
                paramsByName.putIfAbsent(((TemplateType.Parameter)param).getName(), this.syntheticTemplateParam((TemplateType.Parameter)param));
            }
        }
        TemplateType templateType = GenJsCodeVisitor.isModTemplate(node) ? GenJsCodeVisitor.getModifiedTemplateType((TemplateBasicNode)node) : TemplateMetadata.buildTemplateType(node);
        return (ImmutableList)templateType.getActualParameters().stream().map(p -> (TemplateParam)paramsByName.get(p.getName())).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    protected final JsDoc.Builder addInternalCallerParam(JsDoc.Builder jsDocBuilder) {
        return jsDocBuilder.addParam("$$areYouAnInternalCaller", "!Object");
    }

    protected static String getPositionalParamName(TemplateParam param) {
        return "p$" + param.name();
    }

    protected JsDoc generatePositionalFunctionJsDoc(TemplateNode node, boolean addVariantParam) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        this.addInternalCallerParam(jsDocBuilder);
        this.addIjDataParam(jsDocBuilder, true);
        for (TemplateParam param : this.paramsInOrder(node)) {
            JsType jsType = this.getJsTypeForParamForDeclaration(param.type());
            jsDocBuilder.addParam(GenJsCodeVisitor.getPositionalParamName(param), jsType.typeExpr() + (param.isRequired() ? "" : "="));
        }
        if (addVariantParam) {
            jsDocBuilder.addParam("opt_variant", "string=");
        }
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    protected JsDoc generateEmptyFunctionJsDoc(TemplateNode node) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        String ijDataTypeExpression = this.ijDataTypeExpression(jsDocBuilder);
        jsDocBuilder.addAnnotation("type", String.format("{function(?Object<string, *>=, ?%s=):string}", ijDataTypeExpression));
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    protected JsDoc generateFunctionJsDoc(TemplateNode node, String alias, boolean suppressCheckTypes, boolean addVariantParam) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        if (this.hasOnlyImplicitParams(node)) {
            jsDocBuilder.addParam("opt_data", "?Object<string, *>=");
        } else if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            jsDocBuilder.addParam("opt_data", "?" + alias + ".Params=");
        } else {
            jsDocBuilder.addParam("opt_data", "!" + alias + ".Params");
        }
        this.addIjDataParam(jsDocBuilder, false);
        if (addVariantParam) {
            jsDocBuilder.addParam("opt_variant", "string=");
        }
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        if (suppressCheckTypes) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        } else if (TemplateMetadata.buildTemplateType(node).getActualParameters().stream().anyMatch(TemplateType.Parameter::isImplicit)) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "missingProperties");
        }
        if (node instanceof TemplateElementNode) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "uselessCode");
            jsDocBuilder.addParameterizedAnnotation("suppress", "suspiciousCode");
        }
        return jsDocBuilder.build();
    }

    protected final void addReturnTypeAndAnnotations(TemplateNode node, JsDoc.Builder jsDocBuilder) {
        JsType returnType = this.getTemplateReturnType(node);
        jsDocBuilder.addParameterizedAnnotation("return", returnType.typeExpr());
        jsDocBuilder.addGoogRequires((Collection<? extends GoogRequire>)returnType.getGoogRequires());
        if (node.getVisibility() == Visibility.PRIVATE) {
            jsDocBuilder.addAnnotation("private");
        }
    }

    protected ImmutableList<Expression> templateArguments(TemplateNode node, boolean isPositionalStyle) {
        if (isPositionalStyle) {
            return ImmutableList.of((Object)Expressions.objectLiteral((Map)node.getParams().stream().collect(ImmutableMap.toImmutableMap(p -> GenJsCodeVisitor.genParamPropAlias(p.name()), p -> Expressions.id(GenJsCodeVisitor.getPositionalParamName(p))))), (Object)JsRuntime.IJ_DATA);
        }
        return ImmutableList.of((Object)JsRuntime.OPT_DATA, (Object)JsRuntime.IJ_DATA);
    }

    protected final Statement generateStubbingTest(TemplateNode node, String alias, boolean isPositionalStyle) {
        return Statements.ifStatement(JsRuntime.GOOG_DEBUG.and(JsRuntime.SOY_STUBS_MAP.bracketAccess(Expressions.stringLiteral(node.getTemplateName())), this.templateTranslationContext.codeGenerator()), Statements.returnValue(JsRuntime.SOY_STUBS_MAP.bracketAccess(Expressions.stringLiteral(node.getTemplateName())).call((Iterable<? extends Expression>)this.templateArguments(node, isPositionalStyle)))).build();
    }

    protected String ijDataTypeExpression(JsDoc.Builder jsDocBuilder) {
        GoogRequire googSoy = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.GOOG_SOY_ALIAS : JsRuntime.GOOG_SOY;
        jsDocBuilder.addGoogRequire(googSoy);
        return googSoy.alias() + ".IjData";
    }

    protected void addIjDataParam(JsDoc.Builder jsDocBuilder, boolean forPositionalSignature) {
        String ijDataTypeExpression = this.ijDataTypeExpression(jsDocBuilder);
        if (forPositionalSignature) {
            jsDocBuilder.addParam("$ijData", "!" + ijDataTypeExpression);
        } else {
            jsDocBuilder.addParam("opt_ijData", String.format("(?%s|?Object<string, *>)=", ijDataTypeExpression));
        }
    }

    private void generateIdomStub(TemplateNode templateNode, String alias, ImmutableList.Builder<Statement> bodyStatements, List<Expression> callParams) {
        if (!this.jsSrcOptions.shouldGenerateGoogModules() && templateNode.getContentKind() == SanitizedContentKind.HTML && templateNode.getVisibility() == Visibility.PUBLIC) {
            Expression stub = Expressions.dottedIdNoRequire(alias + "_soyInternalStubs");
            Statement functionStub = Statements.ifStatement(JsRuntime.SHOULD_STUB.and(stub, this.templateTranslationContext.codeGenerator()), Statements.returnValue(stub.call(callParams))).build();
            bodyStatements.add((Object)functionStub);
        }
    }

    @CheckReturnValue
    protected Statement generateDelegateFunction(TemplateNode templateNode, String alias) {
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (new ShouldEnsureDataIsDefinedVisitor().exec(templateNode)) {
            bodyStatements.add((Object)Statements.assign(JsRuntime.OPT_DATA, JsRuntime.OPT_DATA.or(Expressions.EMPTY_OBJECT_LITERAL, this.templateTranslationContext.codeGenerator())));
        }
        bodyStatements.add((Object)this.redeclareIjData());
        ArrayList<Expression> callParams = new ArrayList<Expression>((Collection<Expression>)this.getFixedParamsToPositionalCall(templateNode));
        for (TemplateParam param : this.paramsInOrder(templateNode)) {
            callParams.add(this.genCodeForParamAccess(GenJsCodeVisitor.genParamPropAlias(param.name()), param));
        }
        if (GenJsCodeVisitor.isModifiableWithUseVariantType(templateNode)) {
            callParams.add(JsRuntime.OPT_VARIANT);
        }
        this.generateIdomStub(templateNode, alias, (ImmutableList.Builder<Statement>)bodyStatements, callParams);
        boolean voidReturn = this.isIncrementalDom() && (templateNode.getContentKind().isHtml() || templateNode.getContentKind() == SanitizedContentKind.ATTRIBUTES);
        Expression callExpr = Expressions.dottedIdNoRequire(alias + "$").call(callParams);
        bodyStatements.add((Object)(voidReturn ? callExpr.asStatement() : Statements.returnValue(callExpr)));
        return Statements.of((Iterable<Statement>)bodyStatements.build());
    }

    protected ImmutableList<Expression> getFixedParamsToPositionalCall(TemplateNode node) {
        return ImmutableList.of((Object)JsRuntime.SOY_INTERNAL_CALL_MARKER, (Object)JsRuntime.IJ_DATA);
    }

    protected ImmutableList<Expression> getFixedParamsForNonPositionalCall(TemplateNode node) {
        return ImmutableList.of((Object)JsRuntime.OPT_DATA, (Object)Expressions.id("$ijData"));
    }

    protected final Statement redeclareIjData() {
        GoogRequire googSoy = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.GOOG_SOY_ALIAS : JsRuntime.GOOG_SOY;
        return VariableDeclaration.builder("$ijData").setRhs(Expressions.id("opt_ijData").castAs("!" + googSoy.alias() + ".IjData", (ImmutableSet<GoogRequire>)ImmutableSet.of((Object)googSoy))).build();
    }

    protected Statement generateModTemplateSelection(TemplateNode node, String alias, CodeChunk.Generator codeGenerator) {
        Expression delegateFn;
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (!this.generatePositionalParamsSignature) {
            bodyStatements.add((Object)this.redeclareIjData());
        } else {
            bodyStatements.add((Object)JsRuntime.SOY_ARE_YOU_AN_INTERNAL_CALLER.call(Expressions.id("$$areYouAnInternalCaller")).asStatement());
        }
        bodyStatements.add((Object)this.generateStubbingTest(node, alias, this.generatePositionalParamsSignature));
        Expression templateId = JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expressions.stringLiteral(this.delTemplateNamer.getDelegateName((TemplateBasicNode)node)));
        Expression expression = delegateFn = GenJsCodeVisitor.isModifiableWithUseVariantType(node) ? JsRuntime.SOY_GET_DELEGATE_FN.call(templateId, JsRuntime.OPT_VARIANT) : JsRuntime.SOY_GET_DELEGATE_FN.call(templateId);
        if (!this.generatePositionalParamsSignature) {
            bodyStatements.add((Object)Statements.returnValue(delegateFn.call((Iterable<? extends Expression>)this.getFixedParamsForNonPositionalCall(node))));
        } else {
            ArrayList<Expression> callParams = new ArrayList<Expression>((Collection<Expression>)this.getFixedParamsToPositionalCall(node));
            for (TemplateParam param : this.paramsInOrder(node)) {
                callParams.add(Expressions.id(GenJsCodeVisitor.genParamAlias(param.name())));
            }
            bodyStatements.add((Object)Statements.returnValue(delegateFn.call(callParams)));
        }
        return Statements.of((Iterable<Statement>)bodyStatements.build());
    }

    @CheckReturnValue
    protected Statement generateFunctionBody(TemplateNode node, String alias, @Nullable String objectParamName, boolean addStubMapLogic) {
        boolean isPositionalStyle = objectParamName == null;
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (!isPositionalStyle) {
            bodyStatements.add((Object)this.redeclareIjData());
            this.generateIdomStub(node, alias, (ImmutableList.Builder<Statement>)bodyStatements, (List<Expression>)this.templateArguments(node, isPositionalStyle));
        } else {
            bodyStatements.add((Object)JsRuntime.SOY_ARE_YOU_AN_INTERNAL_CALLER.call(Expressions.id("$$areYouAnInternalCaller")).asStatement());
        }
        if (addStubMapLogic) {
            bodyStatements.add((Object)this.generateStubbingTest(node, alias, isPositionalStyle));
        }
        if (!isPositionalStyle && new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            bodyStatements.add((Object)Statements.assign(JsRuntime.OPT_DATA, JsRuntime.OPT_DATA.or(Expressions.EMPTY_OBJECT_LITERAL, this.templateTranslationContext.codeGenerator())));
        }
        bodyStatements.add((Object)this.genParamTypeChecks(node, alias, isPositionalStyle));
        Preconditions.checkState((!(node instanceof TemplateElementNode) || ((TemplateElementNode)node).getStateVars().isEmpty() ? 1 : 0) != 0, (String)"state vars in %s should've been removed by DesugarStateNodesPass", (Object)node.getTemplateName());
        SanitizedContentKind kind = node.getContentKind();
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<Expression> templateBodyChunks = this.genJsExprsVisitor.exec(node);
            bodyStatements.add((Object)Statements.returnValue(this.sanitize(Expressions.concat(templateBodyChunks), kind)));
        } else {
            this.jsCodeBuilder.pushOutputVar("$output");
            Statement codeChunk = this.visitTemplateNodeChildren(node);
            this.jsCodeBuilder.popOutputVar();
            bodyStatements.add((Object)Statements.of(codeChunk, Statements.returnValue(this.sanitize(Expressions.id("$output"), kind))));
        }
        return Statements.of((Iterable<Statement>)bodyStatements.build());
    }

    private Statement visitTemplateNodeChildren(TemplateNode node) {
        return this.visitTemplateNodeChildren(node, this.errorReporter);
    }

    @VisibleForTesting
    Statement visitTemplateNodeChildren(TemplateNode node, ErrorReporter errorReporter) {
        return Statements.of(new GenJsTemplateBodyVisitor(this.outputVars, this.jsSrcOptions, this.javaScriptValueFactory, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.canInitOutputVarVisitor, this.genJsExprsVisitor, errorReporter, this.templateTranslationContext, this.templateAliases).visitChildren(node));
    }

    protected final Expression sanitize(Expression templateBody, SanitizedContentKind contentKind) {
        if (contentKind != SanitizedContentKind.TEXT) {
            return JsRuntime.sanitizedContentOrdainerFunction(contentKind).call(templateBody);
        }
        return templateBody;
    }

    protected TranslateExprNodeVisitor getExprTranslator() {
        return new TranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.templateAliases, this.errorReporter, JsRuntime.OPT_DATA);
    }

    protected Expression translateExpr(ExprNode expr) {
        return (Expression)this.getExprTranslator().exec(expr);
    }

    protected Expression genCodeForParamAccess(String paramName, TemplateParam param) {
        return this.getExprTranslator().genCodeForParamAccess(paramName, param);
    }

    @Override
    protected void visitJsImplNode(JsImplNode node) {
        Expression externReference;
        GoogRequire externRequire;
        ExternNode externNode = node.getParent();
        String externName = externNode.getIdentifier().originalName();
        if (this.templateTranslationContext.soyToJsVariableMappings().has(externName)) {
            return;
        }
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            externRequire = GoogRequire.createWithAlias(node.module(), node.module().replace('.', '$'));
            externReference = Expressions.dottedIdNoRequire(externRequire.alias()).dotAccess(node.function());
        } else {
            externRequire = GoogRequire.create(node.module());
            externReference = JsRuntime.GOOG_MODULE_GET.call(Expressions.stringLiteral(node.module())).dotAccess(node.function());
        }
        this.jsCodeBuilder.addGoogRequire(externRequire);
        this.templateTranslationContext.soyToJsVariableMappings().put(externName, externReference);
        if (externNode.isExported()) {
            SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
            Expression exportAlias = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.EXPORTS : Expressions.dottedIdNoRequire(file.getNamespace());
            Expression export = exportAlias.dotAccess(externName);
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]).append(Statements.assign(export, externReference, JsDoc.builder().addAnnotation("const").build()));
        }
    }

    private String genParamsRecordType(TemplateNode node) {
        HashSet<String> paramNames = new HashSet<String>();
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        for (TemplateParam param : this.paramsInOrder(node)) {
            if (param.isImplicit()) continue;
            JsType jsType = this.getJsTypeForParamForDeclaration(param.type());
            record.put(GenJsCodeVisitor.genParamPropAlias(param.name()), jsType.typeExprForRecordMember(!param.isRequired()));
            for (GoogRequire require : jsType.getGoogRequires()) {
                this.jsCodeBuilder.addGoogRequire(require);
            }
            paramNames.add(param.name());
        }
        IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(node);
        for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
            if (paramNames.contains(indirectParamName)) continue;
            ImmutableSet paramTypes = ipi.indirectParamTypes.get((Object)indirectParamName);
            SoyType combinedType = SoyTypes.computeLowestCommonType(this.typeRegistry, (Collection<SoyType>)paramTypes);
            if (ipi.mayHaveIndirectParamsInExternalDelCalls && SoyTypes.hasProtoDep(combinedType)) continue;
            SoyType indirectParamType = SoyTypes.makeNullable(combinedType);
            JsType jsType = this.getJsTypeForParamForDeclaration(indirectParamType);
            this.jsCodeBuilder.addGoogRequires((Iterable)jsType.getGoogRequires().stream().map(GoogRequire::toRequireType).collect(ImmutableList.toImmutableList()));
            record.put(indirectParamName, jsType.typeExprForRecordMember(true));
        }
        return JsType.toRecord(record);
    }

    protected final Statement genParamDefault(TemplateParam param, Expression paramTempVar, JsType typeForCast, CodeChunk.Generator codeGenerator) {
        Preconditions.checkArgument((boolean)param.hasDefault());
        return Statements.assign(paramTempVar, Expressions.ifExpression(paramTempVar.tripleEquals(Expressions.LITERAL_UNDEFINED), this.translateExpr(param.defaultValue())).setElse(paramTempVar).build(codeGenerator).castAs(typeForCast.typeExpr(), typeForCast.getGoogRequires()));
    }

    @CheckReturnValue
    protected Statement genParamTypeChecks(TemplateNode node, String alias, boolean isPositionalStyle) {
        ImmutableList.Builder declarations = ImmutableList.builder();
        for (TemplateParam param : node.getAllParams()) {
            String paramName = param.name();
            SoyType paramType = param.type();
            boolean isThisParamPositional = isPositionalStyle && !param.isInjected();
            CodeChunk.Generator generator = this.templateTranslationContext.codeGenerator();
            String paramAlias = GenJsCodeVisitor.genParamAlias(paramName);
            Expression paramChunk = isThisParamPositional ? Expressions.id(GenJsCodeVisitor.getPositionalParamName(param)) : this.genCodeForParamAccess(paramName, param);
            JsType jsType = this.getJsTypeForParamTypeCheck(paramType);
            if (param.hasDefault()) {
                if (!isThisParamPositional) {
                    paramChunk = generator.declarationBuilder().setMutable().setRhs(paramChunk).build().ref();
                }
                declarations.add((Object)this.genParamDefault(param, paramChunk, jsType, generator));
            }
            Expression initializer = jsType.getSoyParamTypeAssertion(paramChunk, paramName, param.isInjected() ? "@inject" : "@param", generator).orElse(paramChunk);
            JsType declType = this.getJsTypeForParamForDeclaration(paramType);
            if (!jsType.typeExpr().equals(declType.typeExpr()) && !JsSrcUtils.isReservedWord(paramName)) {
                initializer = initializer.castAs(jsType.typeExpr(), jsType.getGoogRequires());
            }
            VariableDeclaration.Builder declarationBuilder = VariableDeclaration.builder(paramAlias).setRhs(initializer).setRequires((Iterable<GoogRequire>)jsType.getGoogRequires());
            declarationBuilder.setJsDoc(JsDoc.builder().addParameterizedAnnotation("const", jsType.typeExpr()).build());
            VariableDeclaration declaration = declarationBuilder.build();
            declarations.add((Object)declaration);
            this.templateTranslationContext.soyToJsVariableMappings().put(param, Expressions.id(paramAlias));
        }
        return Statements.of((Iterable<Statement>)declarations.build());
    }

    protected JsType getJsTypeForParamForDeclaration(SoyType paramType) {
        return JsType.forJsSrc(paramType);
    }

    protected JsType getJsTypeForParam(SoyType paramType) {
        return JsType.forJsSrc(paramType);
    }

    protected JsType getJsTypeForParamTypeCheck(SoyType paramType) {
        return JsType.forJsTypeCheck(paramType);
    }

    public static String genParamAlias(String paramName) {
        return JsSrcUtils.isReservedWord(paramName) ? "param$" + paramName : paramName;
    }

    public static String genParamPropAlias(String paramName) {
        return JsSrcUtils.isPropertyOfObject(paramName) ? "param$" + paramName : paramName;
    }

    protected boolean isIncrementalDom() {
        return false;
    }

    private String namespaceForPath(SourceLogicalPath path) {
        return this.fileSetMetadata.getNamespaceForPath(path);
    }
}

