/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.$AutoValue_VariableDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableReference;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class VariableDeclaration
extends Statement
implements CodeChunk.HasRequires {
    public static Builder builder(String name) {
        return new $AutoValue_VariableDeclaration.Builder().setVarName(name).setRequires((ImmutableSet<GoogRequire>)ImmutableSet.of()).setIsMutable(false).setIsExported(false).setIsDeclaration(false);
    }

    public abstract String varName();

    @Nullable
    abstract Expression rhs();

    @Nullable
    abstract JsDoc jsDoc();

    abstract ImmutableSet<GoogRequire> requires();

    abstract boolean isMutable();

    abstract boolean isExported();

    abstract boolean isDeclaration();

    @Nullable
    abstract Expression type();

    public Expression ref() {
        return VariableReference.of(this);
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        if (this.rhs() != null) {
            ctx.appendInitialStatements(this.rhs());
        }
        if (this.jsDoc() != null) {
            ctx.appendAll(this.jsDoc()).endLine();
        }
        if (this.isExported()) {
            ctx.append("export ");
        }
        if (this.isDeclaration()) {
            ctx.append("declare ");
        }
        if (!this.varName().contains(".")) {
            ctx.append(this.isMutable() || this.rhs() == null && !this.isDeclaration() ? "let " : "const ");
        }
        ctx.append(this.varName());
        if (this.type() != null) {
            ctx.noBreak().append(": ").appendOutputExpression(this.type());
        }
        if (this.rhs() != null) {
            ctx.noBreak().append(" = ").appendOutputExpression(this.rhs());
        }
        ctx.noBreak().append(";").endLine();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.rhs(), this.jsDoc(), this.type()).filter(Objects::nonNull);
    }

    @Override
    @Memoized
    public ImmutableSet<GoogRequire> googRequires() {
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder().addAll(this.requires());
        if (this.rhs() != null) {
            this.rhs().collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        }
        if (this.jsDoc() != null) {
            this.jsDoc().collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        }
        if (this.type() != null) {
            this.type().collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        }
        return requiresBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setVarName(String var1);

        public abstract Builder setJsDoc(JsDoc var1);

        public abstract Builder setRhs(Expression var1);

        @CanIgnoreReturnValue
        public Builder setRequires(Iterable<GoogRequire> requires) {
            return this.setRequires((ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires));
        }

        abstract Builder setRequires(ImmutableSet<GoogRequire> var1);

        public final Builder setMutable() {
            return this.setIsMutable(true);
        }

        abstract Builder setIsMutable(boolean var1);

        public abstract Builder setIsExported(boolean var1);

        public abstract Builder setIsDeclaration(boolean var1);

        public abstract Builder setType(Expression var1);

        public abstract VariableDeclaration build();
    }
}

