/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_UnaryOperation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Precedence;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class UnaryOperation
extends Operation {
    UnaryOperation() {
    }

    abstract String operator();

    abstract Expression arg();

    abstract boolean isPrefix();

    static UnaryOperation create(Operator operator, Expression arg) {
        return new AutoValue_UnaryOperation(Precedence.forSoyOperator(operator), Operation.getOperatorToken(operator), arg, operator != Operator.ASSERT_NON_NULL);
    }

    static UnaryOperation create(String operatorString, Precedence precedence, Expression arg, boolean isPrefix) {
        return new AutoValue_UnaryOperation(precedence, operatorString, arg, isPrefix);
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.Associativity.UNARY;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.arg());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.isPrefix()) {
            ctx.append(this.operator());
            ctx.noBreak();
            this.formatOperand(this.arg(), OperandPosition.LEFT, ctx);
        } else {
            this.formatOperand(this.arg(), OperandPosition.LEFT, ctx);
            ctx.noBreak();
            ctx.append(this.operator());
        }
    }
}

