/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.jssrc.dsl.AutoValue_TsxPrintNode;
import com.google.template.soy.jssrc.dsl.AutoValue_TsxPrintNode_CommandChar;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.LineComment;
import com.google.template.soy.jssrc.dsl.RangeComment;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import java.util.Optional;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class TsxPrintNode
extends Expression {
    public static final CommandChar NIL = CommandChar.create("", false);

    public static TsxPrintNode wrap(CodeChunk expr) {
        if (expr instanceof TsxPrintNode) {
            return (TsxPrintNode)expr;
        }
        if (expr instanceof Expression) {
            return new AutoValue_TsxPrintNode(((Expression)expr).asInlineExpr());
        }
        if (expr instanceof LineComment) {
            return new AutoValue_TsxPrintNode(RangeComment.create(((LineComment)expr).content(), true));
        }
        if (expr instanceof RangeComment) {
            return new AutoValue_TsxPrintNode(expr);
        }
        throw new ClassCastException(expr.getClass().getName());
    }

    public static Expression wrapIfNeeded(StringLiteral s) {
        if (s.quoteStyle() == QuoteStyle.BACKTICK) {
            return TsxPrintNode.wrap(s);
        }
        return s;
    }

    public abstract CodeChunk expr();

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.expr());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(ctx.getInterpolationOpenString());
        ctx.pushLexicalState(FormattingContext.LexicalState.JS);
        ctx.increaseIndent();
        if (this.expr() instanceof Expression) {
            ctx.appendOutputExpression((Expression)this.expr());
        } else {
            ctx.appendAll(this.expr());
        }
        ctx.popLexicalState();
        ctx.append(ctx.getInterpolationCloseString());
        ctx.decreaseIndent();
    }

    @Override
    public boolean isCheap() {
        return !(this.expr() instanceof Expression) || ((Expression)this.expr()).isCheap();
    }

    @Immutable
    @AutoValue
    public static abstract class CommandChar
    extends Expression {
        public static CommandChar create(String charContents) {
            return CommandChar.create(charContents, false);
        }

        public static CommandChar create(String charContents, boolean endLineAfterChar) {
            return new AutoValue_TsxPrintNode_CommandChar(Optional.of(StringLiteral.create(charContents)), endLineAfterChar);
        }

        abstract Optional<Expression> expr();

        abstract boolean endLineAfterChar();

        @Override
        Stream<? extends CodeChunk> childrenStream() {
            return this.expr().isPresent() ? Stream.of(this.expr().get()) : Stream.empty();
        }

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
            String literalValue = ((StringLiteral)this.expr().get()).literalValue();
            if (ctx.getCurrentLexicalState() == FormattingContext.LexicalState.TTL && literalValue.equals(" ")) {
                ctx.append(literalValue);
                return;
            }
            String open = ctx.getInterpolationOpenString();
            String close = ctx.getInterpolationCloseString();
            Object value = "";
            if (this.expr().isPresent()) {
                value = "'" + literalValue + "'";
            }
            ctx.append(open + (String)value + close);
            if (this.endLineAfterChar()) {
                ctx.endLine();
            }
        }
    }
}

