/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jssrc.dsl.AutoValue_TsInterface;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.ParamDecl;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.List;
import java.util.stream.Stream;

@AutoValue
public abstract class TsInterface
extends Statement {
    abstract String name();

    abstract ImmutableList<ParamDecl> properties();

    abstract ImmutableMap<String, JsDoc> docs();

    abstract boolean isExported();

    public static TsInterface create(String name, List<ParamDecl> properties) {
        return new AutoValue_TsInterface(name, (ImmutableList<ParamDecl>)ImmutableList.copyOf(properties), (ImmutableMap<String, JsDoc>)ImmutableMap.of(), false);
    }

    public static TsInterface create(String name, List<ParamDecl> properties, ImmutableMap<String, JsDoc> docs, boolean isExported) {
        return new AutoValue_TsInterface(name, (ImmutableList<ParamDecl>)ImmutableList.copyOf(properties), docs, isExported);
    }

    public boolean hasDoc() {
        return !this.docs().isEmpty();
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        if (this.isExported()) {
            ctx.append("export ");
        }
        ctx.append(String.format("interface %s ", this.name()));
        ctx.enterBlock();
        for (ParamDecl prop : this.properties()) {
            if (this.docs().containsKey((Object)prop.name())) {
                ctx.appendAll((CodeChunk)this.docs().get((Object)prop.name()));
                ctx.endLine();
            }
            ctx.append(String.format("%s%s", prop.name(), prop.optional() ? "?" : ""));
            if (prop.type() != null) {
                ctx.append(": ");
                ctx.appendOutputExpression(prop.type());
            }
            ctx.noBreak().append(";");
            ctx.endLine();
        }
        ctx.close();
        ctx.endLine();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.properties().stream();
    }
}

