/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import com.google.template.soy.jssrc.dsl.Statements;
import java.util.List;

@Immutable
public abstract class Statement
extends CodeChunk {
    Statement() {
    }

    @Override
    final void doFormatInitialStatements(FormattingContext ctx) {
        this.doFormatStatement(ctx);
    }

    @Override
    public final Statement asStatement() {
        return this;
    }

    public Expression asExpr() {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be represented as an expression");
    }

    abstract void doFormatStatement(FormattingContext var1);

    public boolean isTerminal() {
        return false;
    }

    public Statement append(List<SpecialToken> tokens) {
        return Statements.DecoratedStatement.create(this, tokens, (List<SpecialToken>)ImmutableList.of());
    }

    public Statement prepend(List<SpecialToken> tokens) {
        return Statements.DecoratedStatement.create(this, (List<SpecialToken>)ImmutableList.copyOf(tokens), (List<SpecialToken>)ImmutableList.of());
    }

    public final Statement prepend(SpecialToken ... tokens) {
        return this.prepend((List<SpecialToken>)ImmutableList.copyOf((Object[])tokens));
    }
}

