/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Return;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class Return
extends Statement {
    private static final Return EMPTY_RETURN = new AutoValue_Return(null);

    @Nullable
    abstract Expression value();

    public static Return create(Expression value) {
        return new AutoValue_Return(value);
    }

    public static Return create() {
        return EMPTY_RETURN;
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        if (this.value() != null) {
            ctx.appendInitialStatements(this.value());
        }
        ctx.append("return");
        if (this.value() != null) {
            ctx.noBreak().append(" ").noBreak().appendOutputExpression(this.value());
        }
        ctx.noBreak().append(";");
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.value() != null ? Stream.of(this.value()) : Stream.empty();
    }

    @Override
    public Expression asExpr() {
        if (this.value() != null) {
            return this.value();
        }
        return super.asExpr();
    }

    @Override
    public boolean isTerminal() {
        return true;
    }
}

