/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ObjectLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class ObjectLiteral
extends Expression {
    private static final String SPREAD_PREFIX = "_object_literal_spread_xxx_";
    private static final AtomicInteger SERIAL = new AtomicInteger();

    static String newSpread() {
        return SPREAD_PREFIX + SERIAL.incrementAndGet();
    }

    public static boolean isSpreadKey(String key) {
        return key.startsWith(SPREAD_PREFIX);
    }

    private static boolean isSpread(Expression e) {
        String leafText = Expressions.getLeafText(e);
        return leafText != null && leafText.startsWith(SPREAD_PREFIX) || e instanceof StringLiteral && ((StringLiteral)e).literalValue().startsWith(SPREAD_PREFIX);
    }

    abstract ImmutableMap<Expression, Expression> values();

    static ObjectLiteral create(Map<String, Expression> object) {
        return ObjectLiteral.create(object, Expressions::id);
    }

    private static ObjectLiteral create(Map<String, Expression> object, Function<String, Expression> createKeyFn) {
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Map.Entry<String, Expression> entry : object.entrySet()) {
            Expression key = createKeyFn.apply(entry.getKey());
            Expression value = entry.getValue();
            if (ObjectLiteral.isSpread(key) && !Expressions.isSpread(value)) {
                value = Expressions.spread(value);
            }
            values.put((Object)key, (Object)value);
        }
        return new AutoValue_ObjectLiteral((ImmutableMap<Expression, Expression>)values.buildOrThrow());
    }

    static ObjectLiteral createWithQuotedKeys(Map<String, Expression> object) {
        return ObjectLiteral.create(object, Expressions::stringLiteral);
    }

    public ObjectLiteral append(String key, Expression expression) {
        Expression newKey = Expressions.id(key);
        if (ObjectLiteral.isSpread(newKey) && !Expressions.isSpread(expression)) {
            expression = Expressions.spread(expression);
        }
        return new AutoValue_ObjectLiteral((ImmutableMap<Expression, Expression>)ImmutableMap.builder().putAll(this.values()).put((Object)newKey, (Object)expression).buildOrThrow());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('{');
        boolean first = true;
        for (Map.Entry entry : this.values().entrySet()) {
            first = ctx.commaAfterFirst(first);
            if (ObjectLiteral.isSpread((Expression)entry.getKey())) {
                ctx.appendOutputExpression((Expression)entry.getValue());
                continue;
            }
            String keyText = Expressions.getLeafText((Expression)entry.getKey());
            if (keyText != null && keyText.equals(Expressions.getLeafText((Expression)entry.getValue()))) {
                ctx.appendOutputExpression((Expression)entry.getKey());
                continue;
            }
            ctx.appendOutputExpression((Expression)entry.getKey()).noBreak().append(": ").appendOutputExpression((Expression)entry.getValue());
        }
        ctx.append('}');
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return true;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.concat(this.values().keySet().stream(), this.values().values().stream());
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return true;
    }
}

