/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.template.soy.jssrc.dsl.AutoValue_NamedFunctionDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.ParamDecls;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@AutoValue
public abstract class NamedFunctionDeclaration
extends Statement {
    abstract String name();

    abstract ParamDecls params();

    abstract Expression returnType();

    abstract Optional<JsDoc> jsDoc();

    @Nullable
    abstract ImmutableList<Statement> bodyStmts();

    abstract boolean isExported();

    abstract boolean isDeclaration();

    public static NamedFunctionDeclaration create(String name, ParamDecls params, Expression returnType, JsDoc jsDoc, List<Statement> bodyStmts, boolean isExported) {
        return new AutoValue_NamedFunctionDeclaration(name, params, returnType, Optional.of(jsDoc), (ImmutableList<Statement>)ImmutableList.copyOf(bodyStmts), isExported, false);
    }

    public static NamedFunctionDeclaration create(String name, ParamDecls params, Expression returnType, List<Statement> bodyStmts, boolean isExported) {
        return new AutoValue_NamedFunctionDeclaration(name, params, returnType, Optional.empty(), (ImmutableList<Statement>)ImmutableList.copyOf(bodyStmts), isExported, false);
    }

    public static NamedFunctionDeclaration overload(String name, ParamDecls params, Expression returnType, boolean isExported) {
        return new AutoValue_NamedFunctionDeclaration(name, params, returnType, Optional.empty(), null, isExported, false);
    }

    public static NamedFunctionDeclaration declaration(String name, ParamDecls params, Expression returnType, @Nullable JsDoc jsDoc) {
        return new AutoValue_NamedFunctionDeclaration(name, params, returnType, Optional.ofNullable(jsDoc), null, true, true);
    }

    public static NamedFunctionDeclaration privateDeclaration(String name, ParamDecls params, Expression returnType) {
        return new AutoValue_NamedFunctionDeclaration(name, params, returnType, Optional.empty(), (ImmutableList<Statement>)ImmutableList.of(), false, true);
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        if (this.jsDoc().isPresent()) {
            ctx.appendAll(this.jsDoc().get());
        }
        ctx.endLine();
        if (this.isExported()) {
            ctx.append("export ");
        }
        if (this.isDeclaration()) {
            ctx.append("declare ");
        }
        ctx.append("function " + this.name() + "(");
        ctx.appendOutputExpression(this.params());
        ctx.append("): ").appendOutputExpression(this.returnType());
        if (this.bodyStmts() != null) {
            ctx.append(" ");
            ctx.enterBlock();
            for (Statement stmt : this.bodyStmts()) {
                ctx.appendAll(stmt);
                ctx.endLine();
            }
            ctx.close();
        } else {
            ctx.noBreak().append(";");
        }
        ctx.endLine();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Streams.concat((Stream[])new Stream[]{this.bodyStmts() != null ? this.bodyStmts().stream() : Stream.of(new CodeChunk[0]), Stream.of(this.params(), this.returnType(), this.jsDoc().orElse(null)).filter(Objects::nonNull)});
    }
}

