/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Leaf;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class Leaf
extends Expression
implements CodeChunk.HasRequires {
    Leaf() {
    }

    static Leaf create(String text, boolean isCheap, Iterable<GoogRequire> require) {
        return Leaf.create(new JsExpr(text, Integer.MAX_VALUE), isCheap, (Iterable<GoogRequire>)ImmutableSet.copyOf(require), false, false);
    }

    static Leaf create(String text, boolean isCheap) {
        return Leaf.create(text, isCheap, (Iterable<GoogRequire>)ImmutableSet.of());
    }

    static Leaf createNonNull(String text, boolean isCheap) {
        return Leaf.create(new JsExpr(text, Integer.MAX_VALUE), isCheap, (Iterable<GoogRequire>)ImmutableSet.of(), false, true);
    }

    static Leaf create(JsExpr value, boolean isCheap, Iterable<GoogRequire> requires) {
        return Leaf.create(value, isCheap, requires, true, false);
    }

    private static Leaf create(JsExpr value, boolean isCheap, Iterable<GoogRequire> requires, boolean initialExpressionIsObjectLiteral, boolean nonNull) {
        return new AutoValue_Leaf(value, (ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires), isCheap, initialExpressionIsObjectLiteral, nonNull);
    }

    abstract JsExpr value();

    @Override
    public abstract ImmutableSet<GoogRequire> googRequires();

    @Override
    public abstract boolean isCheap();

    @Override
    abstract boolean initialExpressionIsObjectLiteral();

    @Override
    public abstract boolean isDefinitelyNotNull();

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.empty();
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.appendForeignCode(this.value().getText());
    }

    @Override
    public JsExpr singleExprOrName(FormatOptions formatOptions) {
        return this.value();
    }
}

