/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_JsDoc;
import com.google.template.soy.jssrc.dsl.AutoValue_JsDoc_Param;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class JsDoc
extends SpecialToken
implements CodeChunk.HasRequires {
    public static JsDoc getDefaultInstance() {
        return JsDoc.builder().build();
    }

    public static Builder builder() {
        return new AutoValue_JsDoc.Builder().setOverviewComment("");
    }

    abstract String overviewComment();

    @Override
    public abstract ImmutableSet<GoogRequire> googRequires();

    public abstract ImmutableList<Param> params();

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.empty();
    }

    @Override
    void doFormatToken(FormattingContext ctx) {
        if (this.isEmpty()) {
            return;
        }
        if (this.isSingleLine()) {
            ctx.append(this.toString());
            return;
        }
        ctx.append("/**");
        ctx.pushLexicalState(FormattingContext.LexicalState.RANGE_COMMENT);
        ctx.endLine();
        if (!this.overviewComment().isEmpty()) {
            for (String s : Splitter.on((char)'\n').split((CharSequence)this.overviewComment())) {
                ctx.append(" *" + (String)(s.isEmpty() ? "" : " " + s));
                ctx.endLine();
            }
            if (!this.params().isEmpty()) {
                ctx.append(" *");
                ctx.endLine();
            }
        }
        for (Param param : this.params()) {
            ctx.append(" * ");
            param.format(ctx);
            ctx.endLine();
        }
        ctx.append(" */");
        ctx.popLexicalState();
        ctx.endLine();
    }

    public final String toString() {
        if (this.isEmpty()) {
            return "";
        }
        if (this.isSingleLine()) {
            return String.format("/** %s */", this.overviewComment() + String.valueOf(this.params().size() == 1 ? this.params().get(0) : ""));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        if (this.overviewComment().length() > 0) {
            for (String s : Splitter.on((char)'\n').split((CharSequence)this.overviewComment())) {
                sb.append(" *").append((String)(s.isEmpty() ? "" : " " + s)).append("\n");
            }
            if (!this.params().isEmpty()) {
                sb.append(" *\n");
            }
        }
        for (Param param : this.params()) {
            sb.append(" * ").append(param).append("\n");
        }
        sb.append(" */");
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.params().isEmpty() && this.overviewComment().isEmpty();
    }

    private boolean isSingleLine() {
        if (this.overviewComment().contains("\n")) {
            return false;
        }
        return this.params().size() == 0 || this.overviewComment().isEmpty() && this.params().size() == 1 && !((Param)this.params().get(0)).annotationType().equals("typedef") && ((Param)this.params().get(0)).recordLiteralType() == null;
    }

    @Immutable
    @AutoValue
    public static abstract class Param {
        public abstract String annotationType();

        @Nullable
        abstract String field();

        @Nullable
        public abstract String type();

        @Nullable
        public abstract String paramTypeName();

        @Nullable
        abstract ImmutableMap<String, String> recordLiteralType();

        static Param createAnnotation(String annotationType, String field) {
            Preconditions.checkArgument((!annotationType.startsWith("@") ? 1 : 0) != 0);
            return new AutoValue_JsDoc_Param(annotationType, field, null, null, null);
        }

        static Param create(String annotationType, String type) {
            Preconditions.checkArgument((!annotationType.startsWith("@") ? 1 : 0) != 0);
            return new AutoValue_JsDoc_Param(annotationType, null, type, null, null);
        }

        static Param create(String annotationType, String type, String paramTypeName) {
            Preconditions.checkArgument((!annotationType.startsWith("@") ? 1 : 0) != 0);
            return new AutoValue_JsDoc_Param(annotationType, null, type, paramTypeName, null);
        }

        static Param create(String annotationType, String paramTypeName, ImmutableMap<String, String> recordLiteralType) {
            return new AutoValue_JsDoc_Param(annotationType, null, null, paramTypeName, recordLiteralType);
        }

        void format(FormattingContext ctx) {
            if (this.recordLiteralType() != null) {
                ctx.append(String.format("@%s {{", this.annotationType()));
                ctx.endLine();
                for (Map.Entry entry : this.recordLiteralType().entrySet()) {
                    ctx.append(" *   " + (String)entry.getKey() + ": " + (String)entry.getValue() + ",");
                    ctx.endLine();
                }
                ctx.append(String.format(" * }} %s", this.paramTypeName()));
            } else {
                ctx.append(this.toString());
            }
        }

        public final String toString() {
            if (this.type() == null && Strings.isNullOrEmpty((String)this.field())) {
                return String.format("@%s", this.annotationType());
            }
            if (this.field() != null) {
                return String.format("@%s %s", this.annotationType(), this.field());
            }
            if (this.paramTypeName() == null) {
                return String.format("@%s {%s}", this.annotationType(), this.type());
            }
            return String.format("@%s {%s} %s", this.annotationType(), this.type(), this.paramTypeName());
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract ImmutableList.Builder<Param> paramsBuilder();

        abstract ImmutableSet.Builder<GoogRequire> googRequiresBuilder();

        public abstract JsDoc build();

        @CanIgnoreReturnValue
        public Builder addGoogRequire(GoogRequire require) {
            this.googRequiresBuilder().add((Object)require);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addGoogRequires(Collection<? extends GoogRequire> requires) {
            this.googRequiresBuilder().addAll(requires);
            return this;
        }

        @CanIgnoreReturnValue
        public abstract Builder setOverviewComment(String var1);

        @CanIgnoreReturnValue
        public Builder addParameterizedAnnotation(String name, String value) {
            this.paramsBuilder().add((Object)Param.create(name, value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(String type) {
            this.paramsBuilder().add((Object)Param.createAnnotation(type, null));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(String type, String value) {
            this.paramsBuilder().add((Object)Param.createAnnotation(type, value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTsParam(String name, String description) {
            Object value = name;
            if (description != null && !description.isEmpty()) {
                value = (String)value + " " + description;
            }
            this.paramsBuilder().add((Object)Param.createAnnotation("param", (String)value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParam(String name, String type) {
            this.paramsBuilder().add((Object)Param.create("param", type, name));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParam(String name, ImmutableMap<String, String> recordLiteralType) {
            this.paramsBuilder().add((Object)Param.create("param", name, recordLiteralType));
            return this;
        }
    }
}

