/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.template.soy.jssrc.dsl.AutoValue_JsArrowFunction;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.stream.Stream;

@AutoValue
public abstract class JsArrowFunction
extends Expression
implements Expression.InitialStatementsScope {
    abstract JsDoc jsDoc();

    abstract Statement body();

    public static JsArrowFunction create(JsDoc jsDoc, Statement body) {
        return new AutoValue_JsArrowFunction(jsDoc, body);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.body(), this.jsDoc());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        Expression exprBody;
        boolean paramsNeedParens;
        boolean bl = paramsNeedParens = this.jsDoc().params().size() != 1;
        if (paramsNeedParens) {
            ctx.append("(");
        }
        ctx.append(FunctionDeclaration.generateParamList(this.jsDoc(), true));
        if (paramsNeedParens) {
            ctx.append(")");
        }
        ctx.append(" => ");
        if (this.body() instanceof Return && (exprBody = ((Return)this.body()).value()).isRepresentableAsSingleExpression()) {
            if (exprBody.initialExpressionIsObjectLiteral()) {
                exprBody = Group.create(exprBody);
            }
            ctx.appendOutputExpression(exprBody);
            return;
        }
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.body());
        }
    }
}

