/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.jssrc.dsl.AutoValue_ImportsBuilder_ProtoImportData;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Import;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.TsxFragmentElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ImportsBuilder {
    public static final String NO_ALIAS = "";
    private final SortedMap<String, ImportList> imports = new TreeMap<String, ImportList>();
    private boolean hasElementImport;
    private boolean hasFragmentImport;
    private final Map<String, ProtoImportData> protoImportData = new HashMap<String, ProtoImportData>();

    public boolean needsElm() {
        return this.hasElementImport;
    }

    public boolean needsFrag() {
        return this.hasFragmentImport;
    }

    private void importSymbol(ProtoImportData data) {
        if (data.alias().isEmpty()) {
            this.importSymbol(data.file(), data.symbol());
        } else {
            this.importSymbolAlias(data.file(), data.symbol(), data.alias());
        }
    }

    public void importSymbol(String file, String symbol) {
        this.imports.computeIfAbsent(file, k -> new ImportList()).addSymbol(symbol);
    }

    public void importSymbolAlias(String file, String symbol, String alias) {
        this.imports.computeIfAbsent(file, k -> new ImportList()).addSymbol(String.format("%s as %s", symbol, alias));
    }

    public void importModule(String file, String symbol) {
        this.imports.computeIfAbsent(file, k -> new ImportList()).addModuleImport(symbol);
    }

    public void importProto(String file, String symbol, String fqn) {
        this.protoImportData.put(fqn, ProtoImportData.create(file, symbol, NO_ALIAS));
    }

    public void importProtoAlias(String file, String symbol, String alias, String fqn) {
        this.protoImportData.put(fqn, ProtoImportData.create(file, symbol, alias));
    }

    public String useImportedProtoSymbol(String fqn, JspbApi api) {
        int dotIndex;
        ProtoImportData data;
        String topLevelMsg = fqn;
        Object dotPlusNestedSymbol = NO_ALIAS;
        while ((data = this.protoImportData.get(topLevelMsg)) == null && (dotIndex = topLevelMsg.lastIndexOf(".")) != -1) {
            dotPlusNestedSymbol = topLevelMsg.substring(dotIndex) + (String)dotPlusNestedSymbol;
            topLevelMsg = topLevelMsg.substring(0, dotIndex);
        }
        if (data == null) {
            throw new IllegalArgumentException("Unexpected proto: " + fqn);
        }
        if (api == JspbApi.MUTABLE) {
            this.importSymbol(data);
            return data.aliasOrSymbol() + (String)dotPlusNestedSymbol;
        }
        if (!((String)dotPlusNestedSymbol).isEmpty()) {
            this.importSymbol(data);
            return data.aliasOrSymbol() + api.transform((String)dotPlusNestedSymbol);
        }
        if (data.alias().isEmpty()) {
            this.importSymbol(data.file(), api.transform(data.symbol()));
            return api.transform(data.symbol());
        }
        this.importSymbolAlias(data.file(), api.transform(data.symbol()), api.transform(data.alias()));
        return api.transform(data.alias());
    }

    public CodeChunk build() {
        ArrayList<Statement> importStatements = new ArrayList<Statement>();
        for (Map.Entry<String, ImportList> entry : this.imports.entrySet()) {
            ImportList importList = entry.getValue();
            if (!importList.importedSymbols.isEmpty()) {
                importStatements.add(Import.symbolImport(importList.importedSymbols, entry.getKey()));
            }
            for (String moduleAlias : importList.moduleAliases) {
                importStatements.add(Import.moduleImport(moduleAlias, entry.getKey()));
            }
        }
        return Statements.of(importStatements);
    }

    public void ingest(Iterable<? extends CodeChunk> statements) {
        ArrayList requires = new ArrayList();
        for (CodeChunk codeChunk : statements) {
            codeChunk.collectRequires(requires::add);
        }
        for (GoogRequire googRequire : requires) {
            if (googRequire == TsxFragmentElement.FRAGMENT) {
                this.hasFragmentImport = true;
                continue;
            }
            if (googRequire == TsxFragmentElement.ELEMENT) {
                this.hasElementImport = true;
                continue;
            }
            if (googRequire.chunk() instanceof Import) {
                Import i = (Import)googRequire.chunk();
                ImportList list = this.imports.computeIfAbsent(i.path(), k -> new ImportList());
                for (String symbol : i.symbols()) {
                    list.addSymbolRaw(symbol);
                }
                continue;
            }
            throw new IllegalArgumentException("Not an import: " + googRequire.chunk().getCode(FormatOptions.JSSRC));
        }
    }

    public Collection<String> getCollisions() {
        TreeSet<String> collisions = new TreeSet<String>();
        HashMap<String, String> symbolToPathMap = new HashMap<String, String>();
        for (Map.Entry<String, ImportList> entry : this.imports.entrySet()) {
            for (String symbol : entry.getValue().importedSymbols) {
                if (symbolToPathMap.containsKey(symbol)) {
                    collisions.add("{" + symbol + "} from " + entry.getKey());
                    collisions.add("{" + symbol + "} from " + (String)symbolToPathMap.get(symbol));
                    continue;
                }
                symbolToPathMap.put(symbol, entry.getKey());
            }
        }
        return collisions;
    }

    private static class ImportList {
        private final SortedSet<String> importedSymbols = new TreeSet<String>();
        private final SortedSet<String> moduleAliases = new TreeSet<String>();

        ImportList() {
        }

        void addSymbol(String symbol) {
            this.importedSymbols.add(symbol);
        }

        void addSymbolRaw(String symbol) {
            if (symbol.startsWith("* as ")) {
                this.addModuleImport(symbol.substring(5));
            } else {
                this.addSymbol(symbol);
            }
        }

        void addModuleImport(String symbol) {
            this.moduleAliases.add(symbol);
        }
    }

    @AutoValue
    static abstract class ProtoImportData {
        ProtoImportData() {
        }

        static ProtoImportData create(String file, String symbol, String alias) {
            Preconditions.checkArgument((!symbol.equals(alias) ? 1 : 0) != 0);
            return new AutoValue_ImportsBuilder_ProtoImportData(file, symbol, alias);
        }

        abstract String file();

        abstract String symbol();

        abstract String alias();

        String aliasOrSymbol() {
            return this.alias().isEmpty() ? this.symbol() : this.alias();
        }
    }

    public static enum JspbApi {
        MUTABLE,
        IMMUTABLE{

            @Override
            String transform(String fqn) {
                int i = fqn.lastIndexOf(".") + 1;
                return fqn.substring(0, i) + "Immutable" + fqn.substring(i);
            }
        }
        ,
        READONLY{

            @Override
            String transform(String fqn) {
                int i = fqn.lastIndexOf(".") + 1;
                return fqn.substring(0, i) + "Readonly" + fqn.substring(i);
            }
        };


        String transform(String s) {
            throw new RuntimeException();
        }
    }
}

