/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Composite;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class Composite
extends Expression
implements Expression.HasInitialStatements {
    Composite() {
    }

    @Override
    public abstract ImmutableList<Statement> initialStatements();

    abstract Expression value();

    static Composite create(ImmutableList<Statement> initialStatements, Expression value) {
        Preconditions.checkState((!initialStatements.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_Composite(initialStatements, value);
    }

    @Override
    public final boolean isCheap() {
        return this.value().isCheap();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.concat(this.initialStatements().stream(), Stream.of(this.value()));
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.appendOutputExpression(this.value());
    }

    @Override
    public JsExpr singleExprOrName(FormatOptions formatOptions) {
        return this.value().singleExprOrName(formatOptions);
    }
}

