/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.Iterables;
import com.google.template.soy.internal.util.TreeStreams;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.HtmlAttribute;
import com.google.template.soy.jssrc.dsl.ObjectLiteral;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import com.google.template.soy.jssrc.dsl.UnaryOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CodeChunks {
    private static final Pattern ID = Pattern.compile("[A-Za-z_$][\\w$]*");

    private CodeChunks() {
    }

    static void checkId(String id) {
        if (!ID.matcher(id).matches()) {
            throw new IllegalArgumentException(String.format("not a valid js identifier: %s", id));
        }
    }

    public static Expression concat(List<? extends CodeChunk> chunks) {
        if (chunks.isEmpty()) {
            return StringLiteral.create("");
        }
        if (chunks.size() == 1) {
            return (Expression)chunks.get(0);
        }
        if (chunks.stream().allMatch(StringLiteral.class::isInstance)) {
            return StringLiteral.create(chunks.stream().map(StringLiteral.class::cast).map(StringLiteral::literalValue).collect(Collectors.joining()), ((StringLiteral)chunks.get(0)).quoteStyle());
        }
        ArrayList<SpecialToken> special = new ArrayList<SpecialToken>();
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        for (CodeChunk codeChunk : chunks) {
            if (codeChunk instanceof SpecialToken) {
                special.add((SpecialToken)codeChunk);
                continue;
            }
            if (codeChunk instanceof Expression) {
                Expression expr = (Expression)codeChunk;
                if (!special.isEmpty()) {
                    expr = expr.prepend(special);
                    special.clear();
                }
                exprs.add(expr);
                continue;
            }
            throw new ClassCastException(codeChunk.getClass().getName());
        }
        if (!special.isEmpty()) {
            if (exprs.isEmpty()) {
                exprs.add(Expressions.EMPTY.append(special));
            } else {
                exprs.set(exprs.size() - 1, ((Expression)Iterables.getLast(exprs)).append(special));
            }
        }
        return Concatenation.create(exprs);
    }

    public static Expression concatAsObjectLiteral(List<CodeChunk> chunks) {
        LinkedHashMap<String, Expression> map = new LinkedHashMap<String, Expression>();
        CodeChunks.flatten(chunks.stream()).map(c -> c instanceof TsxPrintNode ? ((TsxPrintNode)c).expr() : c).forEach(c -> {
            if (c instanceof HtmlAttribute) {
                HtmlAttribute htmlAttribute = (HtmlAttribute)c;
                map.put(htmlAttribute.name(), htmlAttribute.value() != null ? htmlAttribute.value() : Expressions.LITERAL_TRUE);
            } else {
                map.put(Expressions.objectLiteralSpreadKey(), (Expression)c);
            }
        });
        if (map.size() == 1 && ObjectLiteral.isSpreadKey((String)Iterables.getOnlyElement(map.keySet()))) {
            Expression val = (Expression)Iterables.getOnlyElement(map.values());
            return Expressions.isSpread(val) ? ((UnaryOperation)val).arg() : val;
        }
        return Expressions.objectLiteralWithQuotedKeys(map);
    }

    public static Stream<CodeChunk> flatten(Stream<CodeChunk> chunk) {
        return chunk.flatMap(c -> c instanceof Concatenation ? c.childrenStream() : Stream.of(c));
    }

    public static Stream<? extends CodeChunk> breadthFirst(CodeChunk root) {
        return TreeStreams.breadthFirstWithStream(root, CodeChunk::childrenStream);
    }

    public static Stream<? extends CodeChunk> breadthFirst(List<? extends CodeChunk> roots) {
        return roots.stream().flatMap(root -> TreeStreams.breadthFirstWithStream(root, CodeChunk::childrenStream));
    }
}

