/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ArrayLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class ArrayLiteral
extends Expression {
    abstract ImmutableList<? extends Expression> elements();

    public static ArrayLiteral create(ImmutableList<? extends Expression> elements) {
        return new AutoValue_ArrayLiteral(elements);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.elements().stream();
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return true;
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('[');
        boolean first = true;
        for (Expression element : this.elements()) {
            first = ctx.commaAfterFirst(first);
            ctx.appendOutputExpression(element);
        }
        ctx.append(']');
    }
}

