/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public final class SoyJsSrcOptions
implements Cloneable {
    private JsDepsStrategy depsStrategy;
    private boolean shouldGenerateGoogMsgDefs;
    private boolean dependOnCssHeader;
    private boolean googMsgsAreExternal;
    private int bidiGlobalDir;
    private boolean useGoogIsRtlForBidiGlobalDir;
    private boolean generateMaybeRequireForControllerAndModelXids;

    public SoyJsSrcOptions() {
        this.depsStrategy = JsDepsStrategy.NAMESPACES;
        this.dependOnCssHeader = false;
        this.shouldGenerateGoogMsgDefs = false;
        this.googMsgsAreExternal = false;
        this.bidiGlobalDir = 0;
        this.useGoogIsRtlForBidiGlobalDir = false;
        this.generateMaybeRequireForControllerAndModelXids = false;
    }

    private SoyJsSrcOptions(SoyJsSrcOptions orig) {
        this.depsStrategy = orig.depsStrategy;
        this.dependOnCssHeader = orig.dependOnCssHeader;
        this.shouldGenerateGoogMsgDefs = orig.shouldGenerateGoogMsgDefs;
        this.googMsgsAreExternal = orig.googMsgsAreExternal;
        this.bidiGlobalDir = orig.bidiGlobalDir;
        this.useGoogIsRtlForBidiGlobalDir = orig.useGoogIsRtlForBidiGlobalDir;
        this.generateMaybeRequireForControllerAndModelXids = orig.generateMaybeRequireForControllerAndModelXids;
    }

    public void setShouldProvideRequireSoyNamespaces(boolean shouldProvideRequireSoyNamespaces) {
        if (shouldProvideRequireSoyNamespaces) {
            this.depsStrategy = JsDepsStrategy.NAMESPACES;
        }
    }

    public boolean shouldProvideRequireSoyNamespaces() {
        return this.depsStrategy == JsDepsStrategy.NAMESPACES;
    }

    public void setShouldGenerateGoogModules(boolean shouldGenerateGoogModules) {
        if (shouldGenerateGoogModules) {
            this.depsStrategy = JsDepsStrategy.MODULE;
        }
    }

    public boolean shouldGenerateGoogModules() {
        return this.depsStrategy == JsDepsStrategy.MODULE;
    }

    public void setShouldGenerateGoogMsgDefs(boolean shouldGenerateGoogMsgDefs) {
        this.shouldGenerateGoogMsgDefs = shouldGenerateGoogMsgDefs;
    }

    public boolean shouldGenerateGoogMsgDefs() {
        return this.shouldGenerateGoogMsgDefs;
    }

    public void setGenerateMaybeRequireForControllerAndModelXids(boolean generateMaybeRequireForControllerAndModelXids) {
        this.generateMaybeRequireForControllerAndModelXids = generateMaybeRequireForControllerAndModelXids;
    }

    public boolean generateMaybeRequireForControllerAndModelXids() {
        return this.generateMaybeRequireForControllerAndModelXids;
    }

    public void setDependOnCssHeader(boolean dependOnCssHeader) {
        this.dependOnCssHeader = dependOnCssHeader;
    }

    public boolean dependOnCssHeader() {
        return this.dependOnCssHeader;
    }

    public void setGoogMsgsAreExternal(boolean googMsgsAreExternal) {
        this.googMsgsAreExternal = googMsgsAreExternal;
    }

    public boolean googMsgsAreExternal() {
        return this.googMsgsAreExternal;
    }

    public void setBidiGlobalDir(int bidiGlobalDir) {
        Preconditions.checkArgument((bidiGlobalDir >= -1 && bidiGlobalDir <= 1 ? 1 : 0) != 0, (Object)"bidiGlobalDir must be 1 for LTR, or -1 for RTL (or 0 to leave unspecified).");
        Preconditions.checkState((!this.useGoogIsRtlForBidiGlobalDir || bidiGlobalDir == 0 ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and useGoogIsRtlForBidiGlobalDir.");
        this.bidiGlobalDir = bidiGlobalDir;
    }

    public int getBidiGlobalDir() {
        return this.bidiGlobalDir;
    }

    public void setUseGoogIsRtlForBidiGlobalDir(boolean useGoogIsRtlForBidiGlobalDir) {
        Preconditions.checkState((!useGoogIsRtlForBidiGlobalDir || this.shouldGenerateGoogMsgDefs ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without shouldGenerateGoogMsgDefs.");
        Preconditions.checkState((!useGoogIsRtlForBidiGlobalDir || this.bidiGlobalDir == 0 ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and useGoogIsRtlForBidiGlobalDir.");
        this.useGoogIsRtlForBidiGlobalDir = useGoogIsRtlForBidiGlobalDir;
    }

    public boolean getUseGoogIsRtlForBidiGlobalDir() {
        return this.useGoogIsRtlForBidiGlobalDir;
    }

    public SoyJsSrcOptions clone() {
        return new SoyJsSrcOptions(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shouldProvideRequireSoyNamespaces", this.shouldProvideRequireSoyNamespaces()).add("dependOnCssHeader", this.dependOnCssHeader).add("shouldGenerateGoogMsgDefs", this.shouldGenerateGoogMsgDefs).add("shouldGenerateGoogModules", this.shouldGenerateGoogModules()).add("googMsgsAreExternal", this.googMsgsAreExternal).add("bidiGlobalDir", this.bidiGlobalDir).add("useGoogIsRtlForBidiGlobalDir", this.useGoogIsRtlForBidiGlobalDir).toString();
    }

    private static enum JsDepsStrategy {
        NAMESPACES,
        MODULE;

    }
}

