/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.HashMap;
import java.util.Map;

public final class SwitchFactory {
    private static final MethodHandle GET_OR_DEFAULT_OBJECT = SwitchFactory.findLocalStaticOrDie("getOrDefault", MethodType.methodType(Integer.TYPE, Map.class, Object.class));
    private static final MethodHandle GET_OR_DEFAULT_SOY_VALUE = SwitchFactory.findLocalStaticOrDie("getOrDefault", MethodType.methodType(Integer.TYPE, Map.class, SoyValue.class));

    private static MethodHandle findLocalStaticOrDie(String name, MethodType type) {
        try {
            return MethodHandles.lookup().findStatic(SwitchFactory.class, name, type);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static CallSite bootstrapSwitch(MethodHandles.Lookup lookup, String name, MethodType type, Object ... switchCases) {
        if (switchCases.length == 0) {
            throw new AssertionError();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)switchCases.length);
        for (int i = 0; i < switchCases.length; ++i) {
            Object caseValue = switchCases[i];
            if (caseValue instanceof Integer || caseValue instanceof Long) {
                caseValue = IntegerData.forValue(((Number)caseValue).longValue());
            } else if (caseValue instanceof Double) {
                caseValue = FloatData.forValue((Double)caseValue);
            } else if (caseValue instanceof Boolean) {
                caseValue = BooleanData.forValue((Boolean)caseValue);
            } else if (!(caseValue instanceof String) && caseValue != NullData.INSTANCE && caseValue != UndefinedData.INSTANCE) {
                throw new IllegalArgumentException(String.format("Unknown case type: %s", caseValue.getClass()));
            }
            map.putIfAbsent(caseValue, i);
        }
        TypeDescriptor.OfField caseType = type.parameterType(0);
        MethodHandle getOrDefaultFn = caseType == SoyValue.class ? GET_OR_DEFAULT_SOY_VALUE : GET_OR_DEFAULT_OBJECT;
        return new ConstantCallSite(MethodHandles.insertArguments(getOrDefaultFn, 0, map));
    }

    public static int getOrDefault(Map<?, Integer> map, Object key) {
        Integer v = map.get(key);
        return v == null ? -1 : v;
    }

    public static int getOrDefault(Map<Object, Integer> map, SoyValue key) {
        if (key instanceof StringData || key instanceof SanitizedContent) {
            return SwitchFactory.getOrDefault(map, key.stringValue());
        }
        return SwitchFactory.getOrDefault(map, (Object)key);
    }

    private SwitchFactory() {
    }
}

