/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyInjector;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.MissingPluginInstanceException;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.plugin.java.RenderCssHelper;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyCssTracker;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RenderContext {
    private final Predicate<String> activeModSelector;
    private final CompiledTemplates templates;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final PluginInstances pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap;
    private final SoyInjector ijData;
    private final SoyMsgBundle msgBundle;
    private final SoyCssTracker cssTracker;
    private IdentityHashMap<String, Object> constValues;
    private final boolean debugSoyTemplateInfo;
    private final SoyLogger logger;
    private StackFrame topFrame = StackFrame.INIT;

    public RenderContext(CompiledTemplates templates, ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap, PluginInstances pluginInstances, SoyInjector ijData, @Nullable Predicate<String> activeModSelector, @Nullable SoyCssRenamingMap cssRenamingMap, @Nullable SoyIdRenamingMap xidRenamingMap, @Nullable SoyMsgBundle msgBundle, boolean debugSoyTemplateInfo, @Nullable SoyLogger logger, @Nullable SoyCssTracker cssTracker) {
        this.templates = templates;
        this.soyJavaDirectivesMap = soyJavaDirectivesMap;
        this.pluginInstances = pluginInstances;
        this.ijData = ijData == null ? SoyInjector.EMPTY : ijData;
        this.activeModSelector = activeModSelector != null ? activeModSelector : mod -> false;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.msgBundle = msgBundle == null ? SoyMsgBundle.EMPTY : msgBundle;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
        this.logger = logger == null ? SoyLogger.NO_OP : logger;
        this.cssTracker = cssTracker;
    }

    @Nullable
    public ULocale getLocale() {
        return this.msgBundle.getLocale();
    }

    public RenderCssHelper getRenderCssHelper() {
        return (delTemplate, variant) -> {
            CompiledTemplates.TemplateData data = this.templates.selector.selectTemplate(delTemplate, variant, this.activeModSelector);
            return data != null ? data.soyTemplateName : null;
        };
    }

    public ImmutableList<String> getAllRequiredCssNamespaces(String template) {
        return this.templates.getAllRequiredCssNamespaces(template, this.activeModSelector, false);
    }

    public ImmutableList<String> getAllRequiredCssPaths(String template) {
        return this.templates.getAllRequiredCssPaths(template, this.activeModSelector, false);
    }

    public BidiGlobalDir getBidiGlobalDir() {
        return BidiGlobalDir.forStaticIsRtl(this.msgBundle.isRtl());
    }

    public Dir getBidiGlobalDirDir() {
        return this.getBidiGlobalDir().toDir();
    }

    @Nonnull
    public String renameCssSelector(String selector) {
        String string = this.cssRenamingMap.get(selector);
        return string == null ? (String)Preconditions.checkNotNull((Object)selector) : string;
    }

    public boolean evalToggle(String toggleName) {
        return this.activeModSelector.test(toggleName);
    }

    @Nonnull
    public String renameXid(String id) {
        String string = this.xidRenamingMap.get(id);
        return string == null ? id + "_" : string;
    }

    public Object getPluginInstance(String name) {
        Supplier<Object> instanceSupplier = this.pluginInstances.get(name);
        if (instanceSupplier == null) {
            throw new MissingPluginInstanceException(name, String.format("No plugin instance registered for function with name '%s'.", name));
        }
        return instanceSupplier.get();
    }

    public SoyJavaPrintDirective getPrintDirective(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        return printDirective;
    }

    public Function<String, String> getEscapingDirectiveAsFunction(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        if (!printDirective.getValidArgsSizes().contains(0)) {
            throw new IllegalStateException("Soy print directive with name '" + name + "' is not an escaping directive");
        }
        return input -> printDirective.applyForJava(StringData.forValue(input), (List<SoyValue>)ImmutableList.of()).stringValue();
    }

    public boolean getDebugSoyTemplateInfo() {
        return this.debugSoyTemplateInfo;
    }

    public boolean hasLogger() {
        return this.logger != SoyLogger.NO_OP;
    }

    public SoyLogger getLogger() {
        return this.logger;
    }

    public CompiledTemplate getTemplate(String calleeName) {
        return this.templates.getTemplate(calleeName);
    }

    CompiledTemplates getTemplates() {
        return this.templates;
    }

    public CompiledTemplate getDelTemplate(String calleeName, String variant) {
        CompiledTemplate callee = this.templates.selectDelTemplate(calleeName, variant, this.activeModSelector);
        if (callee == null) {
            throw new IllegalArgumentException("Found no active impl for delegate call to \"" + calleeName + (String)(variant.isEmpty() ? "" : ":" + variant) + "\".");
        }
        return callee;
    }

    public RenderResult renderModifiable(String delCalleeName, ParamStore params, LoggingAdvisingAppendable appendable) throws IOException {
        String variant;
        SoyValueProvider variantProvider = params.getFieldProvider(Names.VARIANT_VAR_PROPERTY);
        if (variantProvider == null) {
            variant = "";
        } else {
            RenderResult status = variantProvider.status();
            if (!status.isDone()) {
                return status;
            }
            SoyValue value = variantProvider.resolve();
            variant = value == null ? "null" : value.coerceToString();
        }
        CompiledTemplate template = this.getDelTemplate(delCalleeName, variant);
        return template.render(params, appendable, this);
    }

    public boolean usePrimaryMsgIfFallback(long msgId, long fallbackId) {
        return this.msgBundle.hasMsg(msgId) || !this.msgBundle.hasMsg(fallbackId);
    }

    public boolean usePrimaryOrAlternateIfFallback(long msgId, long alternateId, long fallbackId) {
        return this.msgBundle.hasMsg(msgId) || this.msgBundle.hasMsg(alternateId) || !this.msgBundle.hasMsg(fallbackId);
    }

    public boolean usePrimaryIfFallbackOrFallbackAlternate(long msgId, long fallbackId, long fallbackAlternateId) {
        return this.msgBundle.hasMsg(msgId) || !this.msgBundle.hasMsg(fallbackId) && !this.msgBundle.hasMsg(fallbackAlternateId);
    }

    public boolean usePrimaryOrAlternateIfFallbackOrFallbackAlternate(long msgId, long alternateId, long fallbackId, long fallbackAlternateId) {
        return this.msgBundle.hasMsg(msgId) || this.msgBundle.hasMsg(alternateId) || !this.msgBundle.hasMsg(fallbackId) && !this.msgBundle.hasMsg(fallbackAlternateId);
    }

    public ImmutableList<SoyMsgPart> getSoyMsgParts(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            return defaultMsgParts;
        }
        return msgParts;
    }

    public ImmutableList<SoyMsgPart> getSoyMsgParts(long msgId) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            throw new AssertionError();
        }
        return msgParts;
    }

    public ImmutableList<SoyMsgPart> getSoyMsgPartsWithAlternateId(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts, long alternateId) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            ImmutableList<SoyMsgPart> msgPartsByAlternateId = this.msgBundle.getMsgParts(alternateId);
            if (msgPartsByAlternateId.isEmpty()) {
                return defaultMsgParts;
            }
            return msgPartsByAlternateId;
        }
        return msgParts;
    }

    public ImmutableList<SoyMsgPart> getSoyMsgPartsWithAlternateId(long msgId, long alternateId) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            ImmutableList<SoyMsgPart> msgPartsByAlternateId = this.msgBundle.getMsgParts(alternateId);
            if (msgPartsByAlternateId.isEmpty()) {
                throw new AssertionError();
            }
            return msgPartsByAlternateId;
        }
        return msgParts;
    }

    public String getBasicSoyMsgPart(long msgId, String defaultPart) {
        String translation = this.msgBundle.getBasicTranslation(msgId);
        return translation == null ? defaultPart : translation;
    }

    public String getBasicSoyMsgPart(long msgId) {
        return this.msgBundle.getBasicTranslation(msgId);
    }

    public String getBasicSoyMsgPartWithAlternateId(long msgId, String defaultPart, long alternateId) {
        String translation = this.msgBundle.getBasicTranslation(msgId);
        if (translation == null && (translation = this.msgBundle.getBasicTranslation(alternateId)) == null) {
            return defaultPart;
        }
        return translation;
    }

    public String getBasicSoyMsgPartWithAlternateId(long msgId, long alternateId) {
        String translation = this.msgBundle.getBasicTranslation(msgId);
        if (translation == null && (translation = this.msgBundle.getBasicTranslation(alternateId)) == null) {
            throw new AssertionError();
        }
        return translation;
    }

    public LoggableElementMetadata getVeMetadata(String metadataClassName, long veId) {
        try {
            return (LoggableElementMetadata)Class.forName(metadataClassName, true, this.templates.getClassLoader()).getMethod("getMetadata", Long.TYPE).invoke(null, veId);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    @Nullable
    public Object getConst(String key) {
        IdentityHashMap<String, Object> local = this.constValues;
        return local == null ? null : local.get(key);
    }

    public void storeConst(String key, Object value) {
        Object lastValue;
        Preconditions.checkNotNull((Object)value);
        IdentityHashMap<String, Object> local = this.constValues;
        if (local == null) {
            this.constValues = local = new IdentityHashMap();
        }
        Preconditions.checkArgument(((lastValue = local.put(key, value)) == null ? 1 : 0) != 0, (String)"Cannot overwrite value %s", (Object)key);
    }

    public void trackRequiredCssPath(String cssPath) {
        if (this.cssTracker != null) {
            this.cssTracker.trackRequiredCssPath(cssPath);
        }
    }

    public void trackRequiredCssNamespace(String cssNamespace) {
        if (this.cssTracker != null) {
            this.cssTracker.trackRequiredCssNamespace(cssNamespace);
        }
    }

    public void pushFrame(StackFrame state) {
        state.child = this.topFrame;
        this.topFrame = state;
    }

    public StackFrame popFrame() {
        StackFrame next = this.topFrame;
        if (next != StackFrame.INIT) {
            this.topFrame = next.child;
        }
        return next;
    }

    public SoyValueProvider getInjectedValue(RecordProperty key) {
        SoyValueProvider value = this.ijData.get(key);
        return value == null ? UndefinedData.INSTANCE : value;
    }

    public SoyValueProvider getInjectedValue(RecordProperty key, SoyValue defaultValue) {
        SoyValueProvider value = this.ijData.get(key);
        return value == null ? defaultValue : value;
    }

    @VisibleForTesting
    public Builder toBuilder() {
        return new Builder(this.templates, this.soyJavaDirectivesMap, this.pluginInstances).withActiveModSelector(this.activeModSelector).withPluginInstances(this.pluginInstances).withCssRenamingMap(this.cssRenamingMap).withXidRenamingMap(this.xidRenamingMap).withMessageBundle(this.msgBundle).withIj(this.ijData);
    }

    @VisibleForTesting
    public static final class Builder {
        private final CompiledTemplates templates;
        private final ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap;
        private PluginInstances pluginInstances;
        private Predicate<String> activeModSelector;
        private SoyCssRenamingMap cssRenamingMap;
        private SoyIdRenamingMap xidRenamingMap;
        private SoyMsgBundle msgBundle;
        private boolean debugSoyTemplateInfo;
        private SoyLogger logger;
        private SoyCssTracker cssTracker;
        private SoyInjector ijData;

        public Builder(CompiledTemplates templates, ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap, PluginInstances pluginInstances) {
            this.templates = templates;
            this.soyJavaDirectivesMap = soyJavaDirectivesMap;
            this.pluginInstances = pluginInstances;
        }

        @CanIgnoreReturnValue
        public Builder withActiveModSelector(Predicate<String> activeModSelector) {
            this.activeModSelector = (Predicate)Preconditions.checkNotNull(activeModSelector);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = (SoyCssRenamingMap)Preconditions.checkNotNull((Object)cssRenamingMap);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.xidRenamingMap = (SoyIdRenamingMap)Preconditions.checkNotNull((Object)xidRenamingMap);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withPluginInstances(PluginInstances pluginInstances) {
            this.pluginInstances = (PluginInstances)Preconditions.checkNotNull((Object)pluginInstances);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withMessageBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgBundle);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withLogger(SoyLogger logger) {
            this.logger = logger;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withCssTracker(SoyCssTracker cssTracker) {
            this.cssTracker = cssTracker;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withIj(SoyInjector ijData) {
            this.ijData = (SoyInjector)Preconditions.checkNotNull((Object)ijData);
            return this;
        }

        public RenderContext build() {
            return new RenderContext(this.templates, this.soyJavaDirectivesMap, this.pluginInstances, this.ijData, this.activeModSelector, this.cssRenamingMap, this.xidRenamingMap, this.msgBundle, this.debugSoyTemplateInfo, this.logger, this.cssTracker);
        }
    }
}

