/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.function.Function;

public final class MsgDefaultConstantFactory {
    public static ImmutableList<Object> msgToPartsList(ImmutableList<SoyMsgPart> parts) {
        Object last;
        ImmutableList<Object> constantParts = MsgDefaultConstantFactory.partsToConstantPartsList(parts);
        int lastElement = constantParts.size() - 1;
        while ((last = constantParts.get(lastElement)) instanceof Integer && ((Integer)last).intValue() == Tag.END.ordinal()) {
            --lastElement;
        }
        return constantParts.subList(0, lastElement + 1);
    }

    private static ImmutableList<Object> partsToConstantPartsList(ImmutableList<SoyMsgPart> msgParts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SoyMsgPart msgPart : msgParts) {
            builder.addAll(MsgDefaultConstantFactory.partToConstantPartsList(msgPart));
        }
        return builder.build();
    }

    private static ImmutableList<Object> partToConstantPartsList(SoyMsgPart part) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (part instanceof SoyMsgPlaceholderPart) {
            builder.add((Object)Tag.PLACEHOLDER.ordinal()).add((Object)((SoyMsgPlaceholderPart)part).getPlaceholderName());
        } else if (part instanceof SoyMsgPluralPart) {
            SoyMsgPluralPart pluralPart = (SoyMsgPluralPart)part;
            builder.add((Object)Tag.BEGIN_PLURAL.ordinal()).add((Object)pluralPart.getPluralVarName()).add((Object)pluralPart.getOffset());
            for (SoyMsgPart.Case item : pluralPart.getCases()) {
                builder.add((Object)Tag.BEGIN_CASE.ordinal());
                if (((SoyMsgPluralCaseSpec)item.spec()).getType() == SoyMsgPluralCaseSpec.Type.EXPLICIT) {
                    builder.add((Object)((SoyMsgPluralCaseSpec)item.spec()).getExplicitValue());
                } else {
                    builder.add((Object)((SoyMsgPluralCaseSpec)item.spec()).getType().name());
                }
                builder.addAll(MsgDefaultConstantFactory.partsToConstantPartsList(item.parts()));
            }
            builder.add((Object)Tag.END.ordinal());
        } else if (part instanceof SoyMsgPluralRemainderPart) {
            builder.add((Object)Tag.REMAINDER.ordinal()).add((Object)((SoyMsgPluralRemainderPart)part).getPluralVarName());
        } else if (part instanceof SoyMsgRawTextPart) {
            builder.add((Object)Tag.RAW.ordinal()).add((Object)((SoyMsgRawTextPart)part).getRawText());
        } else if (part instanceof SoyMsgSelectPart) {
            SoyMsgSelectPart selectPart = (SoyMsgSelectPart)part;
            builder.add((Object)Tag.BEGIN_SELECT.ordinal()).add((Object)selectPart.getSelectVarName());
            for (SoyMsgPart.Case item : selectPart.getCases()) {
                builder.add((Object)Tag.BEGIN_CASE.ordinal());
                builder.add((Object)Strings.nullToEmpty((String)((String)item.spec())));
                builder.addAll(MsgDefaultConstantFactory.partsToConstantPartsList(item.parts()));
            }
            builder.add((Object)Tag.END.ordinal());
        } else {
            throw new AssertionError((Object)("unrecognized part: " + String.valueOf(part)));
        }
        return builder.build();
    }

    public static ImmutableList<SoyMsgPart> bootstrapMsgConstant(MethodHandles.Lookup lookup, String name, Class<?> type, Object ... rawParts) {
        PeekingIterator itr = Iterators.peekingIterator((Iterator)Iterators.forArray((Object[])rawParts));
        ImmutableList<SoyMsgPart> parts = MsgDefaultConstantFactory.parseParts((PeekingIterator<Object>)itr);
        Preconditions.checkState((!itr.hasNext() ? 1 : 0) != 0);
        return parts;
    }

    private static ImmutableList<SoyMsgPart> parseParts(PeekingIterator<Object> rawParts) {
        return MsgDefaultConstantFactory.parseParts(rawParts, false);
    }

    private static ImmutableList<SoyMsgPart> parseParts(PeekingIterator<Object> rawParts, boolean isCase) {
        ImmutableList.Builder parts = ImmutableList.builder();
        while (rawParts.hasNext()) {
            Tag tag = Tag.fromRaw(rawParts.peek());
            if (isCase && (tag == Tag.BEGIN_CASE || tag == Tag.END)) {
                return parts.build();
            }
            rawParts.next();
            switch (tag) {
                case RAW: {
                    parts.add((Object)SoyMsgRawTextPart.of((String)rawParts.next()));
                    break;
                }
                case PLACEHOLDER: {
                    parts.add((Object)new SoyMsgPlaceholderPart((String)rawParts.next()));
                    break;
                }
                case REMAINDER: {
                    parts.add((Object)new SoyMsgPluralRemainderPart((String)rawParts.next()));
                    break;
                }
                case BEGIN_PLURAL: {
                    String pluralVarName = (String)rawParts.next();
                    int offset = (Integer)rawParts.next();
                    ImmutableList<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> cases = MsgDefaultConstantFactory.parseCases(rawParts, spec -> {
                        if (spec instanceof Number) {
                            return new SoyMsgPluralCaseSpec(((Number)spec).longValue());
                        }
                        return SoyMsgPluralCaseSpec.forType((String)spec);
                    });
                    parts.add((Object)new SoyMsgPluralPart(pluralVarName, offset, (Iterable<SoyMsgPart.Case<SoyMsgPluralCaseSpec>>)cases));
                    break;
                }
                case BEGIN_SELECT: {
                    String selectVarName = (String)rawParts.next();
                    ImmutableList<SoyMsgPart.Case<String>> cases = MsgDefaultConstantFactory.parseCases(rawParts, spec -> {
                        String s = (String)spec;
                        return s.isEmpty() ? null : s;
                    });
                    parts.add((Object)new SoyMsgSelectPart(selectVarName, (Iterable<SoyMsgPart.Case<String>>)cases));
                    break;
                }
                case BEGIN_CASE: 
                case END: {
                    throw new AssertionError();
                }
            }
        }
        return parts.build();
    }

    private static <T> ImmutableList<SoyMsgPart.Case<T>> parseCases(PeekingIterator<Object> rawParts, Function<Object, T> specFactory) {
        ImmutableList.Builder cases = ImmutableList.builder();
        while (rawParts.hasNext()) {
            Tag next = Tag.fromRaw(rawParts.next());
            if (next == Tag.BEGIN_CASE) {
                T spec = specFactory.apply(rawParts.next());
                cases.add(SoyMsgPart.Case.create(spec, MsgDefaultConstantFactory.parseParts(rawParts, true)));
                continue;
            }
            if (next != Tag.END) {
                throw new AssertionError();
            }
            break;
        }
        return cases.build();
    }

    private MsgDefaultConstantFactory() {
    }

    private static enum Tag {
        RAW,
        PLACEHOLDER,
        REMAINDER,
        BEGIN_PLURAL,
        BEGIN_SELECT,
        BEGIN_CASE,
        END;

        private static final Tag[] cached;

        static Tag fromRaw(Object object) {
            return cached[(Integer)object];
        }

        static {
            cached = Tag.values();
        }
    }
}

