/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Keep;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Map;

public final class ExtraConstantBootstraps {
    @Keep
    public static boolean constantBoolean(MethodHandles.Lookup lookup, String name, Class<?> type, int v) {
        return v != 0;
    }

    @Keep
    public static Object callSiteKey(MethodHandles.Lookup lookup, String name, Class<?> type, int v) {
        return new Object();
    }

    @Keep
    public static char constantChar(MethodHandles.Lookup lookup, String name, Class<?> type, int v) {
        return (char)v;
    }

    @Keep
    public static ImmutableList<SoyValue> constantSoyList(MethodHandles.Lookup lookup, String name, Class<?> type, int salt, Object ... args) {
        return (ImmutableList)Arrays.stream(args).map(v -> SoyValueConverter.INSTANCE.convert(v).resolve()).collect(ImmutableList.toImmutableList());
    }

    @Keep
    public static SoyMapImpl constantSoyMap(MethodHandles.Lookup lookup, String name, Class<?> type, int salt, Object ... keyValuePairs) {
        ImmutableMap.Builder map = ImmutableMap.builderWithExpectedSize((int)(keyValuePairs.length / 2));
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put((Object)SoyValueConverter.INSTANCE.convert(keyValuePairs[i]).resolve(), (Object)SoyValueConverter.INSTANCE.convert(keyValuePairs[i + 1]).resolve());
        }
        return SoyMapImpl.forProviderMap((Map<? extends SoyValue, ? extends SoyValueProvider>)map.buildKeepingLast());
    }

    @Keep
    public static SoyRecordImpl constantSoyRecord(MethodHandles.Lookup lookup, String name, Class<?> type, int salt, Object ... keyValuePairs) {
        return new SoyRecordImpl(ExtraConstantBootstraps.asParams(keyValuePairs));
    }

    @Keep
    public static ParamStore constantParamStore(MethodHandles.Lookup lookup, String name, Class<?> type, Object ... keyValuePairs) {
        return ExtraConstantBootstraps.asParams(keyValuePairs);
    }

    private static ParamStore asParams(Object ... keyValuePairs) {
        ParamStore params;
        int i = 0;
        if (keyValuePairs.length % 2 == 1) {
            params = new ParamStore((ParamStore)keyValuePairs[0], (keyValuePairs.length - 1) / 2);
            i = 1;
        } else {
            params = new ParamStore(keyValuePairs.length / 2);
        }
        while (i < keyValuePairs.length) {
            params.setField(RecordProperty.get((String)keyValuePairs[i]), SoyValueConverter.INSTANCE.convert(keyValuePairs[i + 1]).resolve());
            i += 2;
        }
        return params.freeze();
    }

    @Keep
    public static RecordProperty symbol(MethodHandles.Lookup lookup, String name, Class<?> type) {
        return RecordProperty.get(name);
    }

    @Keep
    public static Object constantMetafactory(MethodHandles.Lookup lookup, String name, Class<?> type, MethodType samMethodType, MethodHandle implMethod, MethodType instantiatedMethodType) throws Throwable {
        return LambdaMetafactory.metafactory(lookup, name, MethodType.methodType(type), samMethodType, implMethod, instantiatedMethodType).getTarget().invoke();
    }

    private ExtraConstantBootstraps() {
    }
}

