/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.Keep;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.internal.LazyProtoToSoyValueList;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.SaveStateMetaFactory;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JbcSrcRuntime {
    private static final Logger logger = Logger.getLogger(JbcSrcRuntime.class.getName());
    private static final LoggingAdvisingAppendable LOGGER = new AbstractLoggingAdvisingAppendable(){

        @Override
        public boolean softLimitReached() {
            return false;
        }

        @Override
        protected void doAppend(char c) {
            System.out.append(c);
        }

        @Override
        protected void doAppend(CharSequence csq, int start, int end) {
            System.out.append(csq, start, end);
        }

        @Override
        protected void doAppend(CharSequence csq) {
            System.out.append(csq);
        }

        @Override
        protected void doEnterLoggableElement(LogStatement statement) {
        }

        @Override
        protected void doExitLoggableElement() {
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) {
            String val = funCall.placeholderValue();
            for (Function directive : escapers) {
                val = (String)directive.apply(val);
            }
            System.out.append(val);
        }

        @Override
        public void flushBuffers(int depth) {
            throw new AssertionError((Object)"should not be called");
        }
    };

    @Nonnull
    public static AssertionError unexpectedStateError(StackFrame frame) {
        return new AssertionError((Object)("Unexpected state requested: " + frame.stateNumber));
    }

    public static void debugger(String fileName, int lineNumber) {
        logger.log(Level.WARNING, String.format("Hit {debugger} statement at %s:%d. Put a breakpoint here to halt Soy rendering.", fileName, lineNumber), new Exception());
    }

    @Keep
    public static boolean numberEqualsStringAsNumber(double number, String expr) {
        return JbcSrcRuntime.stringEqualsAsNumber(expr, number);
    }

    @Keep
    public static boolean stringEqualsAsNumber(String expr, double number) {
        if (expr == null) {
            return false;
        }
        try {
            return Double.parseDouble(expr) == number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Keep
    @Nonnull
    public static SoyValueProvider soyValueProviderOrNullish(SoyValueProvider provider) {
        SoyValue value = provider.resolve();
        return value.isNullish() ? value : provider;
    }

    @Keep
    @Nonnull
    public static SoyValue getField(SoyValue record, RecordProperty field) {
        if (record.isNullish()) {
            throw new NullPointerException("Attempted to access field '" + field.getName() + "' of null");
        }
        return ((SoyRecord)record).getPositionalParam(field).resolve();
    }

    @Keep
    @Nonnull
    public static SoyValueProvider getFieldProvider(SoyValue record, RecordProperty field) {
        if (record.isNullish()) {
            throw new NullPointerException("Attempted to access field '" + field.getName() + "' of null");
        }
        return ((SoyRecord)record).getPositionalParam(field);
    }

    @Keep
    @Nonnull
    public static SoyValueProvider paramOrDefault(SoyValueProvider provider, SoyValue defaultValue) {
        return provider == UndefinedData.INSTANCE ? defaultValue : provider;
    }

    @Keep
    public static CompiledTemplate bufferTemplate(CompiledTemplate delegate, boolean ignoreExceptions, BufferedRenderDoneFn bufferedRenderDoneFn) {
        return new BufferedCompiledTemplate(delegate, ignoreExceptions, bufferedRenderDoneFn);
    }

    @Keep
    public static SoyValue getSoyListItem(List<SoyValueProvider> list, long index) {
        return JbcSrcRuntime.getSoyListItemProvider(list, index).resolve();
    }

    @Keep
    public static SoyValueProvider getSoyListItemProvider(List<SoyValueProvider> list, long index) {
        if (list == null) {
            throw new NullPointerException("Attempted to access list item '" + index + "' of null");
        }
        int size = list.size();
        if (index < (long)size & index >= 0L) {
            SoyValueProvider soyValueProvider = list.get((int)index);
            return soyValueProvider == null ? UndefinedData.INSTANCE : soyValueProvider;
        }
        return UndefinedData.INSTANCE;
    }

    public static RenderResult getListStatus(List<? extends SoyValueProvider> soyValueProviders) {
        for (SoyValueProvider soyValueProvider : soyValueProviders) {
            RenderResult result = soyValueProvider.status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static RenderResult getMapStatus(Map<String, ? extends SoyValueProvider> soyValueProviders) {
        for (SoyValueProvider soyValueProvider : soyValueProviders.values()) {
            RenderResult result = soyValueProvider.status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    @Keep
    @Nonnull
    public static SoyValue getSoyMapItem(SoyValue soyMap, SoyValue key) {
        return JbcSrcRuntime.getSoyMapItemProvider(soyMap, key).resolve();
    }

    @Keep
    @Nonnull
    public static SoyValueProvider getSoyMapItemProvider(SoyValue soyMap, SoyValue key) {
        if (soyMap.isNullish()) {
            throw new NullPointerException("Attempted to access map item '" + String.valueOf(key) + "' of null");
        }
        SoyValueProvider soyValueProvider = ((SoyMap)soyMap).getProvider(key);
        return soyValueProvider == null ? UndefinedData.INSTANCE : soyValueProvider;
    }

    @Keep
    public static SoyValue getSoyLegacyObjectMapItem(SoyValue legacyObjectMap, SoyValue key) {
        return JbcSrcRuntime.getSoyLegacyObjectMapItemProvider(legacyObjectMap, key).resolve();
    }

    @Keep
    @Nonnull
    public static SoyValueProvider getSoyLegacyObjectMapItemProvider(SoyValue legacyObjectMap, SoyValue key) {
        if (legacyObjectMap == null || legacyObjectMap.isNullish()) {
            throw new NullPointerException("Attempted to access map item '" + String.valueOf(key) + "' of null");
        }
        SoyValueProvider soyValueProvider = ((SoyLegacyObjectMap)legacyObjectMap).getItemProvider(key);
        return soyValueProvider == null ? UndefinedData.INSTANCE : soyValueProvider;
    }

    @Keep
    @Nonnull
    public static String handleBasicTranslationAndEscapeHtml(String text) {
        return MsgRenderer.escapeHtml(text);
    }

    @Keep
    public static boolean compareBoxedStringToBoxed(SoyValue string, SoyValue other) {
        if (string.isNullish() != other.isNullish()) {
            return false;
        }
        if (string.isNullish()) {
            return true;
        }
        return JbcSrcRuntime.compareUnboxedStringToBoxed(string.stringValue(), other);
    }

    @Keep
    public static boolean compareBoxedValueToBoxedString(SoyValue other, SoyValue string) {
        return JbcSrcRuntime.compareBoxedStringToBoxed(string, other);
    }

    @Keep
    public static boolean compareBoxedValueToUnboxedString(SoyValue other, String stringValue) {
        return JbcSrcRuntime.compareUnboxedStringToBoxed(stringValue, other);
    }

    @Keep
    public static boolean compareUnboxedStringToBoxed(String stringValue, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return Objects.equals(stringValue, other.toString());
        }
        if (other instanceof NumberData) {
            try {
                return Double.parseDouble(stringValue) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    @Nonnull
    @Keep
    public static LoggingAdvisingAppendable logger() {
        return LOGGER;
    }

    @Keep
    public static int rangeLoopLength(int start, int end, int step) {
        int length = end - start;
        if ((length ^ step) < 0) {
            return 0;
        }
        return length / step + (length % step == 0 ? 0 : 1);
    }

    @Keep
    public static boolean coerceToBoolean(double v) {
        return v != 0.0 & !Double.isNaN(v);
    }

    @Keep
    public static boolean coerceToBoolean(@Nullable String v) {
        return v != null && !v.isEmpty();
    }

    @Keep
    public static LogStatement createLogStatement(boolean logOnly, SoyValue value) {
        if (value == null || value.isNullish()) {
            throw new NullPointerException();
        }
        SoyVisualElementData veData = (SoyVisualElementData)value;
        return LogStatement.create(veData.ve().id(), veData.data(), logOnly);
    }

    @Keep
    @Nonnull
    public static <T extends SoyValueProvider> List<T> checkResolved(List<T> providerList) {
        for (int i = 0; i < providerList.size(); ++i) {
            SoyValueProvider provider = (SoyValueProvider)providerList.get(i);
            if (provider instanceof SoyValue) continue;
            throw new IllegalStateException("item " + i + " was expected to be a SoyValue, instead it is: " + String.valueOf(provider.getClass()));
        }
        return providerList;
    }

    @Keep
    @Nonnull
    public static <K, V extends SoyValueProvider> Map<K, V> checkResolved(Map<K, V> providerMap) {
        for (Map.Entry<K, V> entry : providerMap.entrySet()) {
            SoyValueProvider provider = (SoyValueProvider)entry.getValue();
            if (provider instanceof SoyValue) continue;
            throw new IllegalStateException("item " + String.valueOf(entry.getKey()) + " was expected to be a SoyValue, instead it is: " + String.valueOf(provider.getClass()));
        }
        return providerMap;
    }

    @Keep
    @Nonnull
    public static <MessageT extends GeneratedMessage.ExtendableMessage<MessageT>, T> LazyProtoToSoyValueList<T> getExtensionList(MessageT message, ExtensionLite<MessageT, List<T>> extension, ProtoFieldInterpreter protoFieldInterpreter) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < message.getExtensionCount(extension); ++i) {
            list.add(message.getExtension(extension, i));
        }
        return LazyProtoToSoyValueList.forList(list.build(), protoFieldInterpreter);
    }

    @Nonnull
    @Keep
    public static TemplateValue bindTemplateParams(TemplateValue template, ParamStore boundParams) {
        PartiallyBoundTemplate newTemplate = new PartiallyBoundTemplate(boundParams, (CompiledTemplate)template.getCompiledTemplate());
        return TemplateValue.createWithBoundParameters(template.getTemplateName(), newTemplate.boundParams, newTemplate);
    }

    static void awaitProvider(SoyValueProvider provider) {
        while (true) {
            RenderResult result = provider.status();
            switch (result.type()) {
                case LIMITED: {
                    throw new AssertionError((Object)"SoyValueProvider.status() returned a RenderResult.limited() which is out of spec");
                }
                case DETACH: {
                    Future<?> future = result.future();
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "blocking to resolve a SoyValueProvider: " + String.valueOf(future), new Exception());
                    }
                    try {
                        future.get();
                        break;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Interrupted while waiting on: " + String.valueOf(future) + " to complete", ie);
                    }
                    catch (CancellationException | ExecutionException exception) {
                        break;
                    }
                }
                case DONE: {
                    return;
                }
            }
        }
    }

    @Keep
    public static boolean isNonSoyNullish(SoyValueProvider value) {
        return !value.resolve().isNullish();
    }

    @Keep
    public static boolean isNonSoyNull(SoyValueProvider value) {
        return !value.resolve().isNull();
    }

    @Keep
    @Nullable
    public static SoyValue soyNullishToJavaNull(SoyValue value) {
        return value == null || value.isNullish() ? null : value;
    }

    @Keep
    @Nullable
    public static SoyValue soyNullToJavaNull(SoyValue value) {
        return value == null || value.isNull() ? null : value;
    }

    @Keep
    @Nonnull
    public static <T> T checkExpressionNotNull(T value, String expression) {
        if (value == null || value instanceof SoyValue && ((SoyValue)value).isNullish()) {
            throw new NullPointerException("'" + expression + "' evaluates to null");
        }
        return value;
    }

    @Nonnull
    @Keep
    public static String base64Encode(ByteString byteString) {
        return BaseEncoding.base64().encode(byteString.toByteArray());
    }

    @Nonnull
    @Keep
    public static ByteString base64Decode(String base64) {
        return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)base64));
    }

    public static int asSwitchableValue(long value, int unusedKey) {
        int asInt = (int)value;
        if ((long)asInt == value) {
            return asInt;
        }
        return unusedKey;
    }

    public static int asSwitchableValue(double value, int unusedKey) {
        int asInt = (int)value;
        if ((double)asInt == value) {
            return asInt;
        }
        return unusedKey;
    }

    public static int asSwitchableValue(SoyValue value, int unusedKey) {
        if (value instanceof NumberData) {
            return JbcSrcRuntime.asSwitchableValue(value.numberValue(), unusedKey);
        }
        return unusedKey;
    }

    public static SoyValue emptyToNull(SoyValue value) {
        return value.stringValue().isEmpty() ? UndefinedData.INSTANCE : value;
    }

    private JbcSrcRuntime() {
    }

    @VisibleForTesting
    public static final class EveryDetachStateForTesting {
        private static final Set<Object> visited = Sets.newConcurrentHashSet();
        private static final RenderResult TRIVIAL_PENDING = RenderResult.continueAfter(Futures.immediateVoidFuture());

        public static void clear() {
            visited.clear();
        }

        public static boolean maybeForceLimited(boolean actual, Object callsite) {
            return actual || visited.add(callsite);
        }

        public static RenderResult maybeForceContinueAfter(RenderResult actual, Object callsite) {
            if (actual.isDone() && visited.add(callsite)) {
                actual = TRIVIAL_PENDING;
            }
            return actual;
        }

        private EveryDetachStateForTesting() {
        }
    }

    @Immutable
    private static final class PartiallyBoundTemplate
    implements CompiledTemplate {
        private final ParamStore boundParams;
        private final CompiledTemplate delegate;

        PartiallyBoundTemplate(ParamStore boundParams, CompiledTemplate delegate) {
            if (delegate instanceof PartiallyBoundTemplate) {
                PartiallyBoundTemplate partiallyBoundTemplate = (PartiallyBoundTemplate)delegate;
                boundParams = ParamStore.merge(partiallyBoundTemplate.boundParams, boundParams);
                delegate = partiallyBoundTemplate.delegate;
            }
            this.delegate = delegate;
            this.boundParams = boundParams;
        }

        @Override
        public RenderResult render(ParamStore params, LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
            return this.delegate.render(ParamStore.merge(this.boundParams, params), appendable, context);
        }
    }

    @Immutable
    private static final class BufferedCompiledTemplate
    implements CompiledTemplate {
        private final CompiledTemplate delegate;
        private final boolean ignoreExceptions;
        private final BufferedRenderDoneFn bufferedRenderDoneFn;

        BufferedCompiledTemplate(CompiledTemplate delegate, boolean ignoreExceptions, BufferedRenderDoneFn bufferedRenderDoneFn) {
            this.delegate = (CompiledTemplate)Preconditions.checkNotNull((Object)delegate);
            this.ignoreExceptions = ignoreExceptions;
            this.bufferedRenderDoneFn = bufferedRenderDoneFn;
        }

        @Override
        public RenderResult render(ParamStore params, LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
            RenderResult result;
            LoggingAdvisingAppendable.BufferingAppendable buffer;
            StackFrame frame = context.popFrame();
            switch (frame.stateNumber) {
                case 0: {
                    buffer = LoggingAdvisingAppendable.buffering();
                    break;
                }
                case 1: {
                    try {
                        buffer = SaveRestoreState.RESTORE_APPENDABLE_HANDLE.invokeExact(frame);
                        break;
                    }
                    catch (Throwable t) {
                        throw new AssertionError((Object)t);
                    }
                }
                default: {
                    throw JbcSrcRuntime.unexpectedStateError(frame);
                }
            }
            try {
                result = this.delegate.render(params, buffer, context);
            }
            catch (RuntimeException e) {
                if (this.ignoreExceptions) {
                    return RenderResult.done();
                }
                throw e;
            }
            if (result.isDone()) {
                this.bufferedRenderDoneFn.exec(appendable, buffer);
            } else {
                try {
                    SaveRestoreState.SAVE_STATE_METHOD_HANDLE.invokeExact(context, 1, buffer);
                }
                catch (Throwable t) {
                    throw new AssertionError((Object)t);
                }
            }
            return result;
        }

        static class SaveRestoreState {
            static final MethodHandle SAVE_STATE_METHOD_HANDLE;
            static final MethodHandle RESTORE_APPENDABLE_HANDLE;

            SaveRestoreState() {
            }

            static {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType saveMethodType = MethodType.methodType(Void.TYPE, RenderContext.class, Integer.TYPE, LoggingAdvisingAppendable.BufferingAppendable.class);
                SAVE_STATE_METHOD_HANDLE = SaveStateMetaFactory.bootstrapSaveState(lookup, "saveState", saveMethodType).getTarget();
                RESTORE_APPENDABLE_HANDLE = SaveStateMetaFactory.bootstrapRestoreState(lookup, "restoreLocal", MethodType.methodType(LoggingAdvisingAppendable.BufferingAppendable.class, StackFrame.class), saveMethodType, 0).getTarget();
            }
        }
    }

    public static class EscapingBufferedRenderDoneFn
    implements BufferedRenderDoneFn {
        private final ImmutableList<SoyJavaPrintDirective> directives;

        public EscapingBufferedRenderDoneFn(ImmutableList<SoyJavaPrintDirective> directives) {
            this.directives = directives;
        }

        @Override
        public void exec(LoggingAdvisingAppendable appendable, LoggingAdvisingAppendable.BufferingAppendable buffer) throws IOException {
            SoyValue resultData = buffer.getAsSoyValue();
            for (SoyJavaPrintDirective directive : this.directives) {
                resultData = directive.applyForJava(resultData, (List<SoyValue>)ImmutableList.of());
            }
            appendable.append(resultData.coerceToString());
        }
    }

    public static class ReplayingBufferedRenderDoneFn
    implements BufferedRenderDoneFn {
        @Override
        public void exec(LoggingAdvisingAppendable appendable, LoggingAdvisingAppendable.BufferingAppendable buffer) throws IOException {
            buffer.replayOn(appendable);
        }
    }

    @Immutable
    public static interface BufferedRenderDoneFn {
        public void exec(LoggingAdvisingAppendable var1, LoggingAdvisingAppendable.BufferingAppendable var2) throws IOException;
    }

    public static final class PlrSelMsgRenderer
    extends MsgRenderer {
        private boolean resolvedCases;
        private double remainder = -1.0;

        public PlrSelMsgRenderer(long msgId, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, int numPlaceholders, boolean htmlEscape) {
            super(msgId, msgParts, locale, numPlaceholders, htmlEscape);
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable out) throws IOException {
            if (!this.resolvedCases) {
                ImmutableList<SoyMsgPart> parts = this.msgParts;
                RenderResult caseSelectionResult = RenderResult.done();
                while (!parts.isEmpty()) {
                    SoyMsgPluralPart pluralPart;
                    SoyValueProvider pluralPlaceholder;
                    SoyMsgPart first = (SoyMsgPart)parts.get(0);
                    if (first instanceof SoyMsgSelectPart) {
                        SoyMsgSelectPart selectPart = (SoyMsgSelectPart)first;
                        SoyValueProvider selectPlaceholder = (SoyValueProvider)this.placeholders.get(selectPart.getSelectVarName());
                        caseSelectionResult = selectPlaceholder.status();
                        if (!caseSelectionResult.isDone()) break;
                        parts = selectPart.lookupCase(selectPlaceholder.resolve().coerceToString());
                        continue;
                    }
                    if (!(first instanceof SoyMsgPluralPart) || !(caseSelectionResult = (pluralPlaceholder = (SoyValueProvider)this.placeholders.get((pluralPart = (SoyMsgPluralPart)first).getPluralVarName())).status()).isDone()) break;
                    double pluralValue = pluralPlaceholder.resolve().numberValue();
                    parts = pluralPart.lookupCase(pluralValue, this.locale);
                    this.remainder = pluralValue - (double)pluralPart.getOffset();
                }
                this.msgParts = parts;
                if (!caseSelectionResult.isDone()) {
                    return caseSelectionResult;
                }
                this.resolvedCases = true;
            }
            return super.renderAndResolve(out);
        }

        @Override
        double getPluralRemainder() {
            return this.remainder;
        }
    }

    public static class MsgRenderer
    implements SoyValueProvider {
        ImmutableList<SoyMsgPart> msgParts;
        final ULocale locale;
        private int partIndex;
        private SoyValueProvider pendingRender;
        final Map<String, SoyValueProvider> placeholders;
        @Nullable
        Set<String> startPlaceholders;
        @Nullable
        Multiset<String> startPlaceholderRenderCount;
        @Nullable
        SetMultimap<String, String> endPlaceholderToStartPlaceholder;
        private final long msgId;
        private final boolean htmlEscape;
        private LoggingAdvisingAppendable.BufferingAppendable buffer;
        private boolean isDone;

        public MsgRenderer(long msgId, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, int numPlaceholders, boolean htmlEscape) {
            this.msgId = msgId;
            this.msgParts = msgParts;
            this.locale = locale;
            this.placeholders = Maps.newLinkedHashMapWithExpectedSize((int)numPlaceholders);
            this.htmlEscape = htmlEscape;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public MsgRenderer setPlaceholder(String placeholderName, SoyValueProvider placeholderValue) {
            SoyValueProvider prev = this.placeholders.put(placeholderName, placeholderValue);
            if (prev != null) {
                throw new IllegalArgumentException("found multiple placeholders: " + String.valueOf(prev) + " and " + String.valueOf(placeholderValue) + " for key " + placeholderName);
            }
            return this;
        }

        static String escapeHtml(String s) {
            int ltIndex = s.indexOf(60);
            if (ltIndex < 0) {
                return s;
            }
            int length = s.length();
            StringBuilder sb = new StringBuilder(length + 3);
            int i = 0;
            do {
                sb.append(s, i, ltIndex).append("&lt;");
                i = ltIndex + 1;
            } while (ltIndex < length && (ltIndex = s.indexOf(60, ltIndex + 1)) > 0);
            return sb.append(s, i, length).toString();
        }

        @Nonnull
        @CanIgnoreReturnValue
        public MsgRenderer setPlaceholderAndOrdering(String placeholderName, SoyValueProvider placeholderValue, String endPlaceholder) {
            if (this.endPlaceholderToStartPlaceholder == null) {
                this.startPlaceholders = new HashSet<String>();
                this.endPlaceholderToStartPlaceholder = HashMultimap.create();
                this.startPlaceholderRenderCount = HashMultiset.create();
            }
            if (this.endPlaceholderToStartPlaceholder.containsKey((Object)placeholderName)) {
                throw new IllegalArgumentException(String.format("%s is supposed to come after %s but before %s. Order constraints should not be transitive.", placeholderName, this.endPlaceholderToStartPlaceholder.get((Object)placeholderName).iterator().next(), endPlaceholder));
            }
            if (this.startPlaceholders.contains(endPlaceholder)) {
                String beforePlaceholder = null;
                for (Map.Entry entry : this.endPlaceholderToStartPlaceholder.entries()) {
                    if (!endPlaceholder.equals(entry.getValue())) continue;
                    beforePlaceholder = (String)entry.getKey();
                    break;
                }
                throw new IllegalArgumentException(String.format("%s is supposed to come after %s but before %s. Order constraints should not be transitive.", endPlaceholder, placeholderName, beforePlaceholder));
            }
            this.setPlaceholder(placeholderName, placeholderValue);
            this.endPlaceholderToStartPlaceholder.put((Object)endPlaceholder, (Object)placeholderName);
            this.startPlaceholders.add(placeholderName);
            return this;
        }

        @Override
        public final RenderResult status() {
            RenderResult result;
            if (this.isDone) {
                return RenderResult.done();
            }
            LoggingAdvisingAppendable.BufferingAppendable currentBuilder = this.buffer;
            if (currentBuilder == null) {
                this.buffer = currentBuilder = LoggingAdvisingAppendable.buffering();
            }
            try {
                result = this.renderAndResolve(currentBuilder);
            }
            catch (IOException ioe) {
                throw new AssertionError("impossible", ioe);
            }
            if (result.isDone()) {
                this.isDone = true;
            }
            return result;
        }

        @Override
        public final SoyValue resolve() {
            Preconditions.checkState((boolean)this.status().isDone());
            return this.buffer.getAsSoyValue();
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable out) throws IOException {
            if (this.pendingRender != null) {
                RenderResult result = this.pendingRender.renderAndResolve(out);
                if (!result.isDone()) {
                    return result;
                }
                this.pendingRender = null;
            }
            for (int i = this.partIndex; i < this.msgParts.size(); ++i) {
                SoyMsgPart msgPart = (SoyMsgPart)this.msgParts.get(i);
                if (msgPart instanceof SoyMsgRawTextPart) {
                    String s = ((SoyMsgRawTextPart)msgPart).getRawText();
                    if (this.htmlEscape) {
                        s = MsgRenderer.escapeHtml(s);
                    }
                    out.append(s);
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    SoyValueProvider placeholderValue;
                    String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                    if (this.endPlaceholderToStartPlaceholder != null) {
                        if (this.startPlaceholders.contains(placeholderName)) {
                            this.startPlaceholderRenderCount.add((Object)placeholderName);
                        } else {
                            Set startPlaceholders = this.endPlaceholderToStartPlaceholder.get((Object)placeholderName);
                            if (!startPlaceholders.isEmpty()) {
                                boolean matched = false;
                                for (String startPlaceholder : startPlaceholders) {
                                    if (!this.startPlaceholderRenderCount.remove((Object)startPlaceholder)) continue;
                                    matched = true;
                                    break;
                                }
                                if (!matched) {
                                    throw new IllegalStateException(String.format("Expected placeholder '%s' to come after one of %s, in message %d", placeholderName, startPlaceholders, this.msgId));
                                }
                            }
                        }
                    }
                    if ((placeholderValue = this.placeholders.get(placeholderName)) == null) {
                        throw new IllegalStateException("No value provided for placeholder: '" + placeholderName + "', expected one of " + String.valueOf(this.placeholders.keySet()));
                    }
                    try {
                        RenderResult result = placeholderValue.renderAndResolve(out);
                        if (result.isDone()) continue;
                        this.partIndex = i + 1;
                        this.pendingRender = placeholderValue;
                        return result;
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException(placeholderName, e);
                    }
                }
                if (msgPart instanceof SoyMsgPluralRemainderPart) {
                    out.append(String.valueOf(this.getPluralRemainder()));
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + String.valueOf(msgPart)));
            }
            if (this.startPlaceholderRenderCount != null && !this.startPlaceholderRenderCount.isEmpty()) {
                throw new IllegalStateException(String.format("The following placeholders never had their matching placeholders rendered in message %d: %s", this.msgId, this.startPlaceholderRenderCount.elementSet()));
            }
            return RenderResult.done();
        }

        double getPluralRemainder() {
            throw new UnsupportedOperationException("this is not a plural message so remainder don't make sense");
        }
    }
}

