/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class DetachableContentProvider
implements SoyValueProvider {
    private SoyValue resolvedValue;
    private LoggingAdvisingAppendable.BufferingAppendable buffer;
    private LoggingAdvisingAppendable builder;

    @Override
    public final SoyValue resolve() {
        JbcSrcRuntime.awaitProvider(this);
        return this.getResolvedValue();
    }

    @Override
    public final RenderResult status() {
        RenderResult result;
        if (this.isDone()) {
            return RenderResult.done();
        }
        LoggingAdvisingAppendable.BufferingAppendable currentBuilder = (LoggingAdvisingAppendable.BufferingAppendable)this.builder;
        if (currentBuilder == null) {
            currentBuilder = LoggingAdvisingAppendable.buffering();
            this.builder = currentBuilder;
        }
        try {
            result = this.doRender(currentBuilder);
        }
        catch (IOException ioe) {
            throw new AssertionError("impossible", ioe);
        }
        if (result.isDone()) {
            this.buffer = currentBuilder;
            this.builder = null;
        }
        return result;
    }

    @Override
    public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable) throws IOException {
        RenderResult result;
        if (this.isDone()) {
            this.buffer.replayOn(appendable);
            return RenderResult.done();
        }
        TeeAdvisingAppendable currentBuilder = (TeeAdvisingAppendable)this.builder;
        if (currentBuilder == null) {
            currentBuilder = new TeeAdvisingAppendable(appendable);
            this.builder = currentBuilder;
        }
        if ((result = this.doRender(currentBuilder)).isDone()) {
            this.buffer = currentBuilder.buffer;
            this.builder = null;
        }
        return result;
    }

    private boolean isDone() {
        return this.resolvedValue != null || this.buffer != null;
    }

    private SoyValue getResolvedValue() {
        SoyValue local = this.resolvedValue;
        if (local == null) {
            if (this.buffer != null) {
                this.resolvedValue = local = this.buffer.getAsSoyValue();
            } else {
                throw new AssertionError((Object)"getResolvedValue() should only be called if the value isDone.");
            }
        }
        return local;
    }

    protected abstract RenderResult doRender(LoggingAdvisingAppendable var1) throws IOException;

    private static final class TeeAdvisingAppendable
    extends LoggingAdvisingAppendable {
        final LoggingAdvisingAppendable.BufferingAppendable buffer = LoggingAdvisingAppendable.buffering();
        final LoggingAdvisingAppendable delegate;

        TeeAdvisingAppendable(LoggingAdvisingAppendable delegate) {
            this.delegate = delegate;
        }

        @Override
        protected void notifyKindAndDirectionality(SanitizedContent.ContentKind kind, @Nullable Dir contentDir) throws IOException {
            this.delegate.setKindAndDirectionality(kind, contentDir);
            this.buffer.setKindAndDirectionality(kind, contentDir);
        }

        @Override
        @CanIgnoreReturnValue
        public TeeAdvisingAppendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public TeeAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public TeeAdvisingAppendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }

        @Override
        public boolean softLimitReached() {
            return this.delegate.softLimitReached();
        }

        @Override
        public void flushBuffers(int depth) {
            throw new AssertionError((Object)"should not be called");
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        @CanIgnoreReturnValue
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            this.delegate.enterLoggableElement(statement);
            this.buffer.enterLoggableElement(statement);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public LoggingAdvisingAppendable exitLoggableElement() {
            this.delegate.exitLoggableElement();
            this.buffer.exitLoggableElement();
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            this.delegate.appendLoggingFunctionInvocation(funCall, escapers);
            this.buffer.appendLoggingFunctionInvocation(funCall, (ImmutableList)escapers);
            return this;
        }
    }
}

