/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public abstract class SoyRuntimeType {
    private final SoyType soyType;
    private final Type runtimeType;

    public static Optional<SoyRuntimeType> getUnboxedType(SoyType soyType) {
        return Optional.ofNullable(SoyRuntimeType.unboxedTypeImpl(soyType));
    }

    public static SoyRuntimeType getBoxedType(SoyType soyType) {
        return new BoxedSoyType(soyType, BytecodeUtils.SOY_VALUE_TYPE);
    }

    @Nullable
    private static PrimitiveSoyType unboxedTypeImpl(SoyType soyType) {
        switch (soyType.getKind()) {
            case BOOL: {
                return new PrimitiveSoyType(BoolType.getInstance(), Type.BOOLEAN_TYPE);
            }
            case STRING: {
                return new PrimitiveSoyType(StringType.getInstance(), BytecodeUtils.STRING_TYPE);
            }
            case INT: {
                return new PrimitiveSoyType(IntType.getInstance(), Type.LONG_TYPE);
            }
            case FLOAT: {
                return new PrimitiveSoyType(FloatType.getInstance(), Type.DOUBLE_TYPE);
            }
            case PROTO_ENUM: {
                return new PrimitiveSoyType(soyType, Type.LONG_TYPE);
            }
            case MESSAGE: {
                return new PrimitiveSoyType(soyType, BytecodeUtils.MESSAGE_TYPE);
            }
            case PROTO: {
                return new PrimitiveSoyType(soyType, SoyRuntimeType.protoType(((SoyProtoType)soyType).getDescriptor()));
            }
            case LIST: {
                return new PrimitiveSoyType(soyType, BytecodeUtils.LIST_TYPE);
            }
            case UNION: {
                SoyType nonNullType = SoyTypes.tryRemoveNullish(soyType);
                if (!nonNullType.equals(soyType)) {
                    return null;
                }
                SoyRuntimeType memberType = null;
                for (SoyType member : ((UnionType)soyType).getMembers()) {
                    PrimitiveSoyType primitive = SoyRuntimeType.getUnboxedType(member).orElse(null);
                    if (primitive == null) {
                        return null;
                    }
                    if (memberType == null) {
                        memberType = primitive;
                        continue;
                    }
                    if (memberType.runtimeType().equals((Object)primitive.runtimeType()) && memberType.box().runtimeType().equals((Object)primitive.box().runtimeType())) continue;
                    return null;
                }
                if (memberType != null) {
                    return new PrimitiveSoyType(soyType, memberType.runtimeType());
                }
            }
            case NULL: 
            case UNDEFINED: 
            case ATTRIBUTES: 
            case CSS: 
            case URI: 
            case ELEMENT: 
            case HTML: 
            case JS: 
            case TRUSTED_RESOURCE_URI: 
            case LEGACY_OBJECT_MAP: 
            case MAP: 
            case RECORD: 
            case TEMPLATE: 
            case VE: 
            case VE_DATA: 
            case UNKNOWN: 
            case ANY: {
                return null;
            }
        }
        throw new AssertionError((Object)("can't map " + String.valueOf(soyType) + " to an unboxed soy runtime type"));
    }

    public static Type protoType(Descriptors.Descriptor descriptor) {
        return BytecodeUtils.getTypeForClassName(JavaQualifiedNames.getClassName(descriptor));
    }

    private SoyRuntimeType(SoyType soyType, Type runtimeType) {
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)soyType);
        this.runtimeType = (Type)Preconditions.checkNotNull((Object)runtimeType);
    }

    public final SoyType soyType() {
        return this.soyType;
    }

    public final Type runtimeType() {
        return this.runtimeType;
    }

    public boolean assignableToNullableInt() {
        return this.assignableToNullableType(IntType.getInstance());
    }

    public boolean assignableToNullableFloat() {
        return this.assignableToNullableType(FloatType.getInstance());
    }

    public boolean assignableToNullableNumber() {
        return this.assignableToNullableType(SoyTypes.NUMBER_TYPE);
    }

    public boolean assignableToNullableString() {
        return this.soyType.getKind().isKnownStringOrSanitizedContent() || this.soyType.getKind() == SoyType.Kind.UNION && SoyTypes.tryRemoveNullish(this.soyType).getKind().isKnownStringOrSanitizedContent();
    }

    private boolean assignableToNullableType(SoyType type) {
        return type.isAssignableFromStrict(this.soyType) || this.soyType.getKind() == SoyType.Kind.UNION && type.isAssignableFromStrict(SoyTypes.tryRemoveNullish(this.soyType));
    }

    public boolean isKnownString() {
        return this.soyType.getKind() == SoyType.Kind.STRING;
    }

    public boolean isKnownStringOrSanitizedContent() {
        if (this.soyType.getKind().isKnownStringOrSanitizedContent()) {
            return true;
        }
        if (this.soyType.getKind() == SoyType.Kind.UNION) {
            for (SoyType member : ((UnionType)this.soyType).getMembers()) {
                if (member.getKind().isKnownStringOrSanitizedContent()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isKnownSanitizedContent() {
        return this.soyType.getKind().isKnownSanitizedContent();
    }

    public boolean isKnownInt() {
        return this.soyType.getKind() == SoyType.Kind.INT || SoyTypes.isKindOrUnionOfKind(this.soyType, SoyType.Kind.PROTO_ENUM);
    }

    public final boolean isKnownFloat() {
        return this.soyType.getKind() == SoyType.Kind.FLOAT;
    }

    public final boolean isKnownListOrUnionOfLists() {
        return SoyTypes.isKindOrUnionOfKind(this.soyType, SoyType.Kind.LIST);
    }

    public final ListType asListType() {
        Preconditions.checkState((boolean)this.isKnownListOrUnionOfLists());
        if (this.soyType instanceof ListType) {
            return (ListType)this.soyType;
        }
        ArrayList<SoyType> members = new ArrayList<SoyType>();
        for (SoyType member : ((UnionType)this.soyType).getMembers()) {
            ListType memberAsList = (ListType)member;
            if (memberAsList.getElementType() == null) continue;
            members.add(memberAsList.getElementType());
        }
        return ListType.of(UnionType.of(members));
    }

    public final boolean isKnownLegacyObjectMapOrUnionOfMaps() {
        return SoyTypes.isKindOrUnionOfKind(this.soyType, SoyType.Kind.LEGACY_OBJECT_MAP);
    }

    public final boolean isKnownMapOrUnionOfMaps() {
        return SoyTypes.isKindOrUnionOfKind(this.soyType, SoyType.Kind.MAP);
    }

    public final boolean isKnownBool() {
        return this.soyType.getKind() == SoyType.Kind.BOOL;
    }

    public final boolean isKnownProtoOrUnionOfProtos() {
        return SoyTypes.isKindOrUnionOfKind(this.soyType, SoyType.Kind.PROTO);
    }

    public final boolean isKnownNumber() {
        return SoyTypes.NUMBER_TYPE.isAssignableFromStrict(this.soyType);
    }

    public final SoyRuntimeType asNonSoyNullish() {
        return this.withNewSoyType(SoyTypes.tryRemoveNullish(this.soyType));
    }

    public final SoyRuntimeType asSoyUndefinable() {
        return this.withNewSoyType(SoyTypes.makeUndefinable(this.soyType));
    }

    private SoyRuntimeType withNewSoyType(SoyType newSoyType) {
        if (newSoyType != this.soyType) {
            if (this.isBoxed()) {
                return SoyRuntimeType.getBoxedType(newSoyType);
            }
            return SoyRuntimeType.getUnboxedType(newSoyType).get();
        }
        return this;
    }

    public abstract boolean isBoxed();

    public SoyRuntimeType box() {
        if (this.isBoxed()) {
            return this;
        }
        return SoyRuntimeType.getBoxedType(this.soyType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoyRuntimeType)) {
            return false;
        }
        SoyRuntimeType that = (SoyRuntimeType)o;
        return Objects.equal((Object)this.soyType, (Object)that.soyType) && Objects.equal((Object)this.runtimeType, (Object)that.runtimeType) && this.isBoxed() == that.isBoxed();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.soyType, this.runtimeType, this.isBoxed()});
    }

    public String toString() {
        return "SoyRuntimeType{" + String.valueOf(this.soyType) + ", " + String.valueOf(this.runtimeType) + "}";
    }

    private static final class BoxedSoyType
    extends SoyRuntimeType {
        BoxedSoyType(SoyType soyType, Type runtimeType) {
            super(soyType, runtimeType);
        }

        @Override
        public boolean isBoxed() {
            return true;
        }
    }

    private static final class PrimitiveSoyType
    extends SoyRuntimeType {
        PrimitiveSoyType(SoyType soyType, Type runtimeType) {
            super(soyType, runtimeType);
        }

        @Override
        public boolean isBoxed() {
            return false;
        }
    }
}

