/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.LazyProtoToSoyValueList;
import com.google.template.soy.data.internal.LazyProtoToSoyValueMap;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.runtime.BufferedSoyValueProvider;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class MethodRefs {
    public static final MethodRef ARRAY_LIST_ADD = MethodRef.createNonPure(ArrayList.class, "add", Object.class);
    public static final MethodRef BOOLEAN_DATA_FOR_VALUE = MethodRef.createPure(BooleanData.class, "forValue", Boolean.TYPE);
    public static final MethodRef BOOLEAN_VALUE = MethodRef.createPure(Boolean.class, "booleanValue", new Class[0]).asCheap();
    public static final MethodRef BOOLEAN_TO_STRING = MethodRef.createPure(Boolean.class, "toString", Boolean.TYPE).asCheap().asNonJavaNullable();
    public static final MethodRef COMPILED_TEMPLATE_RENDER = MethodRef.createNonPure(CompiledTemplate.class, "render", ParamStore.class, LoggingAdvisingAppendable.class, RenderContext.class);
    public static final MethodRef DICT_IMPL_FOR_PROVIDER_MAP = MethodRef.createPure(DictImpl.class, "forProviderMap", Map.class, RuntimeMapTypeTracker.Type.class);
    public static final MethodRef MAP_IMPL_FOR_PROVIDER_MAP = MethodRef.createPure(SoyMapImpl.class, "forProviderMap", Map.class);
    public static final MethodRef MAP_IMPL_FOR_PROVIDER_MAP_NO_NULL_KEYS = MethodRef.createPure(SoyMapImpl.class, "forProviderMapNoNullKeys", Map.class);
    public static final MethodRef DOUBLE_TO_STRING = MethodRef.createPure(FloatData.class, "toString", Double.TYPE);
    public static final MethodRef EQUALS = MethodRef.createPure(Object.class, "equals", Object.class);
    public static final MethodRef STRING_COMPARE_TO = MethodRef.createPure(String.class, "compareTo", String.class);
    public static final MethodRef FLOAT_DATA_FOR_VALUE = MethodRef.createPure(FloatData.class, "forValue", Double.TYPE);
    public static final MethodRef RENDER_RESULT_ASSERT_DONE = MethodRef.createPure(RenderResult.class, "assertDone", new Class[0]);
    public static final ImmutableList<MethodRef> IMMUTABLE_LIST_OF;
    public static final MethodRef IMMUTABLE_LIST_OF_ARRAY;
    public static final ImmutableList<MethodRef> IMMUTABLE_MAP_OF;
    public static final MethodRef IMMUTABLE_MAP_BUILDER_WITH_EXPECTED_SIZE;
    public static final MethodRef IMMUTABLE_MAP_BUILDER_PUT;
    public static final MethodRef IMMUTABLE_MAP_BUILDER_BUILD_KEEPING_LAST;
    public static final MethodRef IMMUTABLE_MAP_BUILDER_BUILD_OR_THROW;
    public static final MethodRef INTEGER_DATA_FOR_VALUE;
    public static final MethodRef INTS_CHECKED_CAST;
    public static final MethodRef MAP_PUT;
    public static final MethodRef LIST_GET;
    public static final MethodRef LIST_SIZE;
    public static final MethodRef MAP_ENTRY_SET;
    public static final MethodRef GET_ITERATOR;
    public static final MethodRef ITERATOR_NEXT;
    public static final MethodRef ITERATOR_HAS_NEXT;
    public static final MethodRef MAP_GET_KEY;
    public static final MethodRef MAP_GET_VALUE;
    public static final MethodRef LIST_IMPL_FOR_PROVIDER_LIST;
    public static final MethodRef LONG_PARSE_LONG;
    public static final MethodRef UNSIGNED_LONGS_PARSE_UNSIGNED_LONG;
    public static final MethodRef UNSIGNED_LONGS_TO_STRING;
    public static final MethodRef UNSIGNED_INTS_SATURATED_CAST;
    public static final MethodRef UNSIGNED_INTS_TO_LONG;
    public static final MethodRef LONG_TO_STRING;
    public static final MethodRef NUMBER_DOUBLE_VALUE;
    public static final MethodRef NUMBER_LONG_VALUE;
    public static final MethodRef NUMBER_INT_VALUE;
    public static final MethodRef NUMBER_FLOAT_VALUE;
    public static final MethodRef OBJECT_TO_STRING;
    public static final MethodRef OBJECTS_EQUALS;
    public static final MethodRef ORDAIN_AS_SAFE;
    public static final MethodRef ORDAIN_AS_SAFE_DIR;
    public static final MethodRef PARAM_STORE_SET_FIELD;
    public static final MethodRef PARAM_STORE_FROM_RECORD;
    public static final MethodRef SOY_PROTO_VALUE_CREATE;
    public static final MethodRef RENDER_RESULT_DONE;
    public static final MethodRef RENDER_RESULT_IS_DONE;
    public static final MethodRef RENDER_RESULT_LIMITED;
    public static final MethodRef BUFFER_TEMPLATE;
    public static final MethodRef RUNTIME_CHECK_RESOLVED_LIST;
    public static final MethodRef RUNTIME_CHECK_RESOLVED_MAP;
    public static final MethodRef SOY_SERVER_KEY;
    public static final MethodRef RUNTIME_RANGE_LOOP_LENGTH;
    public static final MethodRef SOY_JAVA_PRINT_DIRECTIVE_APPLY_FOR_JAVA;
    public static final MethodRef RUNTIME_BIND_TEMPLATE_PARAMS;
    public static final MethodRef SOY_JAVA_FUNCTION_COMPUTE_FOR_JAVA;
    public static final MethodRef RUNTIME_COERCE_DOUBLE_TO_BOOLEAN;
    public static final MethodRef RUNTIME_COERCE_STRING_TO_BOOLEAN;
    public static final MethodRef RUNTIME_EQUAL;
    public static final MethodRef SOY_VALUE_IS_TRUTHY_NON_EMPTY;
    public static final MethodRef SOY_VALUE_HAS_CONTENT;
    public static final MethodRef RUNTIME_TRIPLE_EQUAL;
    public static final MethodRef RUNTIME_SWITCH_CASE_EQUAL;
    public static final MethodRef RUNTIME_COMPARE_BOXED_STRING;
    public static final MethodRef RUNTIME_COMPARE_BOXED_VALUE_TO_BOXED_STRING;
    public static final MethodRef RUNTIME_COMPARE_UNBOXED_STRING;
    public static final MethodRef RUNTIME_COMPARE_BOXED_VALUE_TO_UNBOXED_STRING;
    public static final MethodRef RUNTIME_GET_FIELD;
    public static final MethodRef RUNTIME_GET_FIELD_PROVIDER;
    public static final MethodRef PARAM_STORE_GET_PARAMETER;
    public static final MethodRef PARAM_STORE_GET_PARAMETER_DEFAULT;
    public static final MethodRef RUNTIME_PARAM_OR_DEFAULT;
    public static final MethodRef RUNTIME_GET_LIST_ITEM;
    public static final MethodRef RUNTIME_GET_LIST_ITEM_PROVIDER;
    public static final MethodRef RUNTIME_GET_LIST_STATUS;
    public static final MethodRef RUNTIME_GET_MAP_STATUS;
    public static final MethodRef RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM;
    public static final MethodRef RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM_PROVIDER;
    public static final MethodRef RUNTIME_GET_MAP_ITEM;
    public static final MethodRef RUNTIME_GET_MAP_ITEM_PROVIDER;
    public static final MethodRef RUNTIME_LESS_THAN;
    public static final MethodRef RUNTIME_LESS_THAN_OR_EQUAL;
    public static final MethodRef RUNTIME_LOGGER;
    public static final MethodRef RUNTIME_DEBUGGER;
    public static final MethodRef RUNTIME_MINUS;
    public static final MethodRef RUNTIME_NEGATIVE;
    public static final MethodRef RUNTIME_PLUS;
    public static final MethodRef RUNTIME_MOD;
    public static final MethodRef RUNTIME_SHIFT_RIGHT;
    public static final MethodRef RUNTIME_SHIFT_LEFT;
    public static final MethodRef RUNTIME_BITWISE_OR;
    public static final MethodRef RUNTIME_BITWISE_XOR;
    public static final MethodRef RUNTIME_BITWISE_AND;
    public static final MethodRef CONSTRUCT_MAP_FROM_LIST;
    public static final MethodRef RUNTIME_TIMES;
    public static final MethodRef MSG_RENDERER_SET_PLACEHOLDER;
    public static final MethodRef MSG_RENDERER_SET_PLACEHOLDER_AND_ORDERING;
    public static final MethodRef HANDLE_BASIC_TRANSLATION_AND_ESCAPE_HTML;
    public static final MethodRef RUNTIME_STRING_EQUALS_AS_NUMBER;
    public static final MethodRef RUNTIME_NUMBER_EQUALS_STRING_AS_NUMBER;
    public static final MethodRef RUNTIME_EMPTY_TO_NULL;
    public static final MethodRef RUNTIME_UNEXPECTED_STATE_ERROR;
    public static final MethodRef SOY_VALUE_AS_JAVA_LIST;
    public static final MethodRef SOY_VALUE_AS_JAVA_LIST_OR_NULL;
    public static final MethodRef SOY_VALUE_AS_JAVA_MAP;
    public static final MethodRef SOY_VALUE_GET_PROTO;
    public static final MethodRef SOY_VALUE_GET_PROTO_OR_NULL;
    public static final MethodRef SOY_VALUE_COERCE_TO_BOOLEAN;
    public static final MethodRef SOY_VALUE_BOOLEAN_VALUE;
    public static final MethodRef SOY_VALUE_FLOAT_VALUE;
    public static final MethodRef SOY_VALUE_LONG_VALUE;
    public static final MethodRef SOY_VALUE_INTEGER_VALUE;
    public static final MethodRef SOY_VALUE_NUMBER_VALUE;
    public static final MethodRef SOY_VALUE_IS_NULLISH;
    public static final MethodRef SOY_VALUE_IS_NULL;
    public static final MethodRef SOY_VALUE_IS_UNDEFINED;
    public static final MethodRef SOY_VALUE_NULLISH_TO_NULL;
    public static final MethodRef SOY_VALUE_NULLISH_TO_UNDEFINED;
    public static final MethodRef SOY_VALUE_JAVA_NUMBER_VALUE;
    public static final MethodRef SOY_VALUE_STRING_VALUE;
    public static final MethodRef SOY_VALUE_STRING_VALUE_OR_NULL;
    public static final MethodRef SOY_VALUE_COERCE_TO_STRING;
    public static final MethodRef CHECK_TYPE;
    public static final MethodRef CHECK_INT;
    public static final MethodRef CHECK_FLOAT;
    public static final MethodRef CHECK_NUMBER;
    public static final MethodRef CHECK_STRING;
    public static final MethodRef CHECK_BOOLEAN;
    public static final MethodRef CHECK_CONTENT_KIND;
    public static final MethodRef CHECK_PROTO;
    public static final MethodRef GET_COMPILED_TEMPLATE_FROM_VALUE;
    public static final MethodRef CREATE_TEMPLATE_VALUE;
    public static final MethodRef SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE;
    public static final MethodRef SOY_NULLISH_TO_JAVA_NULL;
    public static final MethodRef SOY_NULL_TO_JAVA_NULL;
    public static final MethodRef SOY_VALUE_PROVIDER_OR_NULLISH;
    public static final MethodRef SOY_VALUE_PROVIDER_STATUS;
    public static final MethodRef SOY_VALUE_PROVIDER_RESOLVE;
    public static final MethodRef STRING_CONCAT;
    public static final MethodRef STRING_IS_EMPTY;
    public static final MethodRef STRING_VALUE_OF;
    public static final MethodRef BOX_INTEGER;
    public static final MethodRef BOX_LONG;
    public static final MethodRef BOX_DOUBLE;
    public static final MethodRef BOX_FLOAT;
    public static final MethodRef BOX_BOOLEAN;
    public static final MethodRef CHECK_NOT_NULL;
    public static final MethodRef IS_SOY_NON_NULLISH;
    public static final MethodRef IS_SOY_NON_NULL;
    public static final MethodRef STRING_DATA_FOR_VALUE;
    public static final MethodRef LOGGING_ADVISING_APPENDABLE_BUFFERING;
    public static final MethodRef BUFFERED_SOY_VALUE_PROVIDER_CREATE;
    public static final MethodRef CREATE_LOG_STATEMENT;
    public static final MethodRef CLOSEABLE_CLOSE;
    public static final MethodRef PROTOCOL_ENUM_GET_NUMBER;
    public static final MethodRef SOY_VISUAL_ELEMENT_CREATE;
    public static final MethodRef SOY_VISUAL_ELEMENT_CREATE_WITH_METADATA;
    public static final MethodRef SOY_VISUAL_ELEMENT_DATA_CREATE;
    public static final MethodRef LAZY_PROTO_TO_SOY_VALUE_LIST_FOR_LIST;
    public static final MethodRef LAZY_PROTO_TO_SOY_VALUE_MAP_FOR_MAP;
    public static final MethodRef GET_EXTENSION_LIST;
    public static final MethodRef AS_SWITCHABLE_VALUE_LONG;
    public static final MethodRef AS_SWITCHABLE_VALUE_DOUBLE;
    public static final MethodRef AS_SWITCHABLE_VALUE_SOY_VALUE;
    public static final MethodRef ARRAY_LIST;
    public static final MethodRef ARRAY_LIST_SIZE;
    public static final MethodRef HASH_MAP_CAPACITY;
    public static final MethodRef LINKED_HASH_MAP_CAPACITY;
    public static final MethodRef PARAM_STORE_AUGMENT;
    public static final MethodRef PARAM_STORE_SIZE;
    public static final MethodRef SOY_RECORD_IMPL;
    public static final MethodRef MSG_RENDERER;
    public static final MethodRef PLRSEL_MSG_RENDERER;
    public static final MethodRef REPLAYING_BUFFERED_RENDER_DONE_FN;
    public static final MethodRef ESCAPING_BUFFERED_RENDER_DONE_FN;

    private MethodRefs() {
    }

    static {
        IMMUTABLE_MAP_BUILDER_WITH_EXPECTED_SIZE = MethodRef.createNonPure(ImmutableMap.class, "builderWithExpectedSize", Integer.TYPE);
        IMMUTABLE_MAP_BUILDER_PUT = MethodRef.createNonPure(ImmutableMap.Builder.class, "put", Object.class, Object.class);
        IMMUTABLE_MAP_BUILDER_BUILD_KEEPING_LAST = MethodRef.createNonPure(ImmutableMap.Builder.class, "buildKeepingLast", new Class[0]);
        IMMUTABLE_MAP_BUILDER_BUILD_OR_THROW = MethodRef.createNonPure(ImmutableMap.Builder.class, "buildOrThrow", new Class[0]);
        TreeMap<Integer, MethodRef> immutableListOfMethods = new TreeMap<Integer, MethodRef>();
        MethodRef immutableListOfArray = null;
        for (Method m : ImmutableList.class.getMethods()) {
            if (!m.getName().equals("of")) continue;
            Class<?>[] params = m.getParameterTypes();
            MethodRef ref = MethodRef.create(m, MethodRef.MethodPureness.PURE).asNonJavaNullable();
            if (params.length > 0 && params[params.length - 1].isArray()) {
                immutableListOfArray = ref;
                continue;
            }
            int arity = params.length;
            if (arity == 0) {
                ref = ref.asCheap();
            }
            immutableListOfMethods.put(arity, ref);
        }
        IMMUTABLE_LIST_OF_ARRAY = immutableListOfArray;
        IMMUTABLE_LIST_OF = ImmutableList.copyOf(immutableListOfMethods.values());
        TreeMap<Integer, MethodRef> immutableMapOfMethods = new TreeMap<Integer, MethodRef>();
        for (Method m : ImmutableMap.class.getMethods()) {
            if (!m.getName().equals("of")) continue;
            Class<?>[] params = m.getParameterTypes();
            MethodRef ref = MethodRef.create(m, MethodRef.MethodPureness.PURE).asNonJavaNullable();
            if (params.length > 0 && params[params.length - 1].isArray()) {
                immutableListOfArray = ref;
                continue;
            }
            int arity = params.length;
            if (arity == 0) {
                ref = ref.asCheap();
            }
            immutableMapOfMethods.put(arity / 2, ref);
        }
        IMMUTABLE_MAP_OF = ImmutableList.copyOf(immutableMapOfMethods.values());
        INTEGER_DATA_FOR_VALUE = MethodRef.createPure(IntegerData.class, "forValue", Long.TYPE);
        INTS_CHECKED_CAST = MethodRef.createPure(Ints.class, "checkedCast", Long.TYPE).asCheap();
        MAP_PUT = MethodRef.createNonPure(Map.class, "put", Object.class, Object.class);
        LIST_GET = MethodRef.createPure(List.class, "get", Integer.TYPE).asCheap();
        LIST_SIZE = MethodRef.createPure(List.class, "size", new Class[0]).asCheap();
        MAP_ENTRY_SET = MethodRef.createPure(Map.class, "entrySet", new Class[0]).asNonJavaNullable();
        GET_ITERATOR = MethodRef.createPure(Iterable.class, "iterator", new Class[0]).asNonJavaNullable();
        ITERATOR_NEXT = MethodRef.createNonPure(Iterator.class, "next", new Class[0]);
        ITERATOR_HAS_NEXT = MethodRef.createPure(Iterator.class, "hasNext", new Class[0]);
        MAP_GET_KEY = MethodRef.createPure(Map.Entry.class, "getKey", new Class[0]);
        MAP_GET_VALUE = MethodRef.createPure(Map.Entry.class, "getValue", new Class[0]);
        LIST_IMPL_FOR_PROVIDER_LIST = MethodRef.createPure(ListImpl.class, "forProviderList", List.class);
        LONG_PARSE_LONG = MethodRef.createPure(Long.class, "parseLong", String.class).asCheap().asNonJavaNullable();
        UNSIGNED_LONGS_PARSE_UNSIGNED_LONG = MethodRef.createPure(UnsignedLongs.class, "parseUnsignedLong", String.class).asCheap();
        UNSIGNED_LONGS_TO_STRING = MethodRef.createPure(UnsignedLongs.class, "toString", Long.TYPE).asCheap().asNonJavaNullable();
        UNSIGNED_INTS_SATURATED_CAST = MethodRef.createPure(UnsignedInts.class, "saturatedCast", Long.TYPE).asCheap();
        UNSIGNED_INTS_TO_LONG = MethodRef.createPure(UnsignedInts.class, "toLong", Integer.TYPE).asCheap();
        LONG_TO_STRING = MethodRef.createPure(Long.class, "toString", Long.TYPE).asNonJavaNullable();
        NUMBER_DOUBLE_VALUE = MethodRef.createPure(Number.class, "doubleValue", new Class[0]).asCheap();
        NUMBER_LONG_VALUE = MethodRef.createPure(Number.class, "longValue", new Class[0]).asCheap();
        NUMBER_INT_VALUE = MethodRef.createPure(Number.class, "intValue", new Class[0]).asCheap();
        NUMBER_FLOAT_VALUE = MethodRef.createPure(Number.class, "floatValue", new Class[0]).asCheap();
        OBJECT_TO_STRING = MethodRef.createPure(Object.class, "toString", new Class[0]).asNonJavaNullable();
        OBJECTS_EQUALS = MethodRef.createPure(Objects.class, "equals", Object.class, Object.class);
        ORDAIN_AS_SAFE = MethodRef.createPure(UnsafeSanitizedContentOrdainer.class, "ordainAsSafe", String.class, SanitizedContent.ContentKind.class);
        ORDAIN_AS_SAFE_DIR = MethodRef.createPure(UnsafeSanitizedContentOrdainer.class, "ordainAsSafe", String.class, SanitizedContent.ContentKind.class, Dir.class);
        PARAM_STORE_SET_FIELD = MethodRef.createNonPure(ParamStore.class, "setField", RecordProperty.class, SoyValueProvider.class);
        PARAM_STORE_FROM_RECORD = MethodRef.createPure(ParamStore.class, "fromRecord", SoyRecord.class);
        SOY_PROTO_VALUE_CREATE = MethodRef.createPure(SoyProtoValue.class, "create", Message.class);
        RENDER_RESULT_DONE = MethodRef.createPure(RenderResult.class, "done", new Class[0]).asCheap();
        RENDER_RESULT_IS_DONE = MethodRef.createPure(RenderResult.class, "isDone", new Class[0]).asCheap();
        RENDER_RESULT_LIMITED = MethodRef.createPure(RenderResult.class, "limited", new Class[0]).asCheap();
        BUFFER_TEMPLATE = MethodRef.createNonPure(JbcSrcRuntime.class, "bufferTemplate", CompiledTemplate.class, Boolean.TYPE, JbcSrcRuntime.BufferedRenderDoneFn.class);
        RUNTIME_CHECK_RESOLVED_LIST = MethodRef.createNonPure(JbcSrcRuntime.class, "checkResolved", List.class);
        RUNTIME_CHECK_RESOLVED_MAP = MethodRef.createNonPure(JbcSrcRuntime.class, "checkResolved", Map.class);
        SOY_SERVER_KEY = MethodRef.createPure(SharedRuntime.class, "soyServerKey", SoyValue.class).asCheap();
        RUNTIME_RANGE_LOOP_LENGTH = MethodRef.createPure(JbcSrcRuntime.class, "rangeLoopLength", Integer.TYPE, Integer.TYPE, Integer.TYPE).asCheap();
        SOY_JAVA_PRINT_DIRECTIVE_APPLY_FOR_JAVA = MethodRef.createNonPure(SoyJavaPrintDirective.class, "applyForJava", SoyValue.class, List.class);
        RUNTIME_BIND_TEMPLATE_PARAMS = MethodRef.createPure(JbcSrcRuntime.class, "bindTemplateParams", TemplateValue.class, ParamStore.class);
        SOY_JAVA_FUNCTION_COMPUTE_FOR_JAVA = MethodRef.createNonPure(SoyJavaFunction.class, "computeForJava", List.class);
        RUNTIME_COERCE_DOUBLE_TO_BOOLEAN = MethodRef.createPure(JbcSrcRuntime.class, "coerceToBoolean", Double.TYPE);
        RUNTIME_COERCE_STRING_TO_BOOLEAN = MethodRef.createPure(JbcSrcRuntime.class, "coerceToBoolean", String.class);
        RUNTIME_EQUAL = MethodRef.createPure(SharedRuntime.class, "equal", SoyValue.class, SoyValue.class);
        SOY_VALUE_IS_TRUTHY_NON_EMPTY = MethodRef.createPure(SoyValue.class, "isTruthyNonEmpty", new Class[0]);
        SOY_VALUE_HAS_CONTENT = MethodRef.createPure(SoyValue.class, "hasContent", new Class[0]);
        RUNTIME_TRIPLE_EQUAL = MethodRef.createPure(SharedRuntime.class, "tripleEqual", SoyValue.class, SoyValue.class);
        RUNTIME_SWITCH_CASE_EQUAL = MethodRef.createPure(SharedRuntime.class, "switchCaseEqual", SoyValue.class, SoyValue.class);
        RUNTIME_COMPARE_BOXED_STRING = MethodRef.createPure(JbcSrcRuntime.class, "compareBoxedStringToBoxed", SoyValue.class, SoyValue.class);
        RUNTIME_COMPARE_BOXED_VALUE_TO_BOXED_STRING = MethodRef.createPure(JbcSrcRuntime.class, "compareBoxedValueToBoxedString", SoyValue.class, SoyValue.class);
        RUNTIME_COMPARE_UNBOXED_STRING = MethodRef.createPure(JbcSrcRuntime.class, "compareUnboxedStringToBoxed", String.class, SoyValue.class);
        RUNTIME_COMPARE_BOXED_VALUE_TO_UNBOXED_STRING = MethodRef.createPure(JbcSrcRuntime.class, "compareBoxedValueToUnboxedString", SoyValue.class, String.class);
        RUNTIME_GET_FIELD = MethodRef.createPure(JbcSrcRuntime.class, "getField", SoyValue.class, RecordProperty.class);
        RUNTIME_GET_FIELD_PROVIDER = MethodRef.createPure(JbcSrcRuntime.class, "getFieldProvider", SoyValue.class, RecordProperty.class);
        PARAM_STORE_GET_PARAMETER = MethodRef.createPure(ParamStore.class, "getParameter", RecordProperty.class);
        PARAM_STORE_GET_PARAMETER_DEFAULT = MethodRef.createPure(ParamStore.class, "getParameter", RecordProperty.class, SoyValue.class);
        RUNTIME_PARAM_OR_DEFAULT = MethodRef.createPure(JbcSrcRuntime.class, "paramOrDefault", SoyValueProvider.class, SoyValue.class).asCheap();
        RUNTIME_GET_LIST_ITEM = MethodRef.createPure(JbcSrcRuntime.class, "getSoyListItem", List.class, Long.TYPE);
        RUNTIME_GET_LIST_ITEM_PROVIDER = MethodRef.createPure(JbcSrcRuntime.class, "getSoyListItemProvider", List.class, Long.TYPE);
        RUNTIME_GET_LIST_STATUS = MethodRef.createNonPure(JbcSrcRuntime.class, "getListStatus", List.class);
        RUNTIME_GET_MAP_STATUS = MethodRef.createNonPure(JbcSrcRuntime.class, "getMapStatus", Map.class);
        RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM = MethodRef.createPure(JbcSrcRuntime.class, "getSoyLegacyObjectMapItem", SoyValue.class, SoyValue.class);
        RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM_PROVIDER = MethodRef.createPure(JbcSrcRuntime.class, "getSoyLegacyObjectMapItemProvider", SoyValue.class, SoyValue.class);
        RUNTIME_GET_MAP_ITEM = MethodRef.createPure(JbcSrcRuntime.class, "getSoyMapItem", SoyValue.class, SoyValue.class);
        RUNTIME_GET_MAP_ITEM_PROVIDER = MethodRef.createPure(JbcSrcRuntime.class, "getSoyMapItemProvider", SoyValue.class, SoyValue.class);
        RUNTIME_LESS_THAN = MethodRef.createPure(SharedRuntime.class, "lessThan", SoyValue.class, SoyValue.class);
        RUNTIME_LESS_THAN_OR_EQUAL = MethodRef.createPure(SharedRuntime.class, "lessThanOrEqual", SoyValue.class, SoyValue.class);
        RUNTIME_LOGGER = MethodRef.createPure(JbcSrcRuntime.class, "logger", new Class[0]).asCheap();
        RUNTIME_DEBUGGER = MethodRef.createNonPure(JbcSrcRuntime.class, "debugger", String.class, Integer.TYPE);
        RUNTIME_MINUS = MethodRef.createPure(SharedRuntime.class, "minus", SoyValue.class, SoyValue.class);
        RUNTIME_NEGATIVE = MethodRef.createPure(SharedRuntime.class, "negative", SoyValue.class);
        RUNTIME_PLUS = MethodRef.createPure(SharedRuntime.class, "plus", SoyValue.class, SoyValue.class);
        RUNTIME_MOD = MethodRef.createPure(SharedRuntime.class, "mod", SoyValue.class, SoyValue.class);
        RUNTIME_SHIFT_RIGHT = MethodRef.createPure(SharedRuntime.class, "shiftRight", SoyValue.class, SoyValue.class);
        RUNTIME_SHIFT_LEFT = MethodRef.createPure(SharedRuntime.class, "shiftLeft", SoyValue.class, SoyValue.class);
        RUNTIME_BITWISE_OR = MethodRef.createPure(SharedRuntime.class, "bitwiseOr", SoyValue.class, SoyValue.class);
        RUNTIME_BITWISE_XOR = MethodRef.createPure(SharedRuntime.class, "bitwiseXor", SoyValue.class, SoyValue.class);
        RUNTIME_BITWISE_AND = MethodRef.createPure(SharedRuntime.class, "bitwiseAnd", SoyValue.class, SoyValue.class);
        CONSTRUCT_MAP_FROM_LIST = MethodRef.createPure(SharedRuntime.class, "constructMapFromList", List.class);
        RUNTIME_TIMES = MethodRef.createPure(SharedRuntime.class, "times", SoyValue.class, SoyValue.class);
        MSG_RENDERER_SET_PLACEHOLDER = MethodRef.createNonPure(JbcSrcRuntime.MsgRenderer.class, "setPlaceholder", String.class, SoyValueProvider.class);
        MSG_RENDERER_SET_PLACEHOLDER_AND_ORDERING = MethodRef.createNonPure(JbcSrcRuntime.MsgRenderer.class, "setPlaceholderAndOrdering", String.class, SoyValueProvider.class, String.class);
        HANDLE_BASIC_TRANSLATION_AND_ESCAPE_HTML = MethodRef.createPure(JbcSrcRuntime.class, "handleBasicTranslationAndEscapeHtml", String.class);
        RUNTIME_STRING_EQUALS_AS_NUMBER = MethodRef.createPure(JbcSrcRuntime.class, "stringEqualsAsNumber", String.class, Double.TYPE);
        RUNTIME_NUMBER_EQUALS_STRING_AS_NUMBER = MethodRef.createPure(JbcSrcRuntime.class, "numberEqualsStringAsNumber", Double.TYPE, String.class);
        RUNTIME_EMPTY_TO_NULL = MethodRef.createPure(JbcSrcRuntime.class, "emptyToNull", SoyValue.class);
        RUNTIME_UNEXPECTED_STATE_ERROR = MethodRef.createNonPure(JbcSrcRuntime.class, "unexpectedStateError", StackFrame.class);
        SOY_VALUE_AS_JAVA_LIST = MethodRef.createPure(SoyValue.class, "asJavaList", new Class[0]);
        SOY_VALUE_AS_JAVA_LIST_OR_NULL = MethodRef.createPure(SoyValue.class, "asJavaListOrNull", new Class[0]);
        SOY_VALUE_AS_JAVA_MAP = MethodRef.createPure(SoyValue.class, "asJavaMap", new Class[0]);
        SOY_VALUE_GET_PROTO = MethodRef.createPure(SoyValue.class, "getProto", new Class[0]).asCheap();
        SOY_VALUE_GET_PROTO_OR_NULL = MethodRef.createPure(SoyValue.class, "getProtoOrNull", new Class[0]).asCheap();
        SOY_VALUE_COERCE_TO_BOOLEAN = MethodRef.createPure(SoyValue.class, "coerceToBoolean", new Class[0]).asCheap();
        SOY_VALUE_BOOLEAN_VALUE = MethodRef.createPure(SoyValue.class, "booleanValue", new Class[0]).asCheap();
        SOY_VALUE_FLOAT_VALUE = MethodRef.createPure(SoyValue.class, "floatValue", new Class[0]).asCheap();
        SOY_VALUE_LONG_VALUE = MethodRef.createPure(SoyValue.class, "longValue", new Class[0]).asCheap();
        SOY_VALUE_INTEGER_VALUE = MethodRef.createPure(SoyValue.class, "integerValue", new Class[0]).asCheap();
        SOY_VALUE_NUMBER_VALUE = MethodRef.createPure(SoyValue.class, "numberValue", new Class[0]);
        SOY_VALUE_IS_NULLISH = MethodRef.createPure(SoyValue.class, "isNullish", new Class[0]).asCheap().asNonJavaNullable();
        SOY_VALUE_IS_NULL = MethodRef.createPure(SoyValue.class, "isNull", new Class[0]).asCheap().asNonJavaNullable();
        SOY_VALUE_IS_UNDEFINED = MethodRef.createPure(SoyValue.class, "isUndefined", new Class[0]).asCheap().asNonJavaNullable();
        SOY_VALUE_NULLISH_TO_NULL = MethodRef.createPure(SoyValue.class, "nullishToNull", new Class[0]).asCheap().asNonJavaNullable();
        SOY_VALUE_NULLISH_TO_UNDEFINED = MethodRef.createPure(SoyValue.class, "nullishToUndefined", new Class[0]).asCheap().asNonJavaNullable();
        SOY_VALUE_JAVA_NUMBER_VALUE = MethodRef.createPure(NumberData.class, "javaNumberValue", new Class[0]);
        SOY_VALUE_STRING_VALUE = MethodRef.createPure(SoyValue.class, "stringValue", new Class[0]).asCheap();
        SOY_VALUE_STRING_VALUE_OR_NULL = MethodRef.createPure(SoyValue.class, "stringValueOrNull", new Class[0]).asCheap();
        SOY_VALUE_COERCE_TO_STRING = MethodRef.createPure(SoyValue.class, "coerceToString", new Class[0]);
        CHECK_TYPE = MethodRef.createNonPure(SoyValue.class, "checkNullishType", Class.class);
        CHECK_INT = MethodRef.createNonPure(SoyValue.class, "checkNullishInt", new Class[0]);
        CHECK_FLOAT = MethodRef.createNonPure(SoyValue.class, "checkNullishFloat", new Class[0]);
        CHECK_NUMBER = MethodRef.createNonPure(SoyValue.class, "checkNullishNumber", new Class[0]);
        CHECK_STRING = MethodRef.createNonPure(SoyValue.class, "checkNullishString", new Class[0]);
        CHECK_BOOLEAN = MethodRef.createNonPure(SoyValue.class, "checkNullishBoolean", new Class[0]);
        CHECK_CONTENT_KIND = MethodRef.createNonPure(SoyValue.class, "checkNullishSanitizedContent", SanitizedContent.ContentKind.class);
        CHECK_PROTO = MethodRef.createNonPure(SoyValue.class, "checkNullishProto", Class.class);
        GET_COMPILED_TEMPLATE_FROM_VALUE = MethodRef.createPure(TemplateValue.class, "getCompiledTemplate", new Class[0]).asCheap();
        CREATE_TEMPLATE_VALUE = MethodRef.createPure(TemplateValue.class, "create", String.class, Object.class);
        SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE = MethodRef.createNonPure(SoyValueProvider.class, "renderAndResolve", LoggingAdvisingAppendable.class);
        SOY_NULLISH_TO_JAVA_NULL = MethodRef.createNonPure(JbcSrcRuntime.class, "soyNullishToJavaNull", SoyValue.class);
        SOY_NULL_TO_JAVA_NULL = MethodRef.createNonPure(JbcSrcRuntime.class, "soyNullToJavaNull", SoyValue.class);
        SOY_VALUE_PROVIDER_OR_NULLISH = MethodRef.createNonPure(JbcSrcRuntime.class, "soyValueProviderOrNullish", SoyValueProvider.class);
        SOY_VALUE_PROVIDER_STATUS = MethodRef.createNonPure(SoyValueProvider.class, "status", new Class[0]);
        SOY_VALUE_PROVIDER_RESOLVE = MethodRef.createNonPure(SoyValueProvider.class, "resolve", new Class[0]);
        STRING_CONCAT = MethodRef.createPure(String.class, "concat", String.class).asNonJavaNullable();
        STRING_IS_EMPTY = MethodRef.createPure(String.class, "isEmpty", new Class[0]);
        STRING_VALUE_OF = MethodRef.createPure(String.class, "valueOf", Object.class).asNonJavaNullable();
        BOX_INTEGER = MethodRef.createPure(Integer.class, "valueOf", Integer.TYPE).asNonJavaNullable();
        BOX_LONG = MethodRef.createPure(Long.class, "valueOf", Long.TYPE).asNonJavaNullable();
        BOX_DOUBLE = MethodRef.createPure(Double.class, "valueOf", Double.TYPE).asNonJavaNullable();
        BOX_FLOAT = MethodRef.createPure(Float.class, "valueOf", Float.TYPE).asNonJavaNullable();
        BOX_BOOLEAN = MethodRef.createPure(Boolean.class, "valueOf", Boolean.TYPE).asNonJavaNullable();
        CHECK_NOT_NULL = MethodRef.createNonPure(JbcSrcRuntime.class, "checkExpressionNotNull", Object.class, String.class);
        IS_SOY_NON_NULLISH = MethodRef.createPure(JbcSrcRuntime.class, "isNonSoyNullish", SoyValueProvider.class);
        IS_SOY_NON_NULL = MethodRef.createPure(JbcSrcRuntime.class, "isNonSoyNull", SoyValueProvider.class);
        STRING_DATA_FOR_VALUE = MethodRef.createPure(StringData.class, "forValue", String.class).asCheap();
        LOGGING_ADVISING_APPENDABLE_BUFFERING = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "buffering", new Class[0]);
        BUFFERED_SOY_VALUE_PROVIDER_CREATE = MethodRef.createPure(BufferedSoyValueProvider.class, "create", LoggingAdvisingAppendable.BufferingAppendable.class);
        CREATE_LOG_STATEMENT = MethodRef.createPure(JbcSrcRuntime.class, "createLogStatement", Boolean.TYPE, SoyValue.class);
        CLOSEABLE_CLOSE = MethodRef.createNonPure(Closeable.class, "close", new Class[0]);
        PROTOCOL_ENUM_GET_NUMBER = MethodRef.createPure(ProtocolMessageEnum.class, "getNumber", new Class[0]).asCheap();
        SOY_VISUAL_ELEMENT_CREATE = MethodRef.createPure(SoyVisualElement.class, "create", Long.TYPE, String.class);
        SOY_VISUAL_ELEMENT_CREATE_WITH_METADATA = MethodRef.createPure(SoyVisualElement.class, "create", Long.TYPE, String.class, LoggableElementMetadata.class);
        SOY_VISUAL_ELEMENT_DATA_CREATE = MethodRef.createPure(SoyVisualElementData.class, "create", SoyValue.class, Message.class);
        LAZY_PROTO_TO_SOY_VALUE_LIST_FOR_LIST = MethodRef.createPure(LazyProtoToSoyValueList.class, "forList", List.class, ProtoFieldInterpreter.class);
        LAZY_PROTO_TO_SOY_VALUE_MAP_FOR_MAP = MethodRef.createPure(LazyProtoToSoyValueMap.class, "forMap", Map.class, ProtoFieldInterpreter.class, ProtoFieldInterpreter.class, Class.class);
        GET_EXTENSION_LIST = MethodRef.createPure(JbcSrcRuntime.class, "getExtensionList", GeneratedMessage.ExtendableMessage.class, ExtensionLite.class, ProtoFieldInterpreter.class);
        AS_SWITCHABLE_VALUE_LONG = MethodRef.createPure(JbcSrcRuntime.class, "asSwitchableValue", Long.TYPE, Integer.TYPE);
        AS_SWITCHABLE_VALUE_DOUBLE = MethodRef.createPure(JbcSrcRuntime.class, "asSwitchableValue", Double.TYPE, Integer.TYPE);
        AS_SWITCHABLE_VALUE_SOY_VALUE = MethodRef.createPure(JbcSrcRuntime.class, "asSwitchableValue", SoyValue.class, Integer.TYPE);
        ARRAY_LIST = MethodRef.createNonPureConstructor(ArrayList.class, new Class[0]);
        ARRAY_LIST_SIZE = MethodRef.createNonPureConstructor(ArrayList.class, Integer.TYPE);
        HASH_MAP_CAPACITY = MethodRef.createNonPureConstructor(HashMap.class, Integer.TYPE);
        LINKED_HASH_MAP_CAPACITY = MethodRef.createNonPureConstructor(LinkedHashMap.class, Integer.TYPE);
        PARAM_STORE_AUGMENT = MethodRef.createPureConstructor(ParamStore.class, ParamStore.class, Integer.TYPE);
        PARAM_STORE_SIZE = MethodRef.createPureConstructor(ParamStore.class, Integer.TYPE);
        SOY_RECORD_IMPL = MethodRef.createPureConstructor(SoyRecordImpl.class, ParamStore.class);
        MSG_RENDERER = MethodRef.createPureConstructor(JbcSrcRuntime.MsgRenderer.class, Long.TYPE, ImmutableList.class, ULocale.class, Integer.TYPE, Boolean.TYPE);
        PLRSEL_MSG_RENDERER = MethodRef.createPureConstructor(JbcSrcRuntime.PlrSelMsgRenderer.class, Long.TYPE, ImmutableList.class, ULocale.class, Integer.TYPE, Boolean.TYPE);
        REPLAYING_BUFFERED_RENDER_DONE_FN = MethodRef.createPureConstructor(JbcSrcRuntime.ReplayingBufferedRenderDoneFn.class, new Class[0]);
        ESCAPING_BUFFERED_RENDER_DONE_FN = MethodRef.createPureConstructor(JbcSrcRuntime.EscapingBufferedRenderDoneFn.class, ImmutableList.class);
    }
}

