/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class LocalVariable
extends Expression {
    private final String variableName;
    private final State state;
    private final Label start;
    private final Label end;

    public static LocalVariable createThisVar(TypeInfo owner, Label start, Label end) {
        return new LocalVariable("this", owner.type(), new State(0, true), start, end, Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, new Expression.Feature[0]));
    }

    public static LocalVariable createLocal(String name, int index, Type type, Label start, Label end) {
        return new LocalVariable(name, type, new State(index, false), start, end, Expression.Features.of());
    }

    private LocalVariable(String variableName, Type type, State state, Label start, Label end, Expression.Features features) {
        super(type, features.plus(Expression.Feature.CHEAP));
        this.variableName = (String)Preconditions.checkNotNull((Object)variableName);
        this.state = state;
        this.start = (Label)Preconditions.checkNotNull((Object)start);
        this.end = (Label)Preconditions.checkNotNull((Object)end);
    }

    public String variableName() {
        return this.variableName;
    }

    public int index() {
        return this.state.index;
    }

    public void shiftIndex(int offset) {
        this.state.shiftIndex(offset);
    }

    public Label end() {
        return this.end;
    }

    @Override
    public LocalVariable asCheap() {
        return this;
    }

    @Override
    public LocalVariable asNonJavaNullable() {
        if (this.isNonJavaNullable()) {
            return this;
        }
        return new LocalVariable(this.variableName, this.resultType(), this.state, this.start, this.end, this.features().plus(Expression.Feature.NON_JAVA_NULLABLE));
    }

    @Override
    public LocalVariable asNonSoyNullish() {
        if (this.isNonSoyNullish()) {
            return this;
        }
        return new LocalVariable(this.variableName, this.resultType(), this.state, this.start, this.end, this.features().plus(Expression.Feature.NON_SOY_NULLISH));
    }

    public void tableEntry(CodeBuilder mv) {
        this.state.markRead();
        if (Flags.DEBUG) {
            this.start.getOffset();
            this.end.getOffset();
        }
        mv.visitLocalVariable(this.variableName(), this.resultType().getDescriptor(), null, this.start, this.end, this.index());
    }

    @Override
    protected void doGen(CodeBuilder cb) {
        cb.visitVarInsn(this.resultType().getOpcode(21), this.index());
    }

    public void storeUnchecked(CodeBuilder cb) {
        this.state.markRead();
        cb.visitVarInsn(this.resultType().getOpcode(54), this.index());
    }

    public void loadUnchecked(CodeBuilder cb) {
        this.state.markRead();
        cb.visitVarInsn(this.resultType().getOpcode(21), this.index());
    }

    public Statement store(Expression expr) {
        return this.doStore(expr, false);
    }

    public Statement initialize(Expression expr) {
        return this.doStore(expr, true);
    }

    private Statement doStore(final Expression expr, final boolean initialization) {
        expr.checkAssignableTo(this.resultType());
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                if (initialization) {
                    adapter.visitLabel(LocalVariable.this.start);
                }
                LocalVariable.this.storeUnchecked(adapter);
            }
        };
    }

    @Override
    public String toString() {
        boolean indexHasBeenRead = this.state.indexHasBeenRead;
        try {
            String string = super.toString();
            return string;
        }
        finally {
            if (!indexHasBeenRead) {
                this.state.indexHasBeenRead = false;
            }
        }
    }

    @Override
    protected void extraToStringProperties(MoreObjects.ToStringHelper helper) {
        helper.add("name", (Object)this.variableName);
    }

    private static final class State {
        int index;
        boolean indexHasBeenRead;

        State(int index, boolean indexHasBeenRead) {
            this.index = index;
            this.indexHasBeenRead = indexHasBeenRead;
        }

        void shiftIndex(int offset) {
            if (this.indexHasBeenRead) {
                throw new IllegalStateException("slot has been read");
            }
            this.index += offset;
        }

        void markRead() {
            this.indexHasBeenRead = true;
        }
    }
}

