/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.ExtraConstantBootstraps;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public final class LambdaFactory {
    private static final Handle METAFACTORY_HANDLE = MethodRef.createPure(LambdaMetafactory.class, "metafactory", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class).asHandle();
    private static final Handle CONDY_METAFACTORY = MethodRef.createPure(ExtraConstantBootstraps.class, "constantMetafactory", MethodHandles.Lookup.class, String.class, Class.class, MethodType.class, MethodHandle.class, MethodType.class).asHandle();
    private final TypeInfo interfaceType;
    private final String interfaceMethodName;
    private final Type interfaceMethodType;
    private final MethodRef implMethod;
    private final String callSiteDescriptor;
    private final ImmutableList<Type> boundParams;

    public static LambdaFactory create(MethodRef interfaceMethod, MethodRef implMethod) {
        Preconditions.checkState((boolean)interfaceMethod.isInterfaceMethod(), (Object)"Only interfaces are supported");
        return new LambdaFactory(interfaceMethod.owner(), interfaceMethod, implMethod);
    }

    private LambdaFactory(TypeInfo interfaceType, MethodRef interfaceMethod, MethodRef implMethod) {
        this.interfaceType = interfaceType;
        this.interfaceMethodName = interfaceMethod.method().getName();
        this.implMethod = implMethod;
        ImmutableList interfaceMethodParams = interfaceMethod.argTypes().subList(1, interfaceMethod.argTypes().size());
        this.interfaceMethodType = Type.getMethodType((Type)interfaceMethod.returnType(), (Type[])((Type[])interfaceMethodParams.toArray((Object[])new Type[0])));
        ImmutableList trailingImplParams = implMethod.argTypes().subList(implMethod.argTypes().size() - interfaceMethodParams.size(), implMethod.argTypes().size());
        Preconditions.checkArgument((boolean)interfaceMethodParams.equals((Object)trailingImplParams), (String)"trailing parameters of %s must match the free parameters of %s", (Object)implMethod, (Object)interfaceMethod);
        this.boundParams = implMethod.argTypes().subList(0, implMethod.argTypes().size() - interfaceMethodParams.size());
        this.callSiteDescriptor = Type.getMethodDescriptor((Type)interfaceType.type(), (Type[])((Type[])this.boundParams.toArray((Object[])new Type[0])));
    }

    public Expression invoke(Expression ... args) {
        return this.invoke(Arrays.asList(args));
    }

    public Expression invoke(final Iterable<Expression> args) {
        Expression.checkTypes(this.boundParams, args);
        Expression.Features features = Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, Expression.Feature.NON_SOY_NULLISH);
        if (Expression.areAllCheap(args)) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        return new Expression(this.interfaceType.type(), features){

            @Override
            protected void doGen(CodeBuilder cb) {
                if (LambdaFactory.this.boundParams.isEmpty()) {
                    cb.visitLdcInsn(new ConstantDynamic(LambdaFactory.this.interfaceMethodName, LambdaFactory.this.interfaceType.type().getDescriptor(), CONDY_METAFACTORY, new Object[]{LambdaFactory.this.interfaceMethodType, LambdaFactory.this.implMethod.asHandle(), LambdaFactory.this.interfaceMethodType}));
                } else {
                    for (Expression arg : args) {
                        arg.gen(cb);
                    }
                    cb.visitInvokeDynamicInsn(LambdaFactory.this.interfaceMethodName, LambdaFactory.this.callSiteDescriptor, METAFACTORY_HANDLE, new Object[]{LambdaFactory.this.interfaceMethodType, LambdaFactory.this.implMethod.asHandle(), LambdaFactory.this.interfaceMethodType});
                }
            }
        };
    }
}

