/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.FormatMethod;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.restricted.BytecodeProducer;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public abstract class Expression
extends BytecodeProducer {
    private final Features features;
    private final Type resultType;
    private final Optional<ConstantValue> constantValue;

    public static boolean areAllCheap(Iterable<? extends Expression> args) {
        return Iterables.all(args, Expression::isCheap);
    }

    public static boolean areAllCheap(Expression first, Expression ... rest) {
        return Expression.areAllCheap((Iterable<? extends Expression>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static boolean areAllConstant(Iterable<? extends Expression> args) {
        return Iterables.all(args, Expression::isConstant);
    }

    static void checkTypes(ImmutableList<Type> types, Iterable<? extends Expression> exprs) {
        int size = Iterables.size(exprs);
        Preconditions.checkArgument((size == types.size() ? 1 : 0) != 0, (String)"Supplied the wrong number of parameters. Expected %s, got %s", types, exprs);
        if (Flags.DEBUG) {
            int i = 0;
            for (Expression expression : exprs) {
                expression.checkAssignableTo((Type)types.get(i), "Parameter %s", i);
                ++i;
            }
        }
    }

    protected Expression(Type resultType) {
        this(resultType, Features.of());
    }

    protected Expression(Type resultType, Features features) {
        this(resultType, features, SourceLocation.UNKNOWN);
    }

    protected Expression(Type resultType, ConstantValue constantValue, Features features) {
        this(resultType, features, SourceLocation.UNKNOWN, Optional.of(constantValue));
    }

    protected Expression(Type resultType, Features features, SourceLocation location) {
        this(resultType, features, location, Optional.empty());
    }

    protected Expression(Type resultType, Features features, SourceLocation location, Optional<ConstantValue> constantValue) {
        super(location);
        this.resultType = (Type)Preconditions.checkNotNull((Object)resultType);
        this.features = Features.forType(resultType, features);
        this.constantValue = (Optional)Preconditions.checkNotNull(constantValue);
        if (Flags.DEBUG && constantValue.isPresent()) {
            Preconditions.checkState((boolean)BytecodeUtils.isPossiblyAssignableFrom(resultType, constantValue.get().type), (String)"Type mismatch. Expected constant value of type %s to to be assignable to %s", (Object)constantValue.get().type, (Object)resultType);
        }
    }

    private static void checkType(Object value, Class<?> type) {
        if (!type.isInstance(value)) {
            throw new IllegalStateException("expected " + String.valueOf(value) + " a " + String.valueOf(value.getClass()) + " to be a " + String.valueOf(type));
        }
    }

    @Override
    protected abstract void doGen(CodeBuilder var1);

    public Expression withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        if (location.equals(this.location)) {
            return this;
        }
        return new DelegatingExpression(this, location);
    }

    public Expression toMaybeConstant() {
        if (this.isConstant() && !this.constantValue.get().isTrivialConstant()) {
            return this.toConstantExpression();
        }
        return this;
    }

    public Expression toConstantExpression() {
        final Object actualConstantValue = this.constantValue.get().byteCodeValue;
        return new Expression(this, this.resultType, this.features.plus(Feature.CHEAP), this.location, this.constantValue){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.visitLdcInsn(actualConstantValue);
            }
        };
    }

    public final Type resultType() {
        return this.resultType;
    }

    public boolean isCheap() {
        return this.features.has(Feature.CHEAP);
    }

    public boolean isNonJavaNullable() {
        return this.features.has(Feature.NON_JAVA_NULLABLE);
    }

    public boolean isNonSoyNullish() {
        return this.features.has(Feature.NON_SOY_NULLISH);
    }

    public Features features() {
        return this.features;
    }

    public final void checkAssignableTo(Type expected) {
        this.checkAssignableTo(expected, "", new Object[0]);
    }

    @FormatMethod
    public final void checkAssignableTo(Type expected, String fmt, Object ... args) {
        if (Flags.DEBUG && !BytecodeUtils.isPossiblyAssignableFrom(expected, this.resultType())) {
            Object message = String.format("Type mismatch. Got %s but expected %s. %b", this.resultType().getClassName(), expected.getClassName(), this instanceof SoyExpression);
            if (!fmt.isEmpty()) {
                message = String.format(fmt, args) + ". " + (String)message;
            }
            throw new IllegalArgumentException((String)message);
        }
    }

    public Statement toStatement() {
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                switch (Expression.this.resultType().getSize()) {
                    case 0: {
                        throw new AssertionError((Object)"void expressions are not allowed");
                    }
                    case 1: {
                        adapter.pop();
                        break;
                    }
                    case 2: {
                        adapter.pop2();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        };
    }

    public Expression asCheap() {
        if (this.isCheap()) {
            return this;
        }
        return new DelegatingExpression(this, this.features.plus(Feature.CHEAP));
    }

    public Expression asNonJavaNullable() {
        if (this.isNonJavaNullable()) {
            return this;
        }
        return new DelegatingExpression(this, this.features.plus(Feature.NON_JAVA_NULLABLE));
    }

    public Expression asJavaNullable() {
        if (!this.isNonJavaNullable()) {
            return this;
        }
        return new DelegatingExpression(this, this.features.minus(Feature.NON_JAVA_NULLABLE));
    }

    public Expression asNonSoyNullish() {
        if (this.isNonSoyNullish()) {
            return this;
        }
        return new DelegatingExpression(this, this.features.plus(Feature.NON_SOY_NULLISH));
    }

    public Expression asSoyNullish() {
        if (!this.isNonSoyNullish()) {
            return this;
        }
        this.checkAssignableTo(BytecodeUtils.SOY_VALUE_TYPE);
        return new DelegatingExpression(this, BytecodeUtils.SOY_VALUE_TYPE, this.features.minus(Feature.NON_SOY_NULLISH));
    }

    public Expression checkedCast(Type target) {
        Preconditions.checkArgument((target.getSort() == 10 ? 1 : 0) != 0, (String)"cast targets must be reference types. (%s)", (Object)target.getClassName());
        Preconditions.checkArgument((this.resultType().getSort() == 10 ? 1 : 0) != 0, (String)"you may only cast from reference types. (%s)", (Object)this.resultType().getClassName());
        if (BytecodeUtils.isDefinitelyAssignableFrom(target, this.resultType())) {
            return this;
        }
        return new Expression(target, this.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                adapter.checkCast(this.resultType());
            }
        };
    }

    public Expression checkedCast(Class<?> target) {
        return this.checkedCast(Type.getType(target));
    }

    public Expression invoke(MethodRef method, Expression ... args) {
        return method.invoke((Iterable<? extends Expression>)ImmutableList.builder().add((Object)this).add((Object[])args).build());
    }

    public Statement invokeVoid(MethodRef method, Expression ... args) {
        return method.invokeVoid((Iterable<? extends Expression>)ImmutableList.builder().add((Object)this).add((Object[])args).build());
    }

    public Expression labelStart(final Label label) {
        return new Expression(this.resultType(), this.features, SourceLocation.UNKNOWN, this.constantValue){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(label);
                Expression.this.gen(adapter);
            }
        };
    }

    public Expression labelEnd(final Label label) {
        return new Expression(this.resultType(), this.features, SourceLocation.UNKNOWN, this.constantValue){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                adapter.mark(label);
            }
        };
    }

    public boolean isConstant() {
        return this.constantValue.isPresent();
    }

    public ConstantValue constantValue() {
        return this.constantValue.get();
    }

    public Object constantBytecodeValue() {
        return this.constantValue.get().byteCodeValue;
    }

    public Expression withConstantValue(ConstantValue constantValue) {
        return new DelegatingExpression(this, constantValue);
    }

    public Expression checkedSoyCast(SoyType type) {
        type = SoyTypes.tryRemoveNullish(type);
        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, this.resultType)) {
            if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.NULLISH_DATA_TYPE, this.resultType)) {
                return this;
            }
            Class expectedClass = null;
            switch (type.getKind()) {
                case ANY: 
                case UNKNOWN: 
                case VE: 
                case VE_DATA: {
                    return this;
                }
                case UNION: {
                    if (type.equals(SoyTypes.NUMBER_TYPE)) {
                        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.NUMBER_DATA_TYPE, this.resultType)) {
                            return this;
                        }
                        return MethodRefs.CHECK_NUMBER.invoke(this);
                    }
                    return this;
                }
                case NULL: {
                    return this.checkedCast(BytecodeUtils.NULL_DATA_TYPE);
                }
                case UNDEFINED: {
                    return this.checkedCast(BytecodeUtils.UNDEFINED_DATA_TYPE);
                }
                case ATTRIBUTES: {
                    return MethodRefs.CHECK_CONTENT_KIND.invoke(this, BytecodeUtils.constant(SanitizedContent.ContentKind.ATTRIBUTES));
                }
                case CSS: {
                    return MethodRefs.CHECK_CONTENT_KIND.invoke(this, BytecodeUtils.constant(SanitizedContent.ContentKind.CSS));
                }
                case BOOL: {
                    if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.BOOLEAN_DATA_TYPE, this.resultType)) {
                        return this;
                    }
                    return MethodRefs.CHECK_BOOLEAN.invoke(this);
                }
                case FLOAT: {
                    if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.FLOAT_DATA_TYPE, this.resultType)) {
                        return this;
                    }
                    return MethodRefs.CHECK_FLOAT.invoke(this);
                }
                case HTML: 
                case ELEMENT: {
                    return MethodRefs.CHECK_CONTENT_KIND.invoke(this, BytecodeUtils.constant(SanitizedContent.ContentKind.HTML));
                }
                case INT: {
                    if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.INTEGER_DATA_TYPE, this.resultType)) {
                        return this;
                    }
                    return MethodRefs.CHECK_INT.invoke(this);
                }
                case JS: {
                    return MethodRefs.CHECK_CONTENT_KIND.invoke(this, BytecodeUtils.constant(SanitizedContent.ContentKind.JS));
                }
                case LIST: {
                    expectedClass = SoyList.class;
                    break;
                }
                case MAP: {
                    expectedClass = SoyMap.class;
                    break;
                }
                case LEGACY_OBJECT_MAP: {
                    expectedClass = SoyLegacyObjectMap.class;
                    break;
                }
                case MESSAGE: {
                    expectedClass = SoyProtoValue.class;
                    break;
                }
                case PROTO: {
                    Type protoType = TypeInfo.create(JavaQualifiedNames.getClassName(((SoyProtoType)type).getDescriptor()), false).type();
                    return MethodRefs.CHECK_PROTO.invoke(this, BytecodeUtils.constant(protoType));
                }
                case PROTO_ENUM: {
                    expectedClass = IntegerData.class;
                    break;
                }
                case RECORD: {
                    expectedClass = SoyRecord.class;
                    break;
                }
                case STRING: {
                    if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.STRING_DATA_TYPE, this.resultType)) {
                        return this;
                    }
                    return MethodRefs.CHECK_STRING.invoke(this);
                }
                case TEMPLATE: {
                    expectedClass = TemplateValue.class;
                    break;
                }
                case TRUSTED_RESOURCE_URI: {
                    return MethodRefs.CHECK_CONTENT_KIND.invoke(this, BytecodeUtils.constant(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI));
                }
                case URI: {
                    return MethodRefs.CHECK_CONTENT_KIND.invoke(this, BytecodeUtils.constant(SanitizedContent.ContentKind.URI));
                }
                case CSS_TYPE: 
                case CSS_MODULE: 
                case TOGGLE_TYPE: 
                case PROTO_TYPE: 
                case PROTO_ENUM_TYPE: 
                case PROTO_EXTENSION: 
                case PROTO_MODULE: 
                case TEMPLATE_TYPE: 
                case TEMPLATE_MODULE: 
                case FUNCTION: {
                    throw new UnsupportedOperationException();
                }
            }
            Type expectedType = Type.getType(expectedClass);
            if (BytecodeUtils.isDefinitelyAssignableFrom(expectedType, this.resultType)) {
                return this;
            }
            return MethodRefs.CHECK_TYPE.invoke(this, BytecodeUtils.constant(expectedType));
        }
        SoyRuntimeType unboxedType = SoyRuntimeType.getUnboxedType(type).orElse(null);
        if (unboxedType != null) {
            Type runtimeType = unboxedType.runtimeType();
            if (BytecodeUtils.isPrimitive(runtimeType)) {
                Preconditions.checkArgument((boolean)this.resultType.equals((Object)runtimeType), (String)"%s != %s", (Object)this.resultType, (Object)runtimeType);
            } else {
                return this.checkedCast(runtimeType);
            }
        }
        return this.checkedCast(BytecodeUtils.SOY_VALUE_TYPE);
    }

    @ForOverride
    protected void extraToStringProperties(MoreObjects.ToStringHelper helper) {
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (name.isEmpty()) {
            name = "Expression";
        }
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)name).omitNullValues();
        helper.add("type", (Object)this.resultType());
        this.extraToStringProperties(helper);
        helper.add("cheap", (Object)(this.features.has(Feature.CHEAP) ? "true" : null));
        helper.add("non-null", this.features.has(Feature.NON_JAVA_NULLABLE) && !BytecodeUtils.isPrimitive(this.resultType) ? "true" : null);
        helper.add("non-soynullish", this.isNonSoyNullish());
        return String.valueOf(helper) + ":\n" + this.trace();
    }

    private static final class DelegatingExpression
    extends Expression {
        private final Expression delegate;

        public DelegatingExpression(Expression delegate, Type resultType, Features features) {
            super(resultType, features, delegate.location, delegate.constantValue);
            this.delegate = delegate;
        }

        public DelegatingExpression(Expression delegate, Features features) {
            super(delegate.resultType, features, delegate.location, delegate.constantValue);
            this.delegate = delegate;
        }

        public DelegatingExpression(Expression delegate, SourceLocation location) {
            super(delegate.resultType, delegate.features, location, delegate.constantValue);
            this.delegate = delegate;
        }

        public DelegatingExpression(Expression delegate, ConstantValue value) {
            super(delegate.resultType, delegate.features, delegate.location, Optional.of(value));
            this.delegate = delegate;
        }

        @Override
        protected void doGen(CodeBuilder adapter) {
            this.delegate.gen(adapter);
        }
    }

    public static final class Features {
        private static final Features EMPTY = new Features(EnumSet.noneOf(Feature.class));
        private final EnumSet<Feature> set;

        public static Features of() {
            return EMPTY;
        }

        public static Features of(Feature first, Feature ... rest) {
            EnumSet<Feature> set = EnumSet.of(first);
            Collections.addAll(set, rest);
            return new Features(set);
        }

        private static Features forType(Type expressionType, Features features) {
            switch (expressionType.getSort()) {
                case 9: 
                case 10: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    features = features.plus(Feature.NON_JAVA_NULLABLE);
                    break;
                }
                case 0: 
                case 11: {
                    throw new IllegalArgumentException("Invalid type: " + String.valueOf(expressionType));
                }
                default: {
                    throw new AssertionError((Object)("unexpected type " + String.valueOf(expressionType)));
                }
            }
            if (features.has(Feature.NON_SOY_NULLISH) || !features.has(Feature.NON_JAVA_NULLABLE)) {
                return features;
            }
            if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.NULLISH_DATA_TYPE, expressionType) || expressionType.equals((Object)BytecodeUtils.SOY_VALUE_TYPE) || expressionType.equals((Object)BytecodeUtils.SOY_VALUE_PROVIDER_TYPE)) {
                return features;
            }
            boolean isGenerated = Names.isGenerated(expressionType);
            if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, expressionType) || !isGenerated) {
                features = features.plus(Feature.NON_SOY_NULLISH);
            }
            return features;
        }

        private Features(EnumSet<Feature> set) {
            this.set = (EnumSet)Preconditions.checkNotNull(set);
        }

        public boolean has(Feature feature) {
            return this.set.contains((Object)feature);
        }

        public Features plus(Feature feature) {
            if (this.set.contains((Object)feature)) {
                return this;
            }
            EnumSet<Feature> newSet = this.copyFeatures();
            newSet.add(feature);
            return new Features(newSet);
        }

        public Features minus(Feature feature) {
            if (!this.set.contains((Object)feature)) {
                return this;
            }
            EnumSet<Feature> newSet = this.copyFeatures();
            newSet.remove((Object)feature);
            return new Features(newSet);
        }

        public Features intersect(Features other) {
            EnumSet<Feature> newSet = EnumSet.noneOf(Feature.class);
            newSet.addAll(this.set);
            newSet.retainAll(other.set);
            return new Features(newSet);
        }

        private EnumSet<Feature> copyFeatures() {
            EnumSet<Feature> newSet = EnumSet.noneOf(Feature.class);
            newSet.addAll(this.set);
            return newSet;
        }
    }

    public static enum Feature {
        NON_JAVA_NULLABLE,
        NON_SOY_NULLISH,
        CHEAP;


        public Features asFeatures() {
            return Features.of(this, new Feature[0]);
        }
    }

    public static final class ConstantValue {
        private static final Object NULL_MARKER = new Object();
        private final Optional<Object> javaValue;
        private final Object byteCodeValue;
        private final Type type;
        private final boolean isTrivialConstant;

        private static void checkJavaValueType(Object javaValue, Type type) {
            switch (type.getSort()) {
                case 10: {
                    if (javaValue == null) break;
                    Expression.checkType(javaValue, String.class);
                    break;
                }
                case 1: {
                    Expression.checkType(javaValue, Boolean.class);
                    break;
                }
                case 5: {
                    Expression.checkType(javaValue, Integer.class);
                    break;
                }
                case 2: {
                    Expression.checkType(javaValue, Character.class);
                    break;
                }
                case 7: {
                    Expression.checkType(javaValue, Long.class);
                    break;
                }
                case 8: {
                    Expression.checkType(javaValue, Double.class);
                    break;
                }
                case 0: 
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    throw new IllegalArgumentException("Invalid constant type: " + String.valueOf(javaValue));
                }
                default: {
                    throw new AssertionError((Object)("unexpected constant type " + String.valueOf(javaValue)));
                }
            }
        }

        public static ConstantValue raw(Object javaValue, Type type) {
            ConstantValue.checkJavaValueType(javaValue, type);
            return new ConstantValue(Optional.of(javaValue), javaValue, type, true);
        }

        public static ConstantValue raw(@Nullable Object javaValue, ConstantDynamic byteCodeValue, Type type, boolean isTrivialConstant) {
            Preconditions.checkState((boolean)type.getDescriptor().equals(byteCodeValue.getDescriptor()));
            ConstantValue.checkJavaValueType(javaValue, type);
            return new ConstantValue(javaValue == null ? Optional.of(NULL_MARKER) : Optional.of(javaValue), byteCodeValue, type, isTrivialConstant);
        }

        public static ConstantValue dynamic(ConstantDynamic byteCodeValue, Type type, boolean isTrivialConstant) {
            Preconditions.checkState((boolean)type.getDescriptor().equals(byteCodeValue.getDescriptor()));
            return new ConstantValue(Optional.empty(), byteCodeValue, type, isTrivialConstant);
        }

        private ConstantValue(Optional<Object> javaValue, Object byteCodeValue, Type type, boolean isTrivialConstant) {
            this.javaValue = javaValue;
            this.byteCodeValue = Preconditions.checkNotNull((Object)byteCodeValue);
            this.type = type;
            this.isTrivialConstant = isTrivialConstant;
            Preconditions.checkArgument((!(byteCodeValue instanceof ConstantValue) ? 1 : 0) != 0);
        }

        public boolean isTrivialConstant() {
            return this.isTrivialConstant;
        }

        public boolean hasJavaValue() {
            return this.javaValue.isPresent();
        }

        @Nullable
        public Object getJavaValue() {
            Object rawValue = this.javaValue.get();
            return rawValue == NULL_MARKER ? null : rawValue;
        }

        public <T> Optional<T> getJavaValueAsType(Class<T> type) {
            return this.javaValue.map(value -> type.isInstance(value) ? type.cast(value) : null);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("javaValue", this.hasJavaValue() ? this.getJavaValue() : "N/A").add("byteCodeValue", this.byteCodeValue).toString();
        }
    }
}

