/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Message;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NullishData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.restricted.Branch;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.ExtraConstantBootstraps;
import com.google.template.soy.jbcsrc.shared.LargeStringConstantFactory;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import java.io.Closeable;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class BytecodeUtils {
    private static final int MAX_CONSTANT_STRING_LENGTH = 65535;
    public static final TypeInfo OBJECT = TypeInfo.create(Object.class);
    private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
    public static final Type LOGGING_ADVISING_APPENDABLE_TYPE = Type.getType(LoggingAdvisingAppendable.class);
    public static final Type LOGGING_ADVISING_BUILDER_TYPE = Type.getType(LoggingAdvisingAppendable.BufferingAppendable.class);
    public static final Type COMPILED_TEMPLATE_TYPE = Type.getType(CompiledTemplate.class);
    public static final Type TEMPLATE_VALUE_TYPE = Type.getType(TemplateValue.class);
    public static final Type CONTENT_KIND_TYPE = Type.getType(SanitizedContent.ContentKind.class);
    public static final Type CLOSEABLE_TYPE = Type.getType(Closeable.class);
    public static final Type DIR_TYPE = Type.getType(Dir.class);
    public static final Type HASH_MAP_TYPE = Type.getType(HashMap.class);
    public static final Type NULLISH_DATA_TYPE = Type.getType(NullishData.class);
    public static final Type NULL_DATA_TYPE = Type.getType(NullData.class);
    public static final Type UNDEFINED_DATA_TYPE = Type.getType(UndefinedData.class);
    public static final Type PRIMITIVE_DATA_TYPE = Type.getType(PrimitiveData.class);
    public static final Type NUMBER_DATA_TYPE = Type.getType(NumberData.class);
    public static final Type INTEGER_DATA_TYPE = Type.getType(IntegerData.class);
    public static final Type FLOAT_DATA_TYPE = Type.getType(FloatData.class);
    public static final Type BOOLEAN_DATA_TYPE = Type.getType(BooleanData.class);
    public static final Type STRING_DATA_TYPE = Type.getType(StringData.class);
    public static final Type SANITIZED_CONTENT_TYPE = Type.getType(SanitizedContent.class);
    public static final Type SOY_LIST_TYPE = Type.getType(SoyList.class);
    public static final Type SOY_LEGACY_OBJECT_MAP_TYPE = Type.getType(SoyLegacyObjectMap.class);
    public static final Type SOY_MAP_TYPE = Type.getType(SoyMap.class);
    public static final Type SOY_MAP_IMPL_TYPE = Type.getType(SoyMapImpl.class);
    public static final Type SOY_PROTO_VALUE_TYPE = Type.getType(SoyProtoValue.class);
    public static final Type SOY_RECORD_TYPE = Type.getType(SoyRecord.class);
    public static final Type SOY_RECORD_IMPL_TYPE = Type.getType(SoyRecordImpl.class);
    public static final Type SOY_VALUE_TYPE = Type.getType(SoyValue.class);
    public static final Type SOY_VALUE_PROVIDER_TYPE = Type.getType(SoyValueProvider.class);
    public static final Type LINKED_HASH_MAP_TYPE = Type.getType(LinkedHashMap.class);
    public static final Type IDENTITY_HASH_MAP_TYPE = Type.getType(IdentityHashMap.class);
    public static final Type COLLECTION_TYPE = Type.getType(Collection.class);
    public static final Type ITERABLE_TYPE = Type.getType(Iterable.class);
    public static final Type LIST_TYPE = Type.getType(List.class);
    public static final Type IMMUTABLE_LIST_TYPE = Type.getType(ImmutableList.class);
    public static final Type IMMUTABLE_MAP_TYPE = Type.getType(ImmutableMap.class);
    public static final Type MAP_TYPE = Type.getType(Map.class);
    public static final Type MAP_ENTRY_TYPE = Type.getType(Map.Entry.class);
    public static final Type MESSAGE_TYPE = Type.getType(Message.class);
    public static final Type NULL_POINTER_EXCEPTION_TYPE = Type.getType(NullPointerException.class);
    public static final Type RENDER_CONTEXT_TYPE = Type.getType(RenderContext.class);
    public static final Type RENDER_RESULT_TYPE = Type.getType(RenderResult.class);
    public static final Type PARAM_STORE_TYPE = Type.getType(ParamStore.class);
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    public static final Type ILLEGAL_STATE_EXCEPTION_TYPE = Type.getType(IllegalStateException.class);
    public static final Type SOY_VISUAL_ELEMENT_TYPE = Type.getType(SoyVisualElement.class);
    public static final Type SOY_VISUAL_ELEMENT_DATA_TYPE = Type.getType(SoyVisualElementData.class);
    public static final Type CLASS_TYPE = Type.getType(Class.class);
    public static final Type BOXED_INTEGER_TYPE = Type.getType(Integer.class);
    public static final Type BOXED_LONG_TYPE = Type.getType(Long.class);
    public static final Type BOXED_BOOLEAN_TYPE = Type.getType(Boolean.class);
    public static final Type BOXED_DOUBLE_TYPE = Type.getType(Double.class);
    public static final Type BOXED_CHARACTER_TYPE = Type.getType(Character.class);
    public static final Type BOXED_FLOAT_TYPE = Type.getType(Float.class);
    public static final Type NUMBER_TYPE = Type.getType(Number.class);
    public static final Type LOGGABLE_ELEMENT_METADATA_TYPE = Type.getType(LoggableElementMetadata.class);
    public static final Type STACK_FRAME_TYPE = Type.getType(StackFrame.class);
    public static final Type SAFE_URL_TYPE = Type.getType(SafeUrl.class);
    public static final Type SAFE_URL_PROTO_TYPE = Type.getType(SafeUrlProto.class);
    public static final Type TRUSTED_RESOURCE_PROTO_TYPE = Type.getType(TrustedResourceUrlProto.class);
    public static final Type SAFE_HTML_PROTO_TYPE = Type.getType(SafeHtmlProto.class);
    public static final Type SAFE_HTML_TYPE = Type.getType(SafeHtml.class);
    public static final Type TRUSTED_RESOURCE_URL_TYPE = Type.getType(TrustedResourceUrl.class);
    public static final Type RECORD_SYMBOL_TYPE = Type.getType(RecordProperty.class);
    public static final Method CLASS_INIT = Method.getMethod((String)"void <clinit>()");
    public static final Method NULLARY_INIT = Method.getMethod((String)"void <init>()");
    private static final Handle LARGE_STRING_CONSTANT_HANDLE = MethodRef.createPure(LargeStringConstantFactory.class, "bootstrapLargeStringConstant", MethodHandles.Lookup.class, String.class, Class.class, String[].class).asHandle();
    private static final Handle NULL_CONSTANT_HANDLE = MethodRef.createPure(ConstantBootstraps.class, "nullConstant", MethodHandles.Lookup.class, String.class, Class.class).asHandle();
    private static final Handle CHAR_CONSTANT_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "constantBoolean", MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE).asHandle();
    private static final Handle BOOLEAN_CONSTANT_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "constantBoolean", MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE).asHandle();
    public static final Expression.ConstantValue CONSTANT_FALSE = Expression.ConstantValue.raw(false, new ConstantDynamic("false", Type.BOOLEAN_TYPE.getDescriptor(), BOOLEAN_CONSTANT_HANDLE, new Object[]{0}), Type.BOOLEAN_TYPE, true);
    public static final Expression.ConstantValue CONSTANT_TRUE = Expression.ConstantValue.raw(true, new ConstantDynamic("true", Type.BOOLEAN_TYPE.getDescriptor(), BOOLEAN_CONSTANT_HANDLE, new Object[]{1}), Type.BOOLEAN_TYPE, true);
    private static final Handle RECORD_SYMBOL_CONSTANT_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "symbol", MethodHandles.Lookup.class, String.class, Class.class).asHandle();
    private static final Handle CONSTANT_PARAM_STORE = MethodRef.createPure(ExtraConstantBootstraps.class, "constantParamStore", MethodHandles.Lookup.class, String.class, Class.class, Object[].class).asHandle();
    private static final Handle CONSTANT_RECORD_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "constantSoyRecord", MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE, Object[].class).asHandle();
    private static final LoadingCache<Type, Optional<Class<?>>> objectTypeToClassCache = CacheBuilder.newBuilder().build(new CacheLoader<Type, Optional<Class<?>>>(){

        public Optional<Class<?>> load(Type key) {
            switch (key.getSort()) {
                case 9: {
                    Optional elementType = (Optional)objectTypeToClassCache.getUnchecked((Object)key.getElementType());
                    if (elementType.isPresent()) {
                        return Optional.of(Array.newInstance((Class)elementType.get(), 0).getClass());
                    }
                    return Optional.empty();
                }
                case 0: {
                    return Optional.of(Void.TYPE);
                }
                case 1: {
                    return Optional.of(Boolean.TYPE);
                }
                case 3: {
                    return Optional.of(Byte.TYPE);
                }
                case 2: {
                    return Optional.of(Character.TYPE);
                }
                case 8: {
                    return Optional.of(Double.TYPE);
                }
                case 5: {
                    return Optional.of(Integer.TYPE);
                }
                case 4: {
                    return Optional.of(Short.TYPE);
                }
                case 7: {
                    return Optional.of(Long.TYPE);
                }
                case 6: {
                    return Optional.of(Float.TYPE);
                }
                case 10: {
                    try {
                        if (Names.isGenerated(key)) {
                            return Optional.empty();
                        }
                        return Optional.of(Class.forName(key.getClassName(), false, BytecodeUtils.class.getClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        return Optional.empty();
                    }
                }
            }
            throw new IllegalArgumentException("unsupported type: " + String.valueOf(key));
        }
    });
    private static final ImmutableList<Type> SUPERTYPES_TO_CHECK = ImmutableList.of((Object)NULLISH_DATA_TYPE, (Object)PRIMITIVE_DATA_TYPE, (Object)SOY_VALUE_TYPE);
    private static final Expression SOY_NULL = FieldRef.NULL_DATA.accessor();
    private static final Expression SOY_UNDEFINED = FieldRef.UNDEFINED_DATA.accessor();

    private BytecodeUtils() {
    }

    public static Type getCommonSuperType(Type left, Type right) {
        if (left.equals((Object)right)) {
            return left;
        }
        for (Type type : SUPERTYPES_TO_CHECK) {
            if (!BytecodeUtils.isDefinitelyAssignableFrom(type, left) || !BytecodeUtils.isDefinitelyAssignableFrom(type, right)) continue;
            return type;
        }
        if ((BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_PROVIDER_TYPE, left) || Names.isGeneratedSoyValueProvider(left)) && (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_PROVIDER_TYPE, right) || Names.isGeneratedSoyValueProvider(right))) {
            return SOY_VALUE_PROVIDER_TYPE;
        }
        throw new IllegalArgumentException(String.format("%s != %s", left, right));
    }

    public static boolean isPossiblyAssignableFrom(Type left, Type right) {
        return BytecodeUtils.doIsAssignableFrom(left, right, true);
    }

    public static boolean isDefinitelyAssignableFrom(Type left, Type right) {
        return BytecodeUtils.doIsAssignableFrom(left, right, false);
    }

    private static boolean doIsAssignableFrom(Type left, Type right, boolean failOpen) {
        if (left.equals((Object)right)) {
            return true;
        }
        if (left.getSort() != right.getSort()) {
            return false;
        }
        if (left.getSort() != 10) {
            return false;
        }
        Optional leftClass = (Optional)objectTypeToClassCache.getUnchecked((Object)left);
        Optional rightClass = (Optional)objectTypeToClassCache.getUnchecked((Object)right);
        if (!leftClass.isPresent() || !rightClass.isPresent()) {
            return failOpen;
        }
        return ((Class)leftClass.get()).isAssignableFrom((Class)rightClass.get());
    }

    public static Class<?> classFromAsmType(Type type) {
        return (Class)((Optional)objectTypeToClassCache.getUnchecked((Object)type)).orElseThrow(() -> new IllegalArgumentException("Could not load: " + String.valueOf(type)));
    }

    public static Expression constant(ConstantDynamic value, Expression.Features features) {
        return BytecodeUtils.constant(Type.getType((String)value.getDescriptor()), value, features);
    }

    public static Expression constant(Type type, final ConstantDynamic value, Expression.Features features) {
        Preconditions.checkArgument((!value.getName().equals("<init>") ? 1 : 0) != 0);
        return new Expression(type, Expression.ConstantValue.dynamic(value, type, true), features.plus(Expression.Feature.CHEAP)){

            @Override
            protected void doGen(CodeBuilder cb) {
                cb.visitLdcInsn(value);
            }
        };
    }

    public static Expression constant(boolean value) {
        return (value ? Branch.always() : Branch.never()).asBoolean();
    }

    public static Expression constant(final int value) {
        return new Expression(Type.INT_TYPE, Expression.ConstantValue.raw(value, Type.INT_TYPE), Expression.Feature.CHEAP.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushInt(value);
            }
        };
    }

    public static Expression constant(final char value) {
        return new Expression(Type.CHAR_TYPE, Expression.ConstantValue.raw(Character.valueOf(value), new ConstantDynamic("char", Type.CHAR_TYPE.getDescriptor(), CHAR_CONSTANT_HANDLE, new Object[]{(int)value}), Type.CHAR_TYPE, true), Expression.Feature.CHEAP.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushInt(value);
            }
        };
    }

    public static Expression constant(final long value) {
        return new Expression(Type.LONG_TYPE, Expression.ConstantValue.raw(value, Type.LONG_TYPE), Expression.Feature.CHEAP.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushLong(value);
            }
        };
    }

    public static Expression constant(final double value) {
        return new Expression(Type.DOUBLE_TYPE, Expression.ConstantValue.raw(value, Type.DOUBLE_TYPE), Expression.Feature.CHEAP.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushDouble(value);
            }
        };
    }

    public static Expression constant(final float value) {
        return new Expression(Type.FLOAT_TYPE, Expression.Feature.CHEAP.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushFloat(value);
            }
        };
    }

    public static Expression constant(String value) {
        int previousStart = 0;
        ArrayList<String> stringConstants = new ArrayList<String>();
        int byteCount = 0;
        for (int index = 0; index < value.length(); ++index) {
            char c = value.charAt(index);
            int charBytes = c >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2);
            if (byteCount + charBytes > 65535) {
                stringConstants.add(value.substring(previousStart, index));
                byteCount = 0;
                previousStart = index;
            }
            byteCount += charBytes;
        }
        stringConstants.add(value.substring(previousStart));
        if (stringConstants.size() == 1) {
            final String basicString = (String)stringConstants.get(0);
            return new Expression(STRING_TYPE, Expression.ConstantValue.raw(basicString, STRING_TYPE), Expression.Features.of(Expression.Feature.CHEAP, Expression.Feature.NON_JAVA_NULLABLE)){

                @Override
                protected void doGen(CodeBuilder mv) {
                    mv.visitLdcInsn(basicString);
                }
            };
        }
        return BytecodeUtils.constant(STRING_TYPE, new ConstantDynamic("largeString", STRING_TYPE.getDescriptor(), LARGE_STRING_CONSTANT_HANDLE, stringConstants.toArray()), Expression.Feature.NON_JAVA_NULLABLE.asFeatures());
    }

    public static Expression constant(SanitizedContent.ContentKind kind) {
        return FieldRef.enumReference(kind).accessor();
    }

    public static Expression constant(@Nullable Dir dir) {
        return dir == null ? BytecodeUtils.constantNull(DIR_TYPE) : FieldRef.enumReference(dir).accessor();
    }

    public static Expression constant(final Type type) {
        return new Expression(CLASS_TYPE, Expression.Features.of(Expression.Feature.CHEAP, Expression.Feature.NON_JAVA_NULLABLE)){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushType(type);
            }
        };
    }

    public static Expression constantRecordProperty(String value) {
        return BytecodeUtils.constant(new ConstantDynamic(value, RECORD_SYMBOL_TYPE.getDescriptor(), RECORD_SYMBOL_CONSTANT_HANDLE, new Object[0]), Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, Expression.Feature.CHEAP));
    }

    public static Expression constantSanitizedContentKindAsContentKind(SanitizedContentKind kind) {
        return FieldRef.enumReference(Converters.toContentKind(kind)).accessor();
    }

    public static Optional<Expression> getSoleValue(Type type) {
        if (type.equals((Object)NULL_DATA_TYPE)) {
            return Optional.of(BytecodeUtils.soyNull());
        }
        if (type.equals((Object)UNDEFINED_DATA_TYPE)) {
            return Optional.of(BytecodeUtils.soyUndefined());
        }
        return Optional.empty();
    }

    public static Expression soyNull() {
        return SOY_NULL;
    }

    public static Expression soyUndefined() {
        return SOY_UNDEFINED;
    }

    public static Expression constantNull(Type type) {
        Preconditions.checkArgument((type.getSort() == 10 || type.getSort() == 9 ? 1 : 0) != 0, (String)"%s is not a reference type", (Object)type);
        return new Expression(type, Expression.ConstantValue.raw(null, new ConstantDynamic("null", type.getDescriptor(), NULL_CONSTANT_HANDLE, new Object[0]), type, true), Expression.Feature.CHEAP.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushNull();
            }
        };
    }

    public static Expression numericConversion(final Expression expr, final Type to) {
        if (to.equals((Object)expr.resultType())) {
            return expr;
        }
        if (!BytecodeUtils.isNumericPrimitive(to) || !BytecodeUtils.isNumericPrimitive(expr.resultType())) {
            throw new IllegalArgumentException("Cannot convert from " + String.valueOf(expr.resultType()) + " to " + String.valueOf(to));
        }
        if (expr.isConstant() && expr.constantValue().hasJavaValue() && expr.constantValue().getJavaValue() instanceof Number) {
            Number value = (Number)expr.constantValue().getJavaValue();
            switch (to.getSort()) {
                case 8: {
                    return BytecodeUtils.constant(value.doubleValue());
                }
                case 5: {
                    return BytecodeUtils.constant(value.intValue());
                }
                case 7: {
                    return BytecodeUtils.constant(value.longValue());
                }
                case 6: {
                    return BytecodeUtils.constant(value.floatValue());
                }
                case 2: 
                case 3: 
                case 4: {
                    throw new UnsupportedOperationException("unimplemented");
                }
            }
            throw new AssertionError((Object)("unexpected type " + String.valueOf(to)));
        }
        return new Expression(to, expr.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                adapter.cast(expr.resultType(), to);
            }
        };
    }

    private static boolean isNumericPrimitive(Type type) {
        int sort = type.getSort();
        switch (sort) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        throw new AssertionError((Object)("unexpected type " + String.valueOf(type)));
    }

    public static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 0: 
            case 11: {
                throw new IllegalArgumentException("Invalid type: " + String.valueOf(type));
            }
        }
        throw new AssertionError((Object)("unexpected type " + String.valueOf(type)));
    }

    public static void defineDefaultConstructor(ClassVisitor cv, TypeInfo ownerType) {
        CodeBuilder mg = new CodeBuilder(1, NULLARY_INIT, null, cv);
        mg.visitCode();
        Label start = mg.mark();
        Label end = mg.newLabel();
        LocalVariable thisVar = LocalVariable.createThisVar(ownerType, start, end);
        thisVar.gen(mg);
        mg.invokeConstructor(OBJECT.type(), NULLARY_INIT);
        mg.returnValue();
        mg.mark(end);
        thisVar.tableEntry(mg);
        mg.endMethod();
    }

    public static Expression compareSoyEquals(SoyExpression left, SoyExpression right) {
        SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
        SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
        if (leftRuntimeType.isKnownString() || rightRuntimeType.isKnownString()) {
            return BytecodeUtils.doEqualsString(left, right);
        }
        Expression numberComparison = BytecodeUtils.maybeFastCompareNumbers(left, right);
        if (numberComparison != null) {
            return numberComparison;
        }
        return MethodRefs.RUNTIME_EQUAL.invoke(left.box(), right.box());
    }

    public static Expression compareSoyTripleEquals(SoyExpression left, SoyExpression right) {
        Expression numberComparison = BytecodeUtils.maybeFastCompareNumbers(left, right);
        if (numberComparison != null) {
            return numberComparison;
        }
        return MethodRefs.RUNTIME_TRIPLE_EQUAL.invoke(left.box(), right.box());
    }

    public static Expression compareSoySwitchCaseEquals(SoyExpression left, SoyExpression right) {
        Expression numberComparison = BytecodeUtils.maybeFastCompareNumbers(left, right);
        if (numberComparison != null) {
            return numberComparison;
        }
        return MethodRefs.RUNTIME_SWITCH_CASE_EQUAL.invoke(left.box(), right.box());
    }

    @Nullable
    private static Expression maybeFastCompareNumbers(SoyExpression left, SoyExpression right) {
        SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
        SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
        if (leftRuntimeType.isKnownInt() && rightRuntimeType.isKnownInt() && left.isNonSoyNullish() && right.isNonSoyNullish()) {
            return Branch.ifEqual(left.unboxAsLong(), right.unboxAsLong()).asBoolean();
        }
        if (leftRuntimeType.isKnownNumber() && rightRuntimeType.isKnownNumber() && left.isNonSoyNullish() && right.isNonSoyNullish() && (leftRuntimeType.isKnownFloat() || rightRuntimeType.isKnownFloat())) {
            return Branch.ifEqual(left.coerceToDouble(), right.coerceToDouble()).asBoolean();
        }
        return null;
    }

    private static Expression doEqualsString(SoyExpression left, SoyExpression right) {
        if (left.resultType().equals((Object)STRING_TYPE)) {
            if (right.resultType().equals((Object)STRING_TYPE)) {
                return BytecodeUtils.doJavaEquals(left, right);
            }
            return BytecodeUtils.doUnboxedStringEquals(left, right);
        }
        if (right.resultType().equals((Object)STRING_TYPE)) {
            return BytecodeUtils.doBoxedValueEqualsUnboxedString(left, right);
        }
        if (left.soyRuntimeType().isKnownString()) {
            return BytecodeUtils.doBoxedStringEquals(left, right);
        }
        return BytecodeUtils.doValueEqualsBoxedString(left, right);
    }

    private static Expression doUnboxedStringEquals(SoyExpression unboxedString, SoyExpression other) {
        if (other.soyRuntimeType().isKnownNumber() && other.isNonSoyNullish()) {
            return MethodRefs.RUNTIME_STRING_EQUALS_AS_NUMBER.invoke(unboxedString, other.coerceToDouble());
        }
        if (!other.isBoxed()) {
            return BytecodeUtils.constant(false);
        }
        return MethodRefs.RUNTIME_COMPARE_UNBOXED_STRING.invoke(unboxedString, other);
    }

    private static Expression doBoxedValueEqualsUnboxedString(SoyExpression other, SoyExpression unboxedString) {
        if (other.soyRuntimeType().isKnownNumber() && other.isNonSoyNullish()) {
            return MethodRefs.RUNTIME_NUMBER_EQUALS_STRING_AS_NUMBER.invoke(other.coerceToDouble(), unboxedString);
        }
        if (!other.isBoxed()) {
            return BytecodeUtils.constant(false);
        }
        return MethodRefs.RUNTIME_COMPARE_BOXED_VALUE_TO_UNBOXED_STRING.invoke(other, unboxedString);
    }

    private static Expression doBoxedStringEquals(SoyExpression boxedString, SoyExpression other) {
        if (other.soyRuntimeType().isKnownNumber()) {
            other = other.box();
        } else if (!other.isBoxed()) {
            return BytecodeUtils.constant(false);
        }
        return MethodRefs.RUNTIME_COMPARE_BOXED_STRING.invoke(boxedString, other);
    }

    private static Expression doValueEqualsBoxedString(SoyExpression other, SoyExpression boxedString) {
        if (other.soyRuntimeType().isKnownNumber()) {
            other = other.box();
        } else if (!other.isBoxed()) {
            return BytecodeUtils.constant(false);
        }
        return MethodRefs.RUNTIME_COMPARE_BOXED_VALUE_TO_BOXED_STRING.invoke(other, boxedString);
    }

    private static Expression doJavaEquals(SoyExpression left, SoyExpression right) {
        return MethodRefs.OBJECTS_EQUALS.invoke(left, right);
    }

    public static Expression firstSoyNonNullish(final Expression left, final Expression right) {
        Preconditions.checkArgument((left.resultType().getSort() == 10 ? 1 : 0) != 0, (String)"Expected left to be an object, got: %s", (Object)left.resultType());
        Preconditions.checkArgument((right.resultType().getSort() == 10 ? 1 : 0) != 0, (String)"Expected right to be an object, got: %s", (Object)right.resultType());
        Expression.Features features = Expression.Features.of();
        if (Expression.areAllCheap(left, right)) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (right.isNonSoyNullish()) {
            features = features.plus(Expression.Feature.NON_SOY_NULLISH);
        }
        return new Expression(BytecodeUtils.getCommonSuperType(left.resultType(), right.resultType()), features){

            @Override
            protected void doGen(CodeBuilder cb) {
                Label leftIsNonNull = new Label();
                left.gen(cb);
                cb.dup();
                BytecodeUtils.ifNonNullish(cb, left.resultType(), leftIsNonNull);
                cb.pop();
                right.gen(cb);
                cb.mark(leftIsNonNull);
            }
        };
    }

    public static Expression asImmutableList(Iterable<? extends Expression> items) {
        ImmutableList copy = ImmutableList.copyOf(items);
        if (copy.size() < MethodRefs.IMMUTABLE_LIST_OF.size()) {
            return ((MethodRef)MethodRefs.IMMUTABLE_LIST_OF.get(copy.size())).invoke((Iterable<? extends Expression>)copy);
        }
        ImmutableList explicit = copy.subList(0, MethodRefs.IMMUTABLE_LIST_OF.size());
        Expression remainder = BytecodeUtils.asArray(OBJECT_ARRAY_TYPE, (ImmutableList<? extends Expression>)copy.subList(MethodRefs.IMMUTABLE_LIST_OF.size(), copy.size()));
        return MethodRefs.IMMUTABLE_LIST_OF_ARRAY.invoke(Iterables.concat((Iterable)explicit, (Iterable)ImmutableList.of((Object)remainder)));
    }

    public static SoyExpression newRecordImplFromParamStore(SoyType soyType, SourceLocation location, Expression paramStore) {
        SoyExpression recordExp = SoyExpression.forSoyValue(soyType, MethodRefs.SOY_RECORD_IMPL.invoke(paramStore));
        if (paramStore.isConstant()) {
            ConstantDynamic paramCondy = (ConstantDynamic)paramStore.constantBytecodeValue();
            Preconditions.checkState((paramCondy.getBootstrapMethod() == CONSTANT_PARAM_STORE ? 1 : 0) != 0);
            Object[] args = new Object[1 + paramCondy.getBootstrapMethodArgumentCount()];
            args[0] = location.hashCode();
            for (int i = 0; i < paramCondy.getBootstrapMethodArgumentCount(); ++i) {
                args[i + 1] = paramCondy.getBootstrapMethodArgument(i);
            }
            recordExp = recordExp.withConstantValue(Expression.ConstantValue.dynamic(new ConstantDynamic("soyRecord", SOY_RECORD_IMPL_TYPE.getDescriptor(), CONSTANT_RECORD_HANDLE, args), SOY_RECORD_IMPL_TYPE, false));
        }
        return recordExp;
    }

    public static Expression newParamStore(Optional<Expression> baseStore, Map<String, Expression> params) {
        baseStore.ifPresent(e -> e.checkAssignableTo(PARAM_STORE_TYPE));
        if (params.isEmpty()) {
            return baseStore.orElse(FieldRef.EMPTY_PARAMS.accessor());
        }
        if (Expression.areAllConstant(params.values()) && baseStore.map(Expression::isConstant).orElse(true).booleanValue()) {
            Object[] constantArgs = new Object[params.size() * 2 + (baseStore.isPresent() ? 1 : 0)];
            int i = 0;
            if (baseStore.isPresent()) {
                constantArgs[i++] = baseStore.get().constantBytecodeValue();
            }
            for (Map.Entry<String, Expression> entry : params.entrySet()) {
                constantArgs[i++] = entry.getKey();
                constantArgs[i++] = entry.getValue().constantBytecodeValue();
            }
            return BytecodeUtils.constant(PARAM_STORE_TYPE, new ConstantDynamic("constantParamStore", PARAM_STORE_TYPE.getDescriptor(), CONSTANT_PARAM_STORE, constantArgs), Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, Expression.Feature.NON_SOY_NULLISH));
        }
        Expression paramStore = baseStore.isPresent() ? MethodRefs.PARAM_STORE_AUGMENT.invoke(baseStore.get(), BytecodeUtils.constant(params.size())) : MethodRefs.PARAM_STORE_SIZE.invoke(BytecodeUtils.constant(params.size()));
        for (Map.Entry<String, Expression> entry : params.entrySet()) {
            Expression value = entry.getValue();
            if (value instanceof SoyExpression) {
                value = ((SoyExpression)value).box();
            }
            Expression key = BytecodeUtils.constantRecordProperty(entry.getKey());
            paramStore = paramStore.invoke(MethodRefs.PARAM_STORE_SET_FIELD, key, value);
        }
        return paramStore;
    }

    public static Expression newImmutableMap(List<Expression> keys, List<Expression> values, boolean allowDuplicates) {
        if (!(keys.size() >= MethodRefs.IMMUTABLE_MAP_OF.size() || keys.size() > 1 && allowDuplicates)) {
            ArrayList<Expression> kvps = new ArrayList<Expression>();
            for (int i = 0; i < keys.size(); ++i) {
                kvps.add(keys.get(i));
                kvps.add(values.get(i));
            }
            return ((MethodRef)MethodRefs.IMMUTABLE_MAP_OF.get(keys.size())).invoke(kvps);
        }
        Expression builder = MethodRefs.IMMUTABLE_MAP_BUILDER_WITH_EXPECTED_SIZE.invoke(BytecodeUtils.constant(keys.size()));
        for (int i = 0; i < keys.size(); ++i) {
            builder = builder.invoke(MethodRefs.IMMUTABLE_MAP_BUILDER_PUT, keys.get(i), values.get(i));
        }
        return builder.invoke(allowDuplicates ? MethodRefs.IMMUTABLE_MAP_BUILDER_BUILD_KEEPING_LAST : MethodRefs.IMMUTABLE_MAP_BUILDER_BUILD_OR_THROW, new Expression[0]);
    }

    private static Expression asArray(Type arrayType, final ImmutableList<? extends Expression> elements) {
        final Type elementType = arrayType.getElementType();
        return new Expression(arrayType, Expression.Feature.NON_JAVA_NULLABLE.asFeatures()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.pushInt(elements.size());
                adapter.newArray(elementType);
                for (int i = 0; i < elements.size(); ++i) {
                    adapter.dup();
                    adapter.pushInt(i);
                    ((Expression)elements.get(i)).gen(adapter);
                    adapter.arrayStore(elementType);
                }
            }
        };
    }

    public static Expression asList(Iterable<? extends Expression> items) {
        final ImmutableList copy = ImmutableList.copyOf(items);
        if (copy.isEmpty()) {
            return ((MethodRef)MethodRefs.IMMUTABLE_LIST_OF.get(0)).invoke(new Expression[0]);
        }
        final Expression construct = MethodRefs.ARRAY_LIST_SIZE.invoke(BytecodeUtils.constant(copy.size()));
        return new Expression(LIST_TYPE, Expression.Feature.NON_JAVA_NULLABLE.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                construct.gen(mv);
                for (Expression child : copy) {
                    mv.dup();
                    child.gen(mv);
                    MethodRefs.ARRAY_LIST_ADD.invokeUnchecked(mv);
                    mv.pop();
                }
            }
        };
    }

    public static void coalesceSoyNullishToSoyNull(CodeBuilder builder, Type argType, Label nullExit) {
        if (argType.equals((Object)SOY_VALUE_TYPE)) {
            MethodRefs.SOY_VALUE_NULLISH_TO_NULL.invokeUnchecked(builder);
            builder.dup();
            MethodRefs.SOY_VALUE_IS_NULLISH.invokeUnchecked(builder);
            builder.ifZCmp(154, nullExit);
        } else {
            BytecodeUtils.nullCoalesce(builder, nullExit, argType, cb -> BytecodeUtils.soyNull().gen((CodeBuilder)((Object)cb)), true);
        }
    }

    public static void coalesceSoyNullishToSoyUndefined(CodeBuilder builder, Type argType, Label nullExit) {
        if (argType.equals((Object)SOY_VALUE_TYPE)) {
            MethodRefs.SOY_VALUE_NULLISH_TO_UNDEFINED.invokeUnchecked(builder);
            builder.dup();
            MethodRefs.SOY_VALUE_IS_NULLISH.invokeUnchecked(builder);
            builder.ifZCmp(154, nullExit);
        } else {
            BytecodeUtils.nullCoalesce(builder, nullExit, argType, cb -> BytecodeUtils.soyUndefined().gen((CodeBuilder)((Object)cb)), true);
        }
    }

    public static void coalesceSoyNullishToJavaNull(CodeBuilder builder, Type argType, Label nullExit) {
        BytecodeUtils.nullCoalesce(builder, nullExit, argType, CodeBuilder::pushNull, true);
    }

    public static void coalesceSoyNullToJavaNull(CodeBuilder builder, Type argType, Label nullExit) {
        BytecodeUtils.nullCoalesce(builder, nullExit, argType, CodeBuilder::pushNull, false);
    }

    private static void nullCoalesce(CodeBuilder builder, Label nullExit, Type argType, Consumer<CodeBuilder> pusher, boolean ish) {
        Label nonNull = new Label();
        builder.dup();
        if (ish) {
            BytecodeUtils.ifNonNullish(builder, argType, nonNull);
        } else {
            BytecodeUtils.ifNonSoyNull(builder, argType, nonNull);
        }
        builder.pop();
        pusher.accept(builder);
        builder.goTo(nullExit);
        builder.mark(nonNull);
    }

    public static void ifNonSoyNull(CodeBuilder cb, Type argType, Label ifNonNull) {
        if (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_TYPE, argType)) {
            MethodRefs.SOY_VALUE_IS_NULL.invokeUnchecked(cb);
            cb.ifZCmp(153, ifNonNull);
        } else if (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_PROVIDER_TYPE, argType)) {
            MethodRefs.IS_SOY_NON_NULL.invokeUnchecked(cb);
            cb.ifZCmp(154, ifNonNull);
        } else {
            cb.ifNonNull(ifNonNull);
        }
    }

    public static void ifNonNullish(CodeBuilder cb, Type argType, Label ifNonNullish) {
        if (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_TYPE, argType)) {
            MethodRefs.SOY_VALUE_IS_NULLISH.invokeUnchecked(cb);
            cb.ifZCmp(153, ifNonNullish);
        } else if (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_PROVIDER_TYPE, argType)) {
            MethodRefs.IS_SOY_NON_NULLISH.invokeUnchecked(cb);
            cb.ifZCmp(154, ifNonNullish);
        } else {
            cb.ifNonNull(ifNonNullish);
        }
    }

    public static void ifNullish(CodeBuilder cb, Type argType, Label ifNullish) {
        if (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_TYPE, argType)) {
            MethodRefs.SOY_VALUE_IS_NULLISH.invokeUnchecked(cb);
            cb.ifZCmp(154, ifNullish);
        } else if (BytecodeUtils.isDefinitelyAssignableFrom(SOY_VALUE_PROVIDER_TYPE, argType)) {
            MethodRefs.IS_SOY_NON_NULLISH.invokeUnchecked(cb);
            cb.ifZCmp(153, ifNullish);
        } else {
            cb.ifNull(ifNullish);
        }
    }

    public static Type unboxUnchecked(CodeBuilder cb, SoyRuntimeType soyType, Class<?> asType) {
        Preconditions.checkArgument((boolean)soyType.isBoxed(), (String)"Expected %s to be a boxed type", (Object)soyType);
        Type fromType = soyType.runtimeType();
        Preconditions.checkArgument((!SoyValue.class.isAssignableFrom(asType) ? 1 : 0) != 0, (String)"Can't use unboxUnchecked() to convert from %s to a SoyValue: %s.", (Object)fromType, asType);
        if (BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), fromType)) {
            return fromType;
        }
        if (asType.equals(Boolean.TYPE)) {
            MethodRefs.SOY_VALUE_BOOLEAN_VALUE.invokeUnchecked(cb);
            return Type.BOOLEAN_TYPE;
        }
        if (asType.equals(Long.TYPE)) {
            MethodRefs.SOY_VALUE_LONG_VALUE.invokeUnchecked(cb);
            return Type.LONG_TYPE;
        }
        if (asType.equals(Double.TYPE)) {
            MethodRefs.SOY_VALUE_FLOAT_VALUE.invokeUnchecked(cb);
            return Type.DOUBLE_TYPE;
        }
        if (asType.equals(String.class)) {
            MethodRefs.SOY_VALUE_STRING_VALUE.invokeUnchecked(cb);
            return STRING_TYPE;
        }
        if (asType.equals(List.class)) {
            cb.checkCast(SOY_LIST_TYPE);
            MethodRefs.SOY_VALUE_AS_JAVA_LIST.invokeUnchecked(cb);
            return LIST_TYPE;
        }
        if (asType.equals(Message.class)) {
            MethodRefs.SOY_VALUE_GET_PROTO.invokeUnchecked(cb);
            return MESSAGE_TYPE;
        }
        throw new UnsupportedOperationException("Can't unbox top of stack from " + String.valueOf(fromType) + " to " + String.valueOf(asType));
    }

    public static Expression newHashMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values) {
        return BytecodeUtils.newMap(keys, values, expectedSize -> MethodRefs.HASH_MAP_CAPACITY.invoke(BytecodeUtils.constant(BytecodeUtils.hashMapCapacity(expectedSize))), HASH_MAP_TYPE);
    }

    public static Expression newLinkedHashMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values) {
        return BytecodeUtils.newMap(keys, values, expectedSize -> MethodRefs.LINKED_HASH_MAP_CAPACITY.invoke(BytecodeUtils.constant(BytecodeUtils.hashMapCapacity(expectedSize))), LINKED_HASH_MAP_TYPE);
    }

    private static Expression newMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values, IntFunction<Expression> constructorWithExpectedSize, Type mapType) {
        final ImmutableList keysCopy = ImmutableList.copyOf(keys);
        final ImmutableList valuesCopy = ImmutableList.copyOf(values);
        Preconditions.checkArgument((keysCopy.size() == valuesCopy.size() ? 1 : 0) != 0);
        for (int i = 0; i < keysCopy.size(); ++i) {
            Preconditions.checkArgument((((Expression)keysCopy.get(i)).resultType().getSort() == 10 ? 1 : 0) != 0);
            Preconditions.checkArgument((((Expression)valuesCopy.get(i)).resultType().getSort() == 10 ? 1 : 0) != 0);
        }
        final Expression construct = constructorWithExpectedSize.apply(keysCopy.size());
        return new Expression(mapType, Expression.Feature.NON_JAVA_NULLABLE.asFeatures()){

            @Override
            protected void doGen(CodeBuilder mv) {
                construct.gen(mv);
                for (int i = 0; i < keysCopy.size(); ++i) {
                    Expression key = (Expression)keysCopy.get(i);
                    Expression value = (Expression)valuesCopy.get(i);
                    mv.dup();
                    key.gen(mv);
                    value.gen(mv);
                    MethodRefs.MAP_PUT.invokeUnchecked(mv);
                    mv.pop();
                }
            }
        };
    }

    private static int hashMapCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static SoyExpression isNonSoyNullish(Expression expr) {
        return SoyExpression.forBool(Branch.ifNonSoyNullish(expr).asBoolean());
    }

    public static SoyExpression isSoyNullish(Expression expr) {
        return SoyExpression.forBool(Branch.ifNonSoyNullish(expr).negate().asBoolean());
    }

    public static SoyExpression isNonSoyNull(Expression expr) {
        return SoyExpression.forBool(Branch.ifNonSoyNull(expr).asBoolean());
    }

    public static SoyExpression isSoyNull(Expression expr) {
        return SoyExpression.forBool(Branch.ifNonSoyNull(expr).negate().asBoolean());
    }

    public static SoyExpression isNonSoyUndefined(Expression expr) {
        return SoyExpression.forBool(Branch.ifNonSoyUndefined(expr).asBoolean());
    }

    public static SoyExpression isSoyUndefined(Expression expr) {
        return SoyExpression.forBool(Branch.ifNonSoyUndefined(expr).negate().asBoolean());
    }

    public static Type getTypeForClassName(String name) {
        return Type.getType((String)("L" + name.replace('.', '/') + ";"));
    }

    public static Type getTypeForSoyType(SoyType type) {
        switch (type.getKind()) {
            case INT: {
                return BOXED_LONG_TYPE;
            }
            case FLOAT: {
                return BOXED_DOUBLE_TYPE;
            }
            case BOOL: {
                return BOXED_BOOLEAN_TYPE;
            }
            case STRING: {
                return STRING_TYPE;
            }
            case PROTO: {
                return BytecodeUtils.getTypeForClassName(JavaQualifiedNames.getClassName(((SoyProtoType)type).getDescriptor()));
            }
            case PROTO_ENUM: {
                return BytecodeUtils.getTypeForClassName(JavaQualifiedNames.getClassName(((SoyProtoEnumType)type).getDescriptor()));
            }
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
    }

    public static Expression boxJavaPrimitive(SoyExpression actualParam) {
        return BytecodeUtils.boxJavaPrimitive(actualParam.soyRuntimeType().runtimeType(), actualParam);
    }

    public static Expression boxJavaPrimitive(Type type, Expression expr) {
        switch (type.getSort()) {
            case 5: {
                return MethodRefs.BOX_INTEGER.invoke(expr);
            }
            case 7: {
                return MethodRefs.BOX_LONG.invoke(expr);
            }
            case 1: {
                return MethodRefs.BOX_BOOLEAN.invoke(expr);
            }
            case 6: {
                return MethodRefs.BOX_FLOAT.invoke(expr);
            }
            case 8: {
                return MethodRefs.BOX_DOUBLE.invoke(expr);
            }
        }
        throw new IllegalArgumentException(type.getClassName());
    }

    public static Expression unboxJavaPrimitive(Type type, Expression expr) {
        switch (type.getSort()) {
            case 5: {
                return MethodRefs.NUMBER_INT_VALUE.invoke(expr.checkedCast(NUMBER_TYPE));
            }
            case 7: {
                return MethodRefs.NUMBER_LONG_VALUE.invoke(expr.checkedCast(NUMBER_TYPE));
            }
            case 1: {
                return MethodRefs.BOOLEAN_VALUE.invoke(expr.checkedCast(BOXED_BOOLEAN_TYPE));
            }
            case 6: {
                return MethodRefs.NUMBER_FLOAT_VALUE.invoke(expr.checkedCast(NUMBER_TYPE));
            }
            case 8: {
                return MethodRefs.NUMBER_DOUBLE_VALUE.invoke(expr.checkedCast(NUMBER_TYPE));
            }
        }
        throw new IllegalArgumentException(type.getClassName());
    }
}

