/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyInjector;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.Continuations;
import com.google.template.soy.jbcsrc.api.OutputAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyCssTracker;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SoySauceImpl
implements SoySauce {
    private final CompiledTemplates templates;
    private final PluginInstances pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> printDirectives;

    public SoySauceImpl(CompiledTemplates templates, ImmutableList<? extends SoyFunction> functions, ImmutableList<? extends SoyPrintDirective> printDirectives, PluginInstances pluginInstances) {
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
        ImmutableMap.Builder pluginInstanceBuilder = ImmutableMap.builder();
        for (SoyFunction fn : functions) {
            if (!(fn instanceof SoyJavaFunction)) continue;
            pluginInstanceBuilder.put((Object)fn.getName(), (Object)Suppliers.ofInstance((Object)fn));
        }
        ImmutableMap.Builder soyJavaPrintDirectives = ImmutableMap.builder();
        for (SoyPrintDirective printDirective : printDirectives) {
            if (!(printDirective instanceof SoyJavaPrintDirective)) continue;
            soyJavaPrintDirectives.put((Object)printDirective.getName(), (Object)((SoyJavaPrintDirective)printDirective));
        }
        this.printDirectives = soyJavaPrintDirectives.build();
        this.pluginInstances = pluginInstances.combine((Map<String, ? extends Supplier<Object>>)pluginInstanceBuilder.build());
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplateRender(String templateName, Map<String, ?> data) {
        ImmutableSortedSet.Builder output = ImmutableSortedSet.naturalOrder();
        output.addAll(this.templates.getTransitiveIjParamsForTemplate(templateName));
        this.addIjForTemplateParams((ImmutableSortedSet.Builder<String>)output, data.values());
        return output.build();
    }

    private void addIjForTemplateParams(ImmutableSortedSet.Builder<String> output, Collection<?> data) {
        for (Object dataValue : data) {
            if (!(dataValue instanceof TemplateValue)) continue;
            TemplateValue tmpl = (TemplateValue)dataValue;
            output.addAll(this.templates.getTransitiveIjParamsForTemplate(tmpl.getTemplateName()));
            Optional<ParamStore> boundParams = tmpl.getBoundParameters();
            if (!boundParams.isPresent()) continue;
            this.addIjForTemplateParams(output, (Collection<?>)boundParams.get().asStringMap().values());
        }
    }

    @Override
    public ImmutableList<String> getAllRequiredCssNamespaces(String templateName, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        return this.templates.getAllRequiredCssNamespaces(templateName, enabledMods, collectCssFromDelvariants);
    }

    @Override
    public ImmutableList<String> getAllRequiredCssPaths(String templateName, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        return this.templates.getAllRequiredCssPaths(templateName, enabledMods, collectCssFromDelvariants);
    }

    @Override
    public boolean hasTemplate(String template) {
        try {
            this.templates.getTemplate(template);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public RendererImpl renderTemplate(String template) {
        CompiledTemplates.TemplateData data = this.templates.getTemplateData(template);
        return new RendererImpl(template, data.template(), data.kind(), null);
    }

    @Override
    public RendererImpl newRenderer(SoyTemplate params) {
        String template = params.getTemplateName();
        CompiledTemplates.TemplateData data = this.templates.getTemplateData(template);
        ParamStore typedParams = (ParamStore)params.getParamsAsRecord();
        return new RendererImpl(template, data.template(), data.kind(), typedParams);
    }

    private static SoySauce.WriteContinuation doRender(CompiledTemplate template, ParamStore params, OutputAppendable output, RenderContext context) throws IOException {
        RenderResult result;
        try {
            result = template.render(params, output, context);
        }
        catch (Throwable t) {
            Names.rewriteStackTrace(t);
            Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
            throw t;
        }
        if (result.isDone()) {
            return Continuations.done();
        }
        return new WriteContinuationImpl(result, template, params, output, context);
    }

    private static <T> SoySauce.Continuation<T> doRenderToValue(SanitizedContent.ContentKind targetKind, StringBuilder underlying, CompiledTemplate template, ParamStore params, OutputAppendable output, RenderContext context) {
        RenderResult result;
        try {
            result = template.render(params, output, context);
        }
        catch (IOException t) {
            throw new AssertionError("impossible", t);
        }
        catch (Throwable t) {
            Names.rewriteStackTrace(t);
            throw t;
        }
        if (result.isDone()) {
            String content = underlying.toString();
            if (targetKind == SanitizedContent.ContentKind.TEXT) {
                SoySauce.Continuation<String> c = Continuations.done(content);
                return c;
            }
            SoySauce.Continuation<SanitizedContent> c = Continuations.done(UnsafeSanitizedContentOrdainer.ordainAsSafe(content, targetKind));
            return c;
        }
        return new ValueContinuationImpl(targetKind, underlying, result, template, params, output, context);
    }

    private static final class ValueContinuationImpl<T>
    extends ContinuationImpl
    implements SoySauce.Continuation<T> {
        final SanitizedContent.ContentKind targetKind;
        final StringBuilder underlying;

        ValueContinuationImpl(SanitizedContent.ContentKind targetKind, StringBuilder underlying, RenderResult result, CompiledTemplate template, ParamStore params, OutputAppendable output, RenderContext context) {
            super(result, template, params, output, context);
            this.targetKind = (SanitizedContent.ContentKind)((Object)Preconditions.checkNotNull((Object)((Object)targetKind)));
            this.underlying = (StringBuilder)Preconditions.checkNotNull((Object)underlying);
        }

        @Override
        public T get() {
            throw new IllegalStateException("Rendering is not complete: " + String.valueOf(this.result));
        }

        @Override
        public SoySauce.Continuation<T> continueRender() {
            this.doContinue();
            return SoySauceImpl.doRenderToValue(this.targetKind, this.underlying, this.template, this.params, this.output, this.context);
        }
    }

    private static final class WriteContinuationImpl
    extends ContinuationImpl
    implements SoySauce.WriteContinuation {
        WriteContinuationImpl(RenderResult result, CompiledTemplate template, ParamStore params, OutputAppendable output, RenderContext context) {
            super(result, template, params, output, context);
        }

        @Override
        public SoySauce.WriteContinuation continueRender() throws IOException {
            this.doContinue();
            return SoySauceImpl.doRender(this.template, this.params, this.output, this.context);
        }
    }

    static abstract class ContinuationImpl {
        static final VarHandle HAS_CONTINUE_CALLED_HANDLE;
        final RenderResult result;
        final CompiledTemplate template;
        final ParamStore params;
        final OutputAppendable output;
        final RenderContext context;
        boolean hasContinueBeenCalled;

        public RenderResult result() {
            return this.result;
        }

        ContinuationImpl(RenderResult result, CompiledTemplate template, ParamStore params, OutputAppendable output, RenderContext context) {
            Preconditions.checkArgument((!result.isDone() ? 1 : 0) != 0);
            this.result = (RenderResult)Preconditions.checkNotNull((Object)result);
            this.template = (CompiledTemplate)Preconditions.checkNotNull((Object)template);
            this.params = (ParamStore)Preconditions.checkNotNull((Object)params);
            this.output = (OutputAppendable)Preconditions.checkNotNull((Object)output);
            this.context = (RenderContext)Preconditions.checkNotNull((Object)context);
        }

        void doContinue() {
            if (!HAS_CONTINUE_CALLED_HANDLE.compareAndSet(this, false, true)) {
                throw new IllegalStateException("continueRender() has already been called.");
            }
        }

        static {
            try {
                HAS_CONTINUE_CALLED_HANDLE = MethodHandles.lookup().findVarHandle(ContinuationImpl.class, "hasContinueBeenCalled", Boolean.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError("impossible", e);
            }
        }
    }

    final class RendererImpl
    implements SoySauce.Renderer {
        private final String templateName;
        private final CompiledTemplate template;
        private final SanitizedContent.ContentKind contentKind;
        private Predicate<String> activeModSelector;
        private SoyCssRenamingMap cssRenamingMap;
        private SoyIdRenamingMap xidRenamingMap;
        private PluginInstances pluginInstances;
        private SoyMsgBundle msgBundle;
        private boolean debugSoyTemplateInfo;
        private SoyLogger logger;
        private SoyCssTracker cssTracker;
        private ParamStore data;
        private SoyInjector ij;
        private boolean dataSetInConstructor;

        RendererImpl(String templateName, CompiledTemplate template, @Nullable SanitizedContent.ContentKind contentKind, ParamStore data) {
            this.pluginInstances = SoySauceImpl.this.pluginInstances;
            this.templateName = templateName;
            this.template = (CompiledTemplate)Preconditions.checkNotNull((Object)template);
            this.contentKind = contentKind;
            if (data != null) {
                this.data = data;
                this.dataSetInConstructor = true;
            }
        }

        private RenderContext makeContext() {
            return new RenderContext(SoySauceImpl.this.templates, SoySauceImpl.this.printDirectives, this.pluginInstances, this.ij, this.activeModSelector, this.cssRenamingMap, this.xidRenamingMap, this.msgBundle, this.debugSoyTemplateInfo, this.logger, this.cssTracker);
        }

        private ParamStore mapAsParamStore(Map<String, ?> source) {
            ParamStore params = new ParamStore(source.size());
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                SoyValueProvider value;
                String key = entry.getKey();
                try {
                    value = SoyValueConverter.INSTANCE.convert(entry.getValue());
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Unable to convert param " + key + " to a SoyValue", e);
                }
                params.setField(RecordProperty.get(key), value);
            }
            return params.freeze();
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setIj(SoyInjector ij) {
            this.ij = (SoyInjector)Preconditions.checkNotNull((Object)ij);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setPluginInstances(Map<String, ? extends Supplier<Object>> pluginInstances) {
            this.pluginInstances = SoySauceImpl.this.pluginInstances.combine(pluginInstances);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setData(Map<String, ?> record) {
            Preconditions.checkState((!this.dataSetInConstructor ? 1 : 0) != 0, (Object)"May not call setData on a Renderer created from a TemplateParams");
            this.data = this.mapAsParamStore(record);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setActiveModSelector(Predicate<String> active) {
            this.activeModSelector = (Predicate)Preconditions.checkNotNull(active);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = (SoyCssRenamingMap)Preconditions.checkNotNull((Object)cssRenamingMap);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.xidRenamingMap = (SoyIdRenamingMap)Preconditions.checkNotNull((Object)xidRenamingMap);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setMsgBundle(SoyMsgBundle msgs) {
            this.msgBundle = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgs);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setSoyLogger(SoyLogger logger) {
            this.logger = (SoyLogger)Preconditions.checkNotNull((Object)logger);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public RendererImpl setCssTracker(SoyCssTracker cssTracker) {
            this.cssTracker = cssTracker;
            return this;
        }

        @Override
        public SoySauce.WriteContinuation renderHtml(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.HTML);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderHtml() {
            return this.startRenderToSanitizedContent(SanitizedContent.ContentKind.HTML);
        }

        @Override
        public SoySauce.WriteContinuation renderJs(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.JS);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderJs() {
            return this.startRenderToSanitizedContent(SanitizedContent.ContentKind.JS);
        }

        @Override
        public SoySauce.WriteContinuation renderUri(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.URI);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderUri() {
            return this.startRenderToSanitizedContent(SanitizedContent.ContentKind.URI);
        }

        @Override
        public SoySauce.WriteContinuation renderTrustedResourceUri(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderTrustedResourceUri() {
            return this.startRenderToSanitizedContent(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public SoySauce.WriteContinuation renderAttributes(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderAttributes() {
            return this.startRenderToSanitizedContent(SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public SoySauce.WriteContinuation renderCss(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.CSS);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderCss() {
            return this.startRenderToSanitizedContent(SanitizedContent.ContentKind.CSS);
        }

        @Override
        public SoySauce.WriteContinuation renderText(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.TEXT);
        }

        @Override
        public SoySauce.Continuation<String> renderText() {
            return this.startRenderToValue(SanitizedContent.ContentKind.TEXT);
        }

        private SoySauce.Continuation<SanitizedContent> startRenderToSanitizedContent(SanitizedContent.ContentKind kind) {
            this.enforceContentKind(kind);
            return this.startRenderToValue(kind);
        }

        private <T> SoySauce.Continuation<T> startRenderToValue(SanitizedContent.ContentKind contentKind) {
            StringBuilder sb = new StringBuilder();
            ParamStore params = this.data == null ? ParamStore.EMPTY_INSTANCE : this.data;
            RenderContext context = this.makeContext();
            OutputAppendable output = OutputAppendable.create(sb, context.getLogger());
            return SoySauceImpl.doRenderToValue(contentKind, sb, this.template, params, output, context);
        }

        private SoySauce.WriteContinuation startRender(AdvisingAppendable out, SanitizedContent.ContentKind contentKind) throws IOException {
            this.enforceContentKind(contentKind);
            ParamStore params = this.data == null ? ParamStore.EMPTY_INSTANCE : this.data;
            RenderContext context = this.makeContext();
            OutputAppendable output = OutputAppendable.create(out, context.getLogger());
            return SoySauceImpl.doRender(this.template, params, output, context);
        }

        private void enforceContentKind(SanitizedContent.ContentKind expectedContentKind) {
            if (expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            if (expectedContentKind != this.contentKind) {
                throw new IllegalStateException("Expected template '" + this.templateName + "' to be kind=\"" + Ascii.toLowerCase((String)expectedContentKind.name()) + "\" but was kind=\"" + Ascii.toLowerCase((String)this.contentKind.name()) + "\"");
            }
        }
    }
}

