/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RenderResult {
    private static final RenderResult DONE_RESULT = new RenderResult(Type.DONE);
    private static final RenderResult LIMITED_RESULT = new RenderResult(Type.LIMITED);
    private final Type type;
    @Nullable
    private final Future<?> future;

    @Nonnull
    public static RenderResult done() {
        return DONE_RESULT;
    }

    @Nonnull
    public static RenderResult limited() {
        return LIMITED_RESULT;
    }

    @Nonnull
    public static RenderResult continueAfter(Future<?> future) {
        return new RenderResult(future);
    }

    private RenderResult(Type type) {
        this.type = type;
        this.future = null;
    }

    private RenderResult(Future<?> future) {
        this.type = Type.DETACH;
        this.future = (Future)Preconditions.checkNotNull(future);
    }

    public Type type() {
        return this.type;
    }

    public boolean isDone() {
        return this == DONE_RESULT;
    }

    public void assertDone() {
        if (!this.isDone()) {
            throw new IllegalStateException("Expected " + String.valueOf(this) + " to be done");
        }
    }

    public Future<?> future() {
        Future<?> f = this.future;
        if (f == null) {
            throw new IllegalStateException("Result.future() can only be called if type() is DETACH, type was: " + String.valueOf((Object)this.type));
        }
        return f;
    }

    public String toString() {
        return "RenderResult{" + String.valueOf((Object)this.type) + "}";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.future});
    }

    public boolean equals(Object obj) {
        if (obj instanceof RenderResult) {
            RenderResult other = (RenderResult)obj;
            return other.type.equals((Object)this.type) && other.future == this.future;
        }
        return false;
    }

    public static enum Type {
        LIMITED,
        DETACH,
        DONE;

    }
}

