/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.html.types.SafeHtml;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.AppendableAsAdvisingAppendable;
import com.google.template.soy.logging.SoyLogger;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;

public final class OutputAppendable
extends AbstractLoggingAdvisingAppendable {
    private static final GoogleLogger googleLogger = GoogleLogger.forEnclosingClass();
    private final SoyLogger logger;
    private final AdvisingAppendable outputAppendable;

    public static OutputAppendable create(AdvisingAppendable outputAppendable, SoyLogger logger) {
        return new OutputAppendable(outputAppendable, logger);
    }

    public static OutputAppendable create(StringBuilder sb, SoyLogger logger) {
        return new OutputAppendable(AppendableAsAdvisingAppendable.asAdvisingAppendable(sb), logger);
    }

    private OutputAppendable(AdvisingAppendable outputAppendable, SoyLogger logger) {
        this.outputAppendable = (AdvisingAppendable)Preconditions.checkNotNull((Object)outputAppendable);
        this.logger = (SoyLogger)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public boolean softLimitReached() {
        return this.outputAppendable.softLimitReached();
    }

    @Override
    protected void doAppend(CharSequence csq) throws IOException {
        this.outputAppendable.append(csq);
    }

    @Override
    protected void doAppend(CharSequence csq, int start, int end) throws IOException {
        this.outputAppendable.append(csq, start, end);
    }

    @Override
    protected void doAppend(char c) throws IOException {
        this.outputAppendable.append(c);
    }

    @Override
    protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
        String value = this.logger.evalLoggingFunction(funCall);
        for (Function directive : escapers) {
            value = (String)directive.apply(value);
        }
        this.outputAppendable.append(value);
    }

    @Override
    protected void doEnterLoggableElement(LogStatement statement) {
        Optional<SafeHtml> veDebugOutput = this.logger.enter(statement);
        if (veDebugOutput.isPresent()) {
            try {
                this.appendDebugOutput(veDebugOutput.get().getSafeHtmlString());
            }
            catch (IOException ioException) {
                ((GoogleLogger.Api)((GoogleLogger.Api)googleLogger.atWarning()).withCause((Throwable)ioException)).log("Something went wrong while outputting VE debug info to the DOM");
            }
        }
    }

    @Override
    protected void doExitLoggableElement() {
        Optional<SafeHtml> veDebugOutput = this.logger.exit();
        if (veDebugOutput.isPresent()) {
            try {
                this.appendDebugOutput(veDebugOutput.get().getSafeHtmlString());
            }
            catch (IOException ioException) {
                ((GoogleLogger.Api)((GoogleLogger.Api)googleLogger.atWarning()).withCause((Throwable)ioException)).log("Something went wrong while outputting VE debug info to the DOM");
            }
        }
    }

    @Override
    public void flushBuffers(int depth) {
        throw new AssertionError((Object)"shouldn't be called");
    }

    private void appendDebugOutput(CharSequence csq) throws IOException {
        this.outputAppendable.append(csq);
    }
}

