/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;

public final class Continuations {
    private Continuations() {
    }

    public static SoySauce.WriteContinuation done() {
        return FinalContinuation.INSTANCE;
    }

    public static SoySauce.Continuation<String> done(String value) {
        return new ResultContinuation<String>(value);
    }

    public static SoySauce.Continuation<SanitizedContent> done(SanitizedContent value) {
        return new ResultContinuation<SanitizedContent>(value);
    }

    private static final class ResultContinuation<T>
    implements SoySauce.Continuation<T> {
        final T value;

        ResultContinuation(T value) {
            this.value = Preconditions.checkNotNull(value);
        }

        @Override
        public RenderResult result() {
            return RenderResult.done();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public SoySauce.Continuation<T> continueRender() {
            throw new IllegalStateException("Rendering is already complete and cannot be continued");
        }
    }

    private static enum FinalContinuation implements SoySauce.WriteContinuation
    {
        INSTANCE;


        @Override
        public RenderResult result() {
            return RenderResult.done();
        }

        @Override
        public SoySauce.WriteContinuation continueRender() {
            throw new IllegalStateException("Rendering is already complete and cannot be continued");
        }
    }
}

