/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.Node;
import java.util.ArrayDeque;
import java.util.Deque;

final class UnexpectedCompilerFailureException
extends RuntimeException {
    private final Deque<Node> compilationPath = new ArrayDeque<Node>();

    UnexpectedCompilerFailureException(Node original, Throwable cause) {
        super("unexpected compile failure", cause, false, false);
        this.compilationPath.add(original);
    }

    void addLocation(Node sourceLocation) {
        this.compilationPath.add(sourceLocation);
    }

    SourceLocation getOriginalLocation() {
        return this.compilationPath.getFirst().getSourceLocation();
    }

    String printSoyStack() {
        StringBuilder sb = new StringBuilder();
        for (Node node : this.compilationPath) {
            sb.append(node.getClass().getSimpleName()).append(": ").append(node.getSourceLocation()).append("\n");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\nwhile compiling:\n" + this.printSoyStack() + "\nSourceString: " + this.compilationPath.getLast().toSourceString();
    }
}

