/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoAnnotation;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createDefaultDelTemplateMetadata;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createDelTemplateMetadata;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateAnalysisImpl;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.AnnotationRef;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LambdaFactory;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.RecordToPositionalCallFactory;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UndefinedType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class TemplateCompiler {
    private static final AnnotationRef<TemplateMetadata> TEMPLATE_METADATA_REF = AnnotationRef.forType(TemplateMetadata.class);
    public static final String VARIANT_VAR_NAME = "__modifiable_variant__";
    private final FieldManager fields;
    private final CompiledTemplateMetadata template;
    private final TemplateNode templateNode;
    private final InnerClasses innerClasses;
    private final SoyClassWriter writer;
    private final TemplateAnalysis analysis;
    private final JavaSourceFunctionCompiler javaSourceFunctionCompiler;
    private final PartialFileSetMetadata fileSetMetadata;
    private static final Handle DELEGATE_FACTORY_HANDLE = MethodRef.createPure(RecordToPositionalCallFactory.class, "bootstrapDelegate", MethodHandles.Lookup.class, String.class, MethodType.class, MethodHandle.class, String[].class).asHandle();
    private static final Type COMPILED_TEMPLATE_RENDER_DESCRIPTOR = Type.getMethodType((Type)BytecodeUtils.RENDER_RESULT_TYPE, (Type[])new Type[]{BytecodeUtils.PARAM_STORE_TYPE, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, BytecodeUtils.RENDER_CONTEXT_TYPE});

    TemplateCompiler(TemplateNode templateNode, SoyClassWriter writer, FieldManager fields, InnerClasses innerClasses, JavaSourceFunctionCompiler javaSourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        this.template = CompiledTemplateMetadata.create(templateNode);
        this.templateNode = templateNode;
        this.writer = writer;
        this.fields = fields;
        this.innerClasses = innerClasses;
        this.analysis = TemplateAnalysisImpl.analyze(templateNode);
        this.javaSourceFunctionCompiler = javaSourceFunctionCompiler;
        this.fileSetMetadata = fileSetMetadata;
    }

    void compile() {
        if (this.template.defaultModTemplateMethod().isPresent()) {
            this.generateTemplateMethod(this.template.templateMethod(), this.template.modifiableSelectMethod().get());
            this.generateTemplateMethod(this.template.defaultModTemplateMethod().get(), this.template.renderMethod());
        } else {
            this.generateTemplateMethod(this.template.templateMethod(), this.template.renderMethod());
        }
        this.generateDelegateRenderMethod();
        this.generateRenderMethod();
        this.generateModifiableSelectMethod();
    }

    private void generateTemplateMethod(MethodRef templateMethod, MethodRef renderMethod) {
        Statement methodBody = Statement.returnExpression(LambdaFactory.create(MethodRefs.COMPILED_TEMPLATE_RENDER, renderMethod).invoke(new Expression[0]));
        CodeBuilder methodWriter = new CodeBuilder(this.methodAccess(), templateMethod.method(), null, this.writer);
        this.generateTemplateMetadata(methodWriter);
        methodBody.writeMethodTo(methodWriter);
    }

    private boolean isModifyingTemplate() {
        return this.templateNode instanceof TemplateBasicNode && ((TemplateBasicNode)this.templateNode).getModifiesExpr() != null;
    }

    private int methodAccess() {
        return (this.templateNode.getVisibility() == Visibility.PUBLIC || this.isModifyingTemplate() ? 1 : 0) | 8;
    }

    private void generateTemplateMetadata(CodeBuilder builder) {
        TemplateMetadata.DelTemplateMetadata deltemplateMetadata;
        SanitizedContent.ContentKind kind = Converters.toContentKind(this.templateNode.getContentKind());
        ImmutableList positionalParams = this.template.hasPositionalSignature() ? (List)this.template.templateType().getActualParameters().stream().map(TemplateType.Parameter::getName).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
        ImmutableSet uniqueIjs = (ImmutableSet)SoyTreeUtils.allNodesOfType(this.templateNode, VarRefNode.class).filter(VarRefNode::isInjected).map(VarRefNode::getNameWithoutLeadingDollar).collect(ImmutableSet.toImmutableSet());
        ImmutableSet callees = (ImmutableSet)SoyTreeUtils.allNodesOfType(this.templateNode, TemplateLiteralNode.class).map(TemplateLiteralNode::getResolvedName).collect(ImmutableSet.toImmutableSet());
        ImmutableSet delCallees = ImmutableSet.builder().addAll((Iterable)SoyTreeUtils.allNodesOfType(this.templateNode, CallDelegateNode.class).map(CallDelegateNode::getDelCalleeName).collect(ImmutableSet.toImmutableSet())).addAll((Iterable)SoyTreeUtils.allNodesOfType(this.templateNode, TemplateLiteralNode.class).filter(literal -> ((TemplateType)literal.getType()).isModifiable()).map(TemplateCompiler::legacyOrModifiableName).collect(ImmutableSet.toImmutableSet())).build();
        if (this.templateNode.getKind() == SoyNode.Kind.TEMPLATE_DELEGATE_NODE) {
            TemplateDelegateNode delegateNode = (TemplateDelegateNode)this.templateNode;
            deltemplateMetadata = TemplateCompiler.createDelTemplateMetadata(Strings.nullToEmpty((String)delegateNode.getModName()), delegateNode.getDelTemplateName(), delegateNode.getDelTemplateVariant());
        } else {
            deltemplateMetadata = this.templateNode instanceof TemplateBasicNode ? this.metadataForBasicNode((TemplateBasicNode)this.templateNode) : TemplateCompiler.createDefaultDelTemplateMetadata();
        }
        LinkedHashSet namespaces = Sets.newLinkedHashSet();
        namespaces.addAll(this.templateNode.getParent().getRequiredCssNamespaces());
        this.templateNode.getParent().getAllRequiredCssPaths().stream().map(SoyFileNode.CssPath::getNamespace).filter(Objects::nonNull).forEach(namespaces::add);
        namespaces.addAll(this.templateNode.getRequiredCssNamespaces());
        LinkedHashSet cssPaths = Sets.newLinkedHashSet();
        this.templateNode.getParent().getAllRequiredCssPaths().stream().filter(p -> p.getNamespace() == null).filter(p -> p.resolvedPath().isPresent()).forEach(p -> cssPaths.add(p.resolvedPath().get()));
        TemplateMetadata metadata = TemplateCompiler.createTemplateMetadata(kind, this.template.hasPositionalSignature(), (List<String>)positionalParams, namespaces, cssPaths, (Set<String>)uniqueIjs, (Set<String>)callees, (Set<String>)delCallees, deltemplateMetadata);
        TEMPLATE_METADATA_REF.write(metadata, builder);
    }

    static String legacyOrModifiableName(TemplateLiteralNode node) {
        TemplateType templateType = (TemplateType)node.getType();
        return !templateType.getLegacyDeltemplateNamespace().isEmpty() ? templateType.getLegacyDeltemplateNamespace() : node.getResolvedName();
    }

    TemplateMetadata.DelTemplateMetadata metadataForBasicNode(TemplateBasicNode templateBasicNode) {
        if (templateBasicNode.isModifiable()) {
            return TemplateCompiler.createDelTemplateMetadata(Strings.nullToEmpty((String)templateBasicNode.getModName()), TemplateCompiler.modifiableImplsMapKey(templateBasicNode), templateBasicNode.getDelTemplateVariant());
        }
        if (templateBasicNode.getModifiesExpr() != null) {
            return TemplateCompiler.createDelTemplateMetadata(Strings.nullToEmpty((String)templateBasicNode.getModName()), TemplateCompiler.legacyOrModifiableName((TemplateLiteralNode)templateBasicNode.getModifiesExpr().getRoot()), templateBasicNode.getDelTemplateVariant());
        }
        return TemplateCompiler.createDefaultDelTemplateMetadata();
    }

    private static String modifiableImplsMapKey(TemplateBasicNode templateBasicNode) {
        return !templateBasicNode.getLegacyDeltemplateNamespace().isEmpty() ? templateBasicNode.getLegacyDeltemplateNamespace() : templateBasicNode.getTemplateName();
    }

    @AutoAnnotation
    static TemplateMetadata createTemplateMetadata(SanitizedContent.ContentKind contentKind, boolean hasPositionalSignature, List<String> positionalParams, Set<String> requiredCssNames, Set<String> requiredCssPaths, Set<String> injectedParams, Set<String> callees, Set<String> delCallees, TemplateMetadata.DelTemplateMetadata deltemplateMetadata) {
        return new AutoAnnotation_TemplateCompiler_createTemplateMetadata(contentKind, hasPositionalSignature, positionalParams, requiredCssNames, requiredCssPaths, injectedParams, callees, delCallees, deltemplateMetadata);
    }

    @AutoAnnotation
    static TemplateMetadata.DelTemplateMetadata createDefaultDelTemplateMetadata() {
        return new AutoAnnotation_TemplateCompiler_createDefaultDelTemplateMetadata();
    }

    @AutoAnnotation
    static TemplateMetadata.DelTemplateMetadata createDelTemplateMetadata(String modName, String name, String variant) {
        return new AutoAnnotation_TemplateCompiler_createDelTemplateMetadata(modName, name, variant);
    }

    private void generateDelegateRenderMethod() {
        if (!this.template.hasPositionalSignature()) {
            return;
        }
        final Handle renderHandle = this.template.positionalRenderMethod().get().asHandle();
        Statement.returnExpression(new Expression(BytecodeUtils.COMPILED_TEMPLATE_TYPE){

            @Override
            protected void doGen(CodeBuilder cb) {
                cb.loadArgs();
                cb.visitInvokeDynamicInsn("delegate", COMPILED_TEMPLATE_RENDER_DESCRIPTOR.getDescriptor(), DELEGATE_FACTORY_HANDLE, Stream.concat(Stream.of(renderHandle), TemplateCompiler.this.template.templateType().getActualParameters().stream().map(TemplateType.Parameter::getName)).toArray(Object[]::new));
            }
        }).writeMethod(this.methodAccess(), this.template.renderMethod().method(), this.writer);
    }

    private void generateRenderMethod() {
        ExpressionCompiler.BasicExpressionCompiler constantCompiler = ExpressionCompiler.createConstantCompiler(this.templateNode, this.analysis, new SimpleLocalVariableManager(this.template.typeInfo().type(), true), this.javaSourceFunctionCompiler, this.fileSetMetadata);
        final Label start = new Label();
        final Label end = new Label();
        ImmutableList.Builder paramNames = ImmutableList.builder();
        if (this.template.hasPositionalSignature()) {
            paramNames.addAll((Iterable)this.template.templateType().getActualParameters().stream().map(TemplateType.Parameter::getName).collect(ImmutableList.toImmutableList()));
        } else {
            paramNames.add((Object)"$params");
        }
        paramNames.add((Object)"$appendable");
        paramNames.add((Object)"$renderContext");
        Method method = this.template.positionalRenderMethod().orElse(this.template.renderMethod()).method();
        final TemplateVariableManager variableSet = new TemplateVariableManager(this.template.typeInfo().type(), method.getArgumentTypes(), (ImmutableList<String>)paramNames.build(), start, end, true);
        Optional paramsVar = this.template.hasPositionalSignature() ? Optional.empty() : Optional.of(variableSet.getVariable("$params"));
        RenderContextExpression renderContext = new RenderContextExpression(variableSet.getVariable("$renderContext"));
        TemplateVariables variables = new TemplateVariables(variableSet, paramsVar, renderContext);
        AppendableExpression appendable = AppendableExpression.forExpression(variableSet.getVariable("$appendable").asNonJavaNullable());
        SoyNodeCompiler nodeCompiler = SoyNodeCompiler.create(this.templateNode, this.analysis, this.innerClasses, appendable, variableSet, variables, this.fields, constantCompiler, this.javaSourceFunctionCompiler, this.fileSetMetadata);
        TemplateVariableManager.Scope templateScope = variableSet.enterScope();
        final ArrayList<Statement> paramInitStatements = new ArrayList<Statement>();
        for (TemplateParam param : this.templateNode.getAllParams()) {
            LocalVariable localVariable;
            Expression initialValue;
            SoyExpression defaultValue;
            SoyExpression soyExpression = defaultValue = param.hasDefault() ? this.getDefaultValue(param, nodeCompiler.exprCompiler, constantCompiler) : null;
            if (param.isInjected()) {
                initialValue = renderContext.getInjectedValue(param.name(), defaultValue);
                localVariable = templateScope.createNamedLocal(param.name(), initialValue.resultType());
                paramInitStatements.add(localVariable.initialize(initialValue));
                continue;
            }
            if (paramsVar.isPresent()) {
                initialValue = TemplateCompiler.getFieldProviderOrDefault(param.name(), (Expression)paramsVar.get(), defaultValue);
                localVariable = templateScope.createNamedLocal(param.name(), initialValue.resultType());
                paramInitStatements.add(localVariable.initialize(initialValue));
                continue;
            }
            if (defaultValue == null) continue;
            localVariable = (LocalVariable)variableSet.getVariable(param.name());
            paramInitStatements.add(localVariable.store(MethodRefs.RUNTIME_PARAM_OR_DEFAULT.invoke(localVariable, defaultValue.box())));
        }
        final Statement methodBody = nodeCompiler.compile(this.templateNode, ExtraCodeCompiler.NO_OP, ExtraCodeCompiler.NO_OP);
        final Statement exitTemplateScope = templateScope.exitScope();
        final Statement returnDone = Statement.returnExpression(MethodRefs.RENDER_RESULT_DONE.invoke(new Expression[0]));
        new Statement(this){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(start);
                for (Statement paramInitStatement : paramInitStatements) {
                    paramInitStatement.gen(adapter);
                }
                methodBody.gen(adapter);
                exitTemplateScope.gen(adapter);
                adapter.mark(end);
                returnDone.gen(adapter);
                variableSet.generateTableEntries(adapter);
            }
        }.writeIOExceptionMethod(this.methodAccess(), method, this.writer);
    }

    private SoyExpression getDefaultValue(TemplateHeaderVarDefn headerVar, ExpressionCompiler expressionCompiler, ExpressionCompiler.BasicExpressionCompiler constantCompiler) {
        ExprRootNode defaultValueNode = headerVar.defaultValue();
        if (defaultValueNode.getType() == NullType.getInstance()) {
            return SoyExpression.SOY_NULL;
        }
        if (defaultValueNode.getType() == UndefinedType.getInstance()) {
            return SoyExpression.SOY_UNDEFINED;
        }
        if (ExpressionCompiler.canCompileToConstant(this.templateNode, defaultValueNode)) {
            SoyExpression defaultValue = constantCompiler.compile(defaultValueNode).box().toMaybeConstant();
            if (!defaultValue.isCheap()) {
                FieldRef ref = headerVar.kind() == VarDefn.Kind.STATE ? this.fields.addPackagePrivateStaticField(headerVar.name(), defaultValue) : this.fields.addStaticField("default$" + headerVar.name(), defaultValue);
                defaultValue = defaultValue.withSource(ref.accessor());
            }
            return defaultValue;
        }
        Optional<SoyExpression> defaultExpression = expressionCompiler.compileWithNoDetaches(defaultValueNode);
        Preconditions.checkState((boolean)defaultExpression.isPresent(), (Object)"Default expression unexpectedly required detachment");
        return defaultExpression.get().box();
    }

    private static Expression getFieldProviderOrDefault(String name, Expression record, @Nullable SoyExpression defaultValue) {
        if (defaultValue == null) {
            return MethodRefs.PARAM_STORE_GET_PARAMETER.invoke(record, BytecodeUtils.constantRecordProperty(name));
        }
        return MethodRefs.PARAM_STORE_GET_PARAMETER_DEFAULT.invoke(record, BytecodeUtils.constantRecordProperty(name), defaultValue.box());
    }

    private void generateModifiableSelectMethod() {
        if (!this.template.modifiableSelectMethod().isPresent()) {
            return;
        }
        Method method = this.template.renderMethod().method();
        final Label start = new Label();
        final Label end = new Label();
        ImmutableList.Builder paramNames = ImmutableList.builder();
        paramNames.add((Object)"$params");
        paramNames.add((Object)"$appendable");
        paramNames.add((Object)"$renderContext");
        final TemplateVariableManager variableSet = new TemplateVariableManager(this.template.typeInfo().type(), method.getArgumentTypes(), (ImmutableList<String>)paramNames.build(), start, end, true);
        Expression paramsVar = variableSet.getVariable("$params");
        Expression appendableVar = variableSet.getVariable("$appendable");
        RenderContextExpression context = new RenderContextExpression(variableSet.getVariable("$renderContext"));
        TemplateBasicNode templateBasicNode = (TemplateBasicNode)this.templateNode;
        Expression renderExpression = context.renderModifiable(TemplateCompiler.modifiableImplsMapKey(templateBasicNode), paramsVar, appendableVar);
        final Statement returnExpression = Statement.returnExpression(renderExpression);
        new Statement(this){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(start);
                returnExpression.gen(adapter);
                adapter.mark(end);
                variableSet.generateTableEntries(adapter);
            }
        }.writeIOExceptionMethod(this.methodAccess(), this.template.modifiableSelectMethod().get().method(), this.writer);
    }

    private static final class TemplateVariables
    implements TemplateParameterLookup {
        private final TemplateVariableManager variableSet;
        private final Optional<? extends Expression> paramsRecord;
        private final RenderContextExpression renderContext;

        TemplateVariables(TemplateVariableManager variableSet, Optional<? extends Expression> paramsRecord, RenderContextExpression renderContext) {
            this.variableSet = variableSet;
            this.paramsRecord = paramsRecord;
            this.renderContext = renderContext;
        }

        @Override
        public Expression getParam(TemplateParam param) {
            return this.variableSet.getVariable(param.name());
        }

        @Override
        public Expression getParamsRecord() {
            return this.paramsRecord.get();
        }

        @Override
        public Expression getLocal(AbstractLocalVarDefn<?> local) {
            return this.variableSet.getVariable(local.name());
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            return this.variableSet.getVariable(varName);
        }

        @Override
        public RenderContextExpression getRenderContext() {
            return this.renderContext;
        }
    }
}

