/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.AutoValue_FieldManager_StaticFieldVariable;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

final class FieldManager {
    private final UniqueNameGenerator fieldNames = JbcSrcNameGenerators.forFieldNames();
    private final TypeInfo owner;
    private final List<FieldRef> fields = new ArrayList<FieldRef>();
    private final List<StaticFieldVariable> staticFields = new ArrayList<StaticFieldVariable>();
    private boolean definedFields = false;

    FieldManager(TypeInfo owner) {
        this.owner = owner;
    }

    FieldRef addGeneratedFinalField(String suggestedName, Type type) {
        String name = this.fieldNames.generate(suggestedName);
        return this.doAddField(name, type, 18);
    }

    FieldRef addFinalField(String name, Type type) {
        this.fieldNames.exact(name);
        return this.doAddField(name, type, 18);
    }

    private FieldRef doAddField(String name, Type type, int modifiers) {
        Preconditions.checkState((!this.definedFields ? 1 : 0) != 0);
        FieldRef field = FieldRef.create(this.owner, name, type, modifiers);
        this.fields.add(field);
        return field;
    }

    FieldRef addStaticField(String proposedName, Expression initializer) {
        return this.addStaticField(proposedName, initializer, 26);
    }

    private FieldRef addStaticField(String proposedName, Expression initializer, int accessFlags) {
        String name = this.fieldNames.generate(proposedName);
        FieldRef ref = this.doAddField(name, initializer.resultType(), accessFlags);
        if (initializer.isNonJavaNullable()) {
            ref = ref.asNonJavaNullable();
        }
        this.staticFields.add(new AutoValue_FieldManager_StaticFieldVariable(ref, initializer));
        return ref;
    }

    FieldRef addPackagePrivateStaticField(String proposedName, Expression initializer) {
        return this.addStaticField(proposedName, initializer, 24);
    }

    void defineFields(ClassVisitor writer) {
        Preconditions.checkState((!this.definedFields ? 1 : 0) != 0);
        this.definedFields = true;
        for (FieldRef field : this.fields) {
            field.defineField(writer);
        }
    }

    void defineStaticInitializer(ClassVisitor writer) {
        Preconditions.checkState((boolean)this.definedFields);
        if (this.staticFields.isEmpty()) {
            return;
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (StaticFieldVariable staticField : this.staticFields) {
            statements.add(staticField.field().putStaticField(staticField.initializer()));
        }
        statements.add(Statement.RETURN);
        Statement.concat(statements).writeMethod(8, BytecodeUtils.CLASS_INIT, writer);
    }

    @AutoValue
    static abstract class StaticFieldVariable {
        StaticFieldVariable() {
        }

        abstract FieldRef field();

        abstract Expression initializer();
    }
}

