/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNodes;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.ConstantsCompiler;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.ExternCompiler;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.ProtoUtils;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.restricted.Branch;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.ClassLoaderFallbackCallFactory;
import com.google.template.soy.jbcsrc.shared.ExtraConstantBootstraps;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class ExpressionCompiler {
    private final SoyNode context;
    private final TemplateAnalysis analysis;
    private final TemplateParameterLookup parameters;
    private final LocalVariableManager varManager;
    private final JavaSourceFunctionCompiler sourceFunctionCompiler;
    private final PartialFileSetMetadata fileSetMetadata;

    static ExpressionCompiler create(SoyNode context, TemplateAnalysis analysis, TemplateParameterLookup parameters, LocalVariableManager varManager, JavaSourceFunctionCompiler sourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        return new ExpressionCompiler(context, analysis, (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameters), varManager, sourceFunctionCompiler, fileSetMetadata);
    }

    static BasicExpressionCompiler createConstantCompiler(SoyNode context, TemplateAnalysis analysis, final LocalVariableManager varManager, JavaSourceFunctionCompiler sourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        return new BasicExpressionCompiler(new CompilerVisitor(context, analysis, new TemplateParameterLookup(){

            UnsupportedOperationException unsupported() {
                return new UnsupportedOperationException("This method isn't supported in constant context");
            }

            @Override
            public Expression getParam(TemplateParam param) {
                throw this.unsupported();
            }

            @Override
            public Expression getParamsRecord() {
                throw this.unsupported();
            }

            @Override
            public Expression getLocal(AbstractLocalVarDefn<?> local) {
                return varManager.getVariable(local.name());
            }

            @Override
            public Expression getLocal(SyntheticVarName varName) {
                throw this.unsupported();
            }

            @Override
            public RenderContextExpression getRenderContext() {
                throw this.unsupported();
            }
        }, varManager, ExpressionDetacher.NullDetatcher.INSTANCE, sourceFunctionCompiler, fileSetMetadata, true));
    }

    static BasicExpressionCompiler createBasicCompiler(SoyNode context, TemplateAnalysis analysis, TemplateParameterLookup parameters, LocalVariableManager varManager, JavaSourceFunctionCompiler sourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        return new BasicExpressionCompiler(context, analysis, parameters, varManager, sourceFunctionCompiler, fileSetMetadata);
    }

    static boolean canCompileToConstant(SoyNode context, ExprNode expr) {
        return (Boolean)new CanCompileToConstantVisitor(context).exec(expr);
    }

    private ExpressionCompiler(SoyNode context, TemplateAnalysis analysis, TemplateParameterLookup parameters, LocalVariableManager varManager, JavaSourceFunctionCompiler sourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        this.context = context;
        this.analysis = analysis;
        this.parameters = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameters);
        this.varManager = (LocalVariableManager)Preconditions.checkNotNull((Object)varManager);
        this.sourceFunctionCompiler = (JavaSourceFunctionCompiler)Preconditions.checkNotNull((Object)sourceFunctionCompiler);
        this.fileSetMetadata = fileSetMetadata;
    }

    SoyExpression compileSubExpression(ExprNode node, ExpressionDetacher detacher) {
        return this.asBasicCompiler(detacher).compile(node);
    }

    SoyExpression compileRootExpression(ExprNode node, ExpressionDetacher.Factory detacherFactory) {
        Label reattachPoint = new Label();
        SoyExpression exec = this.compileSubExpression(node, detacherFactory.createExpressionDetacher(reattachPoint));
        return exec.labelStart(reattachPoint);
    }

    static boolean requiresDetach(TemplateAnalysis analysis, ExprNode node) {
        return (Boolean)new RequiresDetachVisitor(analysis).exec(node);
    }

    boolean requiresDetach(ExprNode node) {
        return ExpressionCompiler.requiresDetach(this.analysis, node);
    }

    Optional<SoyExpression> compileWithNoDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        if (this.requiresDetach(node)) {
            return Optional.empty();
        }
        return Optional.of((SoyExpression)new CompilerVisitor(this.context, this.analysis, this.parameters, this.varManager, null, this.sourceFunctionCompiler, this.fileSetMetadata, false).exec(node));
    }

    BasicExpressionCompiler asBasicCompiler(ExpressionDetacher detacher) {
        return new BasicExpressionCompiler(new CompilerVisitor(this.context, this.analysis, this.parameters, this.varManager, detacher, this.sourceFunctionCompiler, this.fileSetMetadata, false));
    }

    private static final class RequiresDetachVisitor
    extends EnhancedAbstractExprNodeVisitor<Boolean> {
        private final TemplateAnalysis analysis;

        RequiresDetachVisitor(TemplateAnalysis analysis) {
            this.analysis = analysis;
        }

        @Override
        Boolean visitForLoopVar(VarRefNode varRef, LocalVar local) {
            return !this.analysis.isResolved(varRef);
        }

        @Override
        protected Boolean visitListComprehensionNode(ListComprehensionNode node) {
            return true;
        }

        @Override
        protected Boolean visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            return true;
        }

        @Override
        Boolean visitParam(VarRefNode varRef, TemplateParam param) {
            return !this.analysis.isResolved(varRef);
        }

        @Override
        Boolean visitLetNodeVar(VarRefNode node, LocalVar local) {
            return !this.analysis.isResolved(node);
        }

        @Override
        protected Boolean visitMethodCallNode(MethodCallNode node) {
            if (node.getMethodName().toString().equals("bind")) {
                for (Boolean childRequiresDetach : this.visitChildren(node)) {
                    if (!childRequiresDetach.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            if (!this.analysis.isResolved(node)) {
                return true;
            }
            for (ExprNode child : node.getChildren()) {
                if (!((Boolean)this.visit(child)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Boolean visitProtoInitFunction(FunctionNode node) {
            for (Boolean i : this.visitChildren(node)) {
                if (!i.booleanValue()) continue;
                return true;
            }
            SoyProtoType protoType = (SoyProtoType)node.getType();
            for (Identifier paramName : node.getParamNames()) {
                if (!protoType.getFieldDescriptor(paramName.identifier()).isRepeated()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Boolean visitTemplateLiteralNode(TemplateLiteralNode node) {
            return false;
        }

        @Override
        protected Boolean visitPluginFunction(FunctionNode node) {
            Object fn = node.getSoyFunction();
            if (fn instanceof SoyJavaSourceFunction) {
                PluginAnalyzer.PluginMetadata metadata = PluginAnalyzer.analyze((SoyJavaSourceFunction)fn);
                for (MethodSignature methodSignature : Iterables.concat(metadata.instanceMethodSignatures(), metadata.staticMethodSignatures())) {
                    if (!Future.class.isAssignableFrom(methodSignature.returnType())) continue;
                    return true;
                }
            }
            return node.getParams().stream().anyMatch(this::visit);
        }

        @Override
        protected Boolean visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                for (Boolean i : this.visitChildren((ExprNode.ParentExprNode)node)) {
                    if (!i.booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class CanCompileToConstantVisitor
    extends AbstractReturningExprNodeVisitor<Boolean> {
        private final SoyNode context;

        CanCompileToConstantVisitor(SoyNode context) {
            this.context = context;
        }

        @Override
        protected Boolean visitExprRootNode(ExprRootNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitVarRefNode(VarRefNode node) {
            switch (node.getDefnDecl().kind()) {
                case COMPREHENSION_VAR: {
                    return true;
                }
                case PARAM: 
                case LOCAL_VAR: {
                    return false;
                }
                case CONST: {
                    return false;
                }
                case STATE: {
                    return true;
                }
                case IMPORT_VAR: {
                    return false;
                }
                case EXTERN: {
                    return false;
                }
            }
            throw new AssertionError((Object)node.getDefnDecl().kind());
        }

        @Override
        protected Boolean visitPrimitiveNode(ExprNode.PrimitiveNode node) {
            return true;
        }

        @Override
        protected Boolean visitTemplateLiteralNode(TemplateLiteralNode node) {
            return CompiledTemplateMetadata.isPrivateReference(this.context, node);
        }

        @Override
        protected Boolean visitGlobalNode(GlobalNode node) {
            return true;
        }

        @Override
        protected Boolean visitListLiteralNode(ListLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitListComprehensionNode(ListComprehensionNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitRecordLiteralNode(RecordLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitMapLiteralNode(MapLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitMethodCallNode(MethodCallNode node) {
            SoyMethod method = node.getSoyMethod();
            if (method == BuiltinMethod.BIND) {
                return this.areAllChildrenConstant(node);
            }
            return false;
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitNullSafeAccessNode(NullSafeAccessNode node) {
            return (Boolean)this.visit(node.getBase()) != false && this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitOperatorNode(ExprNode.OperatorNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitFunctionNode(FunctionNode node) {
            Object function = node.getSoyFunction();
            if (function == BuiltinFunction.VE_DEF) {
                return (Boolean)this.visit(node.getParam(0)) != false && (Boolean)this.visit(node.getParam(1)) != false && (node.numParams() != 4 || (Boolean)this.visit(node.getParam(3)) != false);
            }
            if (!this.areAllParamsConstant(node)) {
                return false;
            }
            if (function == BuiltinFunction.PROTO_INIT || function == BuiltinFunction.VE_DATA || function == BuiltinFunction.CHECK_NOT_NULL || function == BuiltinFunction.TO_FLOAT) {
                return true;
            }
            if (!node.isPure()) {
                return false;
            }
            if (function instanceof SoyJavaSourceFunction) {
                try {
                    PluginAnalyzer.PluginMetadata metadata = PluginAnalyzer.analyze((SoyJavaSourceFunction)function);
                    return metadata.pluginInstanceNames().isEmpty() && !metadata.accessesContext();
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
            return false;
        }

        @Override
        protected Boolean visitGroupNode(GroupNode node) {
            return this.areAllChildrenConstant(node);
        }

        private boolean areAllParamsConstant(ExprNode.CallableExpr node) {
            for (ExprNode child : node.getParams()) {
                if (((Boolean)this.visit(child)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private boolean areAllChildrenConstant(ExprNode.ParentExprNode node) {
            for (ExprNode child : node.getChildren()) {
                if (((Boolean)this.visit(child)).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<SoyExpression> {
        @Nullable
        private final ExpressionDetacher detacher;
        private final SoyNode context;
        private final TemplateAnalysis analysis;
        private final TemplateParameterLookup parameters;
        private final LocalVariableManager varManager;
        private final JavaSourceFunctionCompiler sourceFunctionCompiler;
        private final PartialFileSetMetadata fileSetMetadata;
        private final boolean isConstantContext;
        private static final Handle CONSTANT_LIST_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "constantSoyList", MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE, Object[].class).asHandle();
        private static final Handle CONSTANT_MAP_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "constantSoyMap", MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE, Object[].class).asHandle();
        private static final Handle GET_CONST_HANDLE = MethodRef.createPure(ClassLoaderFallbackCallFactory.class, "bootstrapConstLookup", MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class).asHandle();
        private static final Handle CALL_EXTERN_HANDLE = MethodRef.createPure(ClassLoaderFallbackCallFactory.class, "bootstrapExternCall", MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class).asHandle();
        private static final Handle GET_TEMPLATE_VALUE_HANDLE = MethodRef.createPure(ClassLoaderFallbackCallFactory.class, "bootstrapTemplateValueLookup", MethodHandles.Lookup.class, String.class, MethodType.class, String.class).asHandle();
        private static final String TEMPLATE_VALUE_SIGNATURE = Type.getMethodDescriptor((Type)BytecodeUtils.TEMPLATE_VALUE_TYPE, (Type[])new Type[]{BytecodeUtils.RENDER_CONTEXT_TYPE});

        CompilerVisitor(SoyNode context, TemplateAnalysis analysis, TemplateParameterLookup parameters, LocalVariableManager varManager, ExpressionDetacher detacher, JavaSourceFunctionCompiler sourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata, boolean isConstantContext) {
            this.context = (SoyNode)Preconditions.checkNotNull((Object)context);
            this.analysis = analysis;
            this.detacher = detacher;
            this.parameters = parameters;
            this.varManager = varManager;
            this.sourceFunctionCompiler = sourceFunctionCompiler;
            this.fileSetMetadata = fileSetMetadata;
            this.isConstantContext = isConstantContext;
        }

        @Override
        protected SoyExpression visit(ExprNode node) {
            return ((SoyExpression)super.visit(node)).withSourceLocation(node.getSourceLocation());
        }

        @Override
        protected SoyExpression visitExprRootNode(ExprRootNode node) {
            return this.visit(node.getRoot());
        }

        @Override
        protected SoyExpression visitNullNode(NullNode node) {
            return SoyExpression.SOY_NULL;
        }

        @Override
        protected SoyExpression visitUndefinedNode(UndefinedNode node) {
            return SoyExpression.SOY_UNDEFINED;
        }

        @Override
        protected SoyExpression visitFloatNode(FloatNode node) {
            return SoyExpression.forFloat(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected SoyExpression visitStringNode(StringNode node) {
            return SoyExpression.forString(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected SoyExpression visitProtoEnumValueNode(ProtoEnumValueNode node) {
            return SoyExpression.forInt(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected SoyExpression visitBooleanNode(BooleanNode node) {
            return node.getValue() ? SoyExpression.TRUE : SoyExpression.FALSE;
        }

        @Override
        protected SoyExpression visitIntegerNode(IntegerNode node) {
            return SoyExpression.forInt(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected SoyExpression visitListLiteralNode(ListLiteralNode node) {
            List<SoyExpression> compiledChildren = this.visitChildren(node);
            Expression asList = SoyExpression.asBoxedValueProviderList(compiledChildren);
            SoyExpression asListSoyExpression = SoyExpression.forList((ListType)node.getType(), asList);
            if (this.isConstantContext && Expression.areAllConstant(compiledChildren)) {
                Object[] constantArgs = new Object[1 + compiledChildren.size()];
                constantArgs[0] = node.getSourceLocation().hashCode();
                for (int i = 0; i < compiledChildren.size(); ++i) {
                    constantArgs[i + 1] = compiledChildren.get(i).constantBytecodeValue();
                }
                return asListSoyExpression.withConstantValue(Expression.ConstantValue.dynamic(new ConstantDynamic("constantList", BytecodeUtils.IMMUTABLE_LIST_TYPE.getDescriptor(), CONSTANT_LIST_HANDLE, constantArgs), BytecodeUtils.IMMUTABLE_LIST_TYPE, false));
            }
            return asListSoyExpression;
        }

        @Override
        protected SoyExpression visitListComprehensionNode(ListComprehensionNode node) {
            ExprNode listExpr = node.getListExpr();
            SoyExpression soyList = this.visit(listExpr);
            SoyExpression javaList = soyList.unboxAsListUnchecked();
            ExprNode mapExpr = node.getListItemTransformExpr();
            ExprNode filterExpr = node.getFilterExpr();
            String varName = node.getListIterVar().name();
            LocalVariableManager.Scope scope = this.varManager.enterScope();
            LocalVariable listVar = scope.createTemporary(varName + "_input_list", BytecodeUtils.LIST_TYPE);
            final Statement listVarInitializer = listVar.initialize(javaList);
            final LocalVariable resultVar = scope.createTemporary(varName + "_output_list", BytecodeUtils.LIST_TYPE);
            final Statement resultVarInitializer = resultVar.initialize(MethodRefs.ARRAY_LIST.invoke(new Expression[0]));
            final LocalVariable sizeVar = scope.createTemporary(varName + "_input_list_size", Type.INT_TYPE);
            final Statement sizeVarInitializer = sizeVar.initialize(listVar.invoke(MethodRefs.LIST_SIZE, new Expression[0]));
            final LocalVariable indexVar = scope.createTemporary(varName + "_index", Type.INT_TYPE);
            final Statement indexVarInitializer = indexVar.initialize(BytecodeUtils.constant(0));
            LocalVariable itemVar = scope.createNamedLocal(node.getListIterVar().name(), BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            final Statement itemVarInitializer = itemVar.initialize(listVar.invoke(MethodRefs.LIST_GET, indexVar).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE));
            final LocalVariable userIndexVar = node.getIndexVar() == null ? null : scope.createNamedLocal(node.getIndexVar().name(), Type.LONG_TYPE);
            final Statement userIndexVarInitializer = userIndexVar == null ? null : userIndexVar.initialize(BytecodeUtils.numericConversion(indexVar, Type.LONG_TYPE));
            final SoyExpression visitedMap = this.visit(mapExpr).box();
            final Branch visitedFilter = filterExpr != null ? this.visit(filterExpr).compileToBranch() : null;
            final Statement exitScope = scope.exitScope();
            return SoyExpression.forList((ListType)node.getType(), new Expression(this, BytecodeUtils.LIST_TYPE, Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, new Expression.Feature[0])){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    listVarInitializer.gen(adapter);
                    resultVarInitializer.gen(adapter);
                    sizeVarInitializer.gen(adapter);
                    indexVarInitializer.gen(adapter);
                    Label loopStart = new Label();
                    Label loopContinue = new Label();
                    Label loopEnd = new Label();
                    adapter.mark(loopStart);
                    indexVar.gen(adapter);
                    sizeVar.gen(adapter);
                    adapter.ifICmp(156, loopEnd);
                    itemVarInitializer.gen(adapter);
                    if (userIndexVar != null) {
                        userIndexVarInitializer.gen(adapter);
                    }
                    if (visitedFilter != null) {
                        visitedFilter.negate().branchTo(adapter, loopContinue);
                    }
                    resultVar.gen(adapter);
                    visitedMap.gen(adapter);
                    MethodRefs.ARRAY_LIST_ADD.invokeUnchecked(adapter);
                    adapter.pop();
                    adapter.mark(loopContinue);
                    adapter.iinc(indexVar.index(), 1);
                    adapter.goTo(loopStart);
                    adapter.mark(loopEnd);
                    resultVar.gen(adapter);
                    exitScope.gen(adapter);
                }
            });
        }

        @Override
        protected SoyExpression visitRecordLiteralNode(RecordLiteralNode node) {
            SoyExpression record = BytecodeUtils.newRecordImplFromParamStore(node.getType(), node.getSourceLocation(), this.recordLiteralAsParamStore(node));
            return this.isConstantContext ? record.toMaybeConstant() : record;
        }

        private Expression recordLiteralAsParamStore(RecordLiteralNode node) {
            LinkedHashMap<String, Expression> recordMap = new LinkedHashMap<String, Expression>();
            for (int i = 0; i < node.numChildren(); ++i) {
                recordMap.put(node.getKey(i).identifier(), this.visit(node.getChild(i)));
            }
            return BytecodeUtils.newParamStore(Optional.empty(), recordMap);
        }

        @Override
        protected SoyExpression visitMapLiteralNode(MapLiteralNode node) {
            int numItems = node.numChildren() / 2;
            ArrayList<Expression> keys = new ArrayList<Expression>(numItems);
            ArrayList<Expression> values = new ArrayList<Expression>(numItems);
            for (int i = 0; i < numItems; ++i) {
                keys.add(this.visit(node.getChild(2 * i)).box());
                values.add(this.visit(node.getChild(2 * i + 1)).box());
            }
            SoyExpression soyMap = SoyExpression.forSoyValue(node.getType(), MethodRefs.MAP_IMPL_FOR_PROVIDER_MAP_NO_NULL_KEYS.invoke(BytecodeUtils.newImmutableMap(keys, values, true)));
            if (this.isConstantContext && Expression.areAllConstant(keys) && Expression.areAllConstant(values)) {
                Object[] constantArgs = new Object[1 + node.numChildren()];
                constantArgs[0] = node.getSourceLocation().hashCode();
                for (int i = 0; i < keys.size(); ++i) {
                    constantArgs[2 * i + 1] = ((Expression)keys.get(i)).constantBytecodeValue();
                    constantArgs[2 * i + 2] = ((Expression)values.get(i)).constantBytecodeValue();
                }
                soyMap = soyMap.withConstantValue(Expression.ConstantValue.dynamic(new ConstantDynamic("constantMap", BytecodeUtils.SOY_MAP_IMPL_TYPE.getDescriptor(), CONSTANT_MAP_HANDLE, constantArgs), BytecodeUtils.SOY_MAP_IMPL_TYPE, false));
            }
            return soyMap;
        }

        @Override
        protected SoyExpression visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            return SoyExpression.forSoyValue(node.getType(), MethodRefs.CONSTRUCT_MAP_FROM_LIST.invoke(this.visit(node.getListExpr()).unboxAsListUnchecked()));
        }

        @Override
        protected SoyExpression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            if (ExprNodes.isNullishLiteral(node.getChild(0))) {
                return BytecodeUtils.isSoyNullish(this.visit(node.getChild(1)));
            }
            if (ExprNodes.isNullishLiteral(node.getChild(1))) {
                return BytecodeUtils.isSoyNullish(this.visit(node.getChild(0)));
            }
            return SoyExpression.forBool(BytecodeUtils.compareSoyEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1))));
        }

        @Override
        protected SoyExpression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            if (ExprNodes.isNullishLiteral(node.getChild(0))) {
                return BytecodeUtils.isNonSoyNullish(this.visit(node.getChild(1)));
            }
            if (ExprNodes.isNullishLiteral(node.getChild(1))) {
                return BytecodeUtils.isNonSoyNullish(this.visit(node.getChild(0)));
            }
            return SoyExpression.forBool(Branch.ifTrue(BytecodeUtils.compareSoyEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1)))).negate().asBoolean());
        }

        @Override
        protected SoyExpression visitTripleEqualOpNode(OperatorNodes.TripleEqualOpNode node) {
            if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                return BytecodeUtils.isSoyNull(this.visit(node.getChild(1)));
            }
            if (node.getChild(0).getKind() == ExprNode.Kind.UNDEFINED_NODE) {
                return BytecodeUtils.isSoyUndefined(this.visit(node.getChild(1)));
            }
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                return BytecodeUtils.isSoyNull(this.visit(node.getChild(0)));
            }
            if (node.getChild(1).getKind() == ExprNode.Kind.UNDEFINED_NODE) {
                return BytecodeUtils.isSoyUndefined(this.visit(node.getChild(0)));
            }
            return SoyExpression.forBool(BytecodeUtils.compareSoyTripleEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1))));
        }

        @Override
        protected SoyExpression visitTripleNotEqualOpNode(OperatorNodes.TripleNotEqualOpNode node) {
            if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                return BytecodeUtils.isNonSoyNull(this.visit(node.getChild(1)));
            }
            if (node.getChild(0).getKind() == ExprNode.Kind.UNDEFINED_NODE) {
                return BytecodeUtils.isNonSoyUndefined(this.visit(node.getChild(1)));
            }
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                return BytecodeUtils.isNonSoyNull(this.visit(node.getChild(0)));
            }
            if (node.getChild(1).getKind() == ExprNode.Kind.UNDEFINED_NODE) {
                return BytecodeUtils.isNonSoyUndefined(this.visit(node.getChild(0)));
            }
            return SoyExpression.forBool(Branch.ifTrue(BytecodeUtils.compareSoyTripleEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1)))).negate().asBoolean());
        }

        @Override
        protected SoyExpression visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(Branch.compare(155, left.unboxAsLong(), right.unboxAsLong()).asBoolean());
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(Branch.compare(155, left.coerceToDouble(), right.coerceToDouble()).asBoolean());
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(155, left, right);
            }
            return SoyExpression.forBool(MethodRefs.RUNTIME_LESS_THAN.invoke(left.box(), right.box()));
        }

        @Override
        protected SoyExpression visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(Branch.compare(157, left.unboxAsLong(), right.unboxAsLong()).asBoolean());
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(Branch.compare(157, left.coerceToDouble(), right.coerceToDouble()).asBoolean());
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(157, left, right);
            }
            return SoyExpression.forBool(MethodRefs.RUNTIME_LESS_THAN.invoke(right.box(), left.box()));
        }

        @Override
        protected SoyExpression visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(Branch.compare(158, left.unboxAsLong(), right.unboxAsLong()).asBoolean());
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(Branch.compare(158, left.coerceToDouble(), right.coerceToDouble()).asBoolean());
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(158, left, right);
            }
            return SoyExpression.forBool(MethodRefs.RUNTIME_LESS_THAN_OR_EQUAL.invoke(left.box(), right.box()));
        }

        @Override
        protected SoyExpression visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(Branch.compare(156, left.unboxAsLong(), right.unboxAsLong()).asBoolean());
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(Branch.compare(156, left.coerceToDouble(), right.coerceToDouble()).asBoolean());
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(156, left, right);
            }
            return SoyExpression.forBool(MethodRefs.RUNTIME_LESS_THAN_OR_EQUAL.invoke(right.box(), left.box()));
        }

        private SoyExpression createStringComparisonOperator(int operator, SoyExpression left, SoyExpression right) {
            return SoyExpression.forBool(Branch.compare(operator, left.coerceToString().invoke(MethodRefs.STRING_COMPARE_TO, right.coerceToString()), BytecodeUtils.constant(0)).asBoolean());
        }

        @Override
        protected SoyExpression visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
            SoyExpression right = this.visit(node.getChild(1));
            SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
            if (leftRuntimeType.assignableToNullableNumber() && rightRuntimeType.assignableToNullableNumber()) {
                if (leftRuntimeType.assignableToNullableInt() && rightRuntimeType.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(97, left, right);
                }
                if (leftRuntimeType.assignableToNullableFloat() || rightRuntimeType.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(99, left, right);
                }
            }
            if (leftRuntimeType.isKnownString() || rightRuntimeType.isKnownString()) {
                SoyExpression leftString = left.coerceToString();
                SoyExpression rightString = right.coerceToString();
                return SoyExpression.forString(leftString.invoke(MethodRefs.STRING_CONCAT, rightString).toMaybeConstant());
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRefs.RUNTIME_PLUS.invoke(left.box(), right.box()));
        }

        private SoyExpression visitBinaryOperator(AbstractOperatorNode node, int longOpcode, int doubleOpcode, MethodRef runtimeMethod) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(longOpcode, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(doubleOpcode, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, runtimeMethod.invoke(left.box(), right.box()));
        }

        @Override
        protected SoyExpression visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            return this.visitBinaryOperator(node, 101, 103, MethodRefs.RUNTIME_MINUS);
        }

        @Override
        protected SoyExpression visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            return this.visitBinaryOperator(node, 105, 107, MethodRefs.RUNTIME_TIMES);
        }

        @Override
        protected SoyExpression visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            return CompilerVisitor.applyBinaryFloatOperator(111, this.visit(node.getChild(0)), this.visit(node.getChild(1)));
        }

        @Override
        protected SoyExpression visitModOpNode(OperatorNodes.ModOpNode node) {
            return this.visitBinaryOperator(node, 113, 115, MethodRefs.RUNTIME_MOD);
        }

        @Override
        protected SoyExpression visitShiftLeftOpNode(OperatorNodes.ShiftLeftOpNode node) {
            return this.applyBitwiseIntOperator(node, 121, Type.INT_TYPE, MethodRefs.RUNTIME_SHIFT_LEFT);
        }

        @Override
        protected SoyExpression visitShiftRightOpNode(OperatorNodes.ShiftRightOpNode node) {
            return this.applyBitwiseIntOperator(node, 123, Type.INT_TYPE, MethodRefs.RUNTIME_SHIFT_RIGHT);
        }

        @Override
        protected SoyExpression visitBitwiseOrOpNode(OperatorNodes.BitwiseOrOpNode node) {
            return this.applyBitwiseIntOperator(node, 129, Type.LONG_TYPE, MethodRefs.RUNTIME_BITWISE_OR);
        }

        @Override
        protected SoyExpression visitBitwiseXorOpNode(OperatorNodes.BitwiseXorOpNode node) {
            return this.applyBitwiseIntOperator(node, 131, Type.LONG_TYPE, MethodRefs.RUNTIME_BITWISE_XOR);
        }

        @Override
        protected SoyExpression visitBitwiseAndOpNode(OperatorNodes.BitwiseAndOpNode node) {
            return this.applyBitwiseIntOperator(node, 127, Type.LONG_TYPE, MethodRefs.RUNTIME_BITWISE_AND);
        }

        private SoyExpression applyBitwiseIntOperator(AbstractOperatorNode node, final int operator, Type rht, MethodRef runtimeMethod) {
            SoyExpression lhe = this.visit(node.getChild(0));
            SoyExpression rhe = this.visit(node.getChild(1));
            if (lhe.assignableToNullableInt() && rhe.assignableToNullableInt()) {
                final SoyExpression left = lhe.unboxAsLong();
                final Expression right = BytecodeUtils.numericConversion(rhe.unboxAsLong(), rht);
                return SoyExpression.forInt(new Expression(this, Type.LONG_TYPE){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        left.gen(mv);
                        right.gen(mv);
                        mv.visitInsn(operator);
                    }
                });
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, runtimeMethod.invoke(lhe.box(), rhe.box()));
        }

        private static SoyExpression applyBinaryIntOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftInt = left.unboxAsLong();
            final SoyExpression rightInt = right.unboxAsLong();
            return SoyExpression.forInt(new Expression(Type.LONG_TYPE){

                @Override
                protected void doGen(CodeBuilder mv) {
                    leftInt.gen(mv);
                    rightInt.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        private static SoyExpression applyBinaryFloatOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftFloat = left.coerceToDouble();
            final SoyExpression rightFloat = right.coerceToDouble();
            return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE){

                @Override
                protected void doGen(CodeBuilder mv) {
                    leftFloat.gen(mv);
                    rightFloat.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        @Override
        protected SoyExpression visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            SoyExpression child = this.visit(node.getChild(0));
            if (child.assignableToNullableInt()) {
                final SoyExpression intExpr = child.unboxAsLong();
                return SoyExpression.forInt(new Expression(this, Type.LONG_TYPE, child.features()){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        intExpr.gen(mv);
                        mv.visitInsn(117);
                    }
                });
            }
            if (child.assignableToNullableFloat()) {
                final SoyExpression floatExpr = child.unboxAsDouble();
                return SoyExpression.forFloat(new Expression(this, Type.DOUBLE_TYPE, child.features()){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        floatExpr.gen(mv);
                        mv.visitInsn(119);
                    }
                });
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRefs.RUNTIME_NEGATIVE.invoke(child.box()));
        }

        @Override
        protected SoyExpression visitNotOpNode(OperatorNodes.NotOpNode node) {
            return SoyExpression.forBool(this.visit(node.getChild(0)).compileToBranch().negate().asBoolean());
        }

        @Override
        protected SoyExpression visitAndOpNode(OperatorNodes.AndOpNode node) {
            return this.doSimpleAnd(node);
        }

        private SoyExpression doSimpleAnd(AbstractOperatorNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            return SoyExpression.forBool(Branch.and(left.compileToBranch(), right.compileToBranch()).asBoolean());
        }

        @Override
        protected SoyExpression visitAmpAmpOpNode(OperatorNodes.AmpAmpOpNode node) {
            if (node.getChild(0).getType().getKind() == SoyType.Kind.BOOL && node.getChild(1).getType().getKind() == SoyType.Kind.BOOL) {
                return this.doSimpleAnd(node);
            }
            return this.rewriteAsConditional(node);
        }

        @Override
        protected SoyExpression visitOrOpNode(OperatorNodes.OrOpNode node) {
            return this.doSimpleOr(node);
        }

        private SoyExpression doSimpleOr(AbstractOperatorNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            return SoyExpression.forBool(Branch.or(left.compileToBranch(), right.compileToBranch()).asBoolean());
        }

        @Override
        protected SoyExpression visitBarBarOpNode(OperatorNodes.BarBarOpNode node) {
            if (node.getChild(0).getType().getKind() == SoyType.Kind.BOOL && node.getChild(1).getType().getKind() == SoyType.Kind.BOOL) {
                return this.doSimpleOr(node);
            }
            return this.rewriteAsConditional(node);
        }

        private SoyExpression rewriteAsConditional(final AbstractOperatorNode node) {
            final SoyExpression lhsExpr = this.visit(node.getChild(0)).box();
            final SoyExpression rhsExpr = this.visit(node.getChild(1)).box();
            return SoyExpression.forSoyValue(node.getType(), new Expression(this, SoyRuntimeType.getBoxedType(node.getType()).runtimeType()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    Label trueLabel = new Label();
                    lhsExpr.gen(adapter);
                    adapter.dup();
                    MethodRefs.SOY_VALUE_COERCE_TO_BOOLEAN.invokeUnchecked(adapter);
                    adapter.ifZCmp(node instanceof OperatorNodes.BarBarOpNode ? 154 : 153, trueLabel);
                    adapter.pop();
                    rhsExpr.gen(adapter);
                    adapter.mark(trueLabel);
                }
            });
        }

        @Override
        protected SoyExpression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            SoyExpression left = this.visit(node.getLeftChild());
            if (left.isNonSoyNullish()) {
                return left;
            }
            SoyExpression right = this.visit(node.getRightChild());
            if (left.resultType().equals((Object)right.resultType())) {
                SoyExpression result = left.isBoxed() ? SoyExpression.forSoyValue(node.getType(), BytecodeUtils.firstSoyNonNullish(left, right)) : right.withSource(BytecodeUtils.firstSoyNonNullish(left, right));
                if (Expression.areAllCheap(left, right)) {
                    result = result.asCheap();
                }
                return result;
            }
            return SoyExpression.forSoyValue(node.getType(), BytecodeUtils.firstSoyNonNullish(left.box(), right.box()));
        }

        @Override
        protected SoyExpression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            return this.processConditionalOp(this.visit(node.getChild(0)).compileToBranch(), this.visit(node.getChild(1)), this.visit(node.getChild(2)), node.getType());
        }

        private SoyExpression processConditionalOp(Branch condition, SoyExpression trueBranch, SoyExpression falseBranch, SoyType nodeType) {
            boolean typesEqual = trueBranch.soyType().equals(falseBranch.soyType());
            if (typesEqual) {
                boolean bothUnboxed = !trueBranch.isBoxed() && !falseBranch.isBoxed();
                Type type = (bothUnboxed ? SoyRuntimeType.getUnboxedType(trueBranch.soyType()).get() : SoyRuntimeType.getBoxedType(trueBranch.soyType())).runtimeType();
                if (trueBranch.isBoxed() == falseBranch.isBoxed()) {
                    return trueBranch.withSource(condition.ternary(type, trueBranch, falseBranch));
                }
                SoyExpression boxedTrue = trueBranch.box();
                return boxedTrue.withSource(condition.ternary(type, boxedTrue, falseBranch.box()));
            }
            Type boxedRuntimeType = SoyRuntimeType.getBoxedType(nodeType).runtimeType();
            return SoyExpression.forSoyValue(nodeType, condition.ternary(boxedRuntimeType, trueBranch.box(), falseBranch.box()));
        }

        @Override
        SoyExpression visitForLoopVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            if (expression.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forInt(expression);
            }
            return this.resolveVarRefNode(varRef, expression);
        }

        @Override
        SoyExpression visitParam(VarRefNode varRef, TemplateParam param) {
            return this.resolveVarRefNode(varRef, this.parameters.getParam(param));
        }

        @Override
        SoyExpression visitImportedVar(VarRefNode varRef, final ImportedVar importedVar) {
            String namespace = this.fileSetMetadata.getNamespaceForPath(importedVar.getSourceFilePath());
            final TypeInfo typeInfo = TypeInfo.createClass(Names.javaClassNameFromSoyNamespace(namespace));
            final RenderContextExpression renderContext = this.parameters.getRenderContext();
            Expression constExpression = new Expression(this, ConstantsCompiler.getConstantRuntimeType(importedVar.type()).runtimeType()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    renderContext.gen(adapter);
                    adapter.visitInvokeDynamicInsn("create", ConstantsCompiler.getConstantMethod(importedVar.name(), importedVar.type()).getDescriptor(), GET_CONST_HANDLE, new Object[]{typeInfo.className(), importedVar.getSymbol()});
                }
            };
            return SoyExpression.forRuntimeType(ConstantsCompiler.getConstantRuntimeType(importedVar.type()), constExpression);
        }

        @Override
        SoyExpression visitConstVar(VarRefNode varRef, ConstVar constVar) {
            SoyFileNode fileNode = this.context.getNearestAncestor(SoyFileNode.class);
            TypeInfo typeInfo = TypeInfo.createClass(Names.javaClassNameFromSoyNamespace(fileNode.getNamespace()));
            MethodRef methodRef = MethodRef.createStaticMethod(typeInfo, ConstantsCompiler.getConstantMethod(constVar.name(), constVar.type()), MethodRef.MethodPureness.NON_PURE);
            return SoyExpression.forRuntimeType(ConstantsCompiler.getConstantRuntimeType(constVar.type()), methodRef.invoke(this.parameters.getRenderContext()));
        }

        @Override
        SoyExpression visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            return this.resolveVarRefNode(varRef, this.parameters.getLocal(local));
        }

        @Override
        SoyExpression visitListComprehensionVar(VarRefNode varRef, ListComprehensionNode.ComprehensionVarDefn var) {
            if (((ListComprehensionNode)var.declaringNode()).getIndexVar() == var) {
                return SoyExpression.forInt(this.parameters.getLocal(var));
            }
            return this.resolveVarRefNode(varRef, this.parameters.getLocal(var));
        }

        private SoyExpression resolveVarRefNode(VarRefNode varRef, Expression unresolvedExpression) {
            SoyType type = varRef.getType();
            SoyExpression resolved = !this.analysis.isResolved(varRef) ? SoyExpression.forSoyValue(type, this.detacher.resolveSoyValueProvider(unresolvedExpression).checkedSoyCast(type)) : SoyExpression.resolveSoyValueProvider(type, unresolvedExpression);
            if (unresolvedExpression.isNonSoyNullish()) {
                resolved = resolved.asNonSoyNullish();
            }
            return resolved;
        }

        @Override
        protected SoyExpression visitDataAccessNode(DataAccessNode node) {
            return this.visitDataAccessNodeRecurse(node);
        }

        private SoyExpression visitDataAccessNodeRecurse(final ExprNode node) {
            switch (node.getKind()) {
                case FIELD_ACCESS_NODE: 
                case ITEM_ACCESS_NODE: 
                case METHOD_CALL_NODE: {
                    SoyExpression baseExpr = this.visitDataAccessNodeRecurse(((DataAccessNode)node).getBaseExprChild());
                    if (SoyTypes.isNullOrUndefined(baseExpr.soyType())) {
                        return SoyExpression.forSoyValue(node.getType(), new Expression(this, SoyRuntimeType.getBoxedType(node.getType()).runtimeType(), Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0])){

                            @Override
                            protected void doGen(CodeBuilder cb) {
                                String accessType;
                                switch (node.getKind()) {
                                    case FIELD_ACCESS_NODE: {
                                        accessType = "field " + ((FieldAccessNode)node).getFieldName();
                                        break;
                                    }
                                    case ITEM_ACCESS_NODE: {
                                        accessType = "element " + ((ItemAccessNode)node).getSourceStringSuffix();
                                        break;
                                    }
                                    case METHOD_CALL_NODE: {
                                        accessType = "method " + ((MethodCallNode)node).getMethodName().identifier();
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError();
                                    }
                                }
                                cb.throwException(BytecodeUtils.NULL_POINTER_EXCEPTION_TYPE, String.format("Attempted to access %s of null", accessType));
                            }
                        });
                    }
                    baseExpr = baseExpr.asNonJavaNullable().asNonSoyNullish();
                    return this.visitDataAccess((DataAccessNode)node, baseExpr);
                }
            }
            return this.visit(node);
        }

        private SoyExpression visitDataAccess(DataAccessNode node, SoyExpression baseExpr) {
            SoyExpression result;
            switch (node.getKind()) {
                case FIELD_ACCESS_NODE: {
                    result = this.visitFieldAccess(baseExpr, (FieldAccessNode)node).withSourceLocation(node.getSourceLocation());
                    break;
                }
                case ITEM_ACCESS_NODE: {
                    result = this.visitItemAccess(baseExpr, (ItemAccessNode)node).withSourceLocation(node.getSourceLocation());
                    break;
                }
                case METHOD_CALL_NODE: {
                    result = this.visitMethodCall(baseExpr, (MethodCallNode)node).withSourceLocation(node.getSourceLocation());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return result;
        }

        private SoyExpression visitFieldAccess(SoyExpression baseExpr, FieldAccessNode node) {
            Expression fieldAccess;
            Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
            SoySourceFunctionMethod sourceMethod = node.getSoyMethod();
            if (sourceMethod != null) {
                return this.sourceFunctionCompiler.compile(node, sourceMethod, (List<SoyExpression>)ImmutableList.of((Object)baseExpr), this.parameters, this.detacher);
            }
            if (baseExpr.soyRuntimeType().isKnownProtoOrUnionOfProtos()) {
                return ProtoUtils.accessField(baseExpr, node.getFieldName(), node.getType(), ProtoUtils.SingularFieldAccessMode.NULL_IF_UNSET, this.varManager, false);
            }
            SoyExpression baseExprAsRecord = baseExpr.box();
            if (this.analysis.isResolved(node)) {
                fieldAccess = MethodRefs.RUNTIME_GET_FIELD.invoke(baseExprAsRecord, BytecodeUtils.constantRecordProperty(node.getFieldName()));
            } else {
                Expression fieldProvider = MethodRefs.RUNTIME_GET_FIELD_PROVIDER.invoke(baseExprAsRecord, BytecodeUtils.constantRecordProperty(node.getFieldName()));
                fieldAccess = this.detacher.resolveSoyValueProvider(fieldProvider);
            }
            return SoyExpression.forSoyValue(node.getType(), fieldAccess.checkedSoyCast(node.getType()));
        }

        private SoyExpression visitItemAccess(SoyExpression baseExpr, ItemAccessNode node) {
            Expression soyValueProvider;
            Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
            SoyExpression keyExpr = this.visit(node.getKeyExprChild());
            if (baseExpr.soyRuntimeType().isKnownListOrUnionOfLists()) {
                SoyExpression list = baseExpr.unboxAsListUnchecked();
                SoyExpression index = keyExpr.unboxAsLong();
                soyValueProvider = this.analysis.isResolved(node) ? MethodRefs.RUNTIME_GET_LIST_ITEM.invoke(list, index) : this.detacher.resolveSoyValueProvider(MethodRefs.RUNTIME_GET_LIST_ITEM_PROVIDER.invoke(list, index));
            } else {
                SoyExpression map = baseExpr.box();
                SoyExpression index = keyExpr.box();
                soyValueProvider = this.analysis.isResolved(node) ? MethodRefs.RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM.invoke(map, index) : this.detacher.resolveSoyValueProvider(MethodRefs.RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM_PROVIDER.invoke(map, index));
            }
            return SoyExpression.forSoyValue(node.getType(), soyValueProvider.checkedSoyCast(node.getType()));
        }

        private Expression getMapGetExpression(SoyExpression baseExpr, DataAccessNode node, SoyExpression keyExpr) {
            SoyExpression map = baseExpr.box();
            SoyExpression index = keyExpr.box();
            Expression soyValueProvider = this.analysis.isResolved(node) ? MethodRefs.RUNTIME_GET_MAP_ITEM.invoke(map, index) : this.detacher.resolveSoyValueProvider(MethodRefs.RUNTIME_GET_MAP_ITEM_PROVIDER.invoke(map, index));
            return soyValueProvider;
        }

        private SoyExpression visitMethodCall(SoyExpression baseExpr, MethodCallNode node) {
            Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)node.isMethodResolved());
            SoyMethod function = node.getSoyMethod();
            if (function instanceof BuiltinMethod) {
                BuiltinMethod builtinMethod = (BuiltinMethod)function;
                switch (builtinMethod) {
                    case GET_EXTENSION: {
                        return ProtoUtils.accessExtensionField(baseExpr, node, BuiltinMethod.getProtoExtensionIdFromMethodCall(node), ProtoUtils.SingularFieldAccessMode.DEFAULT_IF_UNSET_UNLESS_MESSAGE_VALUED);
                    }
                    case GET_READONLY_EXTENSION: {
                        return ProtoUtils.accessExtensionField(baseExpr, node, BuiltinMethod.getProtoExtensionIdFromMethodCall(node), ProtoUtils.SingularFieldAccessMode.DEFAULT_IF_UNSET);
                    }
                    case HAS_EXTENSION: {
                        return ProtoUtils.hasExtensionField(baseExpr, node, BuiltinMethod.getProtoExtensionIdFromMethodCall(node));
                    }
                    case HAS_PROTO_FIELD: {
                        return ProtoUtils.hasserField(baseExpr, BuiltinMethod.getProtoFieldNameFromMethodCall(node), this.varManager);
                    }
                    case GET_READONLY_PROTO_FIELD: {
                        return ProtoUtils.accessField(baseExpr, BuiltinMethod.getProtoFieldNameFromMethodCall(node), node.getType(), ProtoUtils.SingularFieldAccessMode.DEFAULT_IF_UNSET, this.varManager, false);
                    }
                    case GET_PROTO_FIELD: {
                        return ProtoUtils.accessField(baseExpr, BuiltinMethod.getProtoFieldNameFromMethodCall(node), node.getType(), ProtoUtils.SingularFieldAccessMode.DEFAULT_IF_UNSET_UNLESS_MESSAGE_VALUED, this.varManager, false);
                    }
                    case GET_PROTO_FIELD_OR_UNDEFINED: {
                        return ProtoUtils.accessField(baseExpr, BuiltinMethod.getProtoFieldNameFromMethodCall(node), node.getType(), ProtoUtils.SingularFieldAccessMode.NULL_IF_UNSET, this.varManager, false);
                    }
                    case MAP_GET: {
                        Expression expr = this.getMapGetExpression(baseExpr, node, this.visit(node.getParam(0)));
                        return SoyExpression.forSoyValue(node.getType(), expr.checkedSoyCast(node.getType()));
                    }
                    case BIND: {
                        return SoyExpression.forSoyValue(node.getType(), MethodRefs.RUNTIME_BIND_TEMPLATE_PARAMS.invoke(baseExpr.checkedCast(BytecodeUtils.TEMPLATE_VALUE_TYPE), this.recordLiteralAsParamStore((RecordLiteralNode)node.getChild(1))));
                    }
                }
            } else if (function instanceof SoySourceFunctionMethod) {
                SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)function;
                ArrayList<SoyExpression> args = new ArrayList<SoyExpression>(node.numParams() + 1);
                args.add(baseExpr);
                node.getParams().forEach(n -> args.add(this.visit((ExprNode)n)));
                return this.sourceFunctionCompiler.compile(node, sourceMethod, args, this.parameters, this.detacher);
            }
            throw new AssertionError(function.getClass());
        }

        @Override
        protected SoyExpression visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
            Label nullSafeExit = new Label();
            SoyExpression accumulator = this.visit(nullSafeAccessNode.getBase());
            ExprNode dataAccess = nullSafeAccessNode.getDataAccess();
            while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
                NullSafeAccessNode node = (NullSafeAccessNode)dataAccess;
                accumulator = this.accumulateNullSafeDataAccess((DataAccessNode)node.getBase(), accumulator, nullSafeExit);
                dataAccess = node.getDataAccess();
            }
            accumulator = this.accumulateNullSafeDataAccessTail((ExprNode.AccessChainComponentNode)dataAccess, accumulator, nullSafeExit);
            return accumulator.box().labelEnd(nullSafeExit).asSoyUndefinable();
        }

        private static SoyExpression addNullSafetyCheck(final SoyExpression baseExpr, final Label nullSafeExit) {
            return baseExpr.withSource(new Expression(baseExpr.resultType(), baseExpr.features()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    baseExpr.gen(adapter);
                    BytecodeUtils.coalesceSoyNullishToSoyUndefined(adapter, baseExpr.resultType(), nullSafeExit);
                }
            }).asNonSoyNullish();
        }

        private SoyExpression accumulateNullSafeDataAccessTail(ExprNode.AccessChainComponentNode dataAccessNode, SoyExpression baseExpr, Label nullSafeExit) {
            if (dataAccessNode.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                OperatorNodes.AssertNonNullOpNode assertNonNull = (OperatorNodes.AssertNonNullOpNode)dataAccessNode;
                dataAccessNode = (ExprNode.AccessChainComponentNode)assertNonNull.getChild(0);
            }
            return this.accumulateNullSafeDataAccess((DataAccessNode)dataAccessNode, baseExpr, nullSafeExit);
        }

        private SoyExpression accumulateNullSafeDataAccess(DataAccessNode dataAccessNode, SoyExpression baseExpr, Label nullSafeExit) {
            if (!baseExpr.isNonSoyNullish()) {
                baseExpr = CompilerVisitor.addNullSafetyCheck(baseExpr, nullSafeExit);
            }
            return this.accumulateDataAccess(dataAccessNode, baseExpr);
        }

        private SoyExpression accumulateDataAccess(DataAccessNode dataAccessNode, SoyExpression baseExpr) {
            if (dataAccessNode.getBaseExprChild() instanceof DataAccessNode) {
                baseExpr = this.accumulateDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild(), baseExpr).asNonSoyNullish();
            }
            return this.visitDataAccess(dataAccessNode, baseExpr);
        }

        @Override
        protected SoyExpression visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            return this.visit((ExprNode)Iterables.getOnlyElement(node.getChildren()));
        }

        @Override
        SoyExpression visitCheckNotNullFunction(FunctionNode node) {
            ExprNode childNode = (ExprNode)Iterables.getOnlyElement(node.getParams());
            SoyExpression expr = this.visit(childNode);
            if (expr.isNonSoyNullish()) {
                return expr;
            }
            return expr.withSource(MethodRefs.CHECK_NOT_NULL.invoke(expr, BytecodeUtils.constant(childNode.toSourceString())).checkedCast(expr.resultType())).asNonSoyNullish();
        }

        @Override
        SoyExpression visitCssFunction(FunctionNode node) {
            StringNode selector = (StringNode)Iterables.getLast(node.getParams());
            Expression renamedSelector = this.parameters.getRenderContext().renameCss(selector.getValue());
            if (node.numParams() == 1) {
                return SoyExpression.forString(renamedSelector);
            }
            SoyExpression base = this.visit(node.getParam(0)).coerceToString();
            Expression fullSelector = base.invoke(MethodRefs.STRING_CONCAT, BytecodeUtils.constant("-")).toMaybeConstant().invoke(MethodRefs.STRING_CONCAT, renamedSelector);
            return SoyExpression.forString(fullSelector);
        }

        @Override
        SoyExpression visitToggleFunction(FunctionNode node) {
            String toggleName = ((StringNode)node.getChild(1)).getValue();
            Expression toggleRewrite = this.parameters.getRenderContext().evalToggle(toggleName);
            return SoyExpression.forBool(toggleRewrite);
        }

        @Override
        SoyExpression visitXidFunction(FunctionNode node) {
            StringNode xid = (StringNode)Iterables.getOnlyElement(node.getParams());
            Expression renamedXid = this.parameters.getRenderContext().renameXid(xid.getValue());
            return SoyExpression.forString(renamedXid);
        }

        @Override
        SoyExpression visitSoyServerKeyFunction(FunctionNode node) {
            ExprNode child = (ExprNode)Iterables.getOnlyElement(node.getParams());
            return SoyExpression.forString(MethodRefs.SOY_SERVER_KEY.invoke(this.visit(child).box()));
        }

        @Override
        SoyExpression visitIsPrimaryMsgInUse(FunctionNode node) {
            return SoyExpression.forBool(this.parameters.getRenderContext().usePrimaryMsgIfFallback(((IntegerNode)node.getParam(1)).getValue(), ((IntegerNode)node.getParam(2)).getValue()));
        }

        @Override
        SoyExpression visitToFloatFunction(FunctionNode node) {
            SoyExpression arg = this.visit(node.getParam(0));
            return SoyExpression.forFloat(BytecodeUtils.numericConversion(arg.unboxAsLong(), Type.DOUBLE_TYPE));
        }

        @Override
        SoyExpression visitDebugSoyTemplateInfoFunction(FunctionNode node) {
            return SoyExpression.forBool(this.parameters.getRenderContext().getDebugSoyTemplateInfo());
        }

        @Override
        SoyExpression visitVeDataFunction(FunctionNode node) {
            SoyExpression ve = this.visit(node.getParam(0));
            Expression data = this.visit(node.getParam(1)).unboxAsMessageOrJavaNull(BytecodeUtils.MESSAGE_TYPE);
            return SoyExpression.forSoyValue(node.getType(), MethodRefs.SOY_VISUAL_ELEMENT_DATA_CREATE.invoke(ve, data));
        }

        @Override
        SoyExpression visitEmptyToNullFunction(FunctionNode node) {
            return SoyExpression.forSoyValue(node.getType(), MethodRefs.RUNTIME_EMPTY_TO_NULL.invoke(this.visit(node.getParam(0)).box()));
        }

        @Override
        SoyExpression visitUndefinedToNullFunction(FunctionNode node) {
            return SoyExpression.forSoyValue(SoyTypes.undefinedToNull(node.getType()), MethodRefs.SOY_VALUE_NULLISH_TO_NULL.invoke(this.visit(node.getParam(0)).box()));
        }

        @Override
        SoyExpression visitBooleanFunction(FunctionNode node) {
            return SoyExpression.forBool(MethodRefs.SOY_VALUE_COERCE_TO_BOOLEAN.invoke(this.visit(node.getParam(0)).box()));
        }

        @Override
        SoyExpression visitHasContentFunction(FunctionNode node) {
            return SoyExpression.forBool(MethodRefs.SOY_VALUE_HAS_CONTENT.invoke(this.visit(node.getParam(0)).box()));
        }

        @Override
        SoyExpression visitIsTruthyNonEmptyFunction(FunctionNode node) {
            return SoyExpression.forBool(MethodRefs.SOY_VALUE_IS_TRUTHY_NON_EMPTY.invoke(this.visit(node.getParam(0)).box()));
        }

        @Override
        SoyExpression visitPluginFunction(FunctionNode node) {
            Object fn = node.getSoyFunction();
            if (fn instanceof SoyJavaSourceFunction) {
                return this.sourceFunctionCompiler.compile(node, (SoyJavaSourceFunction)fn, this.visitChildren(node), this.parameters, this.detacher);
            }
            if (fn instanceof FunctionNode.ExternRef) {
                return this.callExtern((FunctionNode.ExternRef)fn, node.getParams());
            }
            return SoyExpression.forSoyValue(node.getType(), this.parameters.getRenderContext().getPluginInstance(node.getStaticFunctionName()).checkedCast(SoyJavaFunction.class).invoke(MethodRefs.SOY_JAVA_FUNCTION_COMPUTE_FOR_JAVA, SoyExpression.asBoxedValueProviderList(this.visitChildren(node))).checkedSoyCast(node.getType()));
        }

        private SoyExpression callExtern(FunctionNode.ExternRef extern, List<ExprNode> params) {
            String namespace = this.fileSetMetadata.getNamespaceForPath(extern.path());
            final TypeInfo externOwner = TypeInfo.createClass(Names.javaClassNameFromSoyNamespace(namespace));
            final Method asmMethod = ExternCompiler.buildMemberMethod(extern.name(), extern.signature());
            MethodRef ref = MethodRef.createStaticMethod(externOwner, asmMethod, MethodRef.MethodPureness.NON_PURE);
            SoyRuntimeType soyReturnType = ExternCompiler.getRuntimeType(extern.signature().getReturnType());
            final ArrayList<Expression> args = new ArrayList<Expression>();
            args.add(this.parameters.getRenderContext());
            for (int i = 0; i < params.size(); ++i) {
                args.add(CompilerVisitor.adaptExternArg(this.visit(params.get(i)), ((FunctionType.Parameter)extern.signature().getParameters().get(i)).getType()));
            }
            if (namespace.equals(this.context.getNearestAncestor(SoyFileNode.class).getNamespace())) {
                return SoyExpression.forRuntimeType(soyReturnType, ref.invoke(args));
            }
            Expression externCall = new Expression(this, soyReturnType.runtimeType()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    for (Expression arg : args) {
                        arg.gen(adapter);
                    }
                    adapter.visitInvokeDynamicInsn("call", asmMethod.getDescriptor(), CALL_EXTERN_HANDLE, new Object[]{externOwner.className(), asmMethod.getName()});
                }
            };
            return SoyExpression.forRuntimeType(soyReturnType, externCall);
        }

        private static Expression adaptExternArg(SoyExpression soyExpression, SoyType type) {
            SoyRuntimeType runtimeType = ExternCompiler.getRuntimeType(type);
            Type javaType = runtimeType.runtimeType();
            if (javaType.equals((Object)Type.BOOLEAN_TYPE)) {
                return soyExpression.coerceToBoolean().unboxAsBoolean();
            }
            if (javaType.equals((Object)Type.LONG_TYPE)) {
                return soyExpression.unboxAsLong();
            }
            if (javaType.equals((Object)BytecodeUtils.STRING_TYPE)) {
                return soyExpression.unboxAsStringOrJavaNull();
            }
            if (javaType.equals((Object)Type.DOUBLE_TYPE)) {
                return soyExpression.coerceToDouble().unboxAsDouble();
            }
            if (javaType.getSort() == 10) {
                SoyType nonNullableType = SoyTypes.tryRemoveNullish(type);
                if (nonNullableType.getKind() == SoyType.Kind.ANY || nonNullableType.getKind() == SoyType.Kind.UNKNOWN) {
                    return soyExpression.boxWithSoyNullAsJavaNull();
                }
                if (nonNullableType.getKind() == SoyType.Kind.PROTO) {
                    return soyExpression.unboxAsMessageOrJavaNull(ProtoUtils.messageRuntimeType(((SoyProtoType)nonNullableType).getDescriptor()).type());
                }
                if (nonNullableType.getKind() == SoyType.Kind.MESSAGE) {
                    return soyExpression.unboxAsMessageOrJavaNull(BytecodeUtils.MESSAGE_TYPE);
                }
                if (type.getKind() == SoyType.Kind.PROTO_ENUM) {
                    return soyExpression.unboxAsLong();
                }
                if (nonNullableType.getKind() == SoyType.Kind.LIST) {
                    return soyExpression.unboxAsListOrJavaNull();
                }
                if (javaType.equals((Object)BytecodeUtils.SOY_VALUE_TYPE)) {
                    return soyExpression.box().checkedCast(javaType);
                }
                return soyExpression.boxWithSoyNullishAsJavaNull().checkedCast(javaType);
            }
            return soyExpression;
        }

        @Override
        protected SoyExpression visitProtoInitFunction(FunctionNode node) {
            return ProtoUtils.createProto(node, this::visit, this.detacher, this.varManager);
        }

        @Override
        protected SoyExpression visitVeDefNode(FunctionNode node) {
            Expression visualElement;
            Expression id = BytecodeUtils.constant(((IntegerNode)node.getParam(1)).getValue());
            Expression name = BytecodeUtils.constant(((StringNode)node.getParam(0)).getValue());
            if (node.numParams() == 4) {
                SoyExpression metadata = this.visitProtoInitFunction((FunctionNode)node.getParam(3));
                visualElement = MethodRefs.SOY_VISUAL_ELEMENT_CREATE_WITH_METADATA.invoke(id, name, metadata);
            } else {
                visualElement = MethodRefs.SOY_VISUAL_ELEMENT_CREATE.invoke(id, name);
            }
            return SoyExpression.forSoyValue(node.getType(), visualElement);
        }

        @Override
        protected SoyExpression visitTemplateLiteralNode(final TemplateLiteralNode node) {
            if (CompiledTemplateMetadata.isPrivateReference(this.context, node)) {
                Expression templateValue = MethodRef.createStaticMethod(TypeInfo.createClass(Names.javaClassNameFromSoyTemplateName(node.getResolvedName())), CompiledTemplateMetadata.createTemplateMethod(Names.renderMethodNameFromSoyTemplateName(node.getResolvedName())), MethodRef.MethodPureness.PURE).asCheap().asNonJavaNullable().invoke(new Expression[0]);
                return SoyExpression.forSoyValue(node.getType(), MethodRefs.CREATE_TEMPLATE_VALUE.invoke(BytecodeUtils.constant(node.getResolvedName()), templateValue));
            }
            final RenderContextExpression renderContext = this.parameters.getRenderContext();
            return SoyExpression.forSoyValue(node.getType(), new Expression(this, BytecodeUtils.TEMPLATE_VALUE_TYPE, Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, new Expression.Feature[0])){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    renderContext.gen(adapter);
                    adapter.visitInvokeDynamicInsn("create", TEMPLATE_VALUE_SIGNATURE, GET_TEMPLATE_VALUE_HANDLE, new Object[]{node.getResolvedName()});
                }
            });
        }

        @Override
        protected SoyExpression visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException("Support for " + String.valueOf((Object)node.getKind()) + " has not been added yet");
        }
    }

    static final class BasicExpressionCompiler {
        private final CompilerVisitor compilerVisitor;

        private BasicExpressionCompiler(SoyNode context, TemplateAnalysis analysis, TemplateParameterLookup parameters, LocalVariableManager varManager, JavaSourceFunctionCompiler sourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
            this.compilerVisitor = new CompilerVisitor(context, analysis, parameters, varManager, ExpressionDetacher.BasicDetacher.INSTANCE, sourceFunctionCompiler, fileSetMetadata, false);
        }

        private BasicExpressionCompiler(CompilerVisitor visitor) {
            this.compilerVisitor = visitor;
        }

        SoyExpression compile(ExprNode expr) {
            return (SoyExpression)this.compilerVisitor.exec(expr);
        }

        List<SoyExpression> compileToList(List<? extends ExprNode> children) {
            ArrayList<SoyExpression> soyExprs = new ArrayList<SoyExpression>(children.size());
            for (ExprNode exprNode : children) {
                soyExprs.add(this.compile(exprNode));
            }
            return soyExprs;
        }
    }
}

