/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_DetachState_ReattachState;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.jbcsrc.shared.ExtraConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;

final class DetachState
implements ExpressionDetacher.Factory {
    static final boolean FORCE_EVERY_DETACH_POINT = Boolean.getBoolean("soy_jbcsrc_take_every_detach_point");
    private final TemplateVariableManager variables;
    private final List<ReattachState> reattaches = new ArrayList<ReattachState>();
    private final Supplier<RenderContextExpression> renderContextExpression;
    int disabledCount;

    DetachState(TemplateVariableManager variables, Supplier<RenderContextExpression> renderContextExpression) {
        this.variables = variables;
        this.renderContextExpression = renderContextExpression;
    }

    NoNewDetaches expectNoNewDetaches() {
        ++this.disabledCount;
        return () -> {
            --this.disabledCount;
            if (this.disabledCount < 0) {
                throw new AssertionError();
            }
        };
    }

    private void checkDetachesAllowed() {
        if (this.disabledCount > 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public ExpressionDetacher createExpressionDetacher(Label reattachPoint) {
        return new ExpressionDetacher.BasicDetacher(() -> this.addState(reattachPoint));
    }

    Statement detachLimited(AppendableExpression appendable) {
        this.checkDetachesAllowed();
        this.variables.assertSaveRestoreStateIsEmpty();
        if (!appendable.supportsSoftLimiting()) {
            return appendable.toStatement();
        }
        final Expression isSoftLimited = appendable.softLimitReached();
        final Statement returnLimited = Statement.returnExpression(MethodRefs.RENDER_RESULT_LIMITED.invoke(new Expression[0]));
        return new Statement(this){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label continueLabel = new Label();
                isSoftLimited.gen(adapter);
                if (FORCE_EVERY_DETACH_POINT) {
                    adapter.visitLdcInsn(ForceDetachPointsForTesting.uniqueCallSite());
                    ForceDetachPointsForTesting.MAYBE_FORCE_LIMITED.invokeUnchecked(adapter);
                }
                adapter.ifZCmp(153, continueLabel);
                returnLimited.gen(adapter);
                adapter.mark(continueLabel);
            }
        };
    }

    Statement assertFullyRenderered(Expression render) {
        return render.invokeVoid(MethodRefs.RENDER_RESULT_ASSERT_DONE, new Expression[0]);
    }

    Statement detachForRender(final Expression render) {
        this.checkDetachesAllowed();
        Preconditions.checkArgument((boolean)render.resultType().equals((Object)BytecodeUtils.RENDER_RESULT_TYPE));
        final Label reattachPoint = new Label();
        final Statement saveState = this.addState(reattachPoint);
        return new Statement(this){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end;
                adapter.mark(reattachPoint);
                if (FORCE_EVERY_DETACH_POINT) {
                    MethodRefs.RENDER_RESULT_DONE.invokeUnchecked(adapter);
                    adapter.visitLdcInsn(ForceDetachPointsForTesting.uniqueCallSite());
                    ForceDetachPointsForTesting.MAYBE_FORCE_CONTINUE_AFTER.invokeUnchecked(adapter);
                    adapter.dup();
                    MethodRefs.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                    end = new Label();
                    adapter.ifZCmp(154, end);
                    saveState.gen(adapter);
                    adapter.returnValue();
                    adapter.mark(end);
                    adapter.pop();
                }
                render.gen(adapter);
                adapter.dup();
                MethodRefs.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                end = new Label();
                adapter.ifZCmp(154, end);
                saveState.gen(adapter);
                adapter.returnValue();
                adapter.mark(end);
                adapter.pop();
            }
        };
    }

    Statement generateReattachTable() {
        if (this.reattaches.isEmpty()) {
            return Statement.NULL_STATEMENT;
        }
        TemplateVariableManager.Scope stackFrameScope = this.variables.enterScope();
        LocalVariable stackFrameVar = stackFrameScope.createTemporary("$stackFrame", BytecodeUtils.STACK_FRAME_TYPE);
        Statement initStackFrame = stackFrameVar.initialize(this.renderContextExpression.get().popFrame());
        final Expression readStateNumber = FieldRef.STACK_FRAME_STATE_NUMBER.accessor(stackFrameVar);
        final Label unexpectedState = new Label();
        Label end = new Label();
        final ArrayList<Label> caseLabels = new ArrayList<Label>();
        ArrayList<Statement> casesToGen = new ArrayList<Statement>();
        caseLabels.add(end);
        for (final ReattachState reattachState : this.reattaches) {
            if (reattachState.restoreStatement().isPresent()) {
                final Statement restoreState = reattachState.restoreStatement().get().apply(stackFrameVar);
                final Label caseLabel = new Label();
                casesToGen.add(new Statement(this){

                    @Override
                    protected void doGen(CodeBuilder cb) {
                        cb.mark(caseLabel);
                        restoreState.gen(cb);
                        cb.goTo(reattachState.reattachPoint());
                    }
                });
                caseLabels.add(caseLabel);
                continue;
            }
            caseLabels.add(reattachState.reattachPoint());
        }
        casesToGen.add(Statement.throwExpression(MethodRefs.RUNTIME_UNEXPECTED_STATE_ERROR.invoke(stackFrameVar)).labelStart(unexpectedState));
        final Statement scopeExit = stackFrameScope.exitScope();
        return Statement.concat(initStackFrame, new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                readStateNumber.gen(adapter);
                scopeExit.gen(adapter);
                adapter.visitTableSwitchInsn(0, DetachState.this.reattaches.size(), unexpectedState, caseLabels.toArray(new Label[0]));
            }
        }, Statement.concat(casesToGen)).labelEnd(end);
    }

    private Statement addState(Label reattachPoint) {
        this.checkDetachesAllowed();
        int stateNumber = this.reattaches.size() + 1;
        TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState(this.renderContextExpression.get(), stateNumber);
        ReattachState create = ReattachState.create(reattachPoint, saveRestoreState.restore());
        this.reattaches.add(create);
        return saveRestoreState.save();
    }

    @AutoValue
    static abstract class ReattachState {
        ReattachState() {
        }

        static ReattachState create(Label reattachPoint, Optional<Function<LocalVariable, Statement>> restore) {
            return new AutoValue_DetachState_ReattachState(reattachPoint, restore);
        }

        abstract Label reattachPoint();

        abstract Optional<Function<LocalVariable, Statement>> restoreStatement();
    }

    static interface NoNewDetaches
    extends AutoCloseable {
        @Override
        public void close();
    }

    static final class ForceDetachPointsForTesting {
        private static final Handle CALL_SITE_KEY_HANDLE = MethodRef.createPure(ExtraConstantBootstraps.class, "callSiteKey", MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE).asHandle();
        static final MethodRef MAYBE_FORCE_LIMITED = MethodRef.createNonPure(JbcSrcRuntime.EveryDetachStateForTesting.class, "maybeForceLimited", Boolean.TYPE, Object.class);
        static final MethodRef MAYBE_FORCE_CONTINUE_AFTER = MethodRef.createNonPure(JbcSrcRuntime.EveryDetachStateForTesting.class, "maybeForceContinueAfter", RenderResult.class, Object.class);
        private static final AtomicInteger counter = new AtomicInteger();

        private ForceDetachPointsForTesting() {
        }

        static ConstantDynamic uniqueCallSite() {
            return new ConstantDynamic("callsite", BytecodeUtils.OBJECT.type().getDescriptor(), CALL_SITE_KEY_HANDLE, new Object[]{counter.getAndIncrement()});
        }
    }
}

