/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode.javatypes;

import com.google.template.soy.javagencode.javatypes.CodeGenUtils;
import com.google.template.soy.javagencode.javatypes.JavaType;

public final class MapJavaType
extends JavaType {
    public static final CodeGenUtils.Member AS_MAP = CodeGenUtils.castFunction("asMap");
    public static final CodeGenUtils.Member AS_NULLABLE_MAP = CodeGenUtils.castFunction("asNullableMap");
    public static final CodeGenUtils.Member AS_NULLABLE_LEGACY_OBJECT_MAP = CodeGenUtils.castFunction("asNullableLegacyObjectMap");
    public static final CodeGenUtils.Member AS_LEGACY_OBJECT_MAP = CodeGenUtils.castFunction("asLegacyObjectMap");
    private final JavaType keyType;
    private final JavaType valueType;
    private final boolean shouldMarkAsSoyMap;

    public MapJavaType(JavaType keyType, JavaType valueType, boolean shouldMarkAsSoyMap) {
        this(keyType, valueType, shouldMarkAsSoyMap, false);
    }

    public MapJavaType(JavaType keyType, JavaType valueType, boolean shouldMarkAsSoyMap, boolean isNullable) {
        super(isNullable);
        this.keyType = keyType;
        this.valueType = valueType;
        this.shouldMarkAsSoyMap = shouldMarkAsSoyMap;
    }

    @Override
    public String toJavaTypeString() {
        return "java.util.Map<" + this.keyType.asGenericsTypeArgumentString() + ", " + this.valueType.asGenericsTypeArgumentString() + ">";
    }

    @Override
    String asGenericsTypeArgumentString() {
        return "? extends " + this.toJavaTypeString();
    }

    @Override
    public String asInlineCast(String variableName, int depth) {
        if (this.shouldMarkAsSoyMap) {
            return String.valueOf(this.isNullable() ? AS_NULLABLE_MAP : AS_MAP) + "(" + variableName + ", " + this.keyType.getAsInlineCastFunction(depth) + ", " + this.valueType.getAsInlineCastFunction(depth) + ")";
        }
        return String.valueOf(this.isNullable() ? AS_NULLABLE_LEGACY_OBJECT_MAP : AS_LEGACY_OBJECT_MAP) + "(" + variableName + ", " + this.valueType.getAsInlineCastFunction(depth) + ")";
    }

    JavaType getKeyType() {
        return this.keyType;
    }

    JavaType getValueType() {
        return this.valueType;
    }

    @Override
    public MapJavaType asNullable() {
        return new MapJavaType(this.keyType, this.valueType, this.shouldMarkAsSoyMap, true);
    }
}

