/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode.javatypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.template.soy.javagencode.javatypes.JavaType;
import com.google.template.soy.javagencode.javatypes.ListJavaType;
import com.google.template.soy.javagencode.javatypes.MapJavaType;
import com.google.template.soy.javagencode.javatypes.ProtoEnumJavaType;
import com.google.template.soy.javagencode.javatypes.ProtoJavaType;
import com.google.template.soy.javagencode.javatypes.RecordJavaType;
import com.google.template.soy.javagencode.javatypes.SimpleJavaType;
import com.google.template.soy.javagencode.javatypes.TemplateJavaType;
import com.google.template.soy.javagencode.javatypes.VeDataJavaType;
import com.google.template.soy.javagencode.javatypes.VeJavaType;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class JavaTypeUtils {
    private JavaTypeUtils() {
    }

    public static ImmutableList<JavaType> getJavaTypes(SoyType soyType) {
        return JavaTypeUtils.getJavaTypes(soyType, (Set<SoyType.Kind>)ImmutableSet.of());
    }

    public static ImmutableList<JavaType> getJavaTypes(SoyType soyType, Set<SoyType.Kind> skipSoyTypes) {
        boolean nonLegacyMap = true;
        ImmutableList types = ImmutableList.of();
        SoyType.Kind kind = soyType.getKind();
        if (skipSoyTypes.contains((Object)kind)) {
            return types;
        }
        switch (kind) {
            case BOOL: {
                types = ImmutableList.of((Object)SimpleJavaType.BOOLEAN);
                break;
            }
            case INT: {
                types = ImmutableList.of((Object)SimpleJavaType.INT);
                break;
            }
            case FLOAT: {
                types = ImmutableList.of((Object)SimpleJavaType.FLOAT);
                break;
            }
            case STRING: {
                types = ImmutableList.of((Object)SimpleJavaType.STRING);
                break;
            }
            case ELEMENT: 
            case HTML: {
                types = ImmutableList.of((Object)SimpleJavaType.HTML);
                break;
            }
            case JS: {
                types = ImmutableList.of((Object)SimpleJavaType.JS);
                break;
            }
            case URI: {
                types = ImmutableList.of((Object)SimpleJavaType.URL);
                break;
            }
            case TRUSTED_RESOURCE_URI: {
                types = ImmutableList.of((Object)SimpleJavaType.TRUSTED_RESOURCE_URL);
                break;
            }
            case MESSAGE: {
                types = ImmutableList.of((Object)SimpleJavaType.MESSAGE);
                break;
            }
            case PROTO: {
                SoyProtoType asProto = (SoyProtoType)soyType;
                types = ImmutableList.of((Object)new ProtoJavaType(asProto.getDescriptor()));
                break;
            }
            case PROTO_ENUM: {
                SoyProtoEnumType asProtoEnum = (SoyProtoEnumType)soyType;
                types = ImmutableList.of((Object)new ProtoEnumJavaType(asProtoEnum.getDescriptor()));
                break;
            }
            case LIST: {
                SoyType elementType = ((ListType)soyType).getElementType();
                if (elementType.getKind() == SoyType.Kind.RECORD) {
                    types = JavaTypeUtils.trySimpleRecordType((RecordType)elementType, true, skipSoyTypes);
                    break;
                }
                ImmutableList<JavaType> listElementTypes = JavaTypeUtils.getJavaTypes(elementType, skipSoyTypes);
                if (listElementTypes.size() == 1 && ((JavaType)listElementTypes.get(0)).isGenericsTypeSupported()) {
                    return ImmutableList.of((Object)new ListJavaType((JavaType)listElementTypes.get(0)));
                }
                types = ImmutableList.of();
                break;
            }
            case LEGACY_OBJECT_MAP: {
                nonLegacyMap = false;
            }
            case MAP: {
                ImmutableList<JavaType> valueTypes;
                AbstractMapType soyAbstractMapType = (AbstractMapType)soyType;
                ImmutableList<JavaType> keyTypes = JavaTypeUtils.getJavaTypes(soyAbstractMapType.getKeyType(), skipSoyTypes);
                if (keyTypes.size() != 1 || !((JavaType)keyTypes.get(0)).isGenericsTypeSupported() || (valueTypes = JavaTypeUtils.getJavaTypes(soyAbstractMapType.getValueType(), skipSoyTypes)).size() != 1 || !((JavaType)valueTypes.get(0)).isGenericsTypeSupported()) break;
                types = ImmutableList.of((Object)new MapJavaType((JavaType)keyTypes.get(0), (JavaType)valueTypes.get(0), nonLegacyMap));
                break;
            }
            case UNION: {
                types = JavaTypeUtils.convertSoyUnionTypeToJavaTypes((UnionType)soyType, skipSoyTypes);
                break;
            }
            case ANY: 
            case UNKNOWN: {
                types = ImmutableList.of((Object)SimpleJavaType.OBJECT.asNullable());
                break;
            }
            case ATTRIBUTES: {
                types = ImmutableList.of((Object)SimpleJavaType.ATTRIBUTES);
                break;
            }
            case CSS: {
                types = ImmutableList.of((Object)SimpleJavaType.CSS);
                break;
            }
            case RECORD: {
                types = JavaTypeUtils.trySimpleRecordType((RecordType)soyType, false, skipSoyTypes);
                break;
            }
            case TEMPLATE: {
                types = ImmutableList.of((Object)new TemplateJavaType((TemplateType)soyType));
                break;
            }
            case VE: {
                types = ImmutableList.of((Object)new VeJavaType());
                break;
            }
            case VE_DATA: {
                types = ImmutableList.of((Object)new VeDataJavaType());
                break;
            }
            case CSS_TYPE: 
            case CSS_MODULE: 
            case TOGGLE_TYPE: 
            case PROTO_TYPE: 
            case PROTO_ENUM_TYPE: 
            case PROTO_EXTENSION: 
            case PROTO_MODULE: 
            case TEMPLATE_TYPE: 
            case TEMPLATE_MODULE: 
            case FUNCTION: {
                throw new UnsupportedOperationException();
            }
        }
        return types;
    }

    public static ImmutableList<JavaType> makeNullable(List<JavaType> types) {
        return (ImmutableList)types.stream().map(JavaType::asNullable).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<JavaType> trySimpleRecordType(RecordType recordType, boolean list, Set<SoyType.Kind> skipSoyTypes) {
        Preconditions.checkArgument((!recordType.getMembers().isEmpty() ? 1 : 0) != 0);
        if (Streams.stream(SoyTypes.getTypeTraverser(recordType, null)).anyMatch(t -> t.getKind() == SoyType.Kind.RECORD && t != recordType)) {
            return ImmutableList.of();
        }
        ImmutableMap.Builder javaTypeMap = ImmutableMap.builder();
        for (RecordType.Member member : recordType.getMembers()) {
            ImmutableList<JavaType> types = JavaTypeUtils.getJavaTypes(member.checkedType(), skipSoyTypes);
            if (types.size() != 1) {
                return ImmutableList.of();
            }
            javaTypeMap.put((Object)member.name(), (Object)((JavaType)types.get(0)));
        }
        return ImmutableList.of((Object)new RecordJavaType((ImmutableMap<String, JavaType>)javaTypeMap.build(), list));
    }

    public static boolean isJavaIncompatible(SoyType type) {
        switch (type.getKind()) {
            case UNION: {
                return ((UnionType)type).getMembers().stream().anyMatch(JavaTypeUtils::isJavaIncompatible);
            }
            case VE: 
            case VE_DATA: {
                return true;
            }
        }
        return false;
    }

    public static Optional<SoyType> upcastTypesForIndirectParams(Set<SoyType> allTypes) {
        SoyType second;
        SoyType secondNotNullish;
        Iterator<SoyType> i;
        SoyType first;
        SoyType firstNotNullish;
        if (allTypes.size() == 1) {
            return Optional.of((SoyType)Iterables.getOnlyElement(allTypes));
        }
        if (allTypes.contains(UnknownType.getInstance())) {
            return Optional.of(UnknownType.getInstance());
        }
        if (allTypes.size() == 2 && (firstNotNullish = SoyTypes.tryRemoveNullish(first = (i = allTypes.iterator()).next())).equals(secondNotNullish = SoyTypes.tryRemoveNullish(second = i.next()))) {
            return Optional.of(UnionType.of(first, second));
        }
        return Optional.empty();
    }

    private static ImmutableList<JavaType> convertSoyUnionTypeToJavaTypes(UnionType unionType, Set<SoyType.Kind> skipSoyTypes) {
        if (SoyTypes.isNullish(unionType) && SoyTypes.tryRemoveNullish(unionType).equals(SoyTypes.NUMBER_TYPE)) {
            return ImmutableList.of((Object)SimpleJavaType.NUMBER.asNullable());
        }
        if (unionType.equals(UnionType.of(IntType.getInstance(), FloatType.getInstance()))) {
            return ImmutableList.of((Object)SimpleJavaType.NUMBER);
        }
        boolean unionAllowsNull = unionType.getMembers().stream().anyMatch(SoyType::isNullOrUndefined);
        ImmutableList.Builder javaTypeListBuilder = new ImmutableList.Builder();
        for (SoyType soyUnionMemberType : unionType.getMembers()) {
            if (soyUnionMemberType.isNullOrUndefined()) continue;
            ImmutableList<JavaType> javaTypesForUnionMember = JavaTypeUtils.getJavaTypes(soyUnionMemberType, skipSoyTypes);
            if (unionAllowsNull) {
                javaTypesForUnionMember = JavaTypeUtils.makeNullable(javaTypesForUnionMember);
            }
            if (javaTypesForUnionMember.isEmpty()) {
                return ImmutableList.of();
            }
            javaTypeListBuilder.addAll(javaTypesForUnionMember);
        }
        return JavaTypeUtils.clearListIfHasTypeErasureOverloadCollisions((ImmutableList<JavaType>)javaTypeListBuilder.build());
    }

    private static ImmutableList<JavaType> clearListIfHasTypeErasureOverloadCollisions(ImmutableList<JavaType> types) {
        long numTopLevelListTypes = types.stream().filter(type -> type instanceof ListJavaType).count();
        long numTopLevelMapTypes = types.stream().filter(type -> type instanceof MapJavaType).count();
        if (numTopLevelListTypes > 1L || numTopLevelMapTypes > 1L) {
            return ImmutableList.of();
        }
        return types;
    }
}

