/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode.javatypes;

import com.google.common.base.Strings;

public abstract class JavaType {
    private final boolean isNullable;

    JavaType(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public abstract String toJavaTypeString();

    public final String asInlineCast(String variableName) {
        return this.asInlineCast(variableName, 0);
    }

    abstract String asInlineCast(String var1, int var2);

    public boolean isNullable() {
        return this.isNullable;
    }

    public abstract JavaType asNullable();

    public String getAsInlineCastFunction(int depth) {
        String lambdaName = "v" + String.valueOf(depth == 0 ? "" : Integer.valueOf(depth));
        return lambdaName + " -> " + this.asInlineCast(lambdaName, depth + 1);
    }

    abstract String asGenericsTypeArgumentString();

    public boolean isGenericsTypeSupported() {
        return !Strings.isNullOrEmpty((String)this.asGenericsTypeArgumentString());
    }

    public String asTypeLiteralString() {
        return this.toJavaTypeString();
    }

    public boolean isTypeLiteralSupported() {
        return true;
    }
}

