/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode.javatypes;

import com.google.common.base.Preconditions;
import com.google.template.soy.javagencode.javatypes.CodeGenUtils;
import com.google.template.soy.javagencode.javatypes.JavaType;

public final class FutureJavaType
extends JavaType {
    private static final CodeGenUtils.Member AS_FUTURE = CodeGenUtils.castFunction("asFuture");
    private final JavaType type;

    public FutureJavaType(JavaType type) {
        super(false);
        Preconditions.checkArgument((boolean)type.isGenericsTypeSupported());
        this.type = type;
    }

    @Override
    public String toJavaTypeString() {
        return "java.util.concurrent.Future<" + this.type.asGenericsTypeArgumentString() + ">";
    }

    @Override
    String asGenericsTypeArgumentString() {
        return null;
    }

    public JavaType getType() {
        return this.type;
    }

    @Override
    public String asInlineCast(String variableName, int depth) {
        return String.valueOf(AS_FUTURE) + "(" + variableName + ", " + this.type.getAsInlineCastFunction(depth) + ")";
    }

    @Override
    public JavaType asNullable() {
        return this;
    }
}

