/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode;

import com.google.common.base.Joiner;
import com.google.common.base.Utf8;
import com.google.protobuf.Message;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.javagencode.SoyFileNodeTransformer;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class KytheHelper {
    private final String kytheCorpus;

    public KytheHelper(String kytheCorpus) {
        this.kytheCorpus = kytheCorpus;
    }

    public boolean isEnabled() {
        return !this.kytheCorpus.isEmpty();
    }

    @Nullable
    public Message getGeneratedCodeInfo() {
        if (!this.isEnabled()) {
            return null;
        }
        return null;
    }

    public void addKytheLinkTo(Span classNameSpan, SoyFileNode file) {
        if (!this.isEnabled()) {
            return;
        }
    }

    public void addKytheLinkTo(Span templateNameSpan, SoyFileNodeTransformer.TemplateInfo template) {
        this.addKytheLinkTo(templateNameSpan, template.sourceLocation(), template.template());
    }

    public void addKytheLinkTo(Span templateNameSpan, TemplateNode template) {
        this.addKytheLinkTo(templateNameSpan, template.getTemplateNameLocation(), template);
    }

    private void addKytheLinkTo(Span templateNameSpan, SourceLocation sourceLocation, TemplateNode template) {
        if (!this.isEnabled()) {
            return;
        }
    }

    public void addKytheLinkTo(Span paramSpan, SoyFileNodeTransformer.ParamInfo paramInfo, SoyFileNodeTransformer.TemplateInfo template) {
        this.addKytheLinkTo(paramSpan, template.sourceLocation(), template.template(), paramInfo.param().getName());
    }

    public void addKytheLinkTo(Span paramSpan, TemplateNode template, TemplateParam param) {
        this.addKytheLinkTo(paramSpan, param.nameLocation(), template, param.name());
    }

    private void addKytheLinkTo(Span paramSpan, SourceLocation location, TemplateNode template, String paramName) {
        if (!this.isEnabled()) {
            return;
        }
    }

    public List<Span> appendLineStartAndGetSpans(IndentedLinesBuilder ilb, String ... parts) {
        return this.appendAndGetSpans(ilb, false, parts);
    }

    public List<Span> appendLineAndGetSpans(IndentedLinesBuilder ilb, String ... parts) {
        return this.appendAndGetSpans(ilb, true, parts);
    }

    private List<Span> appendAndGetSpans(IndentedLinesBuilder ilb, boolean fullLine, String ... parts) {
        String line = Joiner.on((String)"").join((Object[])parts);
        if (fullLine) {
            ilb.appendLine(line);
        } else {
            ilb.appendLineStart(line);
        }
        int endingLength = ilb.getByteLength();
        int partStart = endingLength - Utf8.encodedLength((CharSequence)line) - (fullLine ? 1 : 0);
        ArrayList<Span> spans = new ArrayList<Span>(parts.length);
        for (String part : parts) {
            int partEnd = partStart + Utf8.encodedLength((CharSequence)part);
            spans.add(new Span(partStart, partEnd));
            partStart = partEnd;
        }
        return spans;
    }

    static final class Span {
        private final int start;
        private final int end;

        public Span(int startOffset, int endOffset) {
            this.start = startOffset;
            this.end = endOffset;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

