/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class TreeStreams {
    private TreeStreams() {
    }

    public static <T> Stream<? extends T> ancestor(final T root, final Function<T, ? extends T> ancestor) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 17){
            private T next;
            {
                super(est, additionalCharacteristics);
                this.next = root;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.next == null) {
                    return false;
                }
                action.accept(this.next);
                this.next = ancestor.apply(this.next);
                return true;
            }
        }, false);
    }

    public static <T> Stream<? extends T> breadthFirst(T root, Function<T, Iterable<? extends T>> successors) {
        return TreeStreams.breadthFirstInternal(root, (queue, next) -> Iterables.addAll((Collection)queue, (Iterable)((Iterable)successors.apply(next))));
    }

    public static <T> Stream<? extends T> breadthFirstWithStream(T root, Function<T, Stream<? extends T>> successors) {
        return TreeStreams.breadthFirstInternal(root, (queue, next) -> ((Stream)successors.apply(next)).forEach(queue::add));
    }

    private static <T> Stream<? extends T> breadthFirstInternal(T root, final BiConsumer<Deque<T>, T> pusher) {
        final ArrayDeque<T> queue = new ArrayDeque<T>();
        queue.add(root);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 17){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object next = queue.poll();
                if (next == null) {
                    return false;
                }
                pusher.accept(queue, next);
                action.accept(next);
                return true;
            }
        }, false);
    }

    public static <T> Stream<? extends T> depthFirst(T root, final Function<T, Iterable<? extends T>> successors) {
        final ArrayDeque<T> stack = new ArrayDeque<T>();
        stack.add(root);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 17){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object next = stack.poll();
                if (next == null) {
                    return false;
                }
                Iterable children = (Iterable)successors.apply(next);
                List reverseOrder = children instanceof List ? Lists.reverse((List)((List)children)) : ImmutableList.copyOf((Iterable)children).reverse();
                for (Object child : reverseOrder) {
                    stack.push(child);
                }
                action.accept(next);
                return true;
            }
        }, false);
    }

    public static <T> Stream<T> collateAndMerge(Stream<? extends T> source, final BiPredicate<T, T> accept, final Function<List<T>, T> merger) {
        final PeekingIterator i = Iterators.peekingIterator(source.iterator());
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!i.hasNext()) {
                    return false;
                }
                Object next = i.next();
                ArrayList<Object> merged = null;
                while (i.hasNext() && accept.test(next, i.peek())) {
                    if (merged == null) {
                        merged = new ArrayList<Object>();
                        merged.add(next);
                    }
                    next = i.next();
                    merged.add(next);
                }
                if (merged != null) {
                    action.accept(merger.apply(merged));
                } else {
                    action.accept(next);
                }
                return true;
            }
        }, false);
    }
}

