/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import java.util.Set;

public abstract class Field {
    private final Descriptors.FieldDescriptor fieldDesc;
    private final String name;
    private final String fullyQualifiedName;

    public static <T extends Field> ImmutableMap<String, T> getFieldsForType(Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions, Factory<T> factory) {
        T field;
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) continue;
            field = factory.create(fieldDescriptor);
            fields.put((Object)((Field)field).getName(), field);
        }
        for (Descriptors.FieldDescriptor extension : extensions) {
            field = factory.create(extension);
            fields.put((Object)((Field)field).getFullyQualifiedName(), field);
        }
        return fields.build();
    }

    protected Field(Descriptors.FieldDescriptor fieldDesc) {
        this.fieldDesc = (Descriptors.FieldDescriptor)Preconditions.checkNotNull((Object)fieldDesc);
        this.name = Field.computeSoyName(fieldDesc);
        this.fullyQualifiedName = Field.computeSoyFullyQualifiedName(fieldDesc);
    }

    public final String getName() {
        return this.name;
    }

    public final String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final Descriptors.FieldDescriptor getDescriptor() {
        return this.fieldDesc;
    }

    public static String computeSoyName(Descriptors.FieldDescriptor field) {
        String result = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
        String lowerCamelCaseGuarantee = Ascii.toLowerCase((String)result.substring(0, Math.min(1, result.length()))) + result.substring(Math.min(1, result.length()));
        return lowerCamelCaseGuarantee + Field.fieldSuffix(field);
    }

    public static String computeSoyFullyQualifiedName(Descriptors.FieldDescriptor field) {
        String fieldPath = !field.isExtension() ? field.getContainingType().getFullName() : (field.getExtensionScope() != null ? field.getExtensionScope().getFullName() : field.getFile().getPackage());
        return fieldPath + "." + Field.computeSoyName(field);
    }

    private static String fieldSuffix(Descriptors.FieldDescriptor field) {
        if (field.isMapField()) {
            return "Map";
        }
        if (field.isRepeated()) {
            return "List";
        }
        return "";
    }

    public static interface Factory<T extends Field> {
        public T create(Descriptors.FieldDescriptor var1);
    }
}

