/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class GenIncrementalDomInteropVisitor
extends GenJsCodeVisitor {
    private List<String> jsFilesContents;
    private JsCodeBuilder codeBuilder;
    private GoogRequire idomGoogRequire;
    private GoogRequire soyJsGoogRequire;
    private final Expression shouldStub = JsRuntime.GOOG_SOY_ALIAS.dotAccess("shouldStub");

    GenIncrementalDomInteropVisitor(SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, DelTemplateNamer delTemplateNamer, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        super(jsSrcOptions, javaScriptValueFactory, delTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitorFactory, typeRegistry);
    }

    public List<String> gen(SoyFileSetNode node, ErrorReporter errorReporter) {
        this.jsFilesContents = new ArrayList<String>();
        this.visit(node);
        return this.jsFilesContents;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    private void addCodeToDeclareGoogModule(StringBuilder header, SoyFileNode soyFile) {
        String exportNamespace = soyFile.getNamespace() + ".idominterop";
        header.append("goog.module('").append(exportNamespace).append("');\n\n");
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.getVisibility() != Visibility.PUBLIC) {
            return;
        }
        boolean hasPositionalSignature = GenCallCodeUtils.hasPositionalSignature(TemplateMetadata.buildTemplateType(node));
        if (!hasPositionalSignature && node.getContentKind() == SanitizedContentKind.HTML) {
            this.codeBuilder.append(Statements.ifStatement(this.shouldStub, Statements.assign(this.soyJsGoogRequire.dotAccess(node.getPartialTemplateName() + "_soyInternalStubs"), Expressions.arrowFunction(JsDoc.builder().addParam("$data", "?").addParam("$ijData", "?").build(), IncrementalDomRuntime.SOY_IDOM_MAKE_HTML.call(Expressions.arrowFunction(JsDoc.builder().build(), this.idomGoogRequire.reference().dotAccess(node.getPartialTemplateName()).call(IncrementalDomRuntime.SOY_IDOM.reference().dotAccess("$$defaultIdomRenderer"), Expressions.id("$data"), JsRuntime.IJ_DATA)))))).build());
            return;
        }
        if (node.getContentKind() == SanitizedContentKind.HTML) {
            JsDoc jsDoc = this.generatePositionalFunctionJsDoc(node, GenIncrementalDomInteropVisitor.isModifiableWithUseVariantType(node));
            ArrayList callParams = jsDoc.params().stream().filter(p -> p.annotationType().equals("param")).map(p -> Expressions.id(p.paramTypeName())).collect(Collectors.toCollection(ArrayList::new));
            callParams.add(2, IncrementalDomRuntime.SOY_IDOM.reference().dotAccess("$$defaultIdomRenderer"));
            this.codeBuilder.append(Statements.ifStatement(this.shouldStub, Statements.assign(this.soyJsGoogRequire.dotAccess(node.getPartialTemplateName() + "_soyInternalStubs"), Expressions.arrowFunction(jsDoc, IncrementalDomRuntime.SOY_IDOM_MAKE_HTML.call(Expressions.arrowFunction(JsDoc.builder().build(), this.idomGoogRequire.reference().dotAccess(node.getPartialTemplateName() + "$").call((Iterable<? extends Expression>)new ImmutableList.Builder().addAll((Iterable)callParams).build())))))).build());
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            if (!(child instanceof TemplateNode)) continue;
            this.visit(child);
        }
    }
}

