/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomTemplateBodyVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.incrementaldomsrc.IncrementalDomTranslateExprNodeVisitor;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.ClassExpression;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";
    private final Deque<SanitizedContentKind> contentKind = new ArrayDeque<SanitizedContentKind>();
    private boolean hasNonConstantState;

    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, IncrementalDomDelTemplateNamer incrementalDomDelTemplateNamer, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genIncrementalDomExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        super(jsSrcOptions, javaScriptValueFactory, incrementalDomDelTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genIncrementalDomExprsVisitorFactory, typeRegistry);
    }

    @Override
    protected JsType getJsTypeForParamForDeclaration(SoyType paramType) {
        return JsType.forIncrementalDomDeclarations(paramType);
    }

    @Override
    protected JsType getJsTypeForParam(SoyType paramType) {
        return JsType.forIncrementalDom(paramType);
    }

    @Override
    protected JsType getJsTypeForParamTypeCheck(SoyType paramType) {
        return JsType.forIncrementalDomTypeChecks(paramType);
    }

    @Override
    protected void visit(SoyNode node) {
        try {
            super.visit(node);
        }
        catch (RuntimeException e) {
            throw new AssertionError("error from : " + String.valueOf((Object)node.getKind()) + " @ " + String.valueOf(node.getSourceLocation()), e);
        }
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected JsType getTemplateReturnType(TemplateNode node) {
        return JsType.templateReturnTypeForIdom(node.getContentKind());
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        this.contentKind.push(kind);
        String alias = node instanceof TemplateDelegateNode ? node.getPartialTemplateName() : this.templateAliases.get(node.getTemplateName());
        if (node instanceof TemplateElementNode) {
            this.hasNonConstantState = this.calcHasNonConstantState((TemplateElementNode)node);
        }
        super.visitTemplateNode(node);
        if (node instanceof TemplateDelegateNode && node.getChildren().isEmpty()) {
            this.contentKind.pop();
            return;
        }
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            Expression type = kind.isHtml() ? IncrementalDomRuntime.SOY_IDOM_TYPE_HTML : IncrementalDomRuntime.SOY_IDOM_TYPE_ATTRIBUTE;
            this.getJsCodeBuilder().append(Statements.assign(Expressions.id(alias).castAs("!" + JsRuntime.ELEMENT_LIB_IDOM.alias() + ".IdomFunction", (ImmutableSet<GoogRequire>)ImmutableSet.of((Object)JsRuntime.ELEMENT_LIB_IDOM)).dotAccess("contentKind"), type));
            if (GenIncrementalDomCodeVisitor.isModifiable(node) && !node.getChildren().isEmpty()) {
                this.getJsCodeBuilder().append(Statements.assign(Expressions.id(alias + "__default_impl").castAs("!" + JsRuntime.ELEMENT_LIB_IDOM.alias() + ".IdomFunction", (ImmutableSet<GoogRequire>)ImmutableSet.of((Object)JsRuntime.ELEMENT_LIB_IDOM)).dotAccess("contentKind"), type));
            }
        }
        if (node instanceof TemplateElementNode) {
            TemplateElementNode element = (TemplateElementNode)node;
            String elementName = this.getSoyElementClassName(alias);
            String elementAccessor = elementName + "Interface";
            this.getJsCodeBuilder().appendLine(new String[0]);
            this.getJsCodeBuilder().append(this.generateAccessorInterface(elementAccessor, element));
            this.getJsCodeBuilder().append(GenIncrementalDomCodeVisitor.generateExportsForSoyElement(elementAccessor));
            this.getJsCodeBuilder().append(this.generateRenderInternal(element, alias));
            this.getJsCodeBuilder().appendNullable(this.generateSyncInternal(element, alias));
            this.getJsCodeBuilder().append(this.generateClassForSoyElement(elementName, elementAccessor, element, alias));
            this.getJsCodeBuilder().append(GenIncrementalDomCodeVisitor.generateExportsForSoyElement(elementName));
        }
        this.contentKind.pop();
    }

    private Statement generateRenderInternal(TemplateElementNode node, String alias) {
        Object paramsType = this.hasOnlyImplicitParams(node) ? "null" : "!" + alias + ".Params";
        String soyElementClassName = this.getSoyElementClassName(alias);
        JsDoc jsDoc = JsDoc.builder().addParam("idomRenderer", "!incrementaldomlib.IncrementalDomRenderer").addParam("opt_data", (String)paramsType).addAnnotation("public").addAnnotation("override").addParameterizedAnnotation("this", soyElementClassName).addParameterizedAnnotation("suppress", "checkTypes").build();
        try (TranslationContext.ExitScope unused = this.templateTranslationContext.enterSoyAndJsScope();){
            Expression fn = Expressions.function(jsDoc, Statements.of(VariableDeclaration.builder("$ijData").setRhs(Expressions.THIS.dotAccess("ijData")).build(), Statements.of((Iterable)node.getStateVars().stream().map(stateVar -> VariableDeclaration.builder("$$state$$state_" + stateVar.name()).setRhs(GenIncrementalDomCodeVisitor.getStateVarWithCasts(stateVar)).build()).collect(ImmutableList.toImmutableList())), this.generateIncrementalDomRenderCalls(node, alias, false)));
            VariableDeclaration variableDeclaration = VariableDeclaration.builder(soyElementClassName + "Render").setJsDoc(jsDoc).setRhs(fn).build();
            return variableDeclaration;
        }
    }

    private Statement generateInitInternal(TemplateElementNode node) {
        ImmutableList.Builder stateVarInitializations = ImmutableList.builder();
        JsCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        for (TemplateStateVar stateVar : node.getStateVars()) {
            Expression rhsValue;
            JsType jsType = JsType.forIncrementalDomState(stateVar.type());
            for (GoogRequire require : jsType.getGoogRequires()) {
                jsCodeBuilder.addGoogRequire(require);
            }
            if (SoyTreeUtils.isConstantExpr(stateVar.defaultValue())) {
                rhsValue = this.translateExpr(stateVar.defaultValue());
                if (!rhsValue.hasOuterCast()) {
                    rhsValue = rhsValue.castAs(jsType.typeExpr(), jsType.getGoogRequires());
                }
            } else {
                rhsValue = Expressions.LITERAL_UNDEFINED.castAsUnknown();
            }
            JsDoc stateVarJsdoc = JsDoc.builder().addParameterizedAnnotation("private", jsType.typeExpr()).build();
            stateVarInitializations.add((Object)Statements.assign(Expressions.THIS.dotAccess("state_" + stateVar.name()), rhsValue, stateVarJsdoc));
        }
        return Statements.of((Iterable<Statement>)stateVarInitializations.build());
    }

    @Nullable
    private Statement generateSyncInternal(TemplateElementNode node, String alias) {
        String soyElementClassName = this.getSoyElementClassName(alias);
        Object paramsType = this.hasOnlyImplicitParams(node) ? "null" : "!" + alias + ".Params";
        JsDoc jsDoc = JsDoc.builder().addParam("opt_data", (String)paramsType).addAnnotation("public").addAnnotation("override").addParameterizedAnnotation("this", soyElementClassName).addParameterizedAnnotation("suppress", "checkTypes").addParam("syncOnlyData", "boolean=").build();
        try (TranslationContext.ExitScope exitScope = this.templateTranslationContext.enterSoyAndJsScope();){
            VariableDeclaration variableDeclaration = VariableDeclaration.builder(soyElementClassName + "SyncInternal").setJsDoc(jsDoc).setRhs(Expressions.function(jsDoc, Statements.of(VariableDeclaration.builder("$ijData").setRhs(Expressions.THIS.dotAccess("ijData")).build(), this.genSyncStateCalls(node, alias)))).build();
            return variableDeclaration;
        }
    }

    @Override
    protected JsDoc generatePositionalFunctionJsDoc(TemplateNode node, boolean addVariantParam) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        this.addInternalCallerParam(jsDocBuilder);
        this.addIjDataParam(jsDocBuilder, true);
        GenIncrementalDomCodeVisitor.maybeAddRenderer(jsDocBuilder, node);
        for (TemplateParam param : this.paramsInOrder(node)) {
            JsType jsType = this.getJsTypeForParamForDeclaration(param.type());
            jsDocBuilder.addParam(GenJsCodeVisitor.getPositionalParamName(param), jsType.typeExpr() + (param.isRequired() ? "" : "="));
        }
        if (addVariantParam) {
            jsDocBuilder.addParam("opt_variant", "string=");
        }
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    @Override
    protected JsDoc generateEmptyFunctionJsDoc(TemplateNode node) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        String ijDataTypeExpression = this.ijDataTypeExpression(jsDocBuilder);
        jsDocBuilder.addAnnotation("type", String.format("{function(?Object<string, *>=, ?%s=):string}", ijDataTypeExpression));
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    @Override
    protected JsDoc generateFunctionJsDoc(TemplateNode node, String alias, boolean suppressCheckTypes, boolean addVariantParam) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        GenIncrementalDomCodeVisitor.maybeAddRenderer(jsDocBuilder, node);
        boolean noRequiredParams = new ShouldEnsureDataIsDefinedVisitor().exec(node);
        if (this.hasOnlyImplicitParams(node)) {
            jsDocBuilder.addParam("opt_data", noRequiredParams ? "?Object<string, *>=" : "null=");
        } else if (noRequiredParams) {
            jsDocBuilder.addParam("opt_data", "?" + alias + ".Params=");
        } else {
            jsDocBuilder.addParam("opt_data", "!" + alias + ".Params");
        }
        this.addIjDataParam(jsDocBuilder, false);
        if (addVariantParam) {
            jsDocBuilder.addParam("opt_variant", "string=");
        }
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        if (suppressCheckTypes) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        } else if (this.fileSetMetadata.getTemplate(node).getTemplateType().getActualParameters().stream().anyMatch(TemplateType.Parameter::isImplicit)) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "missingProperties");
        }
        return jsDocBuilder.build();
    }

    private static void maybeAddRenderer(JsDoc.Builder jsDocBuilder, TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            jsDocBuilder.addGoogRequire(IncrementalDomRuntime.INCREMENTAL_DOM_LIB_TYPE);
            jsDocBuilder.addParam("idomRenderer", "!incrementaldomlib.IncrementalDomRenderer");
        }
    }

    @Override
    protected String ijDataTypeExpression(JsDoc.Builder jsDocBuilder) {
        jsDocBuilder.addGoogRequire(JsRuntime.GOOG_SOY_ALIAS);
        return JsRuntime.GOOG_SOY_ALIAS.alias() + ".IjData";
    }

    @Override
    protected void addIjDataParam(JsDoc.Builder jsDocBuilder, boolean forPositionalSignature) {
        String ijDataTypeExpression = this.ijDataTypeExpression(jsDocBuilder);
        if (forPositionalSignature) {
            jsDocBuilder.addParam("$ijData", "!" + ijDataTypeExpression);
        } else {
            jsDocBuilder.addParam("opt_ijData", "?" + ijDataTypeExpression + "=");
        }
    }

    @Override
    protected ImmutableList<Expression> getFixedParamsToPositionalCall(TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        ImmutableList.Builder params = ImmutableList.builder();
        params.addAll(super.getFixedParamsToPositionalCall(node));
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            params.add((Object)Expressions.id("idomRenderer"));
        }
        return params.build();
    }

    @Override
    protected ImmutableList<Expression> getFixedParamsForNonPositionalCall(TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        ImmutableList.Builder params = ImmutableList.builder();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            params.add((Object)Expressions.id("idomRenderer"));
        }
        params.addAll(super.getFixedParamsForNonPositionalCall(node));
        return params.build();
    }

    @Override
    protected ImmutableList<Expression> templateArguments(TemplateNode node, boolean isPositionalStyle) {
        ImmutableList<Expression> arguments = super.templateArguments(node, isPositionalStyle);
        SanitizedContentKind kind = node.getContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            return ImmutableList.builder().add((Object)IncrementalDomRuntime.INCREMENTAL_DOM).addAll(arguments).build();
        }
        return arguments;
    }

    @Override
    protected Statement generateFunctionBody(TemplateNode node, String alias, @Nullable String objectParamName, boolean addStubMapLogic) {
        boolean isPositionalStyle;
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        boolean bl = isPositionalStyle = objectParamName == null;
        if (!isPositionalStyle) {
            bodyStatements.add((Object)this.redeclareIjData());
        } else {
            bodyStatements.add((Object)JsRuntime.SOY_ARE_YOU_AN_INTERNAL_CALLER.call(Expressions.id("$$areYouAnInternalCaller")).asStatement());
        }
        if (addStubMapLogic) {
            bodyStatements.add((Object)this.generateStubbingTest(node, alias, isPositionalStyle));
        }
        if (!isPositionalStyle && new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            bodyStatements.add((Object)Statements.assign(JsRuntime.OPT_DATA, JsRuntime.OPT_DATA.or(Expressions.EMPTY_OBJECT_LITERAL.castAsNoRequire(objectParamName), this.templateTranslationContext.codeGenerator())));
        }
        if (isPositionalStyle && node instanceof TemplateElementNode) {
            throw new IllegalStateException("elements cannot be compiled into positional style.");
        }
        bodyStatements.add((Object)(node instanceof TemplateElementNode ? this.generateFunctionBodyForSoyElement((TemplateElementNode)node, alias) : this.generateIncrementalDomRenderCalls(node, alias, isPositionalStyle)));
        return Statements.of((Iterable<Statement>)bodyStatements.build());
    }

    private boolean calcHasNonConstantState(TemplateElementNode node) {
        return node.getStateVars().stream().anyMatch(v -> !SoyTreeUtils.isConstantExpr(v.defaultValue()));
    }

    private Statement genSyncStateCalls(TemplateElementNode node, String alias) {
        Statement typeChecks = this.genParamTypeChecks(node, alias, false);
        ImmutableList<TemplateStateVar> headerVars = node.getStateVars();
        ImmutableMap isNonConst = (ImmutableMap)headerVars.stream().collect(ImmutableMap.toImmutableMap(v -> v, v -> !SoyTreeUtils.isConstantExpr(v.defaultValue())));
        ImmutableList.Builder stateReassignmentBuilder = ImmutableList.builder();
        TemplateStateVar lastNonConstVar = headerVars.reverse().stream().filter(arg_0 -> ((ImmutableMap)isNonConst).get(arg_0)).findFirst().orElse(null);
        boolean haveVisitedLastNonConstVar = lastNonConstVar == null;
        String prefix = "state_";
        for (TemplateStateVar headerVar : headerVars) {
            if (((Boolean)isNonConst.get((Object)headerVar)).booleanValue()) {
                stateReassignmentBuilder.add((Object)Statements.assign(Expressions.THIS.dotAccess(prefix + headerVar.name()), this.translateExpr(headerVar.defaultValue())));
            }
            if (haveVisitedLastNonConstVar = haveVisitedLastNonConstVar || headerVar.equals(lastNonConstVar)) continue;
            stateReassignmentBuilder.add((Object)VariableDeclaration.builder("$$state$$state_" + headerVar.name()).setRhs(Expressions.THIS.dotAccess(prefix + headerVar.name())).build());
        }
        ImmutableList assignments = stateReassignmentBuilder.build();
        Statement stateReassignments = Statements.of((Iterable<Statement>)assignments);
        return Statements.of(typeChecks, stateReassignments);
    }

    private Statement generateIncrementalDomRenderCalls(TemplateNode node, String alias, boolean isPositionalStyle) {
        JsCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = GenIncrementalDomCodeVisitor.isTextContent(node.getContentKind());
        Statement typeChecks = this.genParamTypeChecks(node, alias, isPositionalStyle);
        if (isTextTemplate) {
            jsCodeBuilder.pushOutputVar("output").setOutputVarInited();
        }
        GenIncrementalDomTemplateBodyVisitor visitor = new GenIncrementalDomTemplateBodyVisitor(this.outputVars, this.jsSrcOptions, this.javaScriptValueFactory, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.canInitOutputVarVisitor, this.genJsExprsVisitor, this.errorReporter, this.templateTranslationContext, this.templateAliases, this.contentKind, this.staticVarDeclarations, this.generatePositionalParamsSignature, this.fileSetMetadata, alias);
        Statement body = Statements.of(visitor.visitChildren(node));
        if (isTextTemplate) {
            VariableDeclaration declare = VariableDeclaration.builder("output").setMutable().setRhs(Expressions.LITERAL_EMPTY_STRING).build();
            jsCodeBuilder.popOutputVar();
            body = Statements.of(declare, body, Statements.returnValue(this.sanitize(declare.ref(), node.getContentKind())));
        }
        return Statements.of(typeChecks, body);
    }

    private Statement generateFunctionBodyForSoyElement(TemplateElementNode node, String alias) {
        String soyElementClassName = this.getSoyElementClassName(alias);
        String tplName = node.getHtmlElementMetadata().getFinalCallee().isEmpty() ? node.getTemplateName() : node.getHtmlElementMetadata().getFinalCallee();
        Expression firstElementKey = JsRuntime.XID.call(Expressions.stringLiteral(tplName + "-root"));
        List<Expression> params = Arrays.asList(Expressions.id(soyElementClassName), firstElementKey, Expressions.stringLiteral(node.getHtmlElementMetadata().getTag()), JsRuntime.OPT_DATA, JsRuntime.IJ_DATA, Expressions.id(soyElementClassName + "Render"));
        return Statements.of(IncrementalDomRuntime.INCREMENTAL_DOM.dotAccess("handleSoyElement").call(params).asStatement(), new Statement[0]);
    }

    private VariableDeclaration generateClassForSoyElement(String soyElementClassName, String soyElementAccessorName, TemplateElementNode node, String alias) {
        Object paramsType = this.hasOnlyImplicitParams(node) ? "null" : "!" + alias + ".Params";
        ImmutableList.Builder methods = ImmutableList.builder();
        try (TranslationContext.ExitScope unused = this.templateTranslationContext.enterSoyAndJsScope();){
            ImmutableList.Builder stateVarInitializations = ImmutableList.builder();
            stateVarInitializations.add((Object)this.generateInitInternal(node));
            if (this.hasNonConstantState) {
                stateVarInitializations.add((Object)Statements.assign(Expressions.THIS.dotAccess("syncStateFromData"), Expressions.id(soyElementClassName + "SyncInternal")));
            }
            Statement ctorBody = Statements.of(Expressions.id("super").call(new Expression[0]).asStatement(), Statements.of((Iterable<Statement>)stateVarInitializations.build()));
            ClassExpression.MethodDeclaration constructorMethod = ClassExpression.MethodDeclaration.create("constructor", JsDoc.builder().build(), ctorBody);
            methods.add((Object)constructorMethod);
        }
        for (TemplateStateVar stateVar : node.getStateVars()) {
            methods.addAll(this.generateStateMethodsForSoyElementClass(soyElementClassName, stateVar));
        }
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            methods.add((Object)this.generateGetParamMethodForSoyElementClass(param, false, false));
        }
        for (TemplateParam injectedParam : node.getInjectedParams()) {
            methods.add((Object)this.generateGetParamMethodForSoyElementClass(injectedParam, false, true));
        }
        ClassExpression soyElementClass = ClassExpression.create(IncrementalDomRuntime.SOY_IDOM.dotAccess("$SoyElement"), (ImmutableList<ClassExpression.MethodDeclaration>)methods.build());
        String elementAccessor = soyElementClassName + "Interface";
        return VariableDeclaration.builder(soyElementClassName).setJsDoc(JsDoc.builder().addAnnotation("extends", "{soyIdom.$SoyElement<" + (String)paramsType + ",!" + elementAccessor + ">}").addParameterizedAnnotation("implements", soyElementAccessorName).build()).setRhs(soyElementClass).build();
    }

    private VariableDeclaration generateAccessorInterface(String className, TemplateElementNode node) {
        ImmutableList.Builder parameterMethods = ImmutableList.builder();
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            parameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(param, true, false));
        }
        ImmutableList.Builder injectedParameterMethods = ImmutableList.builder();
        for (TemplateParam injectedParam : node.getInjectedParams()) {
            injectedParameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(injectedParam, true, true));
        }
        ClassExpression soyElementClass = ClassExpression.create((ImmutableList<ClassExpression.MethodDeclaration>)ImmutableList.builder().addAll((Iterable)parameterMethods.build()).addAll((Iterable)injectedParameterMethods.build()).build());
        return VariableDeclaration.builder(className).setJsDoc(JsDoc.builder().addAnnotation("interface").build()).setRhs(soyElementClass).build();
    }

    private static Statement generateExportsForSoyElement(String soyElementClassName) {
        return Statements.assign(JsRuntime.EXPORTS.dotAccess(soyElementClassName.substring(1)), Expressions.id(soyElementClassName));
    }

    private ImmutableList<ClassExpression.MethodDeclaration> generateStateMethodsForSoyElementClass(String soyElementClassName, TemplateStateVar stateVar) {
        ImmutableList.Builder methods = ImmutableList.builder();
        JsType typeForState = JsType.forIncrementalDomDeclarations(stateVar.type());
        JsType typeForGetters = JsType.forIncrementalDomGetters(stateVar.type());
        String stateAccessorSuffix = Ascii.toUpperCase((String)stateVar.name().substring(0, 1)) + stateVar.name().substring(1);
        try (TranslationContext.ExitScope unused = this.templateTranslationContext.enterSoyAndJsScope();){
            Expression getterStateValue = GenIncrementalDomCodeVisitor.maybeCastAs(Expressions.id("this").dotAccess("state_" + stateVar.name()), typeForState, typeForGetters);
            methods.add((Object)ClassExpression.MethodDeclaration.create("get" + stateAccessorSuffix, JsDoc.builder().addParameterizedAnnotation("return", typeForGetters.typeExpr()).build(), Statements.returnValue(getterStateValue)));
        }
        unused = this.templateTranslationContext.enterSoyAndJsScope();
        try {
            ImmutableList.Builder setStateMethodStatements = ImmutableList.builder();
            JsType typeForSetters = JsType.forIncrementalDomSetters(stateVar.type());
            Optional<Expression> typeAssertion = typeForSetters.getSoyParamTypeAssertion(Expressions.id(stateVar.name()), stateVar.name(), "@state", this.templateTranslationContext.codeGenerator());
            if (typeAssertion.isPresent()) {
                setStateMethodStatements.add((Object)typeAssertion.get().asStatement());
            }
            Expression setterStateValue = Expressions.id("this").dotAccess("state_" + stateVar.name());
            Expression setterParam = GenIncrementalDomCodeVisitor.maybeCastAs(Expressions.id(stateVar.name()), typeForSetters, typeForState);
            setStateMethodStatements.add((Object[])new Statement[]{setterStateValue.assign(setterParam).asStatement(), Statements.returnValue(Expressions.id("this"))});
            methods.add((Object)ClassExpression.MethodDeclaration.create("set" + stateAccessorSuffix, JsDoc.builder().addParam(stateVar.name(), typeForSetters.typeExpr()).addParameterizedAnnotation("return", "!" + soyElementClassName).build(), Statements.of((Iterable<Statement>)setStateMethodStatements.build())));
        }
        finally {
            if (unused != null) {
                unused.close();
            }
        }
        return methods.build();
    }

    private ClassExpression.MethodDeclaration generateGetParamMethodForSoyElementClass(TemplateParam param, boolean isAbstract, boolean isInjected) {
        JsType jsType = JsType.forIncrementalDomGetters(param.type());
        String accessorSuffix = Ascii.toUpperCase((String)param.name().substring(0, 1)) + param.name().substring(1);
        if (isAbstract) {
            return ClassExpression.MethodDeclaration.create("get" + accessorSuffix, JsDoc.builder().addAnnotation("abstract").addParameterizedAnnotation("return", jsType.typeExpr()).build(), Statements.of((Iterable<Statement>)ImmutableList.of()));
        }
        try (TranslationContext.ExitScope unused = this.templateTranslationContext.enterSoyAndJsScope();){
            Expression value = GenIncrementalDomCodeVisitor.maybeCastAs(Expressions.id("this").dotAccess(isInjected ? "ijData" : "data").dotAccess(param.name()), JsType.forIncrementalDomState(param.type()), jsType);
            if (param.hasDefault()) {
                value = this.templateTranslationContext.codeGenerator().declarationBuilder().setMutable().setRhs(value).build().ref();
                value = value.withInitialStatement(this.genParamDefault(param, value, jsType, this.templateTranslationContext.codeGenerator()));
            }
            Optional<Expression> typeAssertion = isInjected ? jsType.getSoyParamTypeAssertion(value, param.name(), "@inject", this.templateTranslationContext.codeGenerator()) : Optional.empty();
            ClassExpression.MethodDeclaration methodDeclaration = ClassExpression.MethodDeclaration.create("get" + accessorSuffix, JsDoc.builder().addAnnotation("override").addAnnotation("public").build(), Statements.returnValue(typeAssertion.orElse(value)));
            return methodDeclaration;
        }
    }

    private String getSoyElementClassName(String alias) {
        Preconditions.checkState((boolean)alias.startsWith("$"), (Object)"Alias should start with '$', or template class name may be malformed.");
        return "$" + Ascii.toUpperCase((char)alias.charAt(1)) + alias.substring(2) + "Element";
    }

    private static boolean isTextContent(SanitizedContentKind contentKind) {
        return !contentKind.isHtml() && contentKind != SanitizedContentKind.ATTRIBUTES;
    }

    private static Expression getStateVarWithCasts(TemplateStateVar stateVar) {
        SoyType stateVarType = stateVar.typeOrDefault(null);
        return GenIncrementalDomCodeVisitor.maybeCastAs(Expressions.THIS.dotAccess("state_" + stateVar.name()), JsType.forIncrementalDomState(stateVarType), JsType.forIncrementalDomTypeChecks(stateVarType));
    }

    private static Expression maybeCastAs(Expression expression, JsType currentType, JsType desiredType) {
        if (!currentType.typeExpr().equals(desiredType.typeExpr())) {
            expression = expression.castAs(desiredType.typeExpr(), desiredType.getGoogRequires());
        }
        return expression;
    }

    @Override
    protected TranslateExprNodeVisitor getExprTranslator() {
        return new IncrementalDomTranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.templateAliases, this.errorReporter, JsRuntime.OPT_DATA);
    }

    @Override
    protected boolean isIncrementalDom() {
        return true;
    }
}

