/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomTemplateBodyVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.DoWhile;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.OutputVarHandler;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.VeLogNode;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

final class AssistantForHtmlMsgs
extends GenJsCodeVisitorAssistantForMsgs {
    private final Map<String, MsgPlaceholderNode> placeholderNames = new LinkedHashMap<String, MsgPlaceholderNode>();
    private static final String PLACEHOLDER_WRAPPER = "\u0001";
    private static final String PLACEHOLDER_REGEX = "/\\x01\\d+\\x01/g";
    private final String staticDecl;
    private final GenIncrementalDomTemplateBodyVisitor idomTemplateBodyVisitor;

    AssistantForHtmlMsgs(GenIncrementalDomTemplateBodyVisitor idomTemplateBodyVisitor, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter, String staticDecl, OutputVarHandler outputVars) {
        super(idomTemplateBodyVisitor, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter, outputVars);
        this.staticDecl = staticDecl;
        this.idomTemplateBodyVisitor = idomTemplateBodyVisitor;
    }

    @Override
    public Expression generateMsgGroupVariable(MsgFallbackGroupNode node) {
        throw new IllegalStateException("This class should only be used for via the new idom entry-point.");
    }

    Statement generateMsgGroupCode(MsgFallbackGroupNode node) {
        Preconditions.checkState((boolean)this.placeholderNames.isEmpty(), (Object)"This class is not reusable.");
        Preconditions.checkArgument((node.getHtmlContext() == HtmlContext.HTML_PCDATA ? 1 : 0) != 0, (Object)"AssistantForHtmlMsgs is only for HTML {msg}s.");
        Expression translationVar = super.generateMsgGroupVariable(node);
        if (this.placeholderNames.isEmpty()) {
            Expression unescape = JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(translationVar);
            return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(unescape).asStatement();
        }
        if (!translationVar.isCheap()) {
            translationVar = this.translationContext.codeGenerator().declarationBuilder().setRhs(translationVar).build().ref();
        }
        ImmutableList.Builder body = ImmutableList.builder();
        String itemId = "i" + node.getId();
        Expression item = Expressions.id("i" + node.getId());
        body.add((Object)item.bracketAccess(Expressions.number(0L)).and(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(item.bracketAccess(Expressions.number(0L))), this.translationContext.codeGenerator()).asStatement());
        SwitchBuilder switchBuilder = Statements.switchValue(item.bracketAccess(Expressions.number(1L)));
        for (Map.Entry<String, MsgPlaceholderNode> ph : this.placeholderNames.entrySet()) {
            Statement value = this.idomTemplateBodyVisitor.visit(ph.getValue());
            MsgPlaceholderNode phNode = ph.getValue();
            if (phNode.getParent() instanceof VeLogNode) {
                VeLogNode parent = (VeLogNode)phNode.getParent();
                if (parent.getChild(0) == phNode) {
                    GenIncrementalDomTemplateBodyVisitor.VeLogStateHolder state = this.idomTemplateBodyVisitor.openVeLogNode(parent);
                    Preconditions.checkState((state.logOnlyConditional == null ? 1 : 0) != 0);
                    value = Statements.of(state.enterStatement, value);
                }
                if (parent.getChild(parent.numChildren() - 1) == phNode) {
                    value = Statements.of(value, this.idomTemplateBodyVisitor.exitVeLogNode(parent, null));
                }
            }
            switchBuilder.addCase(Expressions.stringLiteral(ph.getKey()), value);
        }
        body.add((Object)switchBuilder.build());
        Statement loop = Statements.forOf(itemId, Expressions.id(this.staticDecl).bracketAccess(translationVar), Statements.of((Iterable<Statement>)body.build()));
        return Statements.of(this.staticsInitializer(node, translationVar), loop);
    }

    private Statement staticsInitializer(MsgFallbackGroupNode node, Expression translationVar) {
        VariableDeclaration regexVar = VariableDeclaration.builder("partRe_" + node.getId()).setRhs(Expressions.regexLiteral(PLACEHOLDER_REGEX)).build();
        VariableDeclaration matchVar = VariableDeclaration.builder("match_" + node.getId()).setMutable().build();
        VariableDeclaration lastIndexVar = VariableDeclaration.builder("lastIndex_" + node.getId()).setMutable().setRhs(Expressions.number(0L)).build();
        VariableDeclaration counter = VariableDeclaration.builder("counter_" + node.getId()).setMutable().setRhs(Expressions.number(0L)).build();
        ArrayList<Statement> doBody = new ArrayList<Statement>();
        doBody.add(matchVar.ref().assign(regexVar.ref().dotAccess("exec").call(translationVar).or(Expressions.id("undefined"), this.translationContext.codeGenerator())).asStatement());
        Expression endIndex = matchVar.ref().and(matchVar.ref().dotAccess("index"), this.translationContext.codeGenerator());
        Expression unescape = JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(translationVar.dotAccess("substring").call(lastIndexVar.ref(), endIndex));
        doBody.add(Expressions.id(this.staticDecl).bracketAccess(translationVar).bracketAccess(counter.ref()).assign(Expressions.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of((Object)unescape, (Object)matchVar.ref().and(matchVar.ref().bracketAccess(Expressions.number(0L)), this.translationContext.codeGenerator())))).asStatement());
        doBody.add(counter.ref().assign(counter.ref().plus(Expressions.number(1L))).asStatement());
        doBody.add(lastIndexVar.ref().assign(regexVar.ref().dotAccess("lastIndex")).asStatement());
        Statement statement = Statements.of(Expressions.id(this.staticDecl).bracketAccess(translationVar).assign(Expressions.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of())).asStatement(), Statements.of(translationVar.allInitialStatementsInTopScope()), regexVar, lastIndexVar, counter, matchVar, DoWhile.builder().setCondition(matchVar.ref()).setBody(Statements.of(doBody)).build());
        statement = Statements.ifStatement(Expressions.not(Expressions.id(this.staticDecl).bracketAccess(translationVar)), statement).build();
        return statement;
    }

    @Override
    protected Expression genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
        CallSite name = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\u0002", PLACEHOLDER_WRAPPER, PLACEHOLDER_WRAPPER}, (int)this.placeholderNames.size());
        this.placeholderNames.put((String)((Object)name), msgPhNode);
        return Expressions.stringLiteral((String)((Object)name));
    }
}

