/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.Operator;

public class OperatorNodes {
    private OperatorNodes() {
    }

    public static final class BitwiseAndOpNode
    extends AbstractOperatorNode {
        public BitwiseAndOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.BITWISE_AND, operatorLocation);
        }

        private BitwiseAndOpNode(BitwiseAndOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.BITWISE_AND_OP_NODE;
        }

        @Override
        public BitwiseAndOpNode copy(CopyState copyState) {
            return new BitwiseAndOpNode(this, copyState);
        }
    }

    public static final class BitwiseXorOpNode
    extends AbstractOperatorNode {
        public BitwiseXorOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.BITWISE_XOR, operatorLocation);
        }

        private BitwiseXorOpNode(BitwiseXorOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.BITWISE_XOR_OP_NODE;
        }

        @Override
        public BitwiseXorOpNode copy(CopyState copyState) {
            return new BitwiseXorOpNode(this, copyState);
        }
    }

    public static final class BitwiseOrOpNode
    extends AbstractOperatorNode {
        public BitwiseOrOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.BITWISE_OR, operatorLocation);
        }

        private BitwiseOrOpNode(BitwiseOrOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.BITWISE_OR_OP_NODE;
        }

        @Override
        public BitwiseOrOpNode copy(CopyState copyState) {
            return new BitwiseOrOpNode(this, copyState);
        }
    }

    public static final class ShiftRightOpNode
    extends AbstractOperatorNode {
        public ShiftRightOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.SHIFT_RIGHT, operatorLocation);
        }

        private ShiftRightOpNode(ShiftRightOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.SHIFT_RIGHT_OP_NODE;
        }

        @Override
        public ShiftRightOpNode copy(CopyState copyState) {
            return new ShiftRightOpNode(this, copyState);
        }
    }

    public static final class ShiftLeftOpNode
    extends AbstractOperatorNode {
        public ShiftLeftOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.SHIFT_LEFT, operatorLocation);
        }

        private ShiftLeftOpNode(ShiftLeftOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.SHIFT_LEFT_OP_NODE;
        }

        @Override
        public ShiftLeftOpNode copy(CopyState copyState) {
            return new ShiftLeftOpNode(this, copyState);
        }
    }

    public static final class AssertNonNullOpNode
    extends AbstractOperatorNode
    implements ExprNode.AccessChainComponentNode {
        public AssertNonNullOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.ASSERT_NON_NULL, operatorLocation);
        }

        private AssertNonNullOpNode(AssertNonNullOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.ASSERT_NON_NULL_OP_NODE;
        }

        @Override
        public AssertNonNullOpNode copy(CopyState copyState) {
            return new AssertNonNullOpNode(this, copyState);
        }
    }

    public static final class ConditionalOpNode
    extends AbstractOperatorNode {
        public ConditionalOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.CONDITIONAL, operatorLocation);
        }

        private ConditionalOpNode(ConditionalOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.CONDITIONAL_OP_NODE;
        }

        @Override
        public ConditionalOpNode copy(CopyState copyState) {
            return new ConditionalOpNode(this, copyState);
        }
    }

    public static final class NullCoalescingOpNode
    extends AbstractOperatorNode {
        public NullCoalescingOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.NULL_COALESCING, operatorLocation);
        }

        private NullCoalescingOpNode(NullCoalescingOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        public ExprNode getLeftChild() {
            return this.getChild(0);
        }

        public ExprNode getRightChild() {
            return this.getChild(1);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.NULL_COALESCING_OP_NODE;
        }

        @Override
        public NullCoalescingOpNode copy(CopyState copyState) {
            return new NullCoalescingOpNode(this, copyState);
        }
    }

    public static final class BarBarOpNode
    extends AbstractOperatorNode {
        public BarBarOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.BAR_BAR, operatorLocation);
        }

        private BarBarOpNode(BarBarOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.BAR_BAR_OP_NODE;
        }

        @Override
        public BarBarOpNode copy(CopyState copyState) {
            return new BarBarOpNode(this, copyState);
        }
    }

    public static final class AmpAmpOpNode
    extends AbstractOperatorNode {
        public AmpAmpOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.AMP_AMP, operatorLocation);
        }

        private AmpAmpOpNode(AmpAmpOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.AMP_AMP_OP_NODE;
        }

        @Override
        public AmpAmpOpNode copy(CopyState copyState) {
            return new AmpAmpOpNode(this, copyState);
        }
    }

    public static final class OrOpNode
    extends AbstractOperatorNode {
        public OrOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.OR, operatorLocation);
        }

        private OrOpNode(OrOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.OR_OP_NODE;
        }

        @Override
        public OrOpNode copy(CopyState copyState) {
            return new OrOpNode(this, copyState);
        }
    }

    public static final class AndOpNode
    extends AbstractOperatorNode {
        public AndOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.AND, operatorLocation);
        }

        private AndOpNode(AndOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.AND_OP_NODE;
        }

        @Override
        public AndOpNode copy(CopyState copyState) {
            return new AndOpNode(this, copyState);
        }
    }

    public static final class TripleNotEqualOpNode
    extends AbstractOperatorNode {
        public TripleNotEqualOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.TRIPLE_NOT_EQUAL, operatorLocation);
        }

        private TripleNotEqualOpNode(TripleNotEqualOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.TRIPLE_NOT_EQUAL_OP_NODE;
        }

        @Override
        public TripleNotEqualOpNode copy(CopyState copyState) {
            return new TripleNotEqualOpNode(this, copyState);
        }
    }

    public static final class TripleEqualOpNode
    extends AbstractOperatorNode {
        public TripleEqualOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.TRIPLE_EQUAL, operatorLocation);
        }

        private TripleEqualOpNode(TripleEqualOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.TRIPLE_EQUAL_OP_NODE;
        }

        @Override
        public TripleEqualOpNode copy(CopyState copyState) {
            return new TripleEqualOpNode(this, copyState);
        }
    }

    public static final class NotEqualOpNode
    extends AbstractOperatorNode {
        public NotEqualOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.NOT_EQUAL, operatorLocation);
        }

        private NotEqualOpNode(NotEqualOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.NOT_EQUAL_OP_NODE;
        }

        @Override
        public NotEqualOpNode copy(CopyState copyState) {
            return new NotEqualOpNode(this, copyState);
        }
    }

    public static final class EqualOpNode
    extends AbstractOperatorNode {
        public EqualOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.EQUAL, operatorLocation);
        }

        private EqualOpNode(EqualOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.EQUAL_OP_NODE;
        }

        @Override
        public EqualOpNode copy(CopyState copyState) {
            return new EqualOpNode(this, copyState);
        }
    }

    public static final class GreaterThanOrEqualOpNode
    extends AbstractOperatorNode {
        public GreaterThanOrEqualOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.GREATER_THAN_OR_EQUAL, operatorLocation);
        }

        private GreaterThanOrEqualOpNode(GreaterThanOrEqualOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.GREATER_THAN_OR_EQUAL_OP_NODE;
        }

        @Override
        public GreaterThanOrEqualOpNode copy(CopyState copyState) {
            return new GreaterThanOrEqualOpNode(this, copyState);
        }
    }

    public static final class LessThanOrEqualOpNode
    extends AbstractOperatorNode {
        public LessThanOrEqualOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.LESS_THAN_OR_EQUAL, operatorLocation);
        }

        private LessThanOrEqualOpNode(LessThanOrEqualOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.LESS_THAN_OR_EQUAL_OP_NODE;
        }

        @Override
        public LessThanOrEqualOpNode copy(CopyState copyState) {
            return new LessThanOrEqualOpNode(this, copyState);
        }
    }

    public static final class GreaterThanOpNode
    extends AbstractOperatorNode {
        public GreaterThanOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.GREATER_THAN, operatorLocation);
        }

        private GreaterThanOpNode(GreaterThanOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.GREATER_THAN_OP_NODE;
        }

        @Override
        public GreaterThanOpNode copy(CopyState copyState) {
            return new GreaterThanOpNode(this, copyState);
        }
    }

    public static final class LessThanOpNode
    extends AbstractOperatorNode {
        public LessThanOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.LESS_THAN, operatorLocation);
        }

        private LessThanOpNode(LessThanOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.LESS_THAN_OP_NODE;
        }

        @Override
        public LessThanOpNode copy(CopyState copyState) {
            return new LessThanOpNode(this, copyState);
        }
    }

    public static final class MinusOpNode
    extends AbstractOperatorNode {
        public MinusOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.MINUS, operatorLocation);
        }

        private MinusOpNode(MinusOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.MINUS_OP_NODE;
        }

        @Override
        public MinusOpNode copy(CopyState copyState) {
            return new MinusOpNode(this, copyState);
        }
    }

    public static final class PlusOpNode
    extends AbstractOperatorNode {
        public PlusOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.PLUS, operatorLocation);
        }

        private PlusOpNode(PlusOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.PLUS_OP_NODE;
        }

        @Override
        public PlusOpNode copy(CopyState copyState) {
            return new PlusOpNode(this, copyState);
        }
    }

    public static final class ModOpNode
    extends AbstractOperatorNode {
        public ModOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.MOD, operatorLocation);
        }

        private ModOpNode(ModOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.MOD_OP_NODE;
        }

        @Override
        public ModOpNode copy(CopyState copyState) {
            return new ModOpNode(this, copyState);
        }
    }

    public static final class DivideByOpNode
    extends AbstractOperatorNode {
        public DivideByOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.DIVIDE_BY, operatorLocation);
        }

        private DivideByOpNode(DivideByOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.DIVIDE_BY_OP_NODE;
        }

        @Override
        public DivideByOpNode copy(CopyState copyState) {
            return new DivideByOpNode(this, copyState);
        }
    }

    public static final class TimesOpNode
    extends AbstractOperatorNode {
        public TimesOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.TIMES, operatorLocation);
        }

        private TimesOpNode(TimesOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.TIMES_OP_NODE;
        }

        @Override
        public TimesOpNode copy(CopyState copyState) {
            return new TimesOpNode(this, copyState);
        }
    }

    public static final class NotOpNode
    extends AbstractOperatorNode {
        public NotOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation, Operator op) {
            super(sourceLocation, op, operatorLocation);
            Preconditions.checkArgument((op == Operator.NOT || op == Operator.NOT_LEGACY ? 1 : 0) != 0);
        }

        private NotOpNode(NotOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.NOT_OP_NODE;
        }

        @Override
        public NotOpNode copy(CopyState copyState) {
            return new NotOpNode(this, copyState);
        }
    }

    public static final class NegativeOpNode
    extends AbstractOperatorNode {
        public NegativeOpNode(SourceLocation sourceLocation, SourceLocation operatorLocation) {
            super(sourceLocation, Operator.NEGATIVE, operatorLocation);
        }

        private NegativeOpNode(NegativeOpNode orig, CopyState copyState) {
            super(orig, copyState);
        }

        @Override
        public ExprNode.Kind getKind() {
            return ExprNode.Kind.NEGATIVE_OP_NODE;
        }

        @Override
        public NegativeOpNode copy(CopyState copyState) {
            return new NegativeOpNode(this, copyState);
        }
    }
}

